/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ctbotp.sync;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.constants.SyncTypeEnum;
import kd.bos.entity.ctbotp.sync.SyncLog;
import kd.bos.entity.ctbotp.sync.SyncQueryArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;

public abstract class AbstractSyncLogService {
    private static final Log LOG = LogFactory.getLog(AbstractSyncLogService.class);
    private static final String KEY_ID = "id";
    private static final String KEY_STENANTCODE = "stenantcode";
    private static final String KEY_SENTITYKEY = "sentitykey";
    private static final String KEY_SBILLID = "sbillid";
    private static final String KEY_SBILLNO = "sbillno";
    private static final String KEY_TTENANTCODE = "ttenantcode";
    private static final String KEY_TENTITYKEY = "tentitykey";
    private static final String KEY_TBILLID = "tbillid";
    private static final String KEY_TBILLNO = "tbillno";
    private static final String KEY_STATUS = "status";
    private static final String KEY_DESC = "desc";
    private static final String KEY_CREATETIME = "createtime";
    private static final String KEY_RULEID = "ruleid";
    private static final String KEY_UPDATETIME = "updatetime";
    private static final String KEY_UPDATESTATUSCOUNT = "updatestatuscount";
    private static final String KEY_SYNCTYPE = "synctype";
    private static final String KEY_TACCOUNTID = "taccountid";
    private static final String KEY_SACCOUNTID = "saccountid";
    private static final String KEY_RULENAME = "rulename";
    private static final String KEY_UNIQUEKEY = "uniquekey";
    private static final String KEY_LKSYNCSTATUS = "lksyncstatus";
    private static final String KEY_SOURCEOPERATE = "sourceoperate";
    private static final String KEY_ROOTJOBID = "rootjobid";
    private static final String selectProperties = "id,stenantcode,saccountid,sentitykey,sbillid,sbillno,ttenantcode,taccountid,tentitykey,tbillid,tbillno,status,synccontent,createtime,updatetime,synctype,ruleid,uniquekey,lksyncstatus,sourceoperate,rootjobid";

    protected abstract String getFormId();

    public List<SyncLog> getSSyncLogs(SyncQueryArgs syncQueryArgs) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter(KEY_SBILLID, "in", (Object)syncQueryArgs.getsBillIds()));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.getFormId(), (String)selectProperties, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        ArrayList<SyncLog> SSyncLogs = new ArrayList<SyncLog>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            SyncLog sSyncLog = AbstractSyncLogService.buildSyncLog(dynamicObject);
            if (!syncQueryArgs.getsTenantCode().equals(sSyncLog.getStenantCode()) || !syncQueryArgs.getsEntityKey().equals(sSyncLog.getsEntityKey()) || !syncQueryArgs.getsAccountId().equals(sSyncLog.getsAccountId()) || !syncQueryArgs.gettTenantCode().equals(sSyncLog.getTtenantCode()) || !syncQueryArgs.gettAccountId().equals(sSyncLog.gettAccountId()) || !syncQueryArgs.gettEntityKey().equals(sSyncLog.gettEntityKey()) || !syncQueryArgs.getSyncType().equals(SyncTypeEnum.FORWARD.getValue())) continue;
            SSyncLogs.add(sSyncLog);
        }
        return SSyncLogs;
    }

    public List<SyncLog> getSyncLogsByUniqueKeys(List<String> uniqueKeys) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter(KEY_UNIQUEKEY, "in", uniqueKeys));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.getFormId(), (String)selectProperties, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        ArrayList<SyncLog> syncLogs = new ArrayList<SyncLog>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            SyncLog syncLog = AbstractSyncLogService.buildSyncLog(dynamicObject);
            syncLogs.add(syncLog);
        }
        return syncLogs;
    }

    public List<SyncLog> getSyncLogsByIds(List<Long> ids) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter(KEY_ID, "in", ids));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.getFormId(), (String)selectProperties, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        ArrayList<SyncLog> syncLogs = new ArrayList<SyncLog>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            SyncLog syncLog = AbstractSyncLogService.buildSyncLog(dynamicObject);
            syncLogs.add(syncLog);
        }
        return syncLogs;
    }

    public List<SyncLog> getSyncLogsBySbillIds(List<Long> ids) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter(KEY_SBILLID, "in", ids));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.getFormId(), (String)selectProperties, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        ArrayList<SyncLog> syncLogs = new ArrayList<SyncLog>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            SyncLog syncLog = AbstractSyncLogService.buildSyncLog(dynamicObject);
            syncLogs.add(syncLog);
        }
        return syncLogs;
    }

    public List<SyncLog> getSyncLogsByQFilters(QFilter[] qFilters, int top) {
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)this.getFormId(), (String)"id,stenantcode,saccountid,sentitykey,sbillid,sbillno,ttenantcode,taccountid,tentitykey,tbillid,tbillno,status,synccontent,createtime,updatetime,synctype,ruleid,uniquekey,lksyncstatus,sourceoperate,rootjobid,updatestatuscount", (QFilter[])qFilters, (String)"updatetime asc,createtime asc", (int)top);
        ArrayList<SyncLog> syncLogs = new ArrayList<SyncLog>(16);
        if (datas == null || datas.length == 0) {
            return syncLogs;
        }
        for (DynamicObject dynamicObject : datas) {
            SyncLog syncLog = AbstractSyncLogService.buildSyncLog(dynamicObject);
            syncLog.setUpdateStatusCount(Integer.valueOf(dynamicObject.getInt(KEY_UPDATESTATUSCOUNT)));
            syncLogs.add(syncLog);
        }
        return syncLogs;
    }

    public SyncLog getSSyncLogsById(Long id) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter(KEY_ID, "=", (Object)id));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.getFormId(), (String)selectProperties, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        if (dynamicObject == null) {
            return null;
        }
        SyncLog syncLog = AbstractSyncLogService.buildSyncLog(dynamicObject);
        return syncLog;
    }

    public Map<Long, SyncLog> getSSyncLogMaps(SyncQueryArgs syncQueryArgs) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter(KEY_SBILLID, "in", (Object)syncQueryArgs.getsBillIds()));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.getFormId(), (String)selectProperties, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        HashMap<Long, SyncLog> ctBillLkMap = new HashMap<Long, SyncLog>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            SyncLog sSyncLog = AbstractSyncLogService.buildSyncLog(dynamicObject);
            if (!syncQueryArgs.getsTenantCode().equals(sSyncLog.getStenantCode()) || !syncQueryArgs.getsEntityKey().equals(sSyncLog.getsEntityKey()) || !syncQueryArgs.getsAccountId().equals(sSyncLog.getsAccountId()) || !syncQueryArgs.gettTenantCode().equals(sSyncLog.getTtenantCode()) || !syncQueryArgs.gettAccountId().equals(sSyncLog.gettAccountId()) || !syncQueryArgs.gettEntityKey().equals(sSyncLog.gettEntityKey()) || !syncQueryArgs.getSyncType().equals(SyncTypeEnum.FORWARD.getValue())) continue;
            ctBillLkMap.put(sSyncLog.getSbillId(), sSyncLog);
        }
        return ctBillLkMap;
    }

    public List<SyncLog> getSSyncLogByRootJobId(SyncQueryArgs syncQueryArgs) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter(KEY_ROOTJOBID, "=", (Object)syncQueryArgs.getRootJobId()));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.getFormId(), (String)selectProperties, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        ArrayList<SyncLog> syncLogs = new ArrayList<SyncLog>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            SyncLog sSyncLog = AbstractSyncLogService.buildSyncLog(dynamicObject);
            if (!syncQueryArgs.getsTenantCode().equals(sSyncLog.getStenantCode()) || !syncQueryArgs.getsEntityKey().equals(sSyncLog.getsEntityKey()) || !syncQueryArgs.getsAccountId().equals(sSyncLog.getsAccountId()) || !syncQueryArgs.gettTenantCode().equals(sSyncLog.getTtenantCode()) || !syncQueryArgs.gettAccountId().equals(sSyncLog.gettAccountId()) || !syncQueryArgs.gettEntityKey().equals(sSyncLog.gettEntityKey())) continue;
            syncLogs.add(sSyncLog);
        }
        return syncLogs;
    }

    public void addSyncLogs(List<SyncLog> syncLogs) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.getFormId());
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(10);
        for (SyncLog syncLog : syncLogs) {
            DynamicObject obj = this.buildDyObject(mainType, syncLog);
            dynamicObjects.add(obj);
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                BusinessDataWriter.save((IDataEntityType)mainType, (Object[])dynamicObjects.toArray());
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public void updateLogStatus(Long[] logIds, String status) {
        if (logIds == null || logIds.length == 0) {
            return;
        }
        String updateSql = "update t_ctbotp_synclog set fstatus = ?, fupdatetime = ? where fid = ?";
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.getFormId());
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(logIds.length);
        for (Long logId : logIds) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("fstatus", 1, (Object)status), new SqlParameter("fupdatetime", 91, (Object)new Date()), new SqlParameter("fid", -5, (Object)logId)};
            paramsList.add(params);
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)new DBRoute(mainType.getDBRouteKey()), (String)updateSql, paramsList);
            }
            catch (Throwable e) {
                h.markRollback();
                LOG.warn(e);
            }
        }
    }

    public void update(List<DynamicObject> dynamicObjects) {
        try (TXHandle h = TX.requiresNew();){
            try {
                this.updateNoTx(dynamicObjects);
            }
            catch (Throwable exp) {
                h.markRollback();
                throw exp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNoTx(List<DynamicObject> dynamicObjects) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.getFormId());
        if (dynamicObjects != null) {
            ShardingHintContext ctx = null;
            if (ShardingHinter.isSharding((String)mainType.getAlias())) {
                ArrayList<Object> pks = new ArrayList<Object>(16);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    pks.add(dynamicObject.getPkValue());
                }
                ctx = ShardingHinter.tryHint((IDataEntityType)mainType, (Object[])pks.toArray());
                ctx.set();
            }
            try {
                SaveServiceHelper.update((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
            }
            finally {
                if (ctx != null) {
                    ctx.close();
                }
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        }
    }

    public void delete(String dbRouteKey, Date lastDate, String logType) {
        Object[] params;
        String deleteSql;
        DBRoute dbRoute = new DBRoute(dbRouteKey);
        if (StringUtils.isBlank((CharSequence)logType)) {
            deleteSql = "delete t_ctbotp_synclog where fstarttime < ?";
            params = new SqlParameter[]{new SqlParameter("fstarttime", 91, (Object)lastDate)};
        } else {
            deleteSql = "delete t_botp_log where fstarttime < ? and flogtype = ?";
            params = new SqlParameter[]{new SqlParameter("fstarttime", 91, (Object)lastDate), new SqlParameter("flogtype", 1, (Object)logType)};
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.execute((DBRoute)dbRoute, (String)deleteSql, (Object[])params);
            }
            catch (Throwable e) {
                h.markRollback();
                LOG.error(e);
                throw e;
            }
        }
    }

    private DynamicObject buildDyObject(MainEntityType mainType, SyncLog log) {
        DynamicObject obj = new DynamicObject((DynamicObjectType)mainType);
        if (StringUtils.isNotBlank((Object)log.getId())) {
            obj.set(KEY_ID, (Object)log.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)log.getStenantCode())) {
            obj.set(KEY_STENANTCODE, (Object)log.getStenantCode());
        }
        if (StringUtils.isNotBlank((CharSequence)log.getsAccountId())) {
            obj.set(KEY_SACCOUNTID, (Object)log.getsAccountId());
        }
        if (StringUtils.isNotEmpty((CharSequence)log.getsEntityKey())) {
            obj.set(KEY_SENTITYKEY, (Object)log.getsEntityKey());
        }
        if (StringUtils.isNotBlank((Object)log.getSbillId())) {
            obj.set(KEY_SBILLID, (Object)log.getSbillId());
        }
        if (StringUtils.isNotBlank((CharSequence)log.getSbillNo())) {
            obj.set(KEY_SBILLNO, (Object)log.getSbillNo());
        }
        if (StringUtils.isNotBlank((CharSequence)log.getRuleId())) {
            obj.set(KEY_RULEID, (Object)log.getRuleId());
        }
        if (StringUtils.isNotBlank((CharSequence)log.getTtenantCode())) {
            obj.set(KEY_TTENANTCODE, (Object)log.getTtenantCode());
        }
        if (StringUtils.isNotBlank((CharSequence)log.gettAccountId())) {
            obj.set(KEY_TACCOUNTID, (Object)log.gettAccountId());
        }
        if (StringUtils.isNotBlank((CharSequence)log.gettEntityKey())) {
            obj.set(KEY_TENTITYKEY, (Object)log.gettEntityKey());
        }
        if (StringUtils.isNotBlank((Object)log.getTbillId())) {
            obj.set(KEY_TBILLID, (Object)log.getTbillId());
        }
        if (StringUtils.isNotBlank((CharSequence)log.getTbillNo())) {
            obj.set(KEY_TBILLNO, (Object)log.getTbillNo());
        }
        if (StringUtils.isNotBlank((CharSequence)log.getStatus())) {
            obj.set(KEY_STATUS, (Object)log.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)log.getDesc())) {
            obj.set(KEY_DESC, (Object)log.getDesc());
        }
        if (StringUtils.isNotBlank((Object)log.getCreateTime())) {
            obj.set(KEY_CREATETIME, (Object)log.getCreateTime());
        }
        if (StringUtils.isNotBlank((Object)log.getUpdateTime())) {
            obj.set(KEY_UPDATETIME, (Object)log.getUpdateTime());
        }
        if (StringUtils.isNotBlank((CharSequence)log.getSyncType())) {
            obj.set(KEY_SYNCTYPE, (Object)log.getSyncType());
        }
        if (StringUtils.isNotBlank((CharSequence)log.getRulename())) {
            obj.set(KEY_RULENAME, (Object)log.getRulename());
        }
        if (StringUtils.isNotBlank((CharSequence)log.getUniqueKey())) {
            obj.set(KEY_UNIQUEKEY, (Object)log.getUniqueKey());
        }
        if (StringUtils.isNotBlank((CharSequence)log.getLkSyncStatus())) {
            obj.set(KEY_LKSYNCSTATUS, (Object)log.getLkSyncStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)log.getSourceOperate())) {
            obj.set(KEY_SOURCEOPERATE, (Object)log.getSourceOperate());
        }
        if (StringUtils.isNotBlank((Object)log.getRootJobId())) {
            obj.set(KEY_ROOTJOBID, (Object)log.getRootJobId());
        }
        return obj;
    }

    private static SyncLog buildSyncLog(DynamicObject obj) {
        SyncLog log = new SyncLog();
        log.setId(Long.valueOf(obj.getLong(KEY_ID)));
        log.setStenantCode(obj.getString(KEY_STENANTCODE));
        log.setsEntityKey(obj.getString(KEY_SENTITYKEY));
        log.setSbillId(Long.valueOf(obj.getLong(KEY_SBILLID)));
        log.setTtenantCode(obj.getString(KEY_TTENANTCODE));
        log.settEntityKey(obj.getString(KEY_TENTITYKEY));
        log.setTbillId(Long.valueOf(obj.getLong(KEY_TBILLID)));
        log.setStatus(obj.getString(KEY_STATUS));
        log.setCreateTime(obj.getDate(KEY_CREATETIME));
        log.setUpdateTime(obj.getDate(KEY_UPDATETIME));
        log.setRuleId(obj.getString(KEY_RULEID));
        log.setSyncType(obj.getString(KEY_SYNCTYPE));
        log.setsAccountId(obj.getString(KEY_SACCOUNTID));
        log.settAccountId(obj.getString(KEY_TACCOUNTID));
        log.setUniqueKey(obj.getString(KEY_UNIQUEKEY));
        log.setLkSyncStatus(obj.getString(KEY_LKSYNCSTATUS));
        log.setSourceOperate(obj.getString(KEY_SOURCEOPERATE));
        log.setRootJobId(Long.valueOf(obj.getLong(KEY_ROOTJOBID)));
        log.setSbillNo(obj.getString(KEY_SBILLNO));
        log.setTbillNo(obj.getString(KEY_TBILLNO));
        return log;
    }
}

