/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ctbotp.sync;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.ctbotp.runtime.CtBFTable;
import kd.bos.entity.ctbotp.sync.SyncRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class CtSyncBillRouteService {
    private static final Log logger = LogFactory.getLog(CtSyncBillRouteService.class);
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-ctbotp";
    private static final String FORMID_CTBOTP_BILLROUTE = "bos_ctbotp_billroute";
    private static final String selectFields = "stenantcode,saccountid,sentitykey,sbillid,ttenantcode,taccountid,tentitykey,tbillid";
    private static final String KEY_STENANTCODE = "stenantcode";
    private static final String KEY_SACCOUNTID = "saccountid";
    private static final String KEY_SENTITYKEY = "sentitykey";
    private static final String KEY_SBILLID = "sbillid";
    private static final String KEY_TTENANTCODE = "ttenantcode";
    private static final String KEY_TACCOUNTID = "taccountid";
    private static final String KEY_TENTITYKEY = "tentitykey";
    private static final String KEY_TBILLID = "tbillid";
    private static final String ALGO_KEY_READ_BILL_ROUTE = "kd.bos.ctbotp.sync.CtSyncBillRouteService";

    public static Map<CtBFTable, List<Long>> getSyncBillRouteDown(String sTenantCode, String sAccountId, String sEntityKey, List<Long> sBillIds) {
        if (sBillIds == null || sBillIds.isEmpty()) {
            return null;
        }
        HashMap<CtBFTable, List<Long>> ctBFTableListMap = new HashMap<CtBFTable, List<Long>>(16);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter(KEY_SBILLID, "in", sBillIds));
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY_READ_BILL_ROUTE, FORMID_CTBOTP_BILLROUTE, selectFields, qFilters.toArray(new QFilter[0]));){
            while (ds.hasNext()) {
                ArrayList<Long> ids;
                Row row = ds.next();
                String sTenantCodeR = row.getString(0);
                String sAccountIdR = row.getString(1);
                String sEntityKeyR = row.getString(2);
                Long sBillId = row.getLong(3);
                String tTenantCode = row.getString(4);
                String tAccountId = row.getString(5);
                String tEntityKey = row.getString(6);
                if (!sTenantCode.equals(sTenantCodeR) || !sAccountId.equals(sAccountIdR) || !sEntityKey.equals(sEntityKeyR)) continue;
                CtBFTable ctBFTable = new CtBFTable(tTenantCode, tAccountId, tEntityKey);
                if (ctBFTableListMap.containsKey(ctBFTable)) {
                    ids = (ArrayList<Long>)ctBFTableListMap.get(ctBFTable);
                    if (ids.contains(sBillId)) continue;
                    ids.add(sBillId);
                    continue;
                }
                ids = new ArrayList<Long>(16);
                ids.add(sBillId);
                ctBFTableListMap.put(ctBFTable, ids);
            }
        }
        return ctBFTableListMap;
    }

    public static List<SyncRoute> getSyncRouteDown(String sTenantCode, String sAccountId, String sEntityKey, List<Long> sBillIds) {
        if (sBillIds == null || sBillIds.isEmpty()) {
            return null;
        }
        ArrayList<SyncRoute> syncRouteList = new ArrayList<SyncRoute>();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter(KEY_SBILLID, "in", sBillIds));
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY_READ_BILL_ROUTE, FORMID_CTBOTP_BILLROUTE, selectFields, qFilters.toArray(new QFilter[0]));){
            while (ds.hasNext()) {
                Row row = ds.next();
                String sTenantCodeR = row.getString(0);
                String sAccountIdR = row.getString(1);
                String sEntityKeyR = row.getString(2);
                String tTenantCode = row.getString(4);
                String tAccountId = row.getString(5);
                String tEntityKey = row.getString(6);
                if (!sTenantCode.equals(sTenantCodeR) || !sAccountId.equals(sAccountIdR) || !sEntityKey.equals(sEntityKeyR)) continue;
                SyncRoute syncRoute = new SyncRoute();
                syncRoute.setStenantCode(sTenantCodeR);
                syncRoute.setsAccountId(sAccountIdR);
                syncRoute.setsEntityKey(sEntityKeyR);
                syncRoute.setTtenantCode(tTenantCode);
                syncRoute.settAccountId(tAccountId);
                syncRoute.settEntityKey(tEntityKey);
                if (syncRouteList.contains(syncRoute)) continue;
                syncRouteList.add(syncRoute);
            }
        }
        return syncRouteList;
    }

    public static List<SyncRoute> getSyncRouteUp(String tTenantCode, String tAccountId, String tEntityKey, List<Long> tBillIds) {
        if (tBillIds == null || tBillIds.isEmpty()) {
            return null;
        }
        ArrayList<SyncRoute> syncRouteList = new ArrayList<SyncRoute>();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter(KEY_TBILLID, "in", tBillIds));
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY_READ_BILL_ROUTE, FORMID_CTBOTP_BILLROUTE, selectFields, qFilters.toArray(new QFilter[0]));){
            while (ds.hasNext()) {
                Row row = ds.next();
                String sTenantCode = row.getString(0);
                String sAccountId = row.getString(1);
                String sEntityKey = row.getString(2);
                String tTenantCodeR = row.getString(4);
                String tAccountIdR = row.getString(5);
                String tEntityKeyR = row.getString(6);
                Long tBillId = row.getLong(7);
                if (!tTenantCode.equals(tTenantCodeR) || !tAccountId.equals(tAccountIdR) || !tEntityKey.equals(tEntityKeyR)) continue;
                SyncRoute syncRoute = new SyncRoute();
                syncRoute.setStenantCode(sTenantCode);
                syncRoute.setsAccountId(sAccountId);
                syncRoute.setsEntityKey(sEntityKey);
                syncRoute.setTtenantCode(tTenantCodeR);
                syncRoute.settAccountId(tAccountIdR);
                syncRoute.settEntityKey(tEntityKeyR);
                if (syncRouteList.contains(syncRoute)) continue;
                syncRouteList.add(syncRoute);
            }
        }
        return syncRouteList;
    }

    public static Map<CtBFTable, List<Long>> getSyncBillRouteUp(String tTenantCode, String tAccountId, String tEntityKey, List<Long> tBillIds) {
        if (tBillIds == null || tBillIds.isEmpty()) {
            return null;
        }
        HashMap<CtBFTable, List<Long>> ctBFTableListMap = new HashMap<CtBFTable, List<Long>>(16);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter(KEY_TBILLID, "in", tBillIds));
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY_READ_BILL_ROUTE, FORMID_CTBOTP_BILLROUTE, selectFields, qFilters.toArray(new QFilter[0]));){
            while (ds.hasNext()) {
                ArrayList<Long> ids;
                Row row = ds.next();
                String sTenantCode = row.getString(0);
                String sAccountId = row.getString(1);
                String sEntityKey = row.getString(2);
                String tTenantCodeR = row.getString(4);
                String tAccountIdR = row.getString(5);
                String tEntityKeyR = row.getString(6);
                Long tBillId = row.getLong(7);
                if (!tTenantCode.equals(tTenantCodeR) || !tAccountId.equals(tAccountIdR) || !tEntityKey.equals(tEntityKeyR)) continue;
                CtBFTable ctBFTable = new CtBFTable(sTenantCode, sAccountId, sEntityKey);
                if (ctBFTableListMap.containsKey(ctBFTable)) {
                    ids = (ArrayList<Long>)ctBFTableListMap.get(ctBFTable);
                    if (ids.contains(tBillId)) continue;
                    ids.add(tBillId);
                    continue;
                }
                ids = new ArrayList<Long>(16);
                ids.add(tBillId);
                ctBFTableListMap.put(ctBFTable, ids);
            }
        }
        return ctBFTableListMap;
    }

    public static Set<CtBFTable> getSyncBillRouteUpByIds(List<Long> tBillIds) {
        if (tBillIds == null || tBillIds.isEmpty()) {
            return null;
        }
        HashSet<CtBFTable> ctBFTables = new HashSet<CtBFTable>();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter(KEY_TBILLID, "in", tBillIds));
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY_READ_BILL_ROUTE, FORMID_CTBOTP_BILLROUTE, selectFields, qFilters.toArray(new QFilter[0]));){
            while (ds.hasNext()) {
                Row row = ds.next();
                String sTenantCode = row.getString(0);
                String sAccountId = row.getString(1);
                String sEntityKey = row.getString(2);
                CtBFTable ctBFTable = new CtBFTable(sTenantCode, sAccountId, sEntityKey);
                ctBFTables.add(ctBFTable);
            }
        }
        return ctBFTables;
    }

    public static List<SyncRoute> getSyncRouteUpByIds(List<Long> tBillIds) {
        if (tBillIds == null || tBillIds.isEmpty()) {
            return null;
        }
        ArrayList<SyncRoute> syncRoutes = new ArrayList<SyncRoute>(16);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter(KEY_TBILLID, "in", tBillIds));
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY_READ_BILL_ROUTE, FORMID_CTBOTP_BILLROUTE, selectFields, qFilters.toArray(new QFilter[0]));){
            while (ds.hasNext()) {
                Row row = ds.next();
                String sTenantCode = row.getString(0);
                String sAccountId = row.getString(1);
                String sEntityKey = row.getString(2);
                String tTenantCode = row.getString(4);
                String tAccountId = row.getString(5);
                String tEntityKey = row.getString(6);
                Long tBillId = row.getLong(7);
                SyncRoute syncRoute = new SyncRoute();
                syncRoute.setStenantCode(sTenantCode);
                syncRoute.setsAccountId(sAccountId);
                syncRoute.setsEntityKey(sEntityKey);
                syncRoute.setTtenantCode(tTenantCode);
                syncRoute.settAccountId(tAccountId);
                syncRoute.settEntityKey(tEntityKey);
                if (syncRoutes.contains(syncRoute)) continue;
                syncRoutes.add(syncRoute);
            }
        }
        return syncRoutes;
    }

    public static Set<CtBFTable> getSyncBillRouteDownByIds(List<Long> sBillIds) {
        if (sBillIds == null || sBillIds.isEmpty()) {
            return null;
        }
        HashSet<CtBFTable> ctBFTables = new HashSet<CtBFTable>();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter(KEY_SBILLID, "in", sBillIds));
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY_READ_BILL_ROUTE, FORMID_CTBOTP_BILLROUTE, selectFields, qFilters.toArray(new QFilter[0]));){
            while (ds.hasNext()) {
                Row row = ds.next();
                String tTenantCode = row.getString(4);
                String tAccountId = row.getString(5);
                String tEntityKey = row.getString(6);
                CtBFTable ctBFTable = new CtBFTable(tTenantCode, tAccountId, tEntityKey);
                ctBFTables.add(ctBFTable);
            }
        }
        return ctBFTables;
    }

    public static List<SyncRoute> getSyncRouteDownByIds(List<Long> sBillIds) {
        if (sBillIds == null || sBillIds.isEmpty()) {
            return null;
        }
        ArrayList<SyncRoute> syncRoutes = new ArrayList<SyncRoute>(16);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter(KEY_SBILLID, "in", sBillIds));
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY_READ_BILL_ROUTE, FORMID_CTBOTP_BILLROUTE, selectFields, qFilters.toArray(new QFilter[0]));){
            while (ds.hasNext()) {
                Row row = ds.next();
                String sTenantCode = row.getString(0);
                String sAccountId = row.getString(1);
                String sEntityKey = row.getString(2);
                String tTenantCode = row.getString(4);
                String tAccountId = row.getString(5);
                String tEntityKey = row.getString(6);
                Long tBillId = row.getLong(7);
                SyncRoute syncRoute = new SyncRoute();
                syncRoute.setStenantCode(sTenantCode);
                syncRoute.setsAccountId(sAccountId);
                syncRoute.setsEntityKey(sEntityKey);
                syncRoute.setTtenantCode(tTenantCode);
                syncRoute.settAccountId(tAccountId);
                syncRoute.settEntityKey(tEntityKey);
                if (syncRoutes.contains(syncRoute)) continue;
                syncRoutes.add(syncRoute);
            }
        }
        return syncRoutes;
    }
}

