/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.BillTypeMapParser;
import kd.bos.entity.botp.BillTypeMapPolicy;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BillTypeMapTestEdit
extends AbstractFormPlugin {
    public static final String FormId_BillTypeMapTest = "botp_billtypemaptest";
    public static final String CustParamKey_BillTypeMapPolicy = "billtypemappolicy";
    public static final String CustParamKey_SourceEntityNumber = "sourceentitynumber";
    public static final String CustParamKey_TargetEntityNumber = "targetentitynumber";
    private static final String KEY_ENTITY_PUSH = "pushentry";
    private static final String KEY_SOURCEBILLTYPE = "sourcebilltype";
    private static final String KEY_PUSHRESULT = "pushresult";
    private static final String KEY_ENTITY_DRAW = "drawentry";
    private static final String KEY_TARGETBILLTYPE = "targetbilltype";
    private static final String KEY_DRAWRESULT = "drawresult";
    private static final String BOS_DESIGNER_PLUGIN = "bos-botp-formplugin";

    public void afterCreateNewData(EventObject e) {
        this.doTest();
    }

    private void doTest() {
        String sourceEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_SourceEntityNumber);
        String targetEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TargetEntityNumber);
        String pocliyString = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_BillTypeMapPolicy);
        Map<Object, DynamicObject> sourceBillTypes = this.loadBillTypeObjs(sourceEntityNumber);
        Map<Object, DynamicObject> targetBillTypes = this.loadBillTypeObjs(targetEntityNumber);
        BillTypeMapPolicy policy = StringUtils.isBlank((CharSequence)pocliyString) ? new BillTypeMapPolicy() : (BillTypeMapPolicy)SerializationUtils.fromJsonString((String)pocliyString, BillTypeMapPolicy.class);
        this.doTestPush(policy, sourceBillTypes, targetBillTypes);
        this.doTestDraw(policy, sourceBillTypes, targetBillTypes);
    }

    private void doTestPush(BillTypeMapPolicy policy, Map<Object, DynamicObject> sourceBillTypes, Map<Object, DynamicObject> targetBillTypes) {
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTITY_PUSH);
        int srcBillTypeCount = sourceBillTypes.size();
        if (srcBillTypeCount > rowCount) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTITY_PUSH, srcBillTypeCount - rowCount);
        } else {
            for (int i = rowCount - 1; i >= srcBillTypeCount; --i) {
                this.getModel().deleteEntryRow(KEY_ENTITY_PUSH, i);
            }
        }
        DynamicObject[] targetBillTypeObjs = targetBillTypes.values().toArray(new DynamicObject[targetBillTypes.size()]);
        BillTypeMapParser parser = new BillTypeMapParser();
        int rowIndex = 0;
        for (Map.Entry<Object, DynamicObject> srcBillType : sourceBillTypes.entrySet()) {
            Long srcId = (Long)srcBillType.getKey();
            String srcName = srcBillType.getValue().getString("name");
            this.getModel().setValue(KEY_SOURCEBILLTYPE, (Object)srcName, rowIndex);
            boolean parseResult = parser.tryGetTargetBillTypeIds(policy, srcId, targetBillTypeObjs);
            if (parser.isCannotPushAnyOne()) {
                this.getModel().setValue(KEY_PUSHRESULT, (Object)ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4e0b\u63a8", (String)"BillTypeMapTestEdit_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), rowIndex);
            } else if (parser.isCanPushAll()) {
                String targetBillTypeName;
                StringBuilder msgBuileder = new StringBuilder();
                if (parser.getOutCannotPushBillTypeIds().isEmpty()) {
                    msgBuileder.append(ResManager.loadKDString((String)"\u5141\u8bb8\u4e0b\u63a8\uff0c\u4e0d\u9650\u7c7b\u578b\uff1b", (String)"BillTypeMapTestEdit_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                } else {
                    targetBillTypeName = this.getBillTypeName(targetBillTypes, parser.getOutCannotPushBillTypeIds().toArray(new Long[0]));
                    msgBuileder.append(String.format(ResManager.loadKDString((String)"\u7981\u6b62\u9009\u62e9\uff1a%s\uff1b\u5176\u4ed6\u7c7b\u578b\u4e0d\u9650\uff1b", (String)"BillTypeMapTestEdit_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), targetBillTypeName));
                }
                if (!parser.getOutBillTypeIds().isEmpty()) {
                    targetBillTypeName = this.getBillTypeName(targetBillTypes, parser.getOutBillTypeIds().toArray(new Long[0]));
                    msgBuileder.append(String.format(ResManager.loadKDString((String)"\u4f18\u5148\u53d6\uff1a%s", (String)"BillTypeMapTestEdit_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), targetBillTypeName));
                }
                this.getModel().setValue(KEY_PUSHRESULT, (Object)msgBuileder.toString(), rowIndex);
            } else if (!parser.getOutBillTypeIds().isEmpty()) {
                String targetBillTypeName = this.getBillTypeName(targetBillTypes, parser.getOutBillTypeIds().toArray(new Long[0]));
                this.getModel().setValue(KEY_PUSHRESULT, (Object)String.format(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u4e0b\u63a8\uff1a%s", (String)"BillTypeMapTestEdit_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), targetBillTypeName), rowIndex);
            } else {
                this.getModel().setValue(KEY_PUSHRESULT, (Object)ResManager.loadKDString((String)"\u6b64\u5355\u636e\u7c7b\u578b\u914d\u7f6e\u6709\u95ee\u9898\uff1a\u6ca1\u6709\u627e\u5230\u53ef\u4e0b\u63a8\u7684\u76ee\u6807\u5355\u7c7b\u578b", (String)"BillTypeMapTestEdit_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), rowIndex);
            }
            ++rowIndex;
        }
    }

    private void doTestDraw(BillTypeMapPolicy policy, Map<Object, DynamicObject> sourceBillTypes, Map<Object, DynamicObject> targetBillTypes) {
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTITY_DRAW);
        int targetBillTypeCount = targetBillTypes.size();
        if (targetBillTypeCount > rowCount) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTITY_DRAW, targetBillTypeCount - rowCount);
        } else {
            for (int i = rowCount - 1; i >= targetBillTypeCount; --i) {
                this.getModel().deleteEntryRow(KEY_ENTITY_DRAW, i);
            }
        }
        BillTypeMapParser parser = new BillTypeMapParser();
        int rowIndex = 0;
        for (Map.Entry<Object, DynamicObject> targetBillType : targetBillTypes.entrySet()) {
            String sourceBillTypeName;
            String targetBillName = targetBillType.getValue().getString("name");
            this.getModel().setValue(KEY_TARGETBILLTYPE, (Object)targetBillName, rowIndex);
            boolean parseResult = parser.tryGetSourceBillTypeIds(policy, targetBillType.getValue());
            if (parser.isCannotDrawAnyOne()) {
                this.getModel().setValue(KEY_DRAWRESULT, (Object)ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u9009\u5355", (String)"BillTypeMapTestEdit_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), rowIndex);
            } else if (parser.isCanDrawAll()) {
                if (parser.getOutCannotDrawBillTypeIds().isEmpty()) {
                    this.getModel().setValue(KEY_DRAWRESULT, (Object)ResManager.loadKDString((String)"\u5141\u8bb8\u9009\u5355\uff1a\u4e0d\u9650\u7c7b\u578b", (String)"BillTypeMapTestEdit_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), rowIndex);
                } else {
                    sourceBillTypeName = this.getBillTypeName(sourceBillTypes, parser.getOutCannotDrawBillTypeIds().toArray(new Long[0]));
                    this.getModel().setValue(KEY_DRAWRESULT, (Object)String.format(ResManager.loadKDString((String)"\u5141\u8bb8\u9009\u5355\uff1a\u4f46\u9700\u6392\u9664\uff1a%s", (String)"BillTypeMapTestEdit_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), sourceBillTypeName), rowIndex);
                }
            } else if (parser.getOutBillTypeIds().isEmpty()) {
                this.getModel().setValue(KEY_DRAWRESULT, (Object)ResManager.loadKDString((String)"\u6b64\u5355\u636e\u7c7b\u578b\u914d\u7f6e\u6709\u95ee\u9898\uff1a\u6ca1\u6709\u627e\u5230\u660e\u786e\u53ef\u9009\u7684\u6e90\u5355\u7c7b\u578b", (String)"BillTypeMapTestEdit_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), rowIndex);
            } else {
                sourceBillTypeName = this.getBillTypeName(sourceBillTypes, parser.getOutBillTypeIds().toArray(new Long[0]));
                this.getModel().setValue(KEY_DRAWRESULT, (Object)String.format(ResManager.loadKDString((String)"\u5141\u8bb8\u9009\u5355\uff1a%s", (String)"BillTypeMapTestEdit_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), sourceBillTypeName), rowIndex);
            }
            ++rowIndex;
        }
    }

    private Map<Object, DynamicObject> loadBillTypeObjs(String entityNumber) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return new HashMap<Object, DynamicObject>();
        }
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)entityNumber)};
        return BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"id, number, name, status, enable, isdefault", (QFilter[])filters);
    }

    private String getBillTypeName(Map<Object, DynamicObject> billTypeObjs, Long[] billTypeIds) {
        if (billTypeIds == null || billTypeIds.length == 0) {
            return "";
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Long id : billTypeIds) {
            if (billTypeObjs.containsKey(id)) {
                String name = billTypeObjs.get(id).get("name").toString();
                names.add(name);
                continue;
            }
            names.add(id.toString());
        }
        return StringUtils.join((Object[])names.toArray(), (String)",");
    }
}

