/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BizAppTreeBuilder;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertPath;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.service.ServiceFactory;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class ConvertPathEdit
extends AbstractFormPlugin
implements TreeNodeClickListener,
RowClickEventListener,
SearchEnterListener,
HyperLinkClickListener {
    private static Log log = LogFactory.getLog(ConvertPathEdit.class);
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String KEY_NEW = "new";
    private static final String KEY_MODIFY = "modify";
    private static final String KEY_DELETE = "delete";
    private static final String KEY_FSOURCE_ENTITY_NUMBER = "fsourceentitynumber";
    private static final String KEY_FSOURCE_ENTITY_NAME = "fsourceentityname";
    private static final String KEY_FTARGET_ENTITY_NUMBER = "ftargetentitynumber";
    private static final String KEY_FTARGET_ENTITY_NAME = "ftargetentityname";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_SEARCH_PATH = "searchpath";
    private static final String FORMID_NEW_CONVERT_PATH = "botp_newconvertpath";
    private static final String FORMID_CONVERT_RULE = "botp_convertrule";
    private static final String CACHEID_CONVERT_PATHS = "paths";
    private static final String CACHEID_TREE_NODES = "nodes";
    private static final String CACHEID_CURR_NODE = "currnode";
    public static final String ParamKey_SourceBill = "SourceBill";
    public static final String ParamKey_TargetBill = "TargetBill";
    public static final String ParamKey_SourceBillName = "SourceBillName";
    public static final String ParamKey_TargetBillName = "TargetBillName";
    public static final String ParamKey_RuleId = "ruleId";
    private static final String BOS_DESIGNER_PLUGIN = "bos-botp-formplugin";
    private static final String KEY_CONVERT_RULE_TAG = "convertrule_";
    private List<ConvertPath> allPaths;

    public void initialize() {
        super.initialize();
        TreeView tView = (TreeView)this.getControl(KEY_TREEVIEW);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"tbar_main"});
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH_PATH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(CACHEID_CONVERT_PATHS);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List paths = ConvertMetaServiceHelper.loadAllConvertPaths();
        this.putPathCache(paths);
        this.doSearchByNodeId(paths, "");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TreeNode rootNode = this.buildTreeNodes();
        TreeView tView = (TreeView)this.getControl(KEY_TREEVIEW);
        tView.addNode(rootNode);
        tView.focusNode(rootNode);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
        String opKey = e.getOperateKey();
        if (opKey.equalsIgnoreCase(KEY_NEW)) {
            this.doNew();
        } else if (opKey.equalsIgnoreCase(KEY_MODIFY)) {
            this.doModify();
        } else if (opKey.equalsIgnoreCase(KEY_DELETE)) {
            this.doBeforeDelete();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equalsIgnoreCase(KEY_NEW)) {
            this.afterShowNewForm(closedCallBackEvent);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_DELETE, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.doDelete();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String currNodeId;
        String newNodeId = (String)e.getNodeId();
        if (newNodeId.equals(currNodeId = this.getPageCache().get(CACHEID_CURR_NODE))) {
            return;
        }
        List<ConvertPath> allPaths = this.getPathCache();
        this.doSearchByNodeId(allPaths, newNodeId);
        this.getPageCache().put(CACHEID_CURR_NODE, newNodeId);
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        int rowIndex = evt.getRow();
        String sourceBill = (String)this.getModel().getValue(KEY_FSOURCE_ENTITY_NUMBER, rowIndex);
        String targetBill = (String)this.getModel().getValue(KEY_FTARGET_ENTITY_NUMBER, rowIndex);
        this.showRuleForm(sourceBill, targetBill);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String sourceBill = (String)this.getModel().getValue(KEY_FSOURCE_ENTITY_NUMBER, rowIndex);
        String targetBill = (String)this.getModel().getValue(KEY_FTARGET_ENTITY_NUMBER, rowIndex);
        this.showRuleForm(sourceBill, targetBill);
    }

    private boolean isMetadataExist(String number) {
        String id = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form);
        if (id != null) {
            return true;
        }
        if (number.endsWith("_mob")) {
            number = number.substring(0, number.length() - 4);
            return this.isMetadataExist(number);
        }
        return false;
    }

    public List<String> getSearchList(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCH_PATH, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                return this.doSearchList(searchText);
            }
            return null;
        }
        return null;
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCH_PATH, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.doSearchByBill(searchText);
        }
    }

    private void doNew() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_NEW_CONVERT_PATH);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_NEW);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void doModify() {
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTRY_ENTITY);
        if (rowCount == 0) {
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY_ENTITY);
        String sourceBill = (String)this.getModel().getValue(KEY_FSOURCE_ENTITY_NUMBER, rowIndex);
        String targetBill = (String)this.getModel().getValue(KEY_FTARGET_ENTITY_NUMBER, rowIndex);
        this.showRuleForm(sourceBill, targetBill);
    }

    private void doBeforeDelete() {
        ConvertPath myPath = this.getSelectPath();
        if (myPath != null) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_DELETE, (IFormPlugin)this);
            String strDeleteConfirmTip = String.format(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u5220\u9664[%1$s]>[%2$s]\u4e4b\u95f4\u7684\u8f6c\u6362\u89c4\u5219\u5417\uff1f", (String)"ConvertPathEdit_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), myPath.getSourceEntityName(), myPath.getTargetEntityName());
            this.getView().showConfirm(strDeleteConfirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks);
            return;
        }
    }

    private void doDelete() {
        ConvertPath myPath = this.getSelectPath();
        if (myPath != null) {
            Map delResult = ConvertMetaServiceHelper.delete((String)myPath.getSourceEntityNumber(), (String)myPath.getTargetEntityNumber());
            if (delResult == null || !delResult.containsKey("success")) {
                return;
            }
            boolean success = (Boolean)delResult.get("success");
            String message = (String)delResult.get("message");
            if (!success) {
                this.getView().showTipNotification(message);
            } else {
                this.writeDeleteLog(myPath.getSourceEntityNumber(), myPath.getTargetEntityNumber());
                int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY_ENTITY);
                this.getModel().deleteEntryRow(KEY_ENTRY_ENTITY, rowIndex);
                List<ConvertPath> allPaths = this.getPathCache();
                allPaths.remove(myPath);
                this.putPathCache(allPaths);
                this.getView().showSuccessNotification(message);
            }
        }
    }

    private ConvertPath getSelectPath() {
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTRY_ENTITY);
        if (rowCount == 0) {
            return null;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY_ENTITY);
        String sourceBill = (String)this.getModel().getValue(KEY_FSOURCE_ENTITY_NUMBER, rowIndex);
        String targetBill = (String)this.getModel().getValue(KEY_FTARGET_ENTITY_NUMBER, rowIndex);
        List<ConvertPath> allPaths = this.getPathCache();
        ConvertPath myPath = null;
        for (ConvertPath path : allPaths) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)sourceBill, (CharSequence)path.getSourceEntityNumber()) || !StringUtils.equalsIgnoreCase((CharSequence)targetBill, (CharSequence)path.getTargetEntityNumber())) continue;
            myPath = path;
            break;
        }
        return myPath;
    }

    private List<String> doSearchList(String searchText) {
        HashSet<String> searchList = new HashSet<String>();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return new ArrayList<String>();
        }
        List<ConvertPath> allPaths = this.getPathCache();
        for (ConvertPath path : allPaths) {
            if (StringUtils.isNotBlank((CharSequence)path.getSourceEntityName()) && path.getSourceEntityName().indexOf(searchText) == 0) {
                searchList.add(path.getSourceEntityName());
            } else if (StringUtils.isNotBlank((CharSequence)path.getSourceEntityNumber()) && path.getSourceEntityNumber().indexOf(searchText) == 0) {
                searchList.add(path.getSourceEntityNumber());
            } else if (StringUtils.isNotBlank((CharSequence)path.getTargetEntityName()) && path.getTargetEntityName().indexOf(searchText) == 0) {
                searchList.add(path.getTargetEntityName());
            } else if (StringUtils.isNotBlank((CharSequence)path.getTargetEntityNumber()) && path.getTargetEntityNumber().indexOf(searchText) == 0) {
                searchList.add(path.getTargetEntityNumber());
            }
            if (searchList.size() < 10) continue;
            break;
        }
        return new ArrayList<String>(searchList);
    }

    private void doSearchByBill(String searchText) {
        List<ConvertPath> allPaths = this.getPathCache();
        ArrayList<ConvertPath> myPaths = new ArrayList<ConvertPath>();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            myPaths.addAll(allPaths);
        } else {
            for (ConvertPath path : allPaths) {
                if (!this.checkPathSourceAndTarget(path, searchText)) continue;
                myPaths.add(path);
            }
        }
        this.refreshEntryGrid(myPaths);
    }

    private boolean checkPathSourceAndTarget(ConvertPath path, String searchText) {
        return StringUtils.isNotBlank((CharSequence)path.getSourceEntityNumber()) && path.getSourceEntityNumber().indexOf(searchText) >= 0 || StringUtils.isNotBlank((CharSequence)path.getSourceEntityName()) && path.getSourceEntityName().indexOf(searchText) >= 0 || StringUtils.isNotBlank((CharSequence)path.getTargetEntityNumber()) && path.getTargetEntityNumber().indexOf(searchText) >= 0 || StringUtils.isNotBlank((CharSequence)path.getTargetEntityName()) && path.getTargetEntityName().indexOf(searchText) >= 0;
    }

    private void doSearchByNodeId(List<ConvertPath> allPaths, String nodedId) {
        ArrayList<ConvertPath> myPaths = new ArrayList<ConvertPath>();
        if (StringUtils.isBlank((CharSequence)nodedId)) {
            myPaths.addAll(allPaths);
        } else {
            String rootNodeJson = this.getPageCache().get(CACHEID_TREE_NODES);
            BizAppTreeBuilder bizAppTreeBuilder = (BizAppTreeBuilder)SerializationUtils.fromJsonString((String)rootNodeJson, BizAppTreeBuilder.class);
            TreeNode rootNode = bizAppTreeBuilder.getRootNode();
            if (rootNode.getId().equals(nodedId)) {
                myPaths.addAll(allPaths);
            } else {
                TreeNode cloudNode = null;
                for (TreeNode node : rootNode.getChildren()) {
                    if (!node.getId().equals(nodedId)) continue;
                    cloudNode = node;
                    break;
                }
                HashSet<String> bizAppIds = new HashSet<String>();
                if (cloudNode != null) {
                    if (cloudNode.getChildren() != null) {
                        for (TreeNode bizAppNode : cloudNode.getChildren()) {
                            bizAppIds.add(bizAppNode.getId());
                            bizAppIds.addAll((Collection)bizAppTreeBuilder.getAppExtIds().get(bizAppNode.getId()));
                        }
                    }
                } else {
                    bizAppIds.add(nodedId);
                    bizAppIds.addAll((Collection)bizAppTreeBuilder.getAppExtIds().get(nodedId));
                }
                for (ConvertPath path : allPaths) {
                    if (!bizAppIds.contains(path.getSourceBizAppId()) && !bizAppIds.contains(path.getTargetBizAppId())) continue;
                    myPaths.add(path);
                }
            }
        }
        this.refreshEntryGrid(myPaths);
    }

    private void refreshEntryGrid(List<ConvertPath> paths) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY);
        rows.clear();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRY_ENTITY);
        int seq = 1;
        for (ConvertPath path : paths) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set("seq", (Object)seq);
            row.set(KEY_FSOURCE_ENTITY_NUMBER, (Object)path.getSourceEntityNumber());
            row.set(KEY_FSOURCE_ENTITY_NAME, (Object)path.getSourceEntityName());
            row.set(KEY_FTARGET_ENTITY_NUMBER, (Object)path.getTargetEntityNumber());
            row.set(KEY_FTARGET_ENTITY_NAME, (Object)path.getTargetEntityName());
            rows.add((Object)row);
            ++seq;
        }
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }

    private void afterShowNewForm(ClosedCallBackEvent closedCallBackEvent) {
        Map params = (Map)closedCallBackEvent.getReturnData();
        if (params == null) {
            return;
        }
        String sourceBill = (String)params.get(ParamKey_SourceBill);
        String sourceBillName = (String)params.get(ParamKey_SourceBillName);
        String targetBill = (String)params.get(ParamKey_TargetBill);
        String targetBillName = (String)params.get(ParamKey_TargetBillName);
        if (StringUtils.isBlank((CharSequence)sourceBill) || StringUtils.isBlank((CharSequence)targetBill)) {
            return;
        }
        List<ConvertPath> allPaths = this.getPathCache();
        if (!this.existPath(allPaths, sourceBill, targetBill)) {
            ConvertPath newPath = new ConvertPath();
            newPath.setSourceEntityNumber(sourceBill);
            newPath.setSourceEntityName(sourceBillName);
            newPath.setTargetEntityNumber(targetBill);
            newPath.setTargetEntityName(targetBillName);
            String targetFormId = MetadataDao.getIdByNumber((String)targetBill, (MetaCategory)MetaCategory.Form);
            String targetAppId = MetadataDao.getAppIdByFormId((String)targetFormId);
            newPath.setBizAppId(targetAppId);
            newPath.setTargetBizAppId(targetAppId);
            String sourceFormId = MetadataDao.getIdByNumber((String)sourceBill, (MetaCategory)MetaCategory.Form);
            String sourceAppId = MetadataDao.getAppIdByFormId((String)sourceFormId);
            newPath.setSourceBizAppId(sourceAppId);
            allPaths.add(newPath);
            this.putPathCache(allPaths);
            this.getModel().createNewEntryRow(KEY_ENTRY_ENTITY);
            int rowIndex = this.getModel().getEntryRowCount(KEY_ENTRY_ENTITY) - 1;
            this.getModel().setValue(KEY_FSOURCE_ENTITY_NUMBER, (Object)sourceBill, rowIndex);
            this.getModel().setValue(KEY_FSOURCE_ENTITY_NAME, (Object)sourceBillName, rowIndex);
            this.getModel().setValue(KEY_FTARGET_ENTITY_NUMBER, (Object)targetBill, rowIndex);
            this.getModel().setValue(KEY_FTARGET_ENTITY_NAME, (Object)targetBillName, rowIndex);
        }
        this.showRuleForm(sourceBill, targetBill);
    }

    private void showRuleForm(String sourceBill, String targetBill) {
        if (StringUtils.isBlank((CharSequence)sourceBill) || StringUtils.isBlank((CharSequence)targetBill)) {
            return;
        }
        if (!this.isMetadataExist(sourceBill)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"number\u4e3a%s\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"ConvertPathEdit_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), sourceBill));
            return;
        }
        if (!this.isMetadataExist(targetBill)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"number\u4e3a%s\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"ConvertPathEdit_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), targetBill));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_CONVERT_RULE);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam(ParamKey_SourceBill, (Object)sourceBill);
        showParameter.setCustomParam(ParamKey_TargetBill, (Object)targetBill);
        showParameter.getCustomParams().put("checkRightAppId", this.getView().getFormShowParameter().getAppId());
        this.getView().showForm(showParameter);
    }

    private boolean existPath(List<ConvertPath> allPaths, String sourceBill, String targetBill) {
        for (ConvertPath path : allPaths) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)path.getSourceEntityNumber(), (CharSequence)sourceBill) || !StringUtils.equalsIgnoreCase((CharSequence)path.getTargetEntityNumber(), (CharSequence)targetBill)) continue;
            return true;
        }
        return false;
    }

    private TreeNode buildTreeNodes() {
        BizAppTreeBuilder bizAppTreeBuilder = new BizAppTreeBuilder();
        bizAppTreeBuilder.setRuntime(true);
        TreeNode root = bizAppTreeBuilder.buildTree();
        root.setId("0");
        root.setText(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"ConvertPathEdit_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        String json = SerializationUtils.toJsonString((Object)bizAppTreeBuilder);
        this.getPageCache().put(CACHEID_TREE_NODES, json);
        return root;
    }

    private void putPathCache(List<ConvertPath> paths) {
        String pathsJsonString = SerializationUtils.toJsonString(paths);
        this.getPageCache().put(CACHEID_CONVERT_PATHS, pathsJsonString);
        this.allPaths = paths;
    }

    private List<ConvertPath> getPathCache() {
        if (this.allPaths != null) {
            return this.allPaths;
        }
        String pathsJsonString = this.getPageCache().get(CACHEID_CONVERT_PATHS);
        this.allPaths = StringUtils.isBlank((CharSequence)pathsJsonString) ? new ArrayList<ConvertPath>() : SerializationUtils.fromJsonStringToList((String)pathsJsonString, ConvertPath.class);
        return this.allPaths;
    }

    private void writeDeleteLog(String srcEntityNumber, String targetEntityNumber) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        MainEntityType srcMainType = null;
        MainEntityType targetMainType = null;
        try {
            srcMainType = EntityMetadataCache.getDataEntityType((String)srcEntityNumber);
            targetMainType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
        }
        catch (Throwable exp) {
            log.error("\u8bfb\u53d6\u5143\u6570\u636e\u5931\u8d25,err:" + exp.getMessage());
        }
        String appNumber = srcMainType == null ? "" : srcMainType.getBizAppNumber();
        String appId = " ";
        if (StringUtils.isNotEmpty((CharSequence)appNumber)) {
            try {
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
                if (null != appInfo) {
                    appId = appInfo.getId();
                }
            }
            catch (KDException e) {
                log.error((Throwable)e);
            }
        }
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID("botp_crlist");
        logInfo.setOrgID(Long.valueOf(0L));
        TimeService timeService = new TimeService();
        logInfo.setOpTime(timeService.getCurrentSystemTime());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5220\u9664", "ConvertPathEdit_2", BOS_DESIGNER_PLUGIN);
        logInfo.setOpName(KEY_DELETE, opNameBridge);
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u5220\u9664\u8f6c\u6362\u8def\u7ebf\uff1a%1$s \u5230 %2$s", "ConvertPathEdit_3", BOS_DESIGNER_PLUGIN);
        logInfo.setOpDesc(opDescBridge, new String[]{srcEntityNumber, targetEntityNumber});
        logService.addLog((AppLogInfo)logInfo);
    }
}

