/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.designer.botp.ConvertRuleRightChecker;
import kd.bos.designer.botp.FieldEventHandler;
import kd.bos.designer.botp.GetRuleHelper;
import kd.bos.designer.botp.LockRuleHelper;
import kd.bos.designer.botp.RuleCacheHelper;
import kd.bos.designer.botp.RuleTreeNode;
import kd.bos.designer.botp.SetRuleHelper;
import kd.bos.designer.botp.common.RuleFormConst;
import kd.bos.designer.botp.common.RuleFormHelper;
import kd.bos.designer.botp.extcontrol.domain.ExtControlCarryDomain;
import kd.bos.designer.botp.extcontrol.domain.ExtControlEditDomain;
import kd.bos.designer.botp.extcontrol.domain.ExtControlLockDomain;
import kd.bos.designer.botp.extcontrol.helper.CarryParamDataHelper;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CheckPoint;
import kd.bos.entity.botp.CheckResult;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.GroupByMode;
import kd.bos.entity.botp.LinkRecordType;
import kd.bos.entity.botp.extcontrol.ExtControlElement;
import kd.bos.entity.botp.extcontrol.ExtControlParam;
import kd.bos.entity.botp.plugin.ConvertRuleSetPlugInProxy;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.botp.ConvertRuleMetadata;
import kd.bos.metadata.botp.ConvertRuleTemplate;
import kd.bos.metadata.botp.ConvertRuleVer;
import kd.bos.metadata.botp.DesignConvertRuleMeta;
import kd.bos.metadata.botp.common.RuleIsvHelper;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class ConvertRuleEdit
extends AbstractFormPlugin
implements TabSelectListener,
TreeNodeClickListener,
HyperLinkClickListener,
RuleFormConst {
    private static Log log = LogFactory.getLog(ConvertRuleEdit.class);
    private RuleTreeNode rootRuleNode;
    private RuleTreeNode currRuleNode;
    private ConvertRuleMetadata ruleMetadata;
    private GetRuleHelper getRuleHelper;
    private SetRuleHelper setRuleHelper;
    private LockRuleHelper lockRuleHelper;
    private FieldEventHandler eventHandler;
    private ConvertRuleSetPlugInProxy ruleSetPlugInProxy;
    private Map<String, ConvertRuleMetadata> beforeModifyRuleMap = new HashMap<String, ConvertRuleMetadata>(16);
    private RuleFormHelper ruleFormHelper = new RuleFormHelper(this);
    private static final String BOS_DESIGNER_PLUGIN = "bos-botp-formplugin";
    private static final String CONVERT_RULE_EDIT_58 = "ConvertRuleEdit_58";
    private static final String BOTP_WRITEBACKRULE = "botp_writebackrule";
    private static final String TARGETENTIRYNUMBER_ID = "targetentitynumber.id";
    private static final String SOURCEENTIRYNUMBER_ID = "sourceentitynumber.id";
    private static final String SWITCH_TREE_NODE = "switchTreeNode";
    private FunctionHelper functionHelper;
    private ExtControlLockDomain extControlLockDomain;
    private ExtControlEditDomain extControlEditDomain;
    private ExtControlCarryDomain extControlCarryDomain;
    private CarryParamDataHelper carryParamDataHelper = new CarryParamDataHelper();

    public ConvertRuleEdit() {
        this.functionHelper = new FunctionHelper(this);
        this.extControlEditDomain = new ExtControlEditDomain(() -> this.functionHelper.getRuleIsv(), () -> this.functionHelper.isRootNode());
        this.extControlLockDomain = new ExtControlLockDomain(() -> this.functionHelper.getRuleIsv(), () -> this.functionHelper.isRootNode());
        this.extControlCarryDomain = new ExtControlCarryDomain(() -> this.ruleFormHelper.getSourceEntityNumber(), () -> this.ruleFormHelper.getTargetEntityNumber());
    }

    public RuleFormHelper getRuleFormHelper() {
        return this.ruleFormHelper;
    }

    private RuleTreeNode getRootRuleNode() {
        if (this.rootRuleNode == null) {
            this.rootRuleNode = RuleCacheHelper.getRootRuleNode(this);
        }
        return this.rootRuleNode;
    }

    private RuleTreeNode getCurrRuleNode() {
        String ruleId;
        if (this.currRuleNode == null && StringUtils.isNotBlank((CharSequence)(ruleId = (String)this.getModel().getValue("fid")))) {
            RuleTreeNode rootRuleNode = this.getRootRuleNode();
            this.currRuleNode = rootRuleNode.searchRule(ruleId);
        }
        return this.currRuleNode;
    }

    private ConvertRuleMetadata getCacheRuleMetadata() {
        if (this.ruleMetadata == null) {
            RuleTreeNode currRuleNode = this.getCurrRuleNode();
            this.ruleMetadata = currRuleNode == null ? new ConvertRuleMetadata() : currRuleNode.deserialize(this.getRootRuleNode());
        }
        return this.ruleMetadata;
    }

    private GetRuleHelper getGetRuleHelper() {
        if (this.getRuleHelper == null) {
            this.getRuleHelper = new GetRuleHelper(this.getView(), this, this.extControlLockDomain);
        }
        return this.getRuleHelper;
    }

    private SetRuleHelper getSetRuleHelper() {
        if (this.setRuleHelper == null) {
            this.setRuleHelper = new SetRuleHelper(this.getView(), this, this.extControlLockDomain, this.extControlEditDomain);
        }
        return this.setRuleHelper;
    }

    private LockRuleHelper getLockRuleHelper() {
        if (this.lockRuleHelper == null) {
            this.lockRuleHelper = new LockRuleHelper(this.getView(), this);
        }
        return this.lockRuleHelper;
    }

    private FieldEventHandler getEventHandler() {
        if (this.eventHandler == null) {
            this.eventHandler = new FieldEventHandler(this.getView(), this, this.extControlLockDomain, this.extControlEditDomain);
        }
        return this.eventHandler;
    }

    public ConvertRuleSetPlugInProxy getRuleSetPlugInProxy() {
        String tgtEntityNumber;
        if (this.ruleSetPlugInProxy != null) {
            return this.ruleSetPlugInProxy;
        }
        BillEntityType srcMainType = null;
        BillEntityType tgtMainType = null;
        ArrayList plugins = new ArrayList();
        String srcEntityNumber = this.ruleFormHelper.getSourceEntityNumber();
        if (StringUtils.isNotBlank((CharSequence)srcEntityNumber)) {
            srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)srcEntityNumber);
            LinkSetElement srcLinkSet = ConvertMetaServiceHelper.loadLinkSet((String)srcEntityNumber);
            if (srcLinkSet != null && srcLinkSet.getConvRulePlugIns() != null) {
                plugins.addAll(srcLinkSet.getConvRulePlugIns());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(tgtEntityNumber = this.ruleFormHelper.getTargetEntityNumber()))) {
            tgtMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)tgtEntityNumber);
            LinkSetElement tgtLinkSet = ConvertMetaServiceHelper.loadLinkSet((String)tgtEntityNumber);
            if (tgtLinkSet != null && tgtLinkSet.getConvRulePlugIns() != null) {
                plugins.addAll(tgtLinkSet.getConvRulePlugIns());
            }
        }
        this.ruleSetPlugInProxy = new ConvertRuleSetPlugInProxy(plugins);
        this.ruleSetPlugInProxy.setContext(srcMainType, tgtMainType);
        return this.ruleSetPlugInProxy;
    }

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"tbar_main", "tbar_treeview", "tbar_billtypemap", "tbar_fieldmap", "tbar_bizrule", "advcontoolbarap", "tbar_plugin"});
        FieldEventHandler fieldEventHandler = this.getEventHandler();
        fieldEventHandler.addClickListeners();
        fieldEventHandler.addHyperLinkClickListener();
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"button_down_extclose", "button_up_extclose"});
        Tab tab = (Tab)this.getView().getControl("tbctrl_design");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        SetRuleHelper.setHelpText(this.getView());
        String sourceBill = this.ruleFormHelper.getSourceEntityNumber();
        String targetBill = this.ruleFormHelper.getTargetEntityNumber();
        this.getModel().setValue("fsourcebill", (Object)sourceBill);
        this.getModel().setValue("ftargetbill", (Object)targetBill);
        List<ConvertRuleMetadata> ruleMetadatas = this.loadMetas(sourceBill, targetBill, true);
        for (ConvertRuleMetadata ruleMetadata : ruleMetadatas) {
            if (!ruleMetadata.getRuleElement().isDefRule() || ruleMetadata.getDevType().equals("2")) continue;
            RuleCacheHelper.putDefRuleId(this, ruleMetadata.getRuleElement().getId());
            break;
        }
        RuleTreeNode rootRuleNode = RuleTreeNode.BuildRuleTree(ruleMetadatas);
        RuleCacheHelper.putRootRuleNode(this, rootRuleNode);
        TreeNode rootNode = rootRuleNode.buildTreeNodes();
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        for (TreeNode childNode : rootNode.getChildren()) {
            tView.addNode(childNode);
        }
        this.setCtrlPropsValue();
        RuleTreeNode firstRuleNode = null;
        Object ruleId = this.getView().getFormShowParameter().getCustomParam("ruleId");
        if (ruleId != null && StringUtils.isNotBlank((CharSequence)ruleId.toString())) {
            firstRuleNode = rootRuleNode.searchRule(ruleId.toString());
            if (firstRuleNode == null) {
                firstRuleNode = rootRuleNode.getChildren().entrySet().iterator().next().getValue();
            }
        } else {
            firstRuleNode = rootRuleNode.getChildren().entrySet().iterator().next().getValue();
        }
        ConvertRuleMetadata ruleMetadata = firstRuleNode.deserialize(rootRuleNode);
        this.currRuleNode = firstRuleNode;
        this.ruleMetadata = ruleMetadata;
        this.setRule();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFocusRule();
        this.setControlVisible();
        this.setFilterAp();
        if (Plugin.enableKingScript((String)"ConvertRuleModel")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnaddtsplug"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnaddjsplug"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnaddtsplug"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnaddjsplug"});
        }
        this.extControlEditDomain.visitExtControlButton(this.getView());
        this.extControlCarryDomain.visitExtControlButton(this.getView());
        this.extControlLockDomain.afterTreeNodeChange(this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        FieldEventHandler fieldEventHandler = this.getEventHandler();
        fieldEventHandler.Click(source.getKey());
        this.extControlEditDomain.clickExtControlButton(this, source.getKey());
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        this.extControlLockDomain.stopAndTipsButton(evt, this.getView());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String barItemKey = evt.getItemKey();
        this.extControlLockDomain.beforeTreeNodeChange(this, barItemKey);
        if (barItemKey.equalsIgnoreCase("btnsave")) {
            this.doModify();
            this.doSaveAll();
        } else if (barItemKey.equalsIgnoreCase("btnwriteback")) {
            this.openWriteBackList();
        } else if (barItemKey.equalsIgnoreCase("btnnewrule")) {
            this.doModify();
            this.doNewOrCarry();
        } else if (barItemKey.equalsIgnoreCase("tbncopy")) {
            ConvertRuleMetadata currRuleMeta = this.doModify();
            if (currRuleMeta != null) {
                this.doCopy(currRuleMeta);
            }
        } else if (barItemKey.equalsIgnoreCase("btnext")) {
            ConvertRuleMetadata currRuleMeta = this.doModify();
            if (currRuleMeta != null) {
                this.doExt(currRuleMeta);
            }
        } else if (barItemKey.equalsIgnoreCase("btninherit")) {
            ConvertRuleMetadata currRuleMeta = this.doModify();
            if (currRuleMeta != null) {
                this.doInherit(currRuleMeta);
            }
        } else if (barItemKey.equalsIgnoreCase("btndelete")) {
            this.doDelete();
        } else if (barItemKey.equalsIgnoreCase("btnxml")) {
            ConvertRuleMetadata currRuleMeta = this.doModify();
            if (currRuleMeta != null) {
                this.doShowXML();
            }
        } else if (barItemKey.equalsIgnoreCase("btnautomatchfield")) {
            SetRuleHelper setRuleHelper = this.getSetRuleHelper();
            setRuleHelper.autoMatchFields();
        } else if (barItemKey.equalsIgnoreCase("btn_control_create_rule")) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("botp_control_settings");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("fsourcebill", (Object)this.ruleFormHelper.getSourceEntityNumber());
            formShowParameter.setCustomParam("ftargetbill", (Object)this.ruleFormHelper.getTargetEntityNumber());
            this.getView().showForm(formShowParameter);
        } else {
            FieldEventHandler eventHandler = this.getEventHandler();
            eventHandler.itemClick(evt);
        }
        this.extControlLockDomain.afterTreeNodeChange(this, barItemKey);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String currRuleId = (String)this.getModel().getValue("fid");
        String nextRuleId = (String)e.getNodeId();
        if (StringUtils.isBlank((CharSequence)nextRuleId)) {
            nextRuleId = "0";
        }
        if (nextRuleId.equals("0") || nextRuleId.equals(currRuleId)) {
            return;
        }
        this.extControlLockDomain.beforeTreeNodeChange(this);
        ConvertRuleMetadata currRuleMeta = this.doModify();
        if (currRuleMeta != null) {
            this.ruleMetadata = RuleCacheHelper.getRule(this, nextRuleId);
            this.getPageCache().put(SWITCH_TREE_NODE, "true");
            this.setRule();
            this.setFocusRule();
            Tab tab = (Tab)this.getView().getControl("tbctrl_design");
            this.getView().getPageCache().put("tab_select", tab.getCurrentTab());
            this.getView().getPageCache().put("tab_select_before", tab.getCurrentTab());
        }
        this.getPageCache().put(SWITCH_TREE_NODE, "false");
        this.extControlLockDomain.afterTreeNodeChange(this);
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void tabSelected(TabSelectEvent evt) {
        if ("tbpage_filter".equals(evt.getTabKey())) {
            boolean isEnable = (Boolean)this.getView().getModel().getValue("advanced_conditions");
            if (isEnable) {
                this.extControlEditDomain.changeTabSelected(this, "adv_filter");
            } else {
                this.extControlEditDomain.changeTabSelected(this, evt.getTabKey());
            }
        } else {
            this.extControlEditDomain.changeTabSelected(this, evt.getTabKey());
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        if (this.extControlLockDomain.stopAndTipsHyperLink(e, this.getView())) {
            return;
        }
        FieldEventHandler eventHandler = this.getEventHandler();
        eventHandler.hyperLinkClick(e);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equalsIgnoreCase("botp_convertrulexml")) {
            this.doReceiveXML(closedCallBackEvent);
        } else if (closedCallBackEvent.getActionId().equals("selectRule")) {
            String node;
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(node = (String)returnData.get("node")))) {
                ConvertRuleMetadata rule = RuleCacheHelper.getRule(this, node);
                this.extControlLockDomain.beforeTreeNodeChange(this);
                this.doCarry(rule);
                this.extControlLockDomain.afterTreeNodeChange(this);
            }
        } else {
            FieldEventHandler clickHandler = this.getEventHandler();
            clickHandler.closedCallBack(closedCallBackEvent.getActionId(), closedCallBackEvent.getReturnData());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        FieldEventHandler fieldEventHandler = this.getEventHandler();
        fieldEventHandler.propertyChanged(e);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)"g_billdel", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("g_billentry");
            } else {
                this.getModel().setValue("g_billcombo", (Object)GroupByMode.GroupByField.getValue());
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"g_entrydel", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("g_entry");
            } else {
                this.getModel().setValue("g_entrycombo", (Object)GroupByMode.GroupByField.getValue());
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"g_subentrydel", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("g_subentry");
            } else {
                this.getModel().setValue("g_subentrycombo", (Object)GroupByMode.GroupByField.getValue());
            }
        }
    }

    private void doNewOrCarry() {
        if (this.extControlCarryDomain.enableNew()) {
            if (this.extControlCarryDomain.enableCarry()) {
                this.doCarry();
                return;
            }
            this.doNew();
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8f6c\u6362\u8def\u7ebf\u5df2\u51fa\u5382\u63a7\u5236\uff0c\u4e0d\u5141\u8bb8\u65b0\u5efa\u8f6c\u6362\u89c4\u5219\u3002", (String)"ConvertRuleEdit_202", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
    }

    private void doNew() {
        RuleTreeNode ruleTreeNode;
        ConvertRuleMetadata newRuleMeta;
        if (!ConvertRuleRightChecker.hasRight(this.getView().getFormShowParameter().getCheckRightAppId(), "47156aff000000ac")) {
            this.getView().showTipNotification(this.getMultiLNoOperationPermission());
            return;
        }
        String sourceBill = this.ruleFormHelper.getSourceEntityNumber();
        String targetBill = this.ruleFormHelper.getTargetEntityNumber();
        this.ruleMetadata = newRuleMeta = this.createBlankRule(sourceBill, targetBill);
        this.currRuleNode = ruleTreeNode = RuleCacheHelper.addRule(this, newRuleMeta);
        this.getModel().beginInit();
        this.setRule();
        this.getModel().endInit();
        this.getView().updateView();
        TreeNode treeNode = ruleTreeNode.buildTreeNode();
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        tView.addNode(treeNode);
        this.setFocusRule();
    }

    private void doCarry() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("botp_extclose_takenew_pop");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        RuleTreeNode rootRuleNode = this.getRootRuleNode();
        Map<String, String> ruleNodes = rootRuleNode.getChildren().values().stream().filter(x -> !x.isDeleted()).collect(Collectors.toMap(RuleTreeNode::getId, RuleTreeNode::getName));
        formShowParameter.setCustomParam("nodes", (Object)SerializationUtils.toJsonString(ruleNodes));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u65b0\u589e\u643a\u5e26\u89c4\u5219", (String)"ConvertRuleEdit_201", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectRule"));
        this.getView().showForm(formShowParameter);
    }

    private void doCarry(ConvertRuleMetadata currRuleMeta) {
        RuleTreeNode ruleTreeNode;
        ConvertRuleMetadata newRuleMeta;
        if (!ConvertRuleRightChecker.hasRight(this.getView().getFormShowParameter().getCheckRightAppId(), "47156aff000000ac")) {
            this.getView().showTipNotification(this.getMultiLNoOperationPermission());
            return;
        }
        String sourceBill = this.ruleFormHelper.getSourceEntityNumber();
        String targetBill = this.ruleFormHelper.getTargetEntityNumber();
        this.ruleMetadata = newRuleMeta = this.createBlankRule(sourceBill, targetBill);
        this.extControlCarryDomain.carryRule(newRuleMeta, currRuleMeta);
        this.currRuleNode = ruleTreeNode = RuleCacheHelper.addRule(this, newRuleMeta);
        this.getModel().beginInit();
        this.setRule();
        this.getModel().endInit();
        this.getView().updateView();
        TreeNode treeNode = ruleTreeNode.buildTreeNode();
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        tView.addNode(treeNode);
        this.setFocusRule();
    }

    private void doCopy(ConvertRuleMetadata currRuleMeta) {
        RuleTreeNode ruleTreeNode;
        if (!ConvertRuleRightChecker.hasRight(this.getView().getFormShowParameter().getCheckRightAppId(), "4730fc9f000020ae")) {
            this.getView().showTipNotification(this.getMultiLNoOperationPermission());
            return;
        }
        currRuleMeta.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
        currRuleMeta.getName().setLocaleValue_zh_CN(String.format(ResManager.loadKDString((String)"%s_\u590d\u5236", (String)"ConvertRuleEdit_72", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), currRuleMeta.getName().getLocaleValue_zh_CN()));
        currRuleMeta.setMasterId("");
        currRuleMeta.setParentId("");
        currRuleMeta.setInheritPath("");
        currRuleMeta.setDevType("0");
        currRuleMeta.getRuleElement().setEnabled(false);
        currRuleMeta.setCreateDate(TimeServiceHelper.now());
        this.currRuleNode = ruleTreeNode = RuleCacheHelper.addRule(this, currRuleMeta);
        this.ruleMetadata = currRuleMeta;
        this.getModel().setValue("fid", (Object)currRuleMeta.getId());
        this.getModel().setValue("fmulilangname", (Object)currRuleMeta.getName());
        this.getModel().setValue("fenabled", (Object)currRuleMeta.getRuleElement().isEnabled());
        TreeNode treeNode = ruleTreeNode.buildTreeNode();
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        tView.addNode(treeNode);
        this.setFocusRule();
    }

    private void doInherit(ConvertRuleMetadata currRuleMeta) {
        RuleTreeNode ruleTreeNode;
        if (!ConvertRuleRightChecker.hasRight(this.getView().getFormShowParameter().getCheckRightAppId(), "47156aff000000ac")) {
            this.getView().showTipNotification(this.getMultiLNoOperationPermission());
            return;
        }
        String parentId = currRuleMeta.getId();
        ConvertRuleMetadata parentRuleMeta = currRuleMeta;
        if (StringUtils.isNotBlank((CharSequence)currRuleMeta.getMasterId())) {
            parentId = currRuleMeta.getMasterId();
            parentRuleMeta = RuleCacheHelper.getRule(this, parentId);
        }
        if (parentRuleMeta == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u539f\u751f\u89c4\u5219\u3002", (String)"ConvertRuleEdit_73", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        currRuleMeta.setParentId(parentId);
        currRuleMeta.setMasterId("");
        String inheritPath = parentRuleMeta.getInheritPath();
        inheritPath = StringUtils.isBlank((CharSequence)inheritPath) ? parentId : inheritPath + "," + parentId;
        currRuleMeta.setInheritPath(inheritPath);
        currRuleMeta.setDevType("1");
        currRuleMeta.getRuleElement().setDefRule(false);
        currRuleMeta.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
        currRuleMeta.getName().setLocaleValue_zh_CN(String.format(ResManager.loadKDString((String)"%s_\u7ee7\u627f", (String)"ConvertRuleEdit_78", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), currRuleMeta.getName().getLocaleValue_zh_CN()));
        currRuleMeta.getRuleElement().setEnabled(false);
        currRuleMeta.setCreateDate(TimeServiceHelper.now());
        this.currRuleNode = ruleTreeNode = RuleCacheHelper.addRule(this, currRuleMeta);
        this.ruleMetadata = currRuleMeta;
        this.getModel().setValue("fid", (Object)currRuleMeta.getId());
        this.getModel().setValue("fmulilangname", (Object)currRuleMeta.getName());
        this.getModel().setValue("fenabled", (Object)currRuleMeta.getRuleElement().isEnabled());
        TreeNode treeNode = ruleTreeNode.buildTreeNode();
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        tView.addNode(treeNode);
        this.setFocusRule();
    }

    private void doExt(ConvertRuleMetadata currRuleMeta) {
        RuleTreeNode ruleTreeNode;
        String inheritPath;
        if (!ConvertRuleRightChecker.hasRight(this.getView().getFormShowParameter().getCheckRightAppId(), "4715a0df000000ac")) {
            this.getView().showTipNotification(this.getMultiLNoOperationPermission());
            return;
        }
        RuleTreeNode currRuleNode = this.getCurrRuleNode();
        int extCount = 0;
        for (RuleTreeNode childNode : currRuleNode.getChildren().values()) {
            if (childNode.isDeleted() || !"2".equals(childNode.getDevType())) continue;
            ++extCount;
        }
        if (extCount > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u7684\u89c4\u5219\uff0c\u5df2\u7ecf\u5b58\u5728\u4e86\u6269\u5c55\uff0c\u4e0d\u5141\u8bb8\u6269\u5c55\u591a\u6b21\u3002", (String)"ConvertRuleEdit_66", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        currRuleMeta.setParentId(currRuleMeta.getId());
        if (StringUtils.isBlank((CharSequence)currRuleMeta.getMasterId())) {
            currRuleMeta.setMasterId(currRuleMeta.getId());
        }
        inheritPath = StringUtils.isBlank((CharSequence)(inheritPath = currRuleMeta.getInheritPath())) ? currRuleMeta.getId() : inheritPath + "," + currRuleMeta.getId();
        currRuleMeta.setInheritPath(inheritPath);
        currRuleMeta.setDevType("2");
        currRuleMeta.getRuleElement().setDefRule(false);
        currRuleMeta.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
        currRuleMeta.getName().setLocaleValue_zh_CN(String.format(ResManager.loadKDString((String)"%s_\u6269\u5c55", (String)"ConvertRuleEdit_79", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), currRuleMeta.getName().getLocaleValue_zh_CN()));
        currRuleMeta.setCreateDate(TimeServiceHelper.now());
        this.currRuleNode = ruleTreeNode = RuleCacheHelper.addRule(this, currRuleMeta);
        this.ruleMetadata = currRuleMeta;
        this.getModel().setValue("fid", (Object)currRuleMeta.getId());
        this.getModel().setValue("fmulilangname", (Object)currRuleMeta.getName());
        this.getModel().setValue("fdefault", (Object)false);
        TreeNode treeNode = ruleTreeNode.buildTreeNode();
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        tView.addNode(treeNode);
        this.setFocusRule();
    }

    private ConvertRuleMetadata doModify() {
        String currRuleId = (String)this.getModel().getValue("fid");
        if (StringUtils.isBlank((CharSequence)currRuleId)) {
            return null;
        }
        RuleTreeNode rootRuleNode = RuleCacheHelper.getRootRuleNode(this);
        RuleTreeNode currRuleNode = rootRuleNode.searchRule(currRuleId);
        if (currRuleNode == null) {
            return null;
        }
        ConvertRuleMetadata ruleMetadata = currRuleNode.deserialize(rootRuleNode);
        boolean newDefFlag = (Boolean)this.getModel().getValue("fdefault");
        boolean oldDefFlag = this.isDefRule(ruleMetadata);
        if (newDefFlag) {
            String defRuleId = ruleMetadata.getId();
            if (StringUtils.isNotBlank((CharSequence)ruleMetadata.getMasterId())) {
                defRuleId = ruleMetadata.getMasterId();
            }
            RuleCacheHelper.putDefRuleId(this, defRuleId);
        } else if (oldDefFlag) {
            RuleCacheHelper.putDefRuleId(this, "");
        }
        currRuleNode.setEnabled((Boolean)this.getModel().getValue("fenabled"));
        currRuleNode.setChanged(true);
        if (!currRuleNode.isCanModify()) {
            RuleCacheHelper.putRootRuleNode(this, rootRuleNode);
        } else {
            ruleMetadata = this.getRule(ruleMetadata);
            currRuleNode.setName(ruleMetadata.getName().toString());
            String currentIsv = RuleIsvHelper.getUserIsv();
            ConvertRuleMetadata parentRuleMeta = RuleCacheHelper.getRule(this, ruleMetadata.getParentId());
            RuleTreeNode newNode = RuleTreeNode.buildRuleNode(parentRuleMeta, ruleMetadata, currentIsv);
            currRuleNode.setDesignJson(newNode.getDesignJson());
            currRuleNode.setLocaleIds(newNode.getLocaleIds());
            currRuleNode.setLocaleItems(newNode.getLocaleItems());
            RuleCacheHelper.putRootRuleNode(this, rootRuleNode);
        }
        return ruleMetadata;
    }

    private void doDelete() {
        RuleTreeNode nextRuleNode;
        String currRuleId = (String)this.getModel().getValue("fid");
        if (StringUtils.isBlank((CharSequence)currRuleId)) {
            return;
        }
        RuleTreeNode rootRuleNode = RuleCacheHelper.getRootRuleNode(this);
        RuleTreeNode currRuleNode = rootRuleNode.searchRule(currRuleId);
        if (currRuleNode == null) {
            return;
        }
        if (!currRuleNode.isNewed()) {
            if (!ConvertRuleRightChecker.hasRight(this.getView().getFormShowParameter().getCheckRightAppId(), "4715e1f1000000ac")) {
                this.getView().showTipNotification(this.getMultiLNoOperationPermission());
                return;
            }
            boolean isEnable = (Boolean)this.getModel().getValue("fenabled");
            if (isEnable) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u7684\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ConvertRuleEdit_60", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
        }
        if (!currRuleNode.isCanModify()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u7684\u662f\u9884\u7f6e\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u88ab\u5220\u9664\u3002", (String)"ConvertRuleEdit_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        tView.deleteNode(currRuleId);
        this.currRuleNode = nextRuleNode = RuleCacheHelper.deleteRule(this, currRuleId);
        this.getModel().beginInit();
        ConvertRuleMetadata nextRuleMeta = null;
        nextRuleMeta = nextRuleNode == null ? new ConvertRuleMetadata() : nextRuleNode.deserialize(rootRuleNode);
        this.ruleMetadata = nextRuleMeta;
        this.setRule();
        this.getModel().endInit();
        this.getView().updateView();
        this.setFocusRule();
    }

    private void doShowXML() {
        String currRuleId = (String)this.getModel().getValue("fid");
        if (StringUtils.isBlank((CharSequence)currRuleId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u67e5\u770bXML\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"ConvertRuleEdit_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        RuleTreeNode rootRuleNode = RuleCacheHelper.getRootRuleNode(this);
        RuleTreeNode currNode = rootRuleNode.searchRule(currRuleId);
        if (currNode == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5728\u89c4\u5219\u6811\u4e0a\uff0c\u6ca1\u6709\u627e\u5230\u5f53\u524d\u89c4\u5219\u3002", (String)"ConvertRuleEdit_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        RuleTreeNode parentNode = rootRuleNode.searchRule(currNode.getParentId());
        String xml = "";
        if (parentNode == null) {
            ConvertRuleTemplate template = new ConvertRuleTemplate();
            ConvertRuleMetadata currRule = currNode.deserialize(rootRuleNode);
            xml = template.buildDiffXml(currRule, null, false);
        } else {
            ConvertRuleMetadata currRule = currNode.deserialize(rootRuleNode);
            ConvertRuleMetadata parentRule = parentNode.deserialize(rootRuleNode);
            ConvertRuleTemplate template = new ConvertRuleTemplate();
            xml = template.buildDiffXml(currRule, parentRule, false);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_convertrulexml");
        showParameter.setCustomParam("xml", (Object)xml);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (!currNode.isCanModify()) {
            showParameter.setCustomParam("lock", (Object)"true");
        } else {
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "botp_convertrulexml");
            showParameter.setCloseCallBack(callBack);
        }
        this.getView().showForm(showParameter);
    }

    private void doReceiveXML(ClosedCallBackEvent closedCallBackEvent) {
        String xml = (String)closedCallBackEvent.getReturnData();
        if (StringUtils.isBlank((CharSequence)xml)) {
            return;
        }
        RuleTreeNode rootRuleNode = RuleCacheHelper.getRootRuleNode(this);
        String currRuleId = (String)this.getModel().getValue("fid");
        RuleTreeNode currNode = rootRuleNode.searchRule(currRuleId);
        String designJson = currNode.getDesignJson();
        DesignConvertRuleMeta designMeta = (DesignConvertRuleMeta)SerializationUtils.fromJsonString((String)designJson, DesignConvertRuleMeta.class);
        RuleTreeNode parentNode = rootRuleNode.searchRule(currNode.getParentId());
        ConvertRuleTemplate template = new ConvertRuleTemplate();
        ConvertRuleMetadata xmlRule = null;
        ConvertRuleMetadata parentRule = null;
        if (parentNode == null) {
            xmlRule = template.getMetadata(xml, null);
        } else {
            parentRule = parentNode.deserialize(rootRuleNode);
            xmlRule = template.getMetadata(xml, parentRule);
            parentRule = parentNode.deserialize(rootRuleNode);
        }
        xmlRule.convertFromDesignMeta((DesignMeta)designMeta);
        String diffXml = template.buildDiffXml(xmlRule, parentRule, false);
        designMeta.setDataXml(diffXml);
        designJson = SerializationUtils.toJsonString((Object)designMeta);
        currNode.setDesignJson(designJson);
        currNode.setChanged(true);
        RuleCacheHelper.putRootRuleNode(this, rootRuleNode);
        this.getModel().beginInit();
        this.getModel().setValue("isv_tag", (Object)xmlRule.getIsv());
        SetRuleHelper helper = new SetRuleHelper(this.getView(), this, this.extControlLockDomain, this.extControlEditDomain);
        helper.setRule(xmlRule.getRuleElement());
        this.getModel().endInit();
        this.getView().updateView();
    }

    private void openWriteBackList() {
        String sourceBill = this.ruleFormHelper.getSourceEntityNumber();
        String targetBill = this.ruleFormHelper.getTargetEntityNumber();
        if (StringUtils.isBlank((CharSequence)sourceBill)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u6ca1\u6709\u786e\u5b9a\u6e90\u5355\uff0c\u4e0d\u80fd\u8c03\u7528\u53cd\u5199\u5217\u8868\u3002", (String)"ConvertRuleEdit_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)targetBill)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u6ca1\u6709\u786e\u5b9a\u76ee\u6807\u5355\uff0c\u4e0d\u80fd\u8c03\u7528\u53cd\u5199\u5217\u8868\u3002", (String)"ConvertRuleEdit_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setCustomParam(TARGETENTIRYNUMBER_ID, (Object)targetBill);
        parameter.setCustomParam(SOURCEENTIRYNUMBER_ID, (Object)sourceBill);
        parameter.setBillFormId(BOTP_WRITEBACKRULE);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void doSaveAll() {
        if (!ConvertRuleRightChecker.hasRight(this.getView().getFormShowParameter().getCheckRightAppId(), "4715a0df000000ac")) {
            this.getView().showTipNotification(this.getMultiLNoOperationPermission());
            return;
        }
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("SourceBill");
        String targetBill = (String)this.getView().getFormShowParameter().getCustomParam("TargetBill");
        DynamicObject data = this.carryParamDataHelper.loadData(sourceBill, targetBill);
        String mustInputJson = null;
        if (data != null) {
            mustInputJson = this.carryParamDataHelper.getMustInputJson(data);
        }
        ArrayList<ExtControlElement> elements = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)mustInputJson)) {
            elements = SerializationUtils.fromJsonStringToList((String)mustInputJson, ExtControlElement.class);
        }
        if (StringUtils.isBlank((CharSequence)sourceBill)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u6ca1\u6709\u786e\u5b9a\u6e90\u5355\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"ConvertRuleEdit_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)targetBill)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u6ca1\u6709\u786e\u5b9a\u76ee\u6807\u5355\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"ConvertRuleEdit_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        RuleTreeNode rootRuleNode = RuleCacheHelper.getRootRuleNode(this);
        List<RuleTreeNode> ruleNodes = rootRuleNode.mergeAllChildren();
        ArrayList<ConvertRuleMetadata> addList = new ArrayList<ConvertRuleMetadata>();
        ArrayList<ConvertRuleMetadata> modifyList = new ArrayList<ConvertRuleMetadata>();
        ArrayList<ConvertRuleMetadata> delList = new ArrayList<ConvertRuleMetadata>();
        ArrayList<String> delRuleIds = new ArrayList<String>();
        ArrayList<Object> oriRuleList = new ArrayList<Object>();
        ConvertRuleMetadata defRuleNode = null;
        String defRuleId = RuleCacheHelper.getDefRuleId(this);
        for (RuleTreeNode ruleNode : ruleNodes) {
            ConvertRuleMetadata ruleMetadata = ruleNode.deserialize(rootRuleNode);
            ruleMetadata.getRuleElement().setEnabled(ruleNode.isEnabled());
            if (ruleNode.isDeleted()) {
                if (ruleNode.isNewed()) continue;
                delRuleIds.add(ruleNode.getId());
                delList.add(ruleMetadata);
                continue;
            }
            if (ruleNode.isNewed()) {
                addList.add(ruleMetadata);
            } else if (ruleNode.isChanged()) {
                modifyList.add(ruleMetadata);
                if (ruleNode.isCanModify()) {
                    ruleMetadata.setModifierId(RequestContext.get().getUserId());
                    ruleMetadata.setModifyDate(TimeServiceHelper.now());
                }
            }
            if (StringUtils.equals((CharSequence)ruleNode.getDevType(), (CharSequence)"2")) continue;
            oriRuleList.add(ruleMetadata);
            if (StringUtils.equals((CharSequence)defRuleId, (CharSequence)ruleMetadata.getId())) {
                ruleMetadata.getRuleElement().setDefRule(true);
                defRuleNode = ruleMetadata;
                continue;
            }
            ruleMetadata.getRuleElement().setDefRule(false);
        }
        ArrayList<ConvertRuleMetadata> allSaveList = new ArrayList<ConvertRuleMetadata>();
        allSaveList.addAll(modifyList);
        allSaveList.addAll(addList);
        CheckResult checkResult = new CheckResult();
        if (!this.doCheck(allSaveList, checkResult, elements)) {
            this.doShowCheckResult(checkResult);
            return;
        }
        for (ConvertRuleMetadata convertRuleMetadata : modifyList) {
            this.beforeModifyRuleMap.put(convertRuleMetadata.getId(), ConvertMetaServiceHelper.loadMeta((String)convertRuleMetadata.getId(), (boolean)false));
        }
        for (ConvertRuleMetadata convertRuleMetadata : modifyList) {
            ConvertMetaServiceHelper.save((ConvertRuleMetadata)convertRuleMetadata);
        }
        if (!modifyList.isEmpty()) {
            this.writeSaveLog(modifyList, true);
        }
        for (ConvertRuleMetadata convertRuleMetadata : addList) {
            ConvertMetaServiceHelper.save((ConvertRuleMetadata)convertRuleMetadata);
        }
        if (!addList.isEmpty()) {
            this.writeSaveLog(addList, false);
        }
        if (delRuleIds.size() > 0) {
            ConvertMetaServiceHelper.delete((String[])delRuleIds.toArray(new String[delRuleIds.size()]));
            this.writeDeleteLog(delList);
        }
        if (defRuleNode != null) {
            ConvertMetaServiceHelper.saveDefaultStatus((ConvertRuleMetadata)defRuleNode);
        } else {
            for (ConvertRuleMetadata convertRuleMetadata : oriRuleList) {
                ConvertMetaServiceHelper.saveDefaultStatus((ConvertRuleMetadata)convertRuleMetadata);
            }
        }
        List<ConvertRuleMetadata> ruleMetas = this.loadMetas(sourceBill, targetBill, false);
        ConvertRuleVer.saveAsVer(ruleMetas);
        rootRuleNode = RuleTreeNode.BuildRuleTree(ruleMetas);
        RuleCacheHelper.putRootRuleNode(this, rootRuleNode);
        TreeNode treeNode = rootRuleNode.buildTreeNodes();
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        for (TreeNode childTreeNode : treeNode.getChildren()) {
            tView.updateNode(childTreeNode);
        }
        String ruleId = (String)this.getModel().getValue("fid");
        if (StringUtils.isNotBlank((CharSequence)ruleId)) {
            TreeNode currNode = new TreeNode();
            currNode.setId(ruleId);
            tView.focusNode(currNode);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ConvertRuleEdit_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
    }

    private boolean doCheck(List<ConvertRuleMetadata> ruleMetadatas, CheckResult checkResult, List<ExtControlElement> elements) {
        CheckPoint checkPoint = new CheckPoint(null, "");
        for (ConvertRuleMetadata ruleMetadata : ruleMetadatas) {
            if (!ruleMetadata.getRuleElement().isEnabled()) continue;
            Map elementMap = elements.stream().collect(Collectors.toMap(ExtControlElement::getModelType, Function.identity()));
            List ruleElements = ruleMetadata.getRuleElement().getExtElements().stream().filter(e -> e.getType() == 2).collect(Collectors.toList());
            Map ruleElementMap = ruleElements.stream().collect(Collectors.toMap(ExtControlElement::getModelType, Function.identity()));
            for (Integer key : ruleElementMap.keySet()) {
                List params = ((ExtControlElement)ruleElementMap.get(key)).getExtControlParam().getParams();
                params = params.stream().filter(ExtControlParam.Param::isMustInput).collect(Collectors.toList());
                if (key == 11) {
                    key = 7;
                }
                if (elementMap.get(key) != null) {
                    ArrayList<ExtControlParam.Param> remove = new ArrayList<ExtControlParam.Param>(16);
                    List parentParams = ((ExtControlElement)elementMap.get(key)).getExtControlParam().getParams();
                    for (ExtControlParam.Param parentParam : parentParams) {
                        for (ExtControlParam.Param param : params) {
                            if (!parentParam.getKey().equals(param.getKey())) continue;
                            remove.add(param);
                        }
                    }
                    params.removeAll(remove);
                    ((ExtControlElement)elementMap.get(key)).getExtControlParam().getParams().addAll(params);
                    continue;
                }
                ExtControlElement extControlElement = ExtControlElement.createNewInstanceByMultiSelect((int)key);
                extControlElement.getExtControlParam().getParams().addAll(params);
                elementMap.put(key, extControlElement);
            }
            ruleMetadata.getRuleElement().check(checkPoint, checkResult, elementMap);
        }
        return checkResult.isPass();
    }

    private void doShowCheckResult(CheckResult checkResult) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_rulecheckreport");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u89c4\u5219\u542f\u7528\u68c0\u67e5\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"ConvertRuleEdit_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        String json = SerializationUtils.toJsonString((Object)checkResult);
        showParameter.setCustomParam("checkresult", (Object)json);
        this.getView().showForm(showParameter);
    }

    private List<ConvertRuleMetadata> loadMetas(String sourceBill, String targetBill, boolean autoCreateNew) {
        List ruleMetas = ConvertMetaServiceHelper.loadMetas((String)sourceBill, (String)targetBill);
        if (ruleMetas.isEmpty() && autoCreateNew) {
            ConvertRuleMetadata newRuleMeta = this.createBlankRule(sourceBill, targetBill);
            newRuleMeta.getRuleElement().setDefRule(true);
            String currentIsv = RuleIsvHelper.getUserIsv();
            newRuleMeta.setIsv(currentIsv);
            if (StringUtils.isNotBlank((CharSequence)sourceBill) && StringUtils.isNotBlank((CharSequence)targetBill)) {
                ConvertMetaServiceHelper.save((ConvertRuleMetadata)newRuleMeta);
            }
            ruleMetas.add(newRuleMeta);
        }
        return ruleMetas;
    }

    private ConvertRuleMetadata createBlankRule(String sourceBill, String targetBill) {
        LinkSetElement linkSet;
        ConvertRuleTemplate template = new ConvertRuleTemplate();
        ConvertRuleMetadata newRuleMeta = template.CreateBlankRule();
        newRuleMeta.getRuleElement().setSourceEntityNumber(sourceBill);
        newRuleMeta.getRuleElement().setTargetEntityNumber(targetBill);
        newRuleMeta.getRuleElement().setVisibled(true);
        newRuleMeta.getRuleElement().setDrawVisibled(true);
        if (StringUtils.isNotBlank((CharSequence)targetBill) && (linkSet = ConvertMetaServiceHelper.loadLinkSet((String)targetBill)) != null && linkSet.getItems().size() > 0) {
            newRuleMeta.getRuleElement().getLinkEntityPolicy().setTargetEntryKey(((LinkSetItemElement)linkSet.getItems().get(0)).getParentEntityKey());
            newRuleMeta.getRuleElement().getLinkEntityPolicy().setLinkRecordType(LinkRecordType.Link);
        }
        if (StringUtils.isNotBlank((CharSequence)sourceBill) && (linkSet = ConvertMetaServiceHelper.loadLinkSet((String)sourceBill)) != null && linkSet.getItems().size() > 0) {
            newRuleMeta.getRuleElement().getLinkEntityPolicy().setSourceEntryKey(((LinkSetItemElement)linkSet.getItems().get(0)).getParentEntityKey());
        }
        return newRuleMeta;
    }

    private ConvertRuleMetadata getRule(ConvertRuleMetadata ruleMetadata) {
        ConvertRuleElement rule = ruleMetadata.getRuleElement();
        GetRuleHelper helper = this.getGetRuleHelper();
        rule = helper.getRule(rule);
        return ruleMetadata;
    }

    private void setRule() {
        ConvertRuleMetadata ruleMetadata = this.getCacheRuleMetadata();
        ConvertRuleElement ruleElement = ruleMetadata.getRuleElement();
        boolean isDefault = this.isDefRule(ruleMetadata);
        this.getModel().setValue("fdefault", (Object)isDefault);
        this.getModel().setValue("isv_tag", (Object)ruleMetadata.getIsv());
        SetRuleHelper setRuleHelper = this.getSetRuleHelper();
        setRuleHelper.setRule(ruleElement);
        setRuleHelper.fillFilterGridFields();
    }

    private void setControlVisible() {
        if (!Boolean.parseBoolean(this.getView().getModel().getValue("checkbaseenable").toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mulcombobaseenable"});
        }
        SetRuleHelper setRuleHelper = this.getSetRuleHelper();
        setRuleHelper.setBillPushAttr();
    }

    private void setFilterAp() {
        boolean isEnable = (Boolean)this.getView().getModel().getValue("advanced_conditions");
        if (isEnable) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fs_filter"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"fs_advfilter"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"fs_filter"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"fs_advfilter"});
        }
    }

    private void setFocusRule() {
        RuleTreeNode currRuleNode = this.getCurrRuleNode();
        ConvertRuleMetadata ruleMetadata = this.getCacheRuleMetadata();
        ConvertRuleElement ruleElement = ruleMetadata.getRuleElement();
        SetRuleHelper setRuleHelper = this.getSetRuleHelper();
        setRuleHelper.setFilterCondition(ruleElement);
        boolean isDefault = this.isDefRule(ruleMetadata);
        this.getModel().setValue("fdefault", (Object)isDefault);
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        String ruleId = (String)this.getModel().getValue("fid");
        if (StringUtils.isNotBlank((CharSequence)ruleId)) {
            TreeNode currNode = new TreeNode();
            currNode.setId(ruleId);
            tView.focusNode(currNode);
        }
        LockRuleHelper lockRuleHelper = this.getLockRuleHelper();
        if (currRuleNode == null) {
            lockRuleHelper.lockRule(true);
            lockRuleHelper.setLabelIsvVisiable(false);
        } else {
            lockRuleHelper.lockRule(!currRuleNode.isCanModify());
            lockRuleHelper.setLabelIsvVisiable(!currRuleNode.isCanModify());
            lockRuleHelper.setAutoSaveEnable(currRuleNode.isCanModify());
            lockRuleHelper.setBillPushEnable(currRuleNode.isCanModify());
        }
    }

    private void setCtrlPropsValue() {
        if (StringUtils.isBlank((CharSequence)this.ruleFormHelper.getSourceEntityNumber()) || StringUtils.isBlank((CharSequence)this.ruleFormHelper.getTargetEntityNumber())) {
            return;
        }
        SetRuleHelper helper = this.getSetRuleHelper();
        helper.fillLinkEntityCombo();
        helper.fillCheckBaseEnableCombo();
    }

    private boolean isDefRule(ConvertRuleMetadata ruleMetadata) {
        String defRuleId = RuleCacheHelper.getDefRuleId(this);
        if (StringUtils.equals((CharSequence)ruleMetadata.getId(), (CharSequence)defRuleId)) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)ruleMetadata.getMasterId()) && StringUtils.equals((CharSequence)ruleMetadata.getMasterId(), (CharSequence)defRuleId);
    }

    private void writeSaveLog(List<ConvertRuleMetadata> rules, boolean isNeedInit) {
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "ConvertRuleEdit_64", BOS_DESIGNER_PLUGIN);
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("%1$s>%2$s\uff1a\u8f6c\u6362\u89c4\u5219\uff08%3$s\uff09\uff0c\u4fdd\u5b58\u6210\u529f", "ConvertRuleEdit_83", BOS_DESIGNER_PLUGIN);
        this.writeLog(rules, "save", opNameBridge, opDescBridge);
        StringBuilder remarkBuilder = new StringBuilder(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219", (String)"ConvertRuleEdit_70", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        if (isNeedInit) {
            remarkBuilder.append(ResManager.loadKDString((String)"_\u4fee\u6539", (String)"ConvertRuleEdit_71", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        this.writeMetadataLog(rules, MetaLogType.BotpSave.getValue(), isNeedInit, remarkBuilder.toString());
    }

    private void writeDeleteLog(List<ConvertRuleMetadata> rules) {
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5220\u9664", "ConvertRuleEdit_62", BOS_DESIGNER_PLUGIN);
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("%1$s>%2$s\uff1a\u8f6c\u6362\u89c4\u5219\uff08%3$s\uff09\uff0c\u5220\u9664\u6210\u529f", "ConvertRuleEdit_84", BOS_DESIGNER_PLUGIN);
        this.writeLog(rules, "delete", opNameBridge, opDescBridge);
    }

    private void writeLog(List<ConvertRuleMetadata> rules, String opKey, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        ArrayList<OpLogAppInfo> appLogInfoList = new ArrayList<OpLogAppInfo>(10);
        MainEntityType srcMainType = null;
        MainEntityType targetMainType = null;
        try {
            srcMainType = EntityMetadataCache.getDataEntityType((String)rules.get(0).getRuleElement().getSourceEntityNumber());
            targetMainType = EntityMetadataCache.getDataEntityType((String)rules.get(0).getRuleElement().getTargetEntityNumber());
        }
        catch (Throwable exp) {
            log.error("\u8bfb\u53d6\u5143\u6570\u636e\u5931\u8d25", exp);
        }
        for (ConvertRuleMetadata ruleMetadata : rules) {
            OpLogAppInfo logInfo = new OpLogAppInfo();
            logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
            String appNumber = srcMainType == null ? "" : srcMainType.getBizAppNumber();
            String appId = " ";
            if (StringUtils.isNotEmpty((CharSequence)appNumber)) {
                try {
                    AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
                    if (null != appInfo) {
                        appId = appInfo.getId();
                    }
                }
                catch (KDException e) {
                    log.error((Throwable)e);
                }
            }
            logInfo.setBizAppID(appId);
            logInfo.setBizObjID("botp_crlist");
            logInfo.setOrgID(Long.valueOf(0L));
            logInfo.setOpTime(TimeServiceHelper.now());
            logInfo.setClientType(RequestContext.get().getClient());
            logInfo.setClientIP(RequestContext.get().getLoginIP());
            logInfo.setOpName(opKey, opNameBridge);
            logInfo.setOpDesc(opDescBridge, new String[]{srcMainType == null ? "" : srcMainType.getName(), targetMainType == null ? "" : targetMainType.getName(), ruleMetadata.getId()});
            appLogInfoList.add(logInfo);
        }
        logService.addBatchLog(appLogInfoList);
    }

    private void writeMetadataLog(List<ConvertRuleMetadata> rules, int metaLogType, boolean isNeedInit, String remark) {
        MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
        long[] globalLongIds = new long[]{};
        if (!rules.isEmpty()) {
            globalLongIds = DB.genGlobalLongIds((int)rules.size());
        }
        for (int i = 0; i < rules.size(); ++i) {
            ConvertRuleMetadata rule = rules.get(i);
            long logId = globalLongIds[i];
            String metaId = rule.getId();
            String metaNumber = rule.getRuleElement().getSourceEntityNumber() + "-" + rule.getRuleElement().getTargetEntityNumber();
            if (isNeedInit && CollectionUtils.isEmpty((Collection)logService.queryMetaIds(Stream.of(metaId).collect(Collectors.toList())))) {
                ConvertRuleTemplate template = new ConvertRuleTemplate();
                String sourceXmlData = template.buildDiffXml(this.beforeModifyRuleMap.get(rule.getId()), null, false);
                long initLogId = DB.genGlobalLongId();
                logService.addBotpMetaLog(metaId, metaNumber, sourceXmlData, (int)MetaLogType.BotpInit.getValue(), initLogId, rule.getBizappId(), remark);
            }
            String remarkDesc = remark;
            if (!isNeedInit) {
                String remarkSuffix = ResManager.loadKDString((String)"_\u65b0\u589e", (String)"ConvertRuleEdit_67", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                if ("1".equals(rule.getDevType())) {
                    remarkSuffix = ResManager.loadKDString((String)"_\u7ee7\u627f", (String)"ConvertRuleEdit_61", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                } else if ("2".equals(rule.getDevType())) {
                    remarkSuffix = ResManager.loadKDString((String)"_\u6269\u5c55", (String)"ConvertRuleEdit_69", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                }
                remarkDesc = remark + remarkSuffix;
            }
            logService.addBotpMetaLog(metaId, metaNumber, this.getRuleXml(rule.getId()), metaLogType, logId, rule.getBizappId(), remarkDesc);
        }
    }

    private String getRuleXml(String ruleId) {
        RuleTreeNode rootRuleNode = RuleCacheHelper.getRootRuleNode(this);
        RuleTreeNode currNode = rootRuleNode.searchRule(ruleId);
        String xml = "";
        if (currNode != null) {
            ConvertRuleTemplate template = new ConvertRuleTemplate();
            ConvertRuleMetadata currRule = currNode.deserialize(rootRuleNode);
            xml = template.buildDiffXml(currRule, null, false);
        }
        return xml;
    }

    private String getMultiLNoOperationPermission() {
        return ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650!", (String)"ConvertRuleEdit_74", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
    }

    class FunctionHelper {
        private AbstractFormPlugin plugin;

        public FunctionHelper(AbstractFormPlugin plugin) {
            this.plugin = plugin;
        }

        private String getRuleIsv() {
            RuleTreeNode currentRuleNode = null;
            String ruleId = (String)this.plugin.getView().getModel().getValue("fid");
            if (StringUtils.isNotBlank((CharSequence)ruleId)) {
                RuleTreeNode rootRuleNode = RuleCacheHelper.getRootRuleNode(this.plugin);
                currentRuleNode = rootRuleNode.searchRule(ruleId);
            }
            if (currentRuleNode == null) {
                log.error("ConvertRuleEdit#getRuleIsv error, not find metadata from current node.");
                return "";
            }
            ConvertRuleMetadata ruleMetadata = currentRuleNode.deserialize(ConvertRuleEdit.this.getRootRuleNode());
            if (ruleMetadata == null) {
                log.error("ConvertRuleEdit#getRuleIsv error, not find metadata from current node.");
                return "";
            }
            return ruleMetadata.getIsv();
        }

        private boolean isRootNode() {
            RuleTreeNode currentRuleNode = null;
            String ruleId = (String)this.plugin.getView().getModel().getValue("fid");
            if (StringUtils.isNotBlank((CharSequence)ruleId)) {
                RuleTreeNode rootRuleNode = RuleCacheHelper.getRootRuleNode(this.plugin);
                currentRuleNode = rootRuleNode.searchRule(ruleId);
            }
            if (currentRuleNode == null) {
                log.error("ConvertRuleEdit#isRootNode error, not find current node.");
                return false;
            }
            return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)currentRuleNode.getParentId());
        }
    }
}

