/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class ConvertRuleListPlugin
extends AbstractListPlugin {
    private static Log log = LogFactory.getLog(ConvertRuleListPlugin.class);
    public static final String ParamKey_SourceBill = "SourceBill";
    public static final String ParamKey_TargetBill = "TargetBill";
    private static final String FORMID_CONVERT_RULE = "botp_convertrule";
    public static final String ParamKey_RuleId = "ruleId";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_SOURCE_APPNAME = "sourceentitynumber.bizappid.name";
    private static final String KEY_Target_APPNAME = "targetentitynumber.bizappid.name";
    private static final String LISTHYPERLINK_SELECT_FIELDS = "id,sourceentitynumber.number,targetentitynumber.number";
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection datas = e.getPageData();
        if (datas == null) {
            return;
        }
        for (DynamicObject data : datas) {
            if (StringUtils.equals((CharSequence)"0", (CharSequence)data.getString(KEY_ENABLED))) continue;
            data.set(KEY_ENABLED, (Object)"1");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        if (args.getHyperLinkClickEvent() instanceof BillListHyperLinkClickEvent) {
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            ListSelectedRow row = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow();
            Object pkValue = row.getPrimaryKeyValue();
            QFilter[] filters = new QFilter[]{new QFilter(billList.getEntityType().getPrimaryKey().getName(), "=", pkValue)};
            DynamicObject dynamicObject = ORM.create().queryOne(billList.getEntityType().getName(), LISTHYPERLINK_SELECT_FIELDS, filters);
            if (dynamicObject == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684%s\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"ConvertRuleListPlugin_6", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), row.getName()));
                return;
            }
            String sourceBill = dynamicObject.getString("sourceentitynumber.number");
            String targetBill = dynamicObject.getString("targetentitynumber.number");
            this.showRuleForm(sourceBill, targetBill, pkValue);
        }
    }

    private void showRuleForm(String sourceBill, String targetBill, Object ruleId) {
        if (StringUtils.isBlank((CharSequence)sourceBill)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6e90\u5355\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"ConvertRuleListPlugin_0", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)targetBill)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"ConvertRuleListPlugin_1", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_CONVERT_RULE);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam(ParamKey_SourceBill, (Object)sourceBill);
        showParameter.setCustomParam(ParamKey_TargetBill, (Object)targetBill);
        showParameter.setCustomParam(ParamKey_RuleId, ruleId);
        showParameter.getCustomParams().put("checkRightAppId", this.getView().getFormShowParameter().getAppId());
        this.getView().showForm(showParameter);
    }
}

