/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.ConvertRuleEdit;
import kd.bos.designer.botp.extcontrol.domain.ExtControlLockDomain;
import kd.bos.designer.botp.extcontrol.helper.ShowFormHelper;
import kd.bos.entity.botp.AttachmentPanelMapItem;
import kd.bos.entity.botp.AttachmentPanelMapPolicy;
import kd.bos.entity.botp.BillTypeMapItem;
import kd.bos.entity.botp.BillTypeMapPolicy;
import kd.bos.entity.botp.BizRulePolicy;
import kd.bos.entity.botp.CRBizRuleElement;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.CRPlugin;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FieldConvertType;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.FieldMapPolicy;
import kd.bos.entity.botp.FieldSumType;
import kd.bos.entity.botp.FilterPolicy;
import kd.bos.entity.botp.GroupByMode;
import kd.bos.entity.botp.GroupByPolicy;
import kd.bos.entity.botp.LinkEntityPolicy;
import kd.bos.entity.botp.LinkRecordType;
import kd.bos.entity.botp.PlugInPolicy;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;

class GetRuleHelper {
    private IFormView view;
    private ConvertRuleEdit plugin;
    private ExtControlLockDomain extControlDomain;

    public GetRuleHelper(IFormView view, ConvertRuleEdit plugin, ExtControlLockDomain extControlDomain) {
        this.view = view;
        this.plugin = plugin;
        this.extControlDomain = extControlDomain;
    }

    private IFormView getView() {
        return this.view;
    }

    private IDataModel getModel() {
        return this.view.getModel();
    }

    public ConvertRuleElement getRule(ConvertRuleElement rule) {
        this.getModel().getDataEntity(true);
        this.getBaseInfo(rule);
        if (StringUtils.isBlank((CharSequence)rule.getSourceEntityNumber()) || StringUtils.isBlank((CharSequence)rule.getTargetEntityNumber())) {
            return rule;
        }
        this.getLinkEntryPolicy(rule);
        this.getBillTypeMapPolicy(rule);
        this.getFieldMapPolicy(rule);
        this.getAttachmentPanelMapPolicy(rule);
        this.getGroupByPolicy(rule);
        this.getFilterPolicyPolicy(rule);
        this.getBizRulePolicy(rule);
        this.getPluginPolicy(rule);
        this.getOptionPolicy(rule);
        this.extControlDomain.setExtControlDataToConvertRule(this.plugin, rule);
        ShowFormHelper showFormHelper = new ShowFormHelper(this.plugin);
        showFormHelper.unshowExtCloseFlex(true);
        return rule;
    }

    private void getBaseInfo(ConvertRuleElement rule) {
        String localeId = RequestContext.get().getLang().toString();
        if (rule.getName() == null) {
            rule.setName(new LocaleString());
        }
        rule.getName().putAll((Map)((OrmLocaleValue)this.getModel().getValue("fmulilangname")));
        rule.setDefRule(((Boolean)this.getModel().getValue("fdefault")).booleanValue());
        rule.setEnabled(((Boolean)this.getModel().getValue("fenabled")).booleanValue());
        rule.setVisibled(((Boolean)this.getModel().getValue("fvisibled")).booleanValue());
        rule.setVisibledCtrl(((Boolean)this.getModel().getValue("fvisibledctrl")).booleanValue());
        rule.setDrawVisibled(((Boolean)this.getModel().getValue("fdrawvisibled")).booleanValue());
        rule.setAutoSave(Boolean.parseBoolean(this.getModel().getValue("fautosave").toString()));
        rule.setBillPush(((Boolean)this.getModel().getValue("fbillpush")).booleanValue());
        String runConditionJson = (String)this.getModel().getValue("fruncondition");
        if (StringUtils.isBlank((CharSequence)runConditionJson)) {
            rule.setRunCondition(null);
        } else {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)runConditionJson, CRCondition.class);
            rule.setRunCondition(condition);
        }
    }

    private void getLinkEntryPolicy(ConvertRuleElement rule) {
        String targetLinkEntry = (String)this.getModel().getValue("ftargetentrykey");
        String targetLinkSubEntry = (String)this.getModel().getValue("ftargetsubentrykey");
        String sourceLinkEntry = (String)this.getModel().getValue("fsourceentrykey");
        String sourceLinkSubEntry = (String)this.getModel().getValue("fsourcesubentrykey");
        String sourceLayout = (String)this.getModel().getValue("fsourcelayout");
        String mobSourceLayout = (String)this.getModel().getValue("fmobsourcelayout");
        String targetLayout = (String)this.getModel().getValue("ftargetlayout");
        String mobTargetLayout = (String)this.getModel().getValue("fmobtargetlayout");
        boolean linkRecord = (Boolean)this.getModel().getValue("flinkrecord");
        LinkEntityPolicy policy = rule.getLinkEntityPolicy();
        policy.setTargetEntryKey(targetLinkEntry);
        policy.setTargetSubEntryKey(targetLinkSubEntry);
        policy.setSourceEntryKey(sourceLinkEntry);
        policy.setSourceSubEntryKey(sourceLinkSubEntry);
        policy.setSourceLayout(sourceLayout);
        policy.setMobSourceLayout(mobSourceLayout);
        policy.setTargetLayout(targetLayout);
        policy.setMobTargetLayout(mobTargetLayout);
        if (linkRecord) {
            policy.setLinkRecordType(LinkRecordType.Link);
        } else {
            policy.setLinkRecordType(LinkRecordType.OnlyCopy);
        }
    }

    public void getBillTypeMapPolicy(ConvertRuleElement rule) {
        BillTypeMapPolicy policy = rule.getBillTypeMapPolicy();
        policy.getItems().clear();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("billtypemappolicy");
        int seq = 1;
        for (DynamicObject row : rows) {
            BillTypeMapItem mapItem = new BillTypeMapItem();
            mapItem.setId(row.getString("billtypemapitemid"));
            mapItem.setSeq(seq);
            String sourceType = row.getString("sourcebilltype");
            if (StringUtils.equalsIgnoreCase((CharSequence)sourceType, (CharSequence)"All")) {
                mapItem.setSourceType("All");
                mapItem.setSourceBillTypeId(0L);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)sourceType, (CharSequence)"Others")) {
                mapItem.setSourceType("Others");
                mapItem.setSourceBillTypeId(0L);
            } else if (StringUtils.isNotBlank((CharSequence)sourceType)) {
                mapItem.setSourceType("Spec");
                mapItem.setSourceBillTypeId(Long.parseLong(sourceType));
            } else {
                mapItem.setSourceType("Spec");
                mapItem.setSourceBillTypeId(0L);
            }
            String pushType = row.getString("pushtype");
            String targetBillTypeId = row.getString("targetbilltype");
            mapItem.setPushType(pushType);
            if (StringUtils.isBlank((CharSequence)targetBillTypeId)) {
                mapItem.setTargetBillTypeId(0L);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)pushType, (CharSequence)"Spec") || StringUtils.equalsIgnoreCase((CharSequence)pushType, (CharSequence)"NoSpec")) {
                mapItem.setTargetBillTypeId(Long.parseLong(targetBillTypeId));
            } else {
                mapItem.setTargetBillTypeId(0L);
            }
            policy.getItems().add(mapItem);
            ++seq;
        }
    }

    public void getAttachmentPanelMapPolicy(ConvertRuleElement rule) {
        AttachmentPanelMapPolicy policy = rule.getAttachmentPanelMapPolicy();
        policy.getItems().clear();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("attachmentpanelmappolicy");
        int seq = 1;
        for (DynamicObject row : rows) {
            AttachmentPanelMapItem mapItem = new AttachmentPanelMapItem();
            mapItem.setId(row.getString("attachmentpanelmapitemid"));
            mapItem.setSeq(seq);
            String sourceAttachmentPanel = row.getString("sourceattachmentpanel");
            mapItem.setSourceAttachmentPanel(sourceAttachmentPanel);
            String targetAttachmentPanel = row.getString("targetattachmentpanel");
            mapItem.setTargetAttachmentPanel(targetAttachmentPanel);
            String attachmentPanelMergeType = row.getString("attachmentmergetype");
            mapItem.setAttachmentPanelMergeType(attachmentPanelMergeType);
            policy.getItems().add(mapItem);
            ++seq;
        }
    }

    private void getFieldMapPolicy(ConvertRuleElement rule) {
        FieldMapPolicy policy = rule.getFieldMapPolicy();
        policy.getFieldMaps().clear();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("fieldmappolicy");
        for (DynamicObject row : rows) {
            FieldMapItem item = new FieldMapItem();
            String targetFieldKey = row.getString("ftargetfield");
            if (StringUtils.isBlank((CharSequence)targetFieldKey)) continue;
            item.setTargetFieldKey(targetFieldKey);
            String convertTypeFldValue = row.getString("fconverttype");
            int convertType = StringUtils.isBlank((CharSequence)convertTypeFldValue) ? FieldConvertType.SourceField.getValue() : Integer.parseInt(convertTypeFldValue);
            String sourceFieldKey = row.getString("fsourcefield");
            String formula = row.getString("ffieldformula");
            if (FieldConvertType.SourceField.getValue() == convertType) {
                item.setFieldConvertType(FieldConvertType.SourceField);
                item.setSourceFieldKey(sourceFieldKey);
            } else if (FieldConvertType.Formula.getValue() == convertType) {
                item.setFieldConvertType(FieldConvertType.Formula);
                if (StringUtils.isNotBlank((CharSequence)formula)) {
                    CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)formula, CRFormula.class);
                    item.setFormula(crFormula);
                }
            } else if (FieldConvertType.ByCondition.getValue() == convertType) {
                item.setFieldConvertType(FieldConvertType.ByCondition);
                if (StringUtils.isNotBlank((CharSequence)formula)) {
                    CRValByConditions valByConditions = (CRValByConditions)SerializationUtils.fromJsonString((String)formula, CRValByConditions.class);
                    item.setValByConditions(valByConditions);
                }
            } else if (FieldConvertType.CONSTANT.getValue() == convertType) {
                item.setFieldConvertType(FieldConvertType.CONSTANT);
                if (StringUtils.isNotBlank((CharSequence)formula)) {
                    CRFormula constant = (CRFormula)SerializationUtils.fromJsonString((String)formula, CRFormula.class);
                    item.setConstant(constant);
                }
            }
            String sumTypeFldValue = row.getString("fsumtype");
            int sumType = StringUtils.isBlank((CharSequence)sumTypeFldValue) ? FieldSumType.First.getValue() : Integer.parseInt(sumTypeFldValue);
            item.setFieldSumType(FieldSumType.valueOf((int)sumType));
            item.setDrawFilter(row.getBoolean("fdrawfilter"));
            item.setDrawAgainFilter(row.getBoolean("fdrawagainfilter"));
            policy.getFieldMaps().add(item);
        }
    }

    private void getGroupByPolicy(ConvertRuleElement rule) {
        IDataModel model = this.getModel();
        GroupByPolicy policy = rule.getGroupByPolicy();
        int comboInt = Integer.parseInt((String)this.getModel().getValue("g_billcombo"));
        policy.setGroupByMode(GroupByMode.valueOf((int)comboInt));
        int comboInt2 = Integer.parseInt((String)this.getModel().getValue("g_entrycombo"));
        policy.setGroupByMode2(GroupByMode.valueOf((int)comboInt2));
        int comboInt3 = Integer.parseInt((String)this.getModel().getValue("g_subentrycombo"));
        policy.setGroupByMode3(GroupByMode.valueOf((int)comboInt3));
        String groupByField = this.getGroupByField("g_billentry", "g_billentrykey");
        String groupByField2 = this.getGroupByField("g_entry", "g_entrykey");
        String groupByField3 = this.getGroupByField("g_subentry", "g_subentrykey");
        policy.setGroupByField(groupByField);
        policy.setGroupByField2(groupByField2);
        policy.setGroupByField3(groupByField3);
    }

    public String getGroupByField(String entryKey, String key) {
        ArrayList<String> list = new ArrayList<String>(10);
        int count = this.getModel().getEntryRowCount(entryKey);
        for (int i = 0; i < count; ++i) {
            String fieldKey = (String)this.getModel().getValue(key, i);
            list.add(fieldKey);
        }
        String groupByField = StringUtils.join((Object[])list.toArray(), (String)",");
        return groupByField;
    }

    private void getFilterPolicyPolicy(ConvertRuleElement rule) {
        FilterPolicy filterPolicy = rule.getFilterPolicy();
        if (filterPolicy.getCondition() == null) {
            filterPolicy.setCondition(new CRCondition());
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        filterPolicy.getCondition().setFilterCondition(filterGridState.getFilterCondition());
        String localeId = RequestContext.get().getLang().toString();
        if (filterPolicy.getCondition().getDescription() == null) {
            filterPolicy.getCondition().setDescription(new LocaleString());
        }
        filterPolicy.getCondition().getDescription().setItem(localeId, (Object)((OrmLocaleValue)this.getModel().getValue("filterdesc")).getLocaleValue());
        boolean isEnable = (Boolean)this.getView().getModel().getValue("advanced_conditions");
        if (isEnable) {
            filterPolicy.setAdvCondition(Boolean.valueOf(true));
            this.getAvdFilterPolicy(filterPolicy, localeId);
        } else {
            filterPolicy.setAdvCondition(Boolean.valueOf(false));
        }
    }

    private void getAvdFilterPolicy(FilterPolicy filterPolicy, String localeId) {
        filterPolicy.getConditionList().clear();
        int rowCount = this.getModel().getEntryRowCount("adv_filter");
        for (int row = 0; row < rowCount; ++row) {
            CRCondition condition = null;
            String runConditionJson = (String)this.getModel().getValue("advfilterjson", row);
            if (StringUtils.isBlank((CharSequence)runConditionJson)) continue;
            condition = (CRCondition)SerializationUtils.fromJsonString((String)runConditionJson, CRCondition.class);
            condition.setEnabled(((Boolean)this.getModel().getValue("advfilterenable", row)).booleanValue());
            condition.setSeq(row + 1);
            condition.setId((String)this.getModel().getValue("ft_id", row));
            condition.getDescription().setItem(localeId, (Object)((OrmLocaleValue)this.getModel().getValue("advfilterdesc", row)).getLocaleValue());
            filterPolicy.getConditionList().add(condition);
        }
    }

    private void getBizRulePolicy(ConvertRuleElement rule) {
        String entityKey = "bizrulepolicy";
        int rowCount = this.getModel().getEntryRowCount(entityKey);
        BizRulePolicy policy = rule.getBizRulePolicy();
        policy.getActions().clear();
        for (int row = 0; row < rowCount; ++row) {
            String bizRuleJson = (String)this.getModel().getValue("br_bizruleitem", row);
            if (StringUtils.isBlank((CharSequence)bizRuleJson)) continue;
            CRBizRuleElement bizRule = (CRBizRuleElement)SerializationUtils.fromJsonString((String)bizRuleJson, CRBizRuleElement.class);
            bizRule.setSeq(row + 1);
            bizRule.setEnabled(((Boolean)this.getModel().getValue("br_enabled", row)).booleanValue());
            policy.getActions().add(bizRule);
        }
    }

    private void getPluginPolicy(ConvertRuleElement rule) {
        String entityKey = "pluginpolicy";
        int rowCount = this.getModel().getEntryRowCount(entityKey);
        PlugInPolicy policy = rule.getPlugInPolicy();
        policy.getPlugins().clear();
        for (int row = 0; row < rowCount; ++row) {
            String crplugJson = (String)this.getModel().getValue("f_pl_plugin", row);
            if (StringUtils.isBlank((CharSequence)crplugJson)) continue;
            CRPlugin crPlugin = (CRPlugin)SerializationUtils.fromJsonString((String)crplugJson, CRPlugin.class);
            crPlugin.setSeq(row + 1);
            crPlugin.setEnabled(((Boolean)this.getModel().getValue("f_pl_enabled", row)).booleanValue());
            policy.getPlugins().add(crPlugin);
        }
    }

    private void getOptionPolicy(ConvertRuleElement rule) {
        if (this.getModel().getProperty("pushmutex") != null) {
            rule.getOptionPolicy().setPushMutex(((Boolean)this.getModel().getValue("pushmutex")).booleanValue());
            rule.getOptionPolicy().setPushOneTime(((Boolean)this.getModel().getValue("pushonetime")).booleanValue());
            rule.getOptionPolicy().setCheckBaseEnable(((Boolean)this.getModel().getValue("checkbaseenable")).booleanValue());
            rule.getOptionPolicy().setMulComboBaseEnableStr((String)this.getModel().getValue("mulcombobaseenable"));
            rule.getOptionPolicy().setCreateReport(((Boolean)this.getModel().getValue("createreport")).booleanValue());
            rule.getOptionPolicy().setReportStartTime((Date)this.getModel().getValue("reportstarttime"));
            rule.getOptionPolicy().setReportEndTime((Date)this.getModel().getValue("reportendtime"));
            rule.getOptionPolicy().setConvertSnapshot(((Boolean)this.getModel().getValue("convertsnapshot")).booleanValue());
            rule.getOptionPolicy().setWithoutTrim(((Boolean)this.getModel().getValue("withouttrim")).booleanValue());
        }
    }

    public HashSet<String> getTargetLinkEntitys() {
        HashSet<String> linkEntitys = new HashSet<String>();
        String entityNumber = this.plugin.getRuleFormHelper().getTargetEntityNumber();
        linkEntitys.add(entityNumber);
        String linkEntry = (String)this.getModel().getValue("ftargetentrykey");
        String linkSubEntry = (String)this.getModel().getValue("ftargetsubentrykey");
        if (StringUtils.isNotBlank((CharSequence)linkEntry) && !linkEntitys.contains(linkEntry)) {
            linkEntitys.add(linkEntry);
            if (StringUtils.isNotBlank((CharSequence)linkSubEntry) && !linkEntitys.contains(linkSubEntry)) {
                linkEntitys.add(linkSubEntry);
            }
        }
        return linkEntitys;
    }

    public HashSet<String> getSourceLinkEntitys() {
        HashSet<String> linkEntitys = new HashSet<String>();
        String entityNumber = this.plugin.getRuleFormHelper().getSourceEntityNumber();
        linkEntitys.add(entityNumber);
        String linkEntry = (String)this.getModel().getValue("fsourceentrykey");
        String linkSubEntry = (String)this.getModel().getValue("fsourcesubentrykey");
        if (StringUtils.isNotBlank((CharSequence)linkEntry) && !linkEntitys.contains(linkEntry)) {
            linkEntitys.add(linkEntry);
            if (StringUtils.isNotBlank((CharSequence)linkSubEntry) && !linkEntitys.contains(linkSubEntry)) {
                linkEntitys.add(linkSubEntry);
            }
        }
        return linkEntitys;
    }
}

