/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.designer.botp.SelectBasedataValue;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.CRValByCondition;
import kd.bos.entity.botp.CRValByConditionType;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GetValByConditionEdit
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(GetValByConditionEdit.class);
    public static final String FormId_ValByCondition = "botp_valbycondition";
    public static final String CustParamKey_CRValByConditions = "crvalbyconditions";
    public static final String CustParamKey_TreeNodes = "treenodes";
    public static final String CustParamKey_EntityNumber = "entitynumber";
    public static final String CustParamKey_Base_entityId = "baseentityid";
    public static final String CUSTPARAMKEY_INIT_ORGFUNCID = "initOrgFuncId";
    public static final String CUSTPARAMKEY_CONSTANT_CRFORMULA_JSON = "CONSTANT_CRFORMULA_JSON";
    public static final String Key_Entity = "entryentity";
    public static final String Key_FItemId = "itemid";
    public static final String Key_FSelectType = "selecttype";
    public static final String Key_FCondition = "condition";
    public static final String Key_FConditionDesc = "conditiondesc";
    public static final String Key_FFormula = "formula";
    public static final String Key_FFormulaDesc = "formuladesc";
    public static final String Key_FConstant = "constant";
    public static final String Key_FConstantDesc = "constantdesc";
    public static final String Key_FIfConstant = "ifconstant";
    public static final String Key_btnOK = "btnok";
    public static final String Key_btnCancel = "btncancel";
    public static final String Key_TreeView = "tv_fields";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_FConditionDesc, Key_FFormulaDesc, Key_FConstantDesc});
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_CRValByConditions);
        CRValByConditions valByConditions = null;
        valByConditions = StringUtils.isBlank((CharSequence)json) ? new CRValByConditions() : (CRValByConditions)SerializationUtils.fromJsonString((String)json, CRValByConditions.class);
        this.setCRValByConditions(valByConditions);
    }

    public void click(EventObject e) {
        super.click(e);
        Control srcCtrl = (Control)e.getSource();
        if (srcCtrl.getKey().equalsIgnoreCase(Key_FConditionDesc)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(Key_Entity);
            String conditionJson = (String)this.getModel().getValue(Key_FCondition, rowIndex);
            String fieldNodes = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_EntityNumber);
            this.showConditionForm(conditionJson, entityNumber, fieldNodes, Key_FConditionDesc);
        } else if (srcCtrl.getKey().equalsIgnoreCase(Key_FFormulaDesc)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(Key_Entity);
            String formulaJson = (String)this.getModel().getValue(Key_FFormula, rowIndex);
            String fieldNodes = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_EntityNumber);
            this.showFormulaForm(formulaJson, entityNumber, fieldNodes, Key_FFormulaDesc);
        } else if (srcCtrl.getKey().equalsIgnoreCase(Key_FConstantDesc)) {
            this.trySetConstantFormula();
            Object objBaseEntityId = this.getView().getFormShowParameter().getCustomParam(CustParamKey_Base_entityId);
            if (objBaseEntityId != null) {
                this.showConstantForm((String)objBaseEntityId, Key_FConstantDesc);
            }
        } else if (srcCtrl.getKey().equalsIgnoreCase(Key_btnOK)) {
            CRValByConditions valByConditions = this.getCRValByConditions();
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)valByConditions));
            this.getView().close();
        } else if (srcCtrl.getKey().equalsIgnoreCase(Key_btnCancel)) {
            this.getView().close();
        }
    }

    private void trySetConstantFormula() {
        try {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(Key_Entity);
            Object formula = this.getModel().getValue(Key_FConstant, rowIndex);
            if (StringUtils.isNotBlank((Object)formula)) {
                this.getView().getFormShowParameter().setCustomParam(CUSTPARAMKEY_CONSTANT_CRFORMULA_JSON, formula);
            }
        }
        catch (Exception e) {
            log.warn("trySetConstantFormula eror is " + e);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getActionId().equalsIgnoreCase(Key_FConditionDesc)) {
            this.receiveCondition((String)e.getReturnData(), Key_Entity, Key_FCondition, Key_FConditionDesc);
        } else if (e.getActionId().equalsIgnoreCase(Key_FFormulaDesc)) {
            this.receiveFormula((String)e.getReturnData(), Key_Entity, Key_FFormula, Key_FFormulaDesc);
        } else if (e.getActionId().equalsIgnoreCase(Key_FConstantDesc)) {
            this.receiveConstant(e.getReturnData());
        }
    }

    private void setCRValByConditions(CRValByConditions valByConditions) {
        int rowCount = this.getModel().getEntryRowCount(Key_Entity);
        if (rowCount > valByConditions.getItems().size()) {
            for (int i = rowCount - 1; i >= valByConditions.getItems().size(); --i) {
                this.getModel().deleteEntryRow(Key_Entity, i);
            }
        } else if (rowCount < valByConditions.getItems().size()) {
            this.getModel().batchCreateNewEntryRow(Key_Entity, valByConditions.getItems().size() - rowCount);
        }
        ArrayList<CRValByCondition> items = new ArrayList<CRValByCondition>();
        items.addAll(valByConditions.getItems());
        items.sort(new Comparator<CRValByCondition>(){

            @Override
            public int compare(CRValByCondition o1, CRValByCondition o2) {
                if (o1.getSeq() < o2.getSeq()) {
                    return -1;
                }
                if (o1.getSeq() > o2.getSeq()) {
                    return 1;
                }
                return 0;
            }
        });
        for (int i = 0; i < items.size(); ++i) {
            CRValByCondition item = (CRValByCondition)valByConditions.getItems().get(i);
            this.getModel().setValue(Key_FItemId, (Object)item.getId(), i);
            this.getModel().setValue(Key_FSelectType, (Object)item.getSelectType().ordinal(), i);
            if (item.getCondition() == null) {
                this.getModel().setValue(Key_FCondition, (Object)"", i);
                this.getModel().setValue(Key_FConditionDesc, (Object)"", i);
            } else {
                this.getModel().setValue(Key_FCondition, (Object)SerializationUtils.toJsonString((Object)item.getCondition()), i);
                this.getModel().setValue(Key_FConditionDesc, (Object)item.getCondition().getExprDesc(), i);
            }
            if (item.getFormula() == null) {
                if (item.getIfconstant() == 1) {
                    this.getModel().setValue(Key_FConstant, (Object)"", i);
                    this.getModel().setValue(Key_FConstantDesc, (Object)"", i);
                    continue;
                }
                this.getModel().setValue(Key_FFormula, (Object)"", i);
                this.getModel().setValue(Key_FFormulaDesc, (Object)"", i);
                continue;
            }
            if (item.getIfconstant() == 1) {
                this.getModel().setValue(Key_FConstant, (Object)SerializationUtils.toJsonString((Object)item.getFormula()), i);
                this.getModel().setValue(Key_FConstantDesc, (Object)item.getFormula().getExprDesc(), i);
                this.getModel().setValue(Key_FIfConstant, (Object)item.getIfconstant(), i);
                continue;
            }
            this.getModel().setValue(Key_FFormula, (Object)SerializationUtils.toJsonString((Object)item.getFormula()), i);
            this.getModel().setValue(Key_FFormulaDesc, (Object)item.getFormula().getExprDesc(), i);
        }
    }

    private CRValByConditions getCRValByConditions() {
        CRValByConditions valByConditions = new CRValByConditions();
        int rowCount = this.getModel().getEntryRowCount(Key_Entity);
        for (int i = 0; i < rowCount; ++i) {
            CRFormula crFormula;
            String id = Uuid8.generateShortUuid();
            String selectType = (String)this.getModel().getValue(Key_FSelectType, i);
            String condition = (String)this.getModel().getValue(Key_FCondition, i);
            String formula = (String)this.getModel().getValue(Key_FFormula, i);
            String constant = (String)this.getModel().getValue(Key_FConstant, i);
            String ifconstantString = this.getModel().getValue(Key_FIfConstant, i).toString();
            int ifconstant = Integer.parseInt(kd.bos.util.StringUtils.isEmpty((String)ifconstantString) ? "0" : ifconstantString);
            CRValByCondition item = new CRValByCondition();
            item.setSeq(i + 1);
            if (StringUtils.isNotBlank((CharSequence)id)) {
                item.setId(id);
            }
            item.setSelectType(CRValByConditionType.valueOf((int)Integer.parseInt(selectType)));
            if (StringUtils.isNotBlank((CharSequence)condition)) {
                CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
                item.setCondition(crCondition);
            }
            if (StringUtils.isNotBlank((CharSequence)formula)) {
                crFormula = (CRFormula)SerializationUtils.fromJsonString((String)formula, CRFormula.class);
                item.setFormula(crFormula);
            }
            if (StringUtils.isNotBlank((CharSequence)constant)) {
                crFormula = (CRFormula)SerializationUtils.fromJsonString((String)constant, CRFormula.class);
                item.setFormula(crFormula);
                item.setIfconstant(ifconstant);
            }
            valByConditions.getItems().add(item);
        }
        return valByConditions;
    }

    private void showFormulaForm(String formulaJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_formula");
        showParameter.getCustomParams().put(Key_FFormula, formulaJson);
        showParameter.getCustomParams().put(CustParamKey_EntityNumber, entityNumber);
        showParameter.getCustomParams().put(CustParamKey_TreeNodes, fieldNodes);
        String funcsXML = (String)this.getView().getFormShowParameter().getCustomParam("functiontypes");
        if (StringUtils.isNotBlank((CharSequence)funcsXML)) {
            showParameter.getCustomParams().put("functiontypes", funcsXML);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveFormula(String formulaJson, String entryEntityKey, String formulaFldKey, String descFldKey) {
        if (StringUtils.isBlank((CharSequence)formulaJson)) {
            return;
        }
        CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaJson, CRFormula.class);
        if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
            this.getModel().setValue(formulaFldKey, (Object)formulaJson);
            this.getModel().setValue(descFldKey, (Object)formula.getExprDesc());
        } else {
            int row = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
            this.getModel().setValue(formulaFldKey, (Object)formulaJson, row);
            this.getModel().setValue(descFldKey, (Object)formula.getExprDesc(), row);
            this.getModel().setValue(Key_FConstant, (Object)"", row);
            this.getModel().setValue(Key_FConstantDesc, (Object)"", row);
            this.getModel().setValue(Key_FIfConstant, (Object)0, row);
        }
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put(Key_FFormula, conditionJson);
        showParameter.getCustomParams().put(CustParamKey_EntityNumber, entityNumber);
        showParameter.getCustomParams().put(CustParamKey_TreeNodes, fieldNodes);
        String funcsXML = (String)this.getView().getFormShowParameter().getCustomParam("functiontypes");
        if (StringUtils.isNotBlank((CharSequence)funcsXML)) {
            showParameter.getCustomParams().put("functiontypes", funcsXML);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveCondition(String conditionJson, String entryEntityKey, String conditionFldKey, String descFldKey) {
        if (StringUtils.isBlank((CharSequence)conditionJson)) {
            return;
        }
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
        if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
            this.getModel().setValue(conditionFldKey, (Object)conditionJson);
            this.getModel().setValue(descFldKey, (Object)condition.getExprDesc());
        } else {
            int row = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
            this.getModel().setValue(conditionFldKey, (Object)conditionJson, row);
            this.getModel().setValue(descFldKey, (Object)condition.getExprDesc(), row);
        }
    }

    private void showConstantForm(String baseEntityId, String sourceCtrlKey) {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, sourceCtrlKey);
        SelectBasedataValue.get().showF7List(baseEntityId, this.getView(), closeCallBack);
    }

    private void receiveConstant(Object returnData) {
        if (StringUtils.isBlank((Object)returnData) || !(returnData instanceof ListSelectedRowCollection)) {
            return;
        }
        ListSelectedRowCollection selections = (ListSelectedRowCollection)returnData;
        if (selections.size() == 0) {
            return;
        }
        CRFormula formula = new CRFormula();
        formula.setExprTran(selections.get(0).getName());
        formula.setExpression(selections.get(0).getPrimaryKeyValue().toString());
        String json = SerializationUtils.toJsonString((Object)formula);
        int row = this.getModel().getEntryCurrentRowIndex(Key_Entity);
        this.getModel().setValue(Key_FConstant, (Object)json, row);
        this.getModel().setValue(Key_FConstantDesc, (Object)formula.getExprTran(), row);
        this.getModel().setValue(Key_FIfConstant, (Object)1, row);
        this.getModel().setValue(Key_FFormula, (Object)"", row);
        this.getModel().setValue(Key_FFormulaDesc, (Object)"", row);
    }
}

