/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;

public class NewConvertPathEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_OK = "btnok";
    private static final String KEY_SOURCE_BILL = "fsourcebill";
    private static final String KEY_TARGET_BILL = "ftargetbill";

    public void initialize() {
        BasedataEdit ftargetbill;
        super.initialize();
        BasedataEdit fsourcebill = (BasedataEdit)this.getView().getControl(KEY_SOURCE_BILL);
        if (fsourcebill != null) {
            fsourcebill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((ftargetbill = (BasedataEdit)this.getView().getControl(KEY_TARGET_BILL)) != null) {
            ftargetbill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{KEY_OK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (source.getKey().equalsIgnoreCase(KEY_OK)) {
            this.returnToParent();
        }
    }

    private void returnToParent() {
        DynamicObject srcBillObj = (DynamicObject)this.getModel().getValue(KEY_SOURCE_BILL);
        if (srcBillObj == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u5355\u3002", (String)"NewConvertPathEdit_0", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject tgtBillObj = (DynamicObject)this.getModel().getValue(KEY_TARGET_BILL);
        if (tgtBillObj == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u5355\u3002", (String)"NewConvertPathEdit_1", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return;
        }
        String sourceBill = (String)srcBillObj.getPkValue();
        String targetBill = (String)tgtBillObj.getPkValue();
        String sourceBillName = srcBillObj.getLocaleString("name").toString();
        String targetBillName = tgtBillObj.getLocaleString("name").toString();
        HashMap<String, String> returnParams = new HashMap<String, String>();
        returnParams.put("SourceBill", sourceBill);
        returnParams.put("SourceBillName", sourceBillName);
        returnParams.put("TargetBill", targetBill);
        returnParams.put("TargetBillName", targetBillName);
        this.getView().returnDataToParent(returnParams);
        this.getView().close();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        evt.addCustomQFilter(new QFilter("botp", "=", (Object)"1"));
    }
}

