/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.ConvertRuleEdit;
import kd.bos.designer.botp.common.RuleFormHelper;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.botp.CRPlugin;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import org.apache.commons.collections4.CollectionUtils;

class PlugPolicyHelper {
    private static Log logger = LogFactory.getLog(PlugPolicyHelper.class);
    private static final String CLASS_NAME = "ClassName";
    private static final String ENABLED = "Enabled";
    private static final String DISPLAY_NAME = "DisplayName";
    private static final String DESCRIPTION = "Description";

    PlugPolicyHelper() {
    }

    public static void showAddPlugForm(IFormView view, AbstractFormPlugin plugin) {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "ide_registerplugin");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "btnaddplug"));
        List<Map<String, Object>> list = PlugPolicyHelper.getPlugins(view);
        showParameter.setCustomParam("plugins", list);
        view.showForm(showParameter);
    }

    public static void receiveNewPlug(IFormView view, AbstractFormPlugin plugin, Object returnData) {
        if (returnData == null) {
            return;
        }
        Map plugParams = (Map)returnData;
        CRPlugin crPlugin = PlugPolicyHelper.convertToPlugin(plugParams);
        String json = SerializationUtils.toJsonString((Object)crPlugin);
        view.getModel().createNewEntryRow("pluginpolicy");
        int row = view.getModel().getEntryRowCount("pluginpolicy");
        view.getModel().setValue("f_pl_enabled", (Object)crPlugin.isEnabled(), row - 1);
        view.getModel().setValue("f_pl_classname", (Object)crPlugin.getClassName(), row - 1);
        view.getModel().setValue("f_pl_displayname", (Object)crPlugin.getDisplayName(), row - 1);
        view.getModel().setValue("f_pl_description", (Object)crPlugin.getDescription(), row - 1);
        view.getModel().setValue("f_pl_plugin", (Object)json, row - 1);
        view.getModel().setValue("f_pl_type", (Object)String.valueOf(crPlugin.getType()), row - 1);
    }

    public static void showAddJSPlugForm(IFormView view, AbstractFormPlugin plugin) {
        String scriptTypeFilter = "convertplugin";
        String bizAppId = "";
        String entityNumber = RuleFormHelper.getSourceEntityNumber(view);
        ArrayList plugIns = new ArrayList();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_register_ks_plugin");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "btnaddjsplug"));
        parameter.setCustomParam("bizpagenumber", (Object)entityNumber);
        parameter.setCustomParam("scripttypefilter", (Object)scriptTypeFilter);
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            parameter.setCustomParam("bizappid", (Object)bizAppId);
        }
        parameter.setCustomParam("value", (Object)SerializationUtils.toJsonString(plugIns));
        view.showForm(parameter);
    }

    public static void showAddTSPlugForm(IFormView view, ConvertRuleEdit plugin) {
        String bizAppId = FormMetadataCache.getFormAppId((String)plugin.getRuleFormHelper().getSourceEntityNumber());
        AppInfo appInfo = null;
        try {
            appInfo = AppMetadataCache.getAppInfoByNumber((String)bizAppId);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setShowTitle(false);
        parameter.setShowClose(false);
        parameter.setFormId("ide_register_kingscript");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "btnaddtsplug"));
        parameter.setCustomParam("bizpagenumber", (Object)RuleFormHelper.getSourceEntityNumber(view));
        parameter.setCustomParam("modelType", (Object)"ConvertRuleModel");
        parameter.setCustomParam("scripttypefilter", (Object)"convertplugin");
        if (appInfo != null) {
            parameter.setCustomParam("bizappid", (Object)appInfo.getId());
        }
        List<Map<String, Object>> list = PlugPolicyHelper.getPlugins(view);
        parameter.setCustomParam("plugins", list);
        view.showForm(parameter);
    }

    public static void openPluginJavaScript(IFormView view, ConvertRuleEdit plugin) {
        String appNumber = FormMetadataCache.getFormAppId((String)plugin.getRuleFormHelper().getSourceEntityNumber());
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.getLocaleString((String)"\u9009\u62e9\u811a\u672c", (String)"PluginsPlugin_10", (String)"bos-designer-plugin").getLocaleValue());
        parameter.setFormId("ide_register_ks_plugin");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "selectts"));
        parameter.setCustomParam("bizpagenumber", (Object)RuleFormHelper.getSourceEntityNumber(view));
        parameter.setCustomParam("engineType", (Object)"1");
        parameter.setCustomParam("modelType", (Object)"ConvertRuleModel");
        parameter.setCustomParam("scripttypefilter", (Object)"convertplugin");
        if (StringUtils.isNotBlank((CharSequence)appNumber)) {
            String appId = AppReader.getAppIdByNumber((String)appNumber);
            parameter.setCustomParam("bizappid", (Object)appId);
        }
        ArrayList value = new ArrayList(1);
        parameter.setCustomParam("value", (Object)SerializationUtils.toJsonString(value));
        view.showForm(parameter);
    }

    public static void receiveNewJSPlug(IFormView view, AbstractFormPlugin plugin, Object returnData) {
        if (returnData == null) {
            return;
        }
        int rowCount = view.getModel().getEntryRowCount("pluginpolicy");
        HashSet<String> classNames = new HashSet<String>();
        for (int row = 0; row < rowCount; ++row) {
            String className = (String)view.getModel().getValue("f_pl_classname", row);
            if (!StringUtils.isNotBlank((CharSequence)className) || classNames.contains(className)) continue;
            classNames.add(className);
        }
        List selectItems = (List)returnData;
        if (selectItems.size() > 0) {
            int row = rowCount;
            for (Map item : selectItems) {
                String name = (String)item.get(CLASS_NAME);
                if (classNames.contains(name)) continue;
                classNames.add(name);
                CRPlugin crPlugin = new CRPlugin();
                crPlugin.setType(1);
                crPlugin.setClassName(name);
                crPlugin.setEnabled(true);
                crPlugin.setScriptId((String)item.get("FPK"));
                String json = SerializationUtils.toJsonString((Object)crPlugin);
                view.getModel().createNewEntryRow("pluginpolicy");
                view.getModel().setValue("f_pl_classname", (Object)crPlugin.getClassName(), row);
                view.getModel().setValue("f_pl_enabled", (Object)crPlugin.isEnabled(), row);
                view.getModel().setValue("f_pl_type", (Object)crPlugin.getType(), row);
                view.getModel().setValue("f_pl_plugin", (Object)json, row);
                ++row;
            }
        }
    }

    public static void receiveNewTSPlug(IFormView view, ConvertRuleEdit edit, Object returnData) {
        Map plugin = (Map)returnData;
        if (returnData == null) {
            return;
        }
        CRPlugin crPlugin = new CRPlugin();
        crPlugin.setType(4);
        crPlugin.setClassName(plugin.get(CLASS_NAME).toString());
        crPlugin.setEnabled(Boolean.parseBoolean(plugin.get(ENABLED).toString()));
        crPlugin.setScriptId((String)plugin.get("FPK"));
        crPlugin.setDescription((String)plugin.get(DESCRIPTION));
        crPlugin.setDisplayName((String)plugin.get(DISPLAY_NAME));
        String json = SerializationUtils.toJsonString((Object)crPlugin);
        DynamicObjectCollection entity = view.getModel().getEntryEntity("pluginpolicy");
        boolean isContinue = true;
        for (DynamicObject dynamicObject : entity) {
            if (!dynamicObject.getString("f_pl_classname").equals(plugin.get(CLASS_NAME))) continue;
            isContinue = false;
            break;
        }
        if (isContinue) {
            view.getModel().createNewEntryRow("pluginpolicy");
            int row = view.getModel().getEntryRowCount("pluginpolicy");
            view.getModel().setValue("f_pl_enabled", plugin.get(ENABLED), row - 1);
            view.getModel().setValue("f_pl_classname", plugin.get(CLASS_NAME), row - 1);
            view.getModel().setValue("f_pl_displayname", plugin.get("ScriptName"), row - 1);
            view.getModel().setValue("f_pl_description", plugin.get(DESCRIPTION), row - 1);
            view.getModel().setValue("f_pl_plugin", (Object)json, row - 1);
            view.getModel().setValue("f_pl_type", (Object)String.valueOf(plugin.get("Type")), row - 1);
        }
    }

    public static void selectTSPlug(IFormView view, ConvertRuleEdit edit, Object returnData) {
        List plugins = (List)returnData;
        if (CollectionUtils.isEmpty((Collection)plugins)) {
            return;
        }
        for (Map plugin : plugins) {
            boolean bExist = false;
            if (bExist) continue;
            PlugPolicyHelper.receiveNewTSPlug(view, edit, plugin);
        }
    }

    public static void showModifyPlugForm(IFormView view, AbstractFormPlugin plugin) {
        int row = view.getModel().getEntryCurrentRowIndex("pluginpolicy");
        String json = (String)view.getModel().getValue("f_pl_plugin", row);
        if (StringUtils.isBlank((CharSequence)json)) {
            return;
        }
        CRPlugin crPlugin = (CRPlugin)SerializationUtils.fromJsonString((String)json, CRPlugin.class);
        boolean enabled = (Boolean)view.getModel().getValue("f_pl_enabled", row);
        crPlugin.setEnabled(enabled);
        if (crPlugin.getType() == 0) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("ide_registerplugin");
            Map<String, Object> currentPlugin = PlugPolicyHelper.convertToParams(crPlugin);
            parameter.setCustomParam("rowKey", (Object)row);
            parameter.setCustomParam("plugin", currentPlugin);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "btnmodifyplug"));
            List<Map<String, Object>> list = PlugPolicyHelper.getPlugins(view);
            parameter.setCustomParam("plugins", list);
            parameter.setCustomParam("isEdit", (Object)true);
            view.showForm(parameter);
        } else if (crPlugin.getType() == 1) {
            PlugPolicyHelper.showModifyJSPlugForm(view, plugin, crPlugin);
        } else if (crPlugin.getType() == 4) {
            PlugPolicyHelper.showModifyTSPlugForm(view, plugin, crPlugin);
        }
    }

    private static void showModifyJSPlugForm(IFormView view, AbstractFormPlugin plugin, CRPlugin crPlugin) {
        if (StringUtils.isBlank((CharSequence)crPlugin.getScriptId())) {
            return;
        }
        String bizAppId = null;
        ORM orm = ORM.create();
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)crPlugin.getScriptId())};
        try (DataSet ds = orm.queryDataSet("kd.bos.designer.botp.ConvertRuleEdit.PlugPolicyHelper", "ide_pluginscript", "id,bizappid", filters);){
            if (ds.hasNext()) {
                bizAppId = ds.next().getString("bizappid");
            }
        }
        if (StringUtils.isBlank(bizAppId)) {
            return;
        }
        HashMap<String, Object> currentPlugin = new HashMap<String, Object>();
        currentPlugin.put("FPK", crPlugin.getScriptId());
        currentPlugin.put("Type", crPlugin.getType());
        currentPlugin.put(CLASS_NAME, crPlugin.getClassName());
        currentPlugin.put("BizAppId", bizAppId);
        currentPlugin.put(ENABLED, crPlugin.isEnabled());
        AbstractGrid grid = (AbstractGrid)view.getControl("pluginpolicy");
        int rowKey = grid.getEntryState().getFocusRow();
        FormShowParameter param = new FormShowParameter();
        param.setFormId("ide_edit_ks_plugin");
        param.setCustomParam("rowKey", (Object)rowKey);
        param.setCustomParam("plugin", currentPlugin);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "btnmodifyplug"));
        view.showForm(param);
    }

    private static void showModifyTSPlugForm(IFormView view, AbstractFormPlugin plugin, CRPlugin crPlugin) {
        if (StringUtils.isBlank((CharSequence)crPlugin.getScriptId())) {
            return;
        }
        if (!Plugin.enableKingScript((String)"DynamicFormModel")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u5f00\u53d1\u5e73\u53f0\u672a\u542f\u7528\uff0c\u6682\u4e0d\u652f\u6301\u7f16\u8f91\u3002", (String)"PluginsPlugin_11", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        String bizAppId = null;
        ORM orm = ORM.create();
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)crPlugin.getScriptId())};
        try (DataSet ds = orm.queryDataSet("kd.bos.designer.botp.ConvertRuleEdit.PlugPolicyHelper", "ide_pluginscript", "id,bizappid", filters);){
            if (ds.hasNext()) {
                bizAppId = ds.next().getString("bizappid");
            }
        }
        if (StringUtils.isBlank(bizAppId)) {
            return;
        }
        HashMap<String, Object> currentPlugin = new HashMap<String, Object>();
        currentPlugin.put("FPK", crPlugin.getScriptId());
        currentPlugin.put("Type", crPlugin.getType());
        currentPlugin.put(CLASS_NAME, crPlugin.getClassName());
        currentPlugin.put("BizAppId", bizAppId);
        currentPlugin.put(ENABLED, crPlugin.isEnabled());
        AbstractGrid grid = (AbstractGrid)view.getControl("pluginpolicy");
        int rowKey = grid.getEntryState().getFocusRow();
        FormShowParameter param = new FormShowParameter();
        param.setShowTitle(false);
        param.setShowClose(false);
        param.setFormId("ide_register_ts_plugin");
        param.setCustomParam("isEdit", (Object)"isEdit");
        param.setCustomParam("rowKey", (Object)rowKey);
        param.setCustomParam("plugin", currentPlugin);
        param.setCustomParam("scripttypefilter", (Object)"convertplugin");
        String sourceEntityNumber = RuleFormHelper.getSourceEntityNumber(view);
        param.setCustomParam("bizpagenumber", (Object)sourceEntityNumber);
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)sourceEntityNumber);
        param.setCustomParam("ServiceAppId", (Object)formConfig.getAppId());
        param.getOpenStyle().setShowType(ShowType.NewWindow);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "btnmodifyplug"));
        view.showForm(param);
    }

    public static void receiveModifyPlug(IFormView view, AbstractFormPlugin plugin, Object returnData) {
        if (returnData == null) {
            return;
        }
        Map plugParams = (Map)returnData;
        int row = view.getModel().getEntryCurrentRowIndex("pluginpolicy");
        String oldJson = (String)view.getModel().getValue("f_pl_plugin", row);
        if (StringUtils.isNotBlank((CharSequence)oldJson)) {
            CRPlugin oldPlugin = (CRPlugin)SerializationUtils.fromJsonString((String)oldJson, CRPlugin.class);
            if (oldPlugin.getType() == 1) {
                PlugPolicyHelper.receiveModifyJsPlug(view, plugin, returnData);
                return;
            }
            if (oldPlugin.getType() == 4) {
                PlugPolicyHelper.receiveModifyTsPlug(view, plugin, returnData);
                return;
            }
        }
        CRPlugin crPlugin = PlugPolicyHelper.convertToPlugin(plugParams);
        String json = SerializationUtils.toJsonString((Object)crPlugin);
        view.getModel().setValue("f_pl_enabled", (Object)crPlugin.isEnabled(), row);
        view.getModel().setValue("f_pl_classname", (Object)crPlugin.getClassName(), row);
        view.getModel().setValue("f_pl_displayname", (Object)crPlugin.getDisplayName(), row);
        view.getModel().setValue("f_pl_description", (Object)crPlugin.getDescription(), row);
        view.getModel().setValue("f_pl_plugin", (Object)json, row);
    }

    public static void receiveModifyJsPlug(IFormView view, AbstractFormPlugin plugin, Object returnData) {
        if (returnData == null) {
            return;
        }
        Map plugParams = (Map)returnData;
        int row = view.getModel().getEntryCurrentRowIndex("pluginpolicy");
        view.getModel().setValue("f_pl_enabled", plugParams.get(ENABLED), row);
    }

    public static void receiveModifyTsPlug(IFormView view, AbstractFormPlugin plugin, Object returnData) {
        if (returnData == null) {
            return;
        }
        Map plugParams = (Map)returnData;
        int row = view.getModel().getEntryCurrentRowIndex("pluginpolicy");
        view.getModel().setValue("f_pl_enabled", plugParams.get(ENABLED), row);
    }

    private static Map<String, Object> convertToParams(CRPlugin crPlugin) {
        HashMap<String, Object> plugParams = new HashMap<String, Object>();
        plugParams.put("_Type_", "Plugin");
        plugParams.put(CLASS_NAME, crPlugin.getClassName());
        plugParams.put(DISPLAY_NAME, crPlugin.getDisplayName());
        plugParams.put(DESCRIPTION, crPlugin.getDescription());
        plugParams.put(ENABLED, crPlugin.isEnabled());
        return plugParams;
    }

    private static CRPlugin convertToPlugin(Map<String, Object> plugParams) {
        CRPlugin crPlugin = new CRPlugin();
        crPlugin.setClassName((String)plugParams.get(CLASS_NAME));
        crPlugin.setEnabled(((Boolean)plugParams.get(ENABLED)).booleanValue());
        crPlugin.setType(0);
        crPlugin.setDescription((String)plugParams.get(DESCRIPTION));
        crPlugin.setDisplayName((String)plugParams.get(DISPLAY_NAME));
        return crPlugin;
    }

    private static List<Map<String, Object>> getPlugins(IFormView view) {
        int rowCount = view.getModel().getEntryRowCount("pluginpolicy");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(rowCount);
        for (int row = 0; row < rowCount; ++row) {
            HashMap<String, String> pluginMap = new HashMap<String, String>();
            String crplugJson = (String)view.getModel().getValue("f_pl_plugin", row);
            if (StringUtils.isBlank((CharSequence)crplugJson)) continue;
            CRPlugin crPlugin = (CRPlugin)SerializationUtils.fromJsonString((String)crplugJson, CRPlugin.class);
            pluginMap.put(CLASS_NAME, crPlugin.getClassName());
            list.add(pluginMap);
        }
        return list;
    }
}

