/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.text.MessageFormat;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.ConvertRuleEdit;
import kd.bos.designer.botp.RuleTreeNode;
import kd.bos.entity.botp.plugin.args.LoadFuncTypesEventArgs;
import kd.bos.entity.botp.runtime.ConvertFuncLoader;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.botp.ConvertRuleMetadata;
import kd.bos.metadata.botp.common.RuleIsvHelper;

class RuleCacheHelper {
    private static final String BOS_DESIGNER_PLUGIN = "bos-botp-formplugin";
    private static final String CACHEKEY_RULES = "Rules";
    private static final String CACHEKEY_SOURCE_BILL_TREENODE = "SourceBillTreeNode";
    private static final String CACHEKEY_DEFRULEID = "defRuleId";
    private static final String CACHEKEY_ISHIDEITEMCLASSPROP = "isHideItemClassProp";

    RuleCacheHelper() {
    }

    public static void putRootRuleNode(AbstractFormPlugin plugin, RuleTreeNode rootNode) {
        String json = SerializationUtils.toJsonString((Object)rootNode);
        plugin.getPageCache().put(CACHEKEY_RULES, json);
    }

    public static RuleTreeNode getRootRuleNode(AbstractFormPlugin plugin) {
        String json = plugin.getPageCache().get(CACHEKEY_RULES);
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ece\u7f13\u5b58\u4e2d\u8bfb\u53d6\u8f6c\u6362\u89c4\u5219\u6811\u5931\u8d25\u3002", (String)"ConvertRuleEdit_51", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        RuleTreeNode rootNode = (RuleTreeNode)SerializationUtils.fromJsonString((String)json, RuleTreeNode.class);
        return rootNode;
    }

    public static ConvertRuleMetadata getRule(AbstractFormPlugin plugin, String ruleId) {
        RuleTreeNode rootNode = RuleCacheHelper.getRootRuleNode(plugin);
        return RuleCacheHelper.getRule(rootNode, ruleId);
    }

    private static ConvertRuleMetadata getRule(RuleTreeNode rootNode, String ruleId) {
        if (StringUtils.isBlank((CharSequence)ruleId)) {
            return null;
        }
        RuleTreeNode currRuleNode = rootNode.searchRule(ruleId);
        if (currRuleNode == null) {
            String errMessage = MessageFormat.format(ResManager.loadKDString((String)"\u4ece\u7f13\u5b58\u4e2d\u8bfb\u53d6\u8f6c\u6362\u89c4\u5219[{0}]\u5931\u8d25\u3002", (String)"ConvertRuleEdit_52", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ruleId);
            throw new KDBizException(errMessage);
        }
        ConvertRuleMetadata ruleMetadata = currRuleNode.deserialize(rootNode);
        return ruleMetadata;
    }

    public static RuleTreeNode addRule(AbstractFormPlugin plugin, ConvertRuleMetadata ruleMetadata) {
        String currentIsv = RuleIsvHelper.getUserIsv();
        ruleMetadata.setIsv(currentIsv);
        RuleTreeNode rootNode = RuleCacheHelper.getRootRuleNode(plugin);
        ConvertRuleMetadata parentRuleMeta = RuleCacheHelper.getRule(rootNode, ruleMetadata.getParentId());
        RuleTreeNode ruleNode = RuleTreeNode.buildRuleNode(parentRuleMeta, ruleMetadata, currentIsv);
        ruleNode.setNewed(true);
        if (StringUtils.isBlank((CharSequence)ruleMetadata.getParentId())) {
            rootNode.getChildren().put(ruleNode.getId(), ruleNode);
        } else {
            RuleTreeNode parentNode = rootNode.searchRule(ruleNode.getParentId());
            if (parentNode == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u628a\u89c4\u5219\u6dfb\u52a0\u5230\u89c4\u5219\u6811\u4e0a\u65f6\uff0c\u6ca1\u6709\u641c\u7d22\u5230\u7236\u7ea7\u89c4\u5219\uff0c\u6dfb\u52a0\u5931\u8d25\u3002", (String)"ConvertRuleEdit_53", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            parentNode.getChildren().put(ruleNode.getId(), ruleNode);
        }
        RuleCacheHelper.putRootRuleNode(plugin, rootNode);
        return ruleNode;
    }

    public static void modifyRule(AbstractFormPlugin plugin, ConvertRuleMetadata ruleMetadata) {
        RuleTreeNode rootNode = RuleCacheHelper.getRootRuleNode(plugin);
        RuleTreeNode ruleNode = rootNode.searchRule(ruleMetadata.getId());
        if (ruleNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5728\u89c4\u5219\u6811\u4e0a\u6ca1\u6709\u627e\u5230\u5f53\u524d\u4fee\u6539\u7684\u89c4\u5219\uff0c\u66f4\u65b0\u89c4\u5219\u5931\u8d25\u3002", (String)"ConvertRuleEdit_54", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        String currentIsv = RuleIsvHelper.getUserIsv();
        ConvertRuleMetadata parentRuleMeta = RuleCacheHelper.getRule(rootNode, ruleMetadata.getParentId());
        RuleTreeNode newNode = RuleTreeNode.buildRuleNode(parentRuleMeta, ruleMetadata, currentIsv);
        ruleNode.setDesignJson(newNode.getDesignJson());
        ruleNode.setChanged(true);
        RuleCacheHelper.putRootRuleNode(plugin, rootNode);
    }

    public static RuleTreeNode deleteRule(AbstractFormPlugin plugin, String ruleId) {
        RuleTreeNode rootNode = RuleCacheHelper.getRootRuleNode(plugin);
        RuleTreeNode currNode = rootNode.searchRule(ruleId);
        if (currNode == null) {
            return null;
        }
        currNode.setDeleted(true);
        List<RuleTreeNode> allChildren = currNode.mergeAllChildren();
        for (RuleTreeNode node : allChildren) {
            node.setDeleted(true);
        }
        RuleCacheHelper.putRootRuleNode(plugin, rootNode);
        RuleTreeNode parentNode = rootNode.searchRule(currNode.getParentId());
        if (parentNode == null) {
            for (RuleTreeNode node : rootNode.getChildren().values()) {
                if (node.isDeleted()) continue;
                return node;
            }
            return null;
        }
        return parentNode;
    }

    public static String getSourceBillTreeNode(AbstractFormPlugin plugin) {
        String json = plugin.getPageCache().get(CACHEKEY_SOURCE_BILL_TREENODE);
        return json;
    }

    public static String putSourceBillTreeNode(AbstractFormPlugin plugin, TreeNode billTreeNode) {
        String json = SerializationUtils.toJsonString((Object)billTreeNode);
        plugin.getPageCache().put(CACHEKEY_SOURCE_BILL_TREENODE, json);
        return json;
    }

    public static void setIsHideItemClassProp(AbstractFormPlugin plugin, boolean isHideItemClassProp) {
        plugin.getPageCache().put(CACHEKEY_ISHIDEITEMCLASSPROP, String.valueOf(isHideItemClassProp));
    }

    public static boolean isHideItemClassProp(AbstractFormPlugin plugin) {
        return Boolean.parseBoolean(plugin.getPageCache().get(CACHEKEY_ISHIDEITEMCLASSPROP));
    }

    public static String getFuncsXML(AbstractFormPlugin plugin) {
        String funcsXML = plugin.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
            FunctionTypes cloudFunc = ConvertFuncLoader.loadBizCloudFuncTypes();
            functionTypes.getFunctionGroups().addAll(cloudFunc.getFunctionGroups());
            functionTypes.getFunctionTypes().addAll(cloudFunc.getFunctionTypes());
            LoadFuncTypesEventArgs args = new LoadFuncTypesEventArgs(functionTypes);
            ((ConvertRuleEdit)plugin).getRuleSetPlugInProxy().fireLoadFuncTypes(args);
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)args.getFuncTypes());
            plugin.getPageCache().put("functiontypes", funcsXML);
        }
        return funcsXML;
    }

    public static String getDefRuleId(AbstractFormPlugin plugin) {
        return plugin.getPageCache().get(CACHEKEY_DEFRULEID);
    }

    public static void putDefRuleId(AbstractFormPlugin plugin, String defRuleId) {
        plugin.getPageCache().put(CACHEKEY_DEFRULEID, defRuleId);
    }
}

