/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.ConvertRuleEdit;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.designer.botp.FieldEventHandler;
import kd.bos.designer.botp.FieldSeqComparator;
import kd.bos.designer.botp.GetRuleHelper;
import kd.bos.designer.botp.extcontrol.domain.ExtControlEditDomain;
import kd.bos.designer.botp.extcontrol.domain.ExtControlLockDomain;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.AttachmentPanelMapItem;
import kd.bos.entity.botp.AttachmentPanelMapPolicy;
import kd.bos.entity.botp.BillTypeMapItem;
import kd.bos.entity.botp.BillTypeMapPolicy;
import kd.bos.entity.botp.BizRulePolicy;
import kd.bos.entity.botp.CRBizRuleElement;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRPlugin;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FieldConvertType;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.FieldMapPolicy;
import kd.bos.entity.botp.FilterPolicy;
import kd.bos.entity.botp.GroupByMode;
import kd.bos.entity.botp.GroupByPolicy;
import kd.bos.entity.botp.LinkEntityPolicy;
import kd.bos.entity.botp.LinkRecordType;
import kd.bos.entity.botp.PlugInPolicy;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.PictureProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.botp.layout.BotpLayoutManager;
import kd.bos.form.plugin.botp.layout.LayoutInfo;
import kd.bos.lang.Lang;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;

class SetRuleHelper {
    private static final String BOS_DESIGNER_PLUGIN = "bos-botp-formplugin";
    private static final String ENABLE = "enable";
    private IFormView view;
    private ConvertRuleEdit plugin;
    private ExtControlLockDomain extControlDomain;
    private ExtControlEditDomain extControlEditDomain;
    private BotpLayoutManager botpLayoutManager = new BotpLayoutManager();

    public SetRuleHelper(IFormView view, ConvertRuleEdit plugin, ExtControlLockDomain extControlDomain, ExtControlEditDomain extControlEditDomain) {
        this.view = view;
        this.plugin = plugin;
        this.extControlDomain = extControlDomain;
        this.extControlEditDomain = extControlEditDomain;
    }

    private IFormView getView() {
        return this.view;
    }

    private IDataModel getModel() {
        return this.view.getModel();
    }

    public void setRule(ConvertRuleElement rule) {
        this.getModel().getDataEntity(true);
        this.setBaseInfo(rule);
        this.setLinkEntryPolicy(rule);
        this.setBillTypeMapPolicy(rule);
        this.setFieldMapPolicy(rule);
        this.setAttachmentPanelMapPolicy(rule);
        this.setFilterPolicy(rule);
        this.setGroupBy(rule);
        this.setBizRulePolicy(rule);
        this.setPluginPolicy(rule);
        this.setOptionPolicy(rule);
        this.extControlDomain.updateExtControlDataFromConvertRule(this.view, rule);
    }

    public void setBillPushAttr() {
        boolean isEnable = (Boolean)this.getView().getModel().getValue("fautosave");
        if (isEnable) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"fbillpush"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fbillpush"});
            this.getModel().setValue("fbillpush", (Object)Boolean.FALSE);
        }
    }

    private void setBaseInfo(ConvertRuleElement rule) {
        String localeId = RequestContext.get().getLang().toString();
        this.getModel().setValue("fid", (Object)rule.getId());
        this.getModel().setValue("fmulilangname", (Object)rule.getName());
        this.getModel().setValue("fenabled", (Object)rule.isEnabled());
        this.getModel().setValue("sysstatus", (Object)rule.getSysStatus());
        this.getModel().setValue("fvisibled", (Object)rule.isVisibled());
        this.getModel().setValue("fvisibledctrl", (Object)rule.isVisibledCtrl());
        this.getModel().setValue("fdrawvisibled", (Object)rule.isDrawVisibled());
        this.getModel().setValue("fautosave", (Object)rule.isAutoSave());
        this.getModel().setValue("fbillpush", (Object)rule.isBillPush());
        String runConditionJson = "";
        String runConditionDesc = "";
        if (rule.getRunCondition() != null) {
            runConditionJson = SerializationUtils.toJsonString((Object)rule.getRunCondition());
            runConditionDesc = rule.getRunCondition().getExprDesc();
        }
        this.getModel().setValue("fruncondition", (Object)runConditionJson);
        this.getModel().setValue("frunconditiondesc", (Object)runConditionDesc);
    }

    private void setLinkEntryPolicy(ConvertRuleElement rule) {
        LinkEntityPolicy policy = rule.getLinkEntityPolicy();
        this.getModel().setValue("ftargetentrykey", (Object)policy.getTargetEntryKey());
        this.changeTgtLinkEntity(policy.getTargetEntryKey());
        this.getModel().setValue("ftargetsubentrykey", (Object)policy.getTargetSubEntryKey());
        this.getModel().setValue("fsourceentrykey", (Object)policy.getSourceEntryKey());
        this.changeSrcLinkEntity(policy.getSourceEntryKey());
        this.getModel().setValue("fsourcesubentrykey", (Object)policy.getSourceSubEntryKey());
        this.getModel().setValue("fsourcelayout", (Object)policy.getSourceLayout());
        this.getModel().setValue("fmobsourcelayout", (Object)policy.getMobSourceLayout());
        this.getModel().setValue("ftargetlayout", (Object)policy.getTargetLayout());
        this.getModel().setValue("fmobtargetlayout", (Object)policy.getMobTargetLayout());
        if (policy.getLinkRecordType() == LinkRecordType.Link) {
            this.getModel().setValue("flinkrecord", (Object)true);
        } else {
            this.getModel().setValue("flinkrecord", (Object)false);
        }
    }

    public void setBillTypeMapPolicy(ConvertRuleElement rule) {
        boolean enableAddRow = this.getBillTypeProp(this.plugin.getRuleFormHelper().getSrcMainType()) != null && this.getBillTypeProp(this.plugin.getRuleFormHelper().getTgtMainType()) != null;
        this.getView().setEnable(Boolean.valueOf(enableAddRow), new String[]{"bar_billtype_newentry", "bar_billtype_test"});
        BillTypeMapPolicy policy = rule.getBillTypeMapPolicy();
        int mapItemCount = policy.getItems().size();
        int rowCount = this.getModel().getEntryRowCount("billtypemappolicy");
        if (rowCount < mapItemCount) {
            this.getModel().batchCreateNewEntryRow("billtypemappolicy", mapItemCount - rowCount);
        }
        if (rowCount > mapItemCount) {
            for (int rowIndex = rowCount - 1; rowIndex >= mapItemCount; --rowIndex) {
                this.getModel().deleteEntryRow("billtypemappolicy", rowIndex);
            }
        }
        Map<String, ComboItem> sourceBillTypeItems = this.plugin.getRuleFormHelper().buildSourceBillTypeItems();
        Map<String, ComboItem> targetBillTypeItems = this.plugin.getRuleFormHelper().buildTargetBillTypeItems();
        policy.setItems(this.sortBillTypeMapItems(policy));
        for (int rowIndex = 0; rowIndex < mapItemCount; ++rowIndex) {
            ComboItem item;
            BillTypeMapItem mapItem = (BillTypeMapItem)policy.getItems().get(rowIndex);
            this.getModel().setValue("billtypemapitemid", (Object)mapItem.getId(), rowIndex);
            if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getSourceType(), (CharSequence)"All")) {
                this.getModel().setValue("sourcebilltype", (Object)"All", rowIndex);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getSourceType(), (CharSequence)"Others")) {
                this.getModel().setValue("sourcebilltype", (Object)"Others", rowIndex);
            } else {
                String srcId = String.valueOf(mapItem.getSourceBillTypeId());
                this.getModel().setValue("sourcebilltype", (Object)srcId, rowIndex);
                if (sourceBillTypeItems.containsKey(srcId)) {
                    mapItem.setSourceBillTypeName(sourceBillTypeItems.get(srcId).getCaption().toString());
                } else {
                    String srcName = String.format(ResManager.loadKDString((String)"%s(\u672a\u77e5\u7c7b\u578b)", (String)"ConvertRuleEdit_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), String.valueOf(mapItem.getSourceBillTypeId()));
                    mapItem.setSourceBillTypeName(srcName);
                    item = new ComboItem(new LocaleString(srcName), srcId);
                    sourceBillTypeItems.put(item.getId(), item);
                }
            }
            this.getModel().setValue("pushtype", (Object)mapItem.getPushType(), rowIndex);
            if (Long.compare(0L, mapItem.getTargetBillTypeId()) == 0) {
                this.getModel().setValue("targetbilltype", (Object)"", rowIndex);
            } else {
                String targetId = String.valueOf(mapItem.getTargetBillTypeId());
                if (targetBillTypeItems.containsKey(targetId)) {
                    mapItem.setTargetBillTypeName(targetBillTypeItems.get(targetId).getCaption().toString());
                } else {
                    String targetName = String.format(ResManager.loadKDString((String)"%s(\u672a\u77e5\u7c7b\u578b)", (String)"ConvertRuleEdit_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), mapItem.getTargetBillTypeId());
                    mapItem.setTargetBillTypeName(targetName);
                    item = new ComboItem(new LocaleString(targetName), targetId);
                    targetBillTypeItems.put(item.getId(), item);
                }
                this.getModel().setValue("targetbilltype", (Object)String.valueOf(mapItem.getTargetBillTypeId()), rowIndex);
            }
            this.getModel().setValue("billtypemapitemdesc", (Object)mapItem.toString(), rowIndex);
        }
        ComboEdit edit1 = (ComboEdit)this.getView().getControl("sourcebilltype");
        edit1.setComboItems(new ArrayList<ComboItem>(sourceBillTypeItems.values()));
        ComboEdit edit2 = (ComboEdit)this.getView().getControl("targetbilltype");
        edit2.setComboItems(new ArrayList<ComboItem>(targetBillTypeItems.values()));
    }

    private List<BillTypeMapItem> sortBillTypeMapItems(BillTypeMapPolicy policy) {
        ArrayList<BillTypeMapItem> list = new ArrayList<BillTypeMapItem>();
        if (policy != null) {
            list.addAll(policy.getItems());
        }
        list.sort(Comparator.comparingInt(BillTypeMapItem::getSeq));
        return list;
    }

    public void setAttachmentPanelMapPolicy(ConvertRuleElement rule) {
        int rowIndex;
        MainEntityType tgtMainType = this.plugin.getRuleFormHelper().getTgtMainType();
        MainEntityType srcMainType = this.plugin.getRuleFormHelper().getSrcMainType();
        if (tgtMainType == null || srcMainType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e3b\u5b9e\u4f53\u7c7b\u578b\u5931\u8d25", (String)"ConvertRuleEdit_81", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        List<ControlAp<?>> targetPanels = this.getAttachmentPanels(tgtMainType.getName());
        List<ControlAp<?>> sourcePanels = this.getAttachmentPanels(srcMainType.getName());
        if (targetPanels.isEmpty() || sourcePanels.isEmpty()) {
            this.getModel().deleteEntryData("attachmentpanelmappolicy");
            return;
        }
        this.initAttachmentPanelComboItems("sourceattachmentpanel", sourcePanels);
        this.initAttachmentPanelComboItems("targetattachmentpanel", targetPanels);
        AttachmentPanelMapPolicy policy = rule.getAttachmentPanelMapPolicy();
        HashMap<String, AttachmentPanelMapItem> attachMaps = new HashMap<String, AttachmentPanelMapItem>(16);
        for (AttachmentPanelMapItem item : policy.getItems()) {
            attachMaps.put(item.getTargetAttachmentPanel(), item);
        }
        int allAttachsCount = targetPanels.size();
        int rowCount = this.getModel().getEntryRowCount("attachmentpanelmappolicy");
        if (rowCount < allAttachsCount) {
            this.getModel().batchCreateNewEntryRow("attachmentpanelmappolicy", allAttachsCount - rowCount);
        }
        if (rowCount > allAttachsCount) {
            for (rowIndex = rowCount - 1; rowIndex >= allAttachsCount; --rowIndex) {
                this.getModel().deleteEntryRow("attachmentpanelmappolicy", rowIndex);
            }
        }
        rowIndex = 0;
        for (ControlAp<?> attachmentPanelAp : targetPanels) {
            String targetKey = attachmentPanelAp.getKey();
            this.getModel().setValue("targetattachmentpanel", (Object)targetKey, rowIndex);
            AttachmentPanelMapItem item = (AttachmentPanelMapItem)attachMaps.get(targetKey);
            if (item != null) {
                this.fillAttachmentPanelMapRow(item, rowIndex);
            } else {
                AttachmentPanelMapItem blankItem = new AttachmentPanelMapItem();
                this.fillAttachmentPanelMapRow(blankItem, rowIndex);
            }
            ++rowIndex;
        }
    }

    private void initAttachmentPanelComboItems(String comboKey, List<ControlAp<?>> comboPanels) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(comboPanels.size());
        for (ControlAp<?> attachmentPanelAp : comboPanels) {
            ComboItem item = new ComboItem(attachmentPanelAp.getName(), attachmentPanelAp.getKey());
            items.add(item);
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(comboKey);
        comboEdit.setComboItems(items);
    }

    private void fillAttachmentPanelMapRow(AttachmentPanelMapItem attachMapItem, int rowIndex) {
        this.getModel().setValue("attachmentpanelmapitemid", (Object)attachMapItem.getId(), rowIndex);
        this.getModel().setValue("sourceattachmentpanel", (Object)attachMapItem.getSourceAttachmentPanel(), rowIndex);
        this.getModel().setValue("attachmentmergetype", (Object)attachMapItem.getAttachmentPanelMergeType(), rowIndex);
    }

    private List<ControlAp<?>> getAttachmentPanels(String formId) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        List<ControlAp<?>> aps = formMetadata.getItems().stream().filter(item -> item instanceof AttachmentPanelAp).collect(Collectors.toList());
        Collections.sort(aps, new Comparator<ControlAp<?>>(){

            @Override
            public int compare(ControlAp<?> o1, ControlAp<?> o2) {
                int compareValue = 0;
                compareValue = o1.getParentId() == null && o2.getParentId() == null ? 0 : (o1.getParentId() == null && o2.getParentId() != null ? -1 : (o1.getParentId() != null && o2.getParentId() == null ? 1 : o1.getParentId().compareTo(o2.getParentId())));
                if (compareValue != 0) {
                    return compareValue;
                }
                return Integer.compare(o1.getIndex(), o2.getIndex());
            }
        });
        return aps;
    }

    public void setFieldMapPolicy(ConvertRuleElement rule) {
        MainEntityType targetMainType = this.plugin.getRuleFormHelper().getTgtMainType();
        MainEntityType sourceMainType = this.plugin.getRuleFormHelper().getSrcMainType();
        if (targetMainType == null || sourceMainType == null) {
            this.getModel().deleteEntryData("fieldmappolicy");
            return;
        }
        FieldMapPolicy policy = rule.getFieldMapPolicy();
        HashMap<String, FieldMapItem> fieldMaps = new HashMap<String, FieldMapItem>(16);
        for (FieldMapItem item : policy.getFieldMaps()) {
            fieldMaps.put(item.getTargetFieldKey(), item);
        }
        BillTreeBuildParameter billTreeBuildParameter = new BillTreeBuildParameter(targetMainType);
        int allFieldCount = 0;
        ArrayList<IDataEntityProperty> allFields = new ArrayList<IDataEntityProperty>();
        for (EntityType entityType : targetMainType.getAllEntities().values()) {
            for (IDataEntityProperty property : entityType.getFields().values()) {
                if (!(property instanceof IFieldHandle) || !((IFieldHandle)property).isConvertTote() || !EntityParseHelper.isSupportConvField(targetMainType, property) || billTreeBuildParameter.isFormDisVisitField(property)) continue;
                allFields.add(property);
                ++allFieldCount;
            }
        }
        allFields.sort(new FieldSeqComparator(targetMainType));
        int rowCount = this.getModel().getEntryRowCount("fieldmappolicy");
        if (rowCount < allFieldCount) {
            this.getModel().batchCreateNewEntryRow("fieldmappolicy", allFieldCount - rowCount);
        }
        if (rowCount > allFieldCount) {
            for (int rowIndex = rowCount - 1; rowIndex >= allFieldCount; --rowIndex) {
                this.getModel().deleteEntryRow("fieldmappolicy", rowIndex);
            }
        }
        int rowIndex = 0;
        for (IDataEntityProperty property : allFields) {
            DynamicProperty field = (DynamicProperty)property;
            String targetFieldKey = field.getName();
            String targetFieldName = EntityParseHelper.buildPropFullCaption(property);
            this.getModel().setValue("ftargetfield", (Object)targetFieldKey, rowIndex);
            this.getModel().setValue("ftargetfieldname", (Object)targetFieldName, rowIndex);
            FieldMapItem item = (FieldMapItem)fieldMaps.get(targetFieldKey);
            if (item != null) {
                this.fillFieldMapRow(sourceMainType, item, rowIndex);
            } else {
                FieldMapItem blankItem = new FieldMapItem();
                this.fillFieldMapRow(sourceMainType, blankItem, rowIndex);
            }
            ++rowIndex;
        }
    }

    public void setFilterCondition(ConvertRuleElement rule) {
        FilterPolicy filterPolicy = rule.getFilterPolicy();
        FilterCondition filterCondition = null;
        filterCondition = filterPolicy.getCondition() != null && filterPolicy.getCondition().getFilterCondition() != null ? filterPolicy.getCondition().getFilterCondition() : new FilterCondition();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        filterGrid.SetValue(filterCondition);
    }

    public void setFilterPolicy(ConvertRuleElement rule) {
        FilterPolicy filterPolicy = rule.getFilterPolicy();
        if (filterPolicy.getCondition().getDescription() == null) {
            this.getModel().setValue("filterdesc", null);
        } else {
            this.getModel().setValue("filterdesc", (Object)filterPolicy.getCondition().getDescription().toString());
        }
        this.getModel().setValue("advanced_conditions", (Object)rule.getFilterPolicy().getAdvCondition());
        this.setAdvFilterPolicy(filterPolicy);
    }

    public void setAdvFilterPolicy(FilterPolicy filterPolicy) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity("adv_filter");
        rows.clear();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get("adv_filter");
        ArrayList<CRCondition> crConditions = new ArrayList<CRCondition>();
        crConditions.addAll(filterPolicy.getConditionList());
        crConditions.sort(new Comparator<CRCondition>(){

            @Override
            public int compare(CRCondition o1, CRCondition o2) {
                if (o1.getSeq() < o2.getSeq()) {
                    return -1;
                }
                if (o1.getSeq() > o2.getSeq()) {
                    return 1;
                }
                return 0;
            }
        });
        int seq = 1;
        for (CRCondition condition : crConditions) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set("seq", (Object)seq);
            row.set("ft_id", (Object)condition.getId());
            row.set("advfilterenable", (Object)condition.isEnabled());
            row.set("advfilterjson", (Object)SerializationUtils.toJsonString((Object)condition));
            row.set("filterexprdesc", (Object)condition.getExprTran());
            row.set("advfilterdesc", (Object)condition.getDescription());
            rows.add((Object)row);
            ++seq;
        }
        this.getView().updateView("adv_filter");
    }

    public void setFilterAp() {
        boolean isEnable = (Boolean)this.getView().getModel().getValue("advanced_conditions");
        if (isEnable) {
            this.extControlEditDomain.changeTabSelected(this.plugin, "adv_filter");
            this.getView().setVisible(Boolean.FALSE, new String[]{"fs_filter"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"fs_advfilter"});
        } else {
            this.extControlEditDomain.changeTabSelected(this.plugin, "tbpage_filter");
            this.getView().setVisible(Boolean.TRUE, new String[]{"fs_filter"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"fs_advfilter"});
        }
    }

    private void setBizRulePolicy(ConvertRuleElement rule) {
        String entityKey = "bizrulepolicy";
        int rowCount = this.getModel().getEntryRowCount(entityKey);
        BizRulePolicy policy = rule.getBizRulePolicy();
        if (policy.getActions().size() == 0) {
            this.getModel().deleteEntryData(entityKey);
        } else if (policy.getActions().size() > rowCount) {
            this.getModel().batchCreateNewEntryRow(entityKey, policy.getActions().size() - rowCount);
        } else {
            for (int i = rowCount; i > policy.getActions().size(); --i) {
                this.getModel().deleteEntryRow(entityKey, i - 1);
            }
        }
        ArrayList<CRBizRuleElement> bizRules = new ArrayList<CRBizRuleElement>();
        bizRules.addAll(policy.getActions());
        bizRules.sort(new Comparator<CRBizRuleElement>(){

            @Override
            public int compare(CRBizRuleElement o1, CRBizRuleElement o2) {
                if (o1.getSeq() < o2.getSeq()) {
                    return -1;
                }
                if (o1.getSeq() > o2.getSeq()) {
                    return 1;
                }
                return 0;
            }
        });
        int i = 0;
        for (CRBizRuleElement bizRule : bizRules) {
            this.getModel().setValue("br_id", (Object)bizRule.getId(), i);
            this.getModel().setValue("br_enabled", (Object)bizRule.isEnabled(), i);
            this.getModel().setValue("br_bizruleitem", (Object)SerializationUtils.toJsonString((Object)bizRule), i);
            this.getModel().setValue("br_bizruledesc", (Object)bizRule.getDescription().toString(), i);
            ++i;
        }
    }

    private void setPluginPolicy(ConvertRuleElement rule) {
        String entityKey = "pluginpolicy";
        int rowCount = this.getModel().getEntryRowCount(entityKey);
        PlugInPolicy policy = rule.getPlugInPolicy();
        int plugCount = policy.getPlugins().size();
        if (plugCount == 0) {
            this.getModel().deleteEntryData(entityKey);
        } else if (plugCount > rowCount) {
            this.getModel().batchCreateNewEntryRow(entityKey, plugCount - rowCount);
        } else {
            for (int i = rowCount; i > plugCount; --i) {
                this.getModel().deleteEntryRow(entityKey, i - 1);
            }
        }
        ArrayList<CRPlugin> crPlugins = new ArrayList<CRPlugin>();
        crPlugins.addAll(policy.getPlugins());
        crPlugins.sort(new Comparator<CRPlugin>(){

            @Override
            public int compare(CRPlugin o1, CRPlugin o2) {
                if (o1.getSeq() < o2.getSeq()) {
                    return -1;
                }
                if (o1.getSeq() > o2.getSeq()) {
                    return 1;
                }
                return 0;
            }
        });
        int i = 0;
        for (CRPlugin crPlugin : crPlugins) {
            this.getModel().setValue("f_pl_enabled", (Object)crPlugin.isEnabled(), i);
            this.getModel().setValue("f_pl_type", (Object)String.valueOf(crPlugin.getType()), i);
            this.getModel().setValue("f_pl_classname", (Object)crPlugin.getClassName(), i);
            this.getModel().setValue("f_pl_displayname", (Object)crPlugin.getDisplayName(), i);
            this.getModel().setValue("f_pl_description", (Object)crPlugin.getDescription(), i);
            this.getModel().setValue("f_pl_plugin", (Object)SerializationUtils.toJsonString((Object)crPlugin), i);
            ++i;
        }
    }

    private void setOptionPolicy(ConvertRuleElement rule) {
        if (this.getModel().getProperty("pushmutex") != null) {
            this.getModel().setValue("pushmutex", (Object)rule.getOptionPolicy().isPushMutex());
            this.getModel().setValue("pushonetime", (Object)rule.getOptionPolicy().isPushOneTime());
            this.getModel().setValue("checkbaseenable", (Object)rule.getOptionPolicy().isCheckBaseEnable());
            this.getModel().setValue("mulcombobaseenable", (Object)rule.getOptionPolicy().getMulComboBaseEnableStr());
            this.getModel().setValue("createreport", (Object)rule.getOptionPolicy().isCreateReport());
            this.getModel().setValue("reportstarttime", (Object)rule.getOptionPolicy().getReportStartTime());
            this.getModel().setValue("reportendtime", (Object)rule.getOptionPolicy().getReportEndTime());
            this.getModel().setValue("convertsnapshot", (Object)rule.getOptionPolicy().isConvertSnapshot());
            this.getModel().setValue("withouttrim", (Object)rule.getOptionPolicy().isWithoutTrim());
        }
    }

    public void changeTgtLinkEntity(String entityKey) {
        this.getModel().setValue("ftargetsubentrykey", (Object)"");
        if (StringUtils.isBlank((CharSequence)entityKey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ftargetsubentrykey"});
            return;
        }
        ArrayList<SubEntryType> subEntrys = new ArrayList<SubEntryType>();
        if (this.plugin.getRuleFormHelper().getTgtMainType() != null) {
            for (EntityType entity : this.plugin.getRuleFormHelper().getTgtMainType().getAllEntities().values()) {
                if (!(entity instanceof SubEntryType) || entity.getParent() == null || !entity.getParent().getName().equalsIgnoreCase(entityKey)) continue;
                subEntrys.add((SubEntryType)entity);
            }
        }
        if (subEntrys.size() == 0) {
            this.view.setVisible(Boolean.valueOf(false), new String[]{"ftargetsubentrykey"});
        } else {
            this.view.setVisible(Boolean.valueOf(true), new String[]{"ftargetsubentrykey"});
        }
        this.fillLinkSubEntityCombo("ftargetsubentrykey", subEntrys);
    }

    public void changeSrcLinkEntity(String entityKey) {
        this.getModel().setValue("fsourcesubentrykey", (Object)"");
        if (StringUtils.isBlank((CharSequence)entityKey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fsourcesubentrykey"});
            return;
        }
        ArrayList<SubEntryType> subEntrys = new ArrayList<SubEntryType>();
        if (this.plugin.getRuleFormHelper().getSrcMainType() != null) {
            for (EntityType entity : this.plugin.getRuleFormHelper().getSrcMainType().getAllEntities().values()) {
                if (!(entity instanceof SubEntryType) || entity.getParent() == null || !entity.getParent().getName().equalsIgnoreCase(entityKey)) continue;
                subEntrys.add((SubEntryType)entity);
            }
        }
        if (subEntrys.size() == 0) {
            this.view.setVisible(Boolean.valueOf(false), new String[]{"fsourcesubentrykey"});
        } else {
            this.view.setVisible(Boolean.valueOf(true), new String[]{"fsourcesubentrykey"});
        }
        this.fillLinkSubEntityCombo("fsourcesubentrykey", subEntrys);
    }

    public void fillLinkEntityCombo() {
        this.fillTgtLinkEntityCombo();
        this.fillSrcLinkEntityCombo();
        this.fillLayoutCombo();
    }

    private void fillLayoutCombo() {
        MainEntityType sourceMainType = this.plugin.getRuleFormHelper().getSrcMainType();
        MainEntityType targetMainType = this.plugin.getRuleFormHelper().getTgtMainType();
        ArrayList<ComboItem> sourceLayoutComboItemList = new ArrayList<ComboItem>();
        ArrayList<ComboItem> sourceMobLayoutComboItemList = new ArrayList<ComboItem>();
        ArrayList<ComboItem> targetLayoutComboItemList = new ArrayList<ComboItem>();
        ArrayList<ComboItem> targetMobLayoutComboItemList = new ArrayList<ComboItem>();
        if (sourceMainType != null && targetMainType != null) {
            this.initDefaultLayoutComboItem(sourceLayoutComboItemList, sourceMainType);
            this.initDefaultLayoutComboItem(sourceMobLayoutComboItemList, sourceMainType);
            this.initDefaultLayoutComboItem(targetLayoutComboItemList, targetMainType);
            this.initDefaultLayoutComboItem(targetMobLayoutComboItemList, targetMainType.getName() + "_mob");
            String sourceMainTypeName = sourceMainType.getName();
            String targetMainTypeName = targetMainType.getName();
            ArrayList<String> formIdList = new ArrayList<String>(2);
            formIdList.add(sourceMainTypeName);
            formIdList.add(targetMainTypeName);
            List<LayoutInfo> layoutInfoList = this.botpLayoutManager.queryLayoutByFormId(formIdList, false);
            for (LayoutInfo layoutInfo : layoutInfoList) {
                LocaleString mobileFormName2;
                String modelType = layoutInfo.getModelType();
                boolean pcModelType = !"MobileBillFormModel".equals(modelType);
                boolean mobileModelType = "BillFormModel".equals(modelType) || "BaseFormModel".equals(modelType) || "MobileBillFormModel".equals(modelType);
                boolean billOrBaseModelType = "BillFormModel".equals(modelType) || "BaseFormModel".equals(modelType);
                ComboItem comboItem = new ComboItem(new LocaleString(layoutInfo.getLayoutName()), layoutInfo.getLayoutNumber());
                if (sourceMainTypeName.equals(layoutInfo.getEntityNumber())) {
                    if (pcModelType) {
                        sourceLayoutComboItemList.add(comboItem);
                    }
                    if (mobileModelType) {
                        if (billOrBaseModelType) {
                            try {
                                mobileFormName2 = this.botpLayoutManager.queryMobileLayoutName(modelType, comboItem.getValue(), comboItem.getCaption().getLocaleValue());
                                sourceMobLayoutComboItemList.add(new ComboItem(mobileFormName2, comboItem.getValue()));
                            }
                            catch (Exception mobileFormName2) {}
                        } else {
                            sourceMobLayoutComboItemList.add(comboItem);
                        }
                    }
                }
                if (!targetMainTypeName.equals(layoutInfo.getEntityNumber())) continue;
                if (pcModelType) {
                    targetLayoutComboItemList.add(comboItem);
                }
                if (!mobileModelType) continue;
                if (billOrBaseModelType) {
                    try {
                        mobileFormName2 = this.botpLayoutManager.queryMobileLayoutName(modelType, comboItem.getValue(), comboItem.getCaption().getLocaleValue());
                        String formNumber = comboItem.getValue() + "_mob";
                        targetMobLayoutComboItemList.add(new ComboItem(mobileFormName2, formNumber));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                targetMobLayoutComboItemList.add(comboItem);
            }
        }
        this.setComboItems("fsourcelayout", sourceLayoutComboItemList);
        this.setComboItems("fmobsourcelayout", sourceMobLayoutComboItemList);
        this.setComboItems("ftargetlayout", targetLayoutComboItemList);
        this.setComboItems("fmobtargetlayout", targetMobLayoutComboItemList);
    }

    private void fillSrcLinkEntityCombo() {
        MainEntityType mainType = this.plugin.getRuleFormHelper().getSrcMainType();
        List<ComboItem> entryItems = this.buildEntryComboItems(mainType);
        ComboEdit entryEditor = (ComboEdit)this.getView().getControl("fsourceentrykey");
        entryEditor.setComboItems(entryItems);
    }

    private void setComboItems(String comboEditKey, List<ComboItem> layoutComboItemList) {
        ComboEdit editor = (ComboEdit)this.getView().getControl(comboEditKey);
        if (editor != null) {
            editor.setComboItems(layoutComboItemList);
        }
    }

    private void initDefaultLayoutComboItem(List<ComboItem> layoutComboItemList, MainEntityType mainType) {
        this.initDefaultLayoutComboItem(layoutComboItemList, mainType.getName());
    }

    private void initDefaultLayoutComboItem(List<ComboItem> layoutComboItemList, String comboItemValue) {
        ComboItem defItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u9ed8\u8ba4\u5e03\u5c40", (String)"ConvertRuleEdit_13", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), comboItemValue);
        layoutComboItemList.add(defItem);
    }

    private void fillTgtLinkEntityCombo() {
        MainEntityType mainType = this.plugin.getRuleFormHelper().getTgtMainType();
        List<ComboItem> entryItems = this.buildEntryComboItems(mainType);
        ComboEdit entryEditor = (ComboEdit)this.getView().getControl("ftargetentrykey");
        entryEditor.setComboItems(entryItems);
    }

    private void fillLinkSubEntityCombo(String comboFldKey, List<SubEntryType> subEntrys) {
        ArrayList<ComboItem> subEntryItems = new ArrayList<ComboItem>(10);
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        subEntryItems.add(blankItem);
        for (SubEntryType entity : subEntrys) {
            ComboItem subEntryItem = new ComboItem();
            subEntryItem.setValue(entity.getName());
            subEntryItem.setCaption(entity.getDisplayName());
            subEntryItems.add(subEntryItem);
        }
        ComboEdit subEntryEditor = (ComboEdit)this.getView().getControl(comboFldKey);
        subEntryEditor.setComboItems(subEntryItems);
    }

    public void fillCheckBaseEnableCombo() {
        ComboEdit propertyField = (ComboEdit)this.view.getControl("mulcombobaseenable");
        ArrayList<String> splitKeys = new ArrayList<String>();
        ArrayList<String> splitValues = new ArrayList<String>();
        if (this.plugin.getRuleFormHelper().getSrcMainType() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e3b\u5b9e\u4f53\u7c7b\u578b\u5931\u8d25", (String)"ConvertRuleEdit_81", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        Map entities = this.plugin.getRuleFormHelper().getSrcMainType().getAllEntities();
        for (EntityType entityType : entities.values()) {
            DataEntityPropertyCollection properties = entityType.getProperties();
            for (IDataEntityProperty property : properties) {
                String entityTypeDisplayName;
                if (!(property instanceof BasedataProp)) continue;
                String string = entityTypeDisplayName = entityType.getDisplayName() == null ? entityType.getName() : entityType.getDisplayName().toString();
                if (!(entityType instanceof EntryType)) {
                    entityTypeDisplayName = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ConvertRuleEdit_14", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                }
                String propertyDisplayName = property.getDisplayName() == null ? property.getName() : property.getDisplayName().toString();
                splitKeys.add(String.format("%s.%s (%s)", entityTypeDisplayName, propertyDisplayName, property.getName()));
                splitValues.add(property.getName());
            }
        }
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(splitKeys.size());
        for (int i = 0; i < splitKeys.size(); ++i) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString((String)splitKeys.get(i)));
            comboItem.setValue((String)splitValues.get(i));
            propertyItems.add(comboItem);
        }
        propertyField.setComboItems(propertyItems);
    }

    private List<ComboItem> buildEntryComboItems(MainEntityType mainType) {
        ArrayList<ComboItem> entryItems = new ArrayList<ComboItem>();
        String currLCId = Lang.get().toString();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        entryItems.add(blankItem);
        if (mainType != null) {
            Map entitys = mainType.getAllEntities();
            ComboItem headItem = new ComboItem();
            headItem.setValue(mainType.getName());
            headItem.setCaption(new LocaleString(currLCId, ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ConvertRuleEdit_14", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
            entryItems.add(headItem);
            for (EntityType entity : entitys.values()) {
                if (entity instanceof LinkEntryType || !(entity instanceof EntryType)) continue;
                ComboItem entryItem = new ComboItem();
                entryItem.setValue(entity.getName());
                entryItem.setCaption(entity.getDisplayName());
                entryItems.add(entryItem);
            }
        }
        return entryItems;
    }

    public BillTypeProp getBillTypeProp(MainEntityType mainType) {
        if (mainType == null) {
            return null;
        }
        for (IDataEntityProperty property : mainType.getProperties()) {
            if (!(property instanceof BillTypeProp)) continue;
            return (BillTypeProp)property;
        }
        return null;
    }

    public void fillFilterGridFields() {
        MainEntityType mainType = this.plugin.getRuleFormHelper().getSrcMainType();
        if (mainType == null) {
            return;
        }
        FilterFieldBuildOption option = new FilterFieldBuildOption();
        option.setCompatibleProductMode(true);
        List cols = FormTreeBuilder.buildFilterColumns((MainEntityType)mainType, (FilterFieldBuildOption)option);
        this.removeInvalidFilterColumns(mainType, cols);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        filterGrid.setEntityNumber(mainType.getName());
        filterGrid.setFilterColumns(cols);
    }

    private void removeInvalidFilterColumns(MainEntityType entityType, List<Map<String, Object>> cols) {
        Map fields = entityType.getAllFields();
        Iterator<Map<String, Object>> iterator = cols.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> col = iterator.next();
            if (col != null && col.get("fieldName") != null && !(fields.get((String)col.get("fieldName")) instanceof PictureProp)) continue;
            iterator.remove();
        }
    }

    public void setGroupBy(ConvertRuleElement rule) {
        if (StringUtils.isBlank((CharSequence)rule.getSourceEntityNumber())) {
            return;
        }
        GroupByPolicy byPolicy = rule.getGroupByPolicy();
        this.fillGroupBillCombo(StringUtils.isBlank((Object)byPolicy.getGroupByMode()) ? String.valueOf(GroupByMode.OneToOne.getValue()) : String.valueOf(byPolicy.getGroupByMode().getValue()));
        this.fillGroupEntryCombo(StringUtils.isBlank((Object)byPolicy.getGroupByMode2()) ? String.valueOf(GroupByMode.OneToOne.getValue()) : String.valueOf(byPolicy.getGroupByMode2().getValue()));
        this.fillGroupSubEntryCombo(StringUtils.isBlank((Object)byPolicy.getGroupByMode3()) ? String.valueOf(GroupByMode.OneToOne.getValue()) : String.valueOf(byPolicy.getGroupByMode3().getValue()));
        this.fillGroupEntry("g_billentry", "g_billentrykey", "g_billentryname", byPolicy.getGroupByField());
        this.fillGroupEntry("g_entry", "g_entrykey", "g_entryname", byPolicy.getGroupByField2());
        this.fillGroupEntry("g_subentry", "g_subentrykey", "g_subentryname", byPolicy.getGroupByField3());
    }

    public void fillGroupEntry(String entryKey, String fieldKey, String fieldName, String groupByField) {
        IDataModel model = this.getModel();
        MainEntityType srcMainType = this.plugin.getRuleFormHelper().getSrcMainType();
        int rowCount = model.getEntryRowCount(entryKey);
        String[] keys = groupByField == null ? new String[]{} : groupByField.split(",");
        ArrayList<String> keyList = new ArrayList<String>();
        for (String key : keys) {
            if (!StringUtils.isNotBlank((CharSequence)key)) continue;
            keyList.add(key);
        }
        if (rowCount < keyList.size()) {
            model.batchCreateNewEntryRow(entryKey, keys.length - rowCount);
        } else {
            for (int row = rowCount - 1; row >= keyList.size(); --row) {
                model.deleteEntryRow(entryKey, row);
            }
        }
        for (int i = 0; i < keyList.size(); ++i) {
            String key = (String)keyList.get(i);
            String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)srcMainType, key);
            if (StringUtils.isBlank((CharSequence)fieldCaption)) {
                fieldCaption = key;
            }
            model.setValue(fieldKey, (Object)key, i);
            model.setValue(fieldName, (Object)fieldCaption, i);
        }
    }

    public void fillGroupBillCombo(String value) {
        this.getModel().setValue("g_billcombo", (Object)value);
        FieldEventHandler eventHandler = new FieldEventHandler(this.view, this.plugin, this.extControlDomain, this.extControlEditDomain);
        eventHandler.groupByChanged("g_billcombo", false);
    }

    public void fillGroupEntryCombo(String value) {
        this.getModel().setValue("g_entrycombo", (Object)value);
        FieldEventHandler eventHandler = new FieldEventHandler(this.view, this.plugin, this.extControlDomain, this.extControlEditDomain);
        eventHandler.groupByChanged("g_entrycombo", false);
    }

    public void fillGroupSubEntryCombo(String value) {
        this.getModel().setValue("g_subentrycombo", (Object)value);
        FieldEventHandler eventHandler = new FieldEventHandler(this.view, this.plugin, this.extControlDomain, this.extControlEditDomain);
        eventHandler.groupByChanged("g_subentrycombo", false);
    }

    private void fillFieldMapRow(MainEntityType sourceMainType, FieldMapItem fieldMapItem, int rowIndex) {
        this.getModel().setValue("fconverttype", (Object)String.valueOf(fieldMapItem.getFieldConvertType().getValue()), rowIndex);
        this.getModel().setValue("fsumtype", (Object)String.valueOf(fieldMapItem.getFieldSumType().getValue()), rowIndex);
        if (fieldMapItem.getFieldConvertType() == FieldConvertType.SourceField) {
            String sourceFieldKey = fieldMapItem.getSourceFieldKey();
            String sourceFieldName = StringUtils.isBlank((CharSequence)sourceFieldKey) ? "" : EntityParseHelper.buildPropFullCaption((EntityType)sourceMainType, fieldMapItem.getSourceFieldKey());
            this.getModel().setValue("fsourcefield", (Object)sourceFieldKey, rowIndex);
            this.getModel().setValue("fsourcefieldname", (Object)sourceFieldName, rowIndex);
            this.getModel().setValue("ffieldformula", (Object)"", rowIndex);
            this.getModel().setValue("ffieldformuladesc", (Object)"", rowIndex);
        } else {
            this.getModel().setValue("fsourcefield", (Object)"", rowIndex);
            this.getModel().setValue("fsourcefieldname", (Object)"", rowIndex);
            if (fieldMapItem.getFieldConvertType() == FieldConvertType.Formula) {
                if (fieldMapItem.getFormula() == null) {
                    this.getModel().setValue("ffieldformula", (Object)"", rowIndex);
                    this.getModel().setValue("ffieldformuladesc", (Object)"", rowIndex);
                } else {
                    String formula = SerializationUtils.toJsonString((Object)fieldMapItem.getFormula());
                    this.getModel().setValue("ffieldformula", (Object)formula, rowIndex);
                    this.getModel().setValue("ffieldformuladesc", (Object)fieldMapItem.getFormula().getExprDesc(), rowIndex);
                }
            } else if (fieldMapItem.getFieldConvertType() == FieldConvertType.ByCondition) {
                if (fieldMapItem.getValByConditions() == null) {
                    this.getModel().setValue("ffieldformula", (Object)"", rowIndex);
                    this.getModel().setValue("ffieldformuladesc", (Object)"", rowIndex);
                } else {
                    String formula = SerializationUtils.toJsonString((Object)fieldMapItem.getValByConditions());
                    this.getModel().setValue("ffieldformula", (Object)formula, rowIndex);
                    this.getModel().setValue("ffieldformuladesc", (Object)fieldMapItem.getValByConditions().getDescription(), rowIndex);
                }
            } else if (fieldMapItem.getFieldConvertType() == FieldConvertType.CONSTANT) {
                if (fieldMapItem.getConstant() == null) {
                    this.getModel().setValue("ffieldformula", (Object)"", rowIndex);
                    this.getModel().setValue("ffieldformuladesc", (Object)"", rowIndex);
                } else {
                    String constant = SerializationUtils.toJsonString((Object)fieldMapItem.getConstant());
                    this.getModel().setValue("ffieldformula", (Object)constant, rowIndex);
                    this.getModel().setValue("ffieldformuladesc", (Object)fieldMapItem.getConstant().getExprTran(), rowIndex);
                }
            }
        }
        this.getModel().setValue("fdrawfilter", (Object)fieldMapItem.isDrawFilter(), rowIndex);
        this.getModel().setValue("fdrawagainfilter", (Object)fieldMapItem.isDrawAgainFilter(), rowIndex);
    }

    public void autoMatchFields() {
        GetRuleHelper getRuleHelper = new GetRuleHelper(this.getView(), this.plugin, this.extControlDomain);
        String sourceEntityNumber = this.plugin.getRuleFormHelper().getSourceEntityNumber();
        MainEntityType srcMainType = EntityMetadataCache.getDataEntityType((String)sourceEntityNumber);
        HashSet<String> srcLinkEntitys = getRuleHelper.getSourceLinkEntitys();
        String targetEntityNumber = this.plugin.getRuleFormHelper().getTargetEntityNumber();
        MainEntityType tgtMainType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
        HashSet<String> tgtLinkEntitys = getRuleHelper.getTargetLinkEntitys();
        int rowCount = this.getModel().getEntryRowCount("fieldmappolicy");
        HashMap<Integer, String> targetFieldKeysByEntryRow = new HashMap<Integer, String>(rowCount);
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            String convertType;
            String sourceFieldKey = (String)this.getModel().getValue("fsourcefield", rowIndex);
            if (StringUtils.isNotBlank((CharSequence)sourceFieldKey) || StringUtils.isBlank((CharSequence)(convertType = (String)this.getModel().getValue("fconverttype", rowIndex))) || Integer.parseInt(convertType) != FieldConvertType.SourceField.getValue()) continue;
            String targetFieldKey = (String)this.getModel().getValue("ftargetfield", rowIndex);
            targetFieldKeysByEntryRow.put(rowIndex, targetFieldKey);
        }
        Set<Integer> lockRowsFromFieldMapping = this.extControlDomain.getLockRowsFromFieldMapping(this.getView());
        targetFieldKeysByEntryRow.entrySet().removeIf(entry -> lockRowsFromFieldMapping.contains(entry.getKey()));
        for (Map.Entry targetFieldKeyByEntryRow : targetFieldKeysByEntryRow.entrySet()) {
            this.autoMatch(srcMainType, srcLinkEntitys, tgtMainType, tgtLinkEntitys, (Integer)targetFieldKeyByEntryRow.getKey(), (String)targetFieldKeyByEntryRow.getValue());
        }
    }

    private void autoMatch(MainEntityType srcMainType, HashSet<String> srcLinkEntitys, MainEntityType tgtMainType, HashSet<String> tgtLinkEntitys, int rowIndex, String targetFieldKey) {
        DynamicProperty targetField = (DynamicProperty)tgtMainType.findProperty(targetFieldKey);
        if (targetField == null) {
            return;
        }
        if (!tgtLinkEntitys.contains(targetField.getParent().getName())) {
            return;
        }
        if (!EntityParseHelper.isSupportAutoBatch(tgtMainType, (IDataEntityProperty)targetField)) {
            return;
        }
        DynamicProperty sourceField = (DynamicProperty)srcMainType.findProperty(targetFieldKey);
        if (sourceField != null && srcLinkEntitys.contains(sourceField.getParent().getName()) && targetField.getClass().isInstance(sourceField) && StringUtils.isNotBlank((CharSequence)sourceField.getAlias())) {
            String sourceFieldName = EntityParseHelper.buildPropFullCaption((IDataEntityProperty)sourceField);
            this.getModel().setValue("fsourcefield", (Object)sourceField.getName(), rowIndex);
            this.getModel().setValue("fsourcefieldname", (Object)sourceFieldName, rowIndex);
        }
    }

    public void clearSourceField(int row) {
        this.getModel().setValue("fsourcefield", (Object)"", row);
        this.getModel().setValue("fsourcefieldname", (Object)"", row);
    }

    public static void setHelpText(IFormView view) {
        IDataModel model = view.getModel();
        StringBuilder baseTip = new StringBuilder();
        baseTip.append(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\uff1a\u4e24\u4e2a\u5355\u636e\u4e4b\u95f4\u53ef\u4ee5\u914d\u7f6e\u591a\u4e2a\u89c4\u5219\uff0c\u6309\u542f\u52a8\u6761\u4ef6\u81ea\u52a8\u9009\u62e9\uff1b\u5b9e\u9645\u8fd0\u884c\u65f6\uff0c\u53ea\u4f1a\u9009\u62e9\u52fe\u9009\u4e86\u542f\u7528\u9009\u9879\u7684\u89c4\u5219\uff1b\u4e24\u4e2a\u5355\u636e\u4e4b\u95f4\uff0c\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u9ed8\u8ba4\u89c4\u5219\uff1b", (String)"ConvertRuleEdit_18", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        StringBuilder linkEntityTip = new StringBuilder();
        linkEntityTip.append(ResManager.loadKDString((String)"\u5173\u8054\u4e3b\u5b9e\u4f53\uff1a\u7cfb\u7edf\u53ea\u4f1a\u8bb0\u5f55\u6e90\u5355\u5230\u76ee\u6807\u5355\uff0c\u4e24\u4e2a\u5173\u8054\u4e3b\u5b9e\u4f53\u4e4b\u95f4\u7684\u5173\u8054\u5173\u7cfb\u3002\u6570\u636e\u53cd\u5199\u3001\u8ffd\u67e5\uff0c\u90fd\u9700\u8981\u4f9d\u8d56\u4e8e\u5173\u8054\u5173\u7cfb\uff1b\u5982\u679c\u5173\u8054\u4e3b\u5b9e\u4f53\u914d\u7f6e\u9519\u8bef\uff0c\u53ef\u80fd\u5bfc\u81f4\u53cd\u5199\u3001\u8ffd\u67e5\u4e0d\u6b63\u786e\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u3002", (String)"ConvertRuleEdit_22", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        StringBuilder billTypeMapTip = new StringBuilder();
        billTypeMapTip.append(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u6620\u5c04\uff1a\u914d\u7f6e\u6e90\u5355\u4e0e\u76ee\u6807\u5355\uff0c\u5355\u636e\u7c7b\u578b\u4e4b\u95f4\u7684\u8f6c\u6362\u5173\u7cfb\uff1b", (String)"ConvertRuleEdit_26", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        StringBuilder fieldMapTip = new StringBuilder();
        fieldMapTip.append(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\uff1a\u53d6\u503c\uff1a\u914d\u7f6e\u4ee5\u4f55\u79cd\u65b9\u5f0f\u5230\u6e90\u5355\u53d6\u6570\uff0c\u76f4\u63a5\u53d6\u6e90\u5355\u5b57\u6bb5\u503c\u3001\u53d6\u8ba1\u7b97\u516c\u5f0f\u503c\u3001\u6309\u6761\u4ef6\u53d6\u8ba1\u7b97\u516c\u5f0f\u503c\uff1b\u5408\u5e76\uff1a\u6e90\u5355\u591a\u884c\u5408\u5e76\u751f\u6210\u4e00\u884c\u76ee\u6807\u5355\u884c\u65f6\uff0c\u5b57\u6bb5\u503c\u6c47\u603b\u6a21\u5f0f\uff1b\u8fc7\u6ee4\uff1a\u9009\u5355\u65f6\uff0c\u662f\u5426\u6309\u6b64\u5b57\u6bb5\u503c\u8fc7\u6ee4\u6e90\u5355\u6570\u636e\u884c\uff1b\u8ffd\u52a0\u65f6\u8fc7\u6ee4\uff1a\u518d\u6b21\u9009\u5355\u65f6\uff0c\u662f\u5426\u6309\u6b64\u5b57\u6bb5\u8fc7\u6ee4\uff0c\u4ece\u800c\u786e\u4fdd\u591a\u6b21\u9009\u5355\uff0c\u6570\u636e\u8303\u56f4\u4e00\u81f4\uff1b\u53d6\u503c\u5e38\u91cf\u652f\u6301\u7c7b\u578b\uff1a\u57fa\u7840\u8d44\u6599\u3001\u4e0b\u62c9\u5217\u8868\uff1b", (String)"ConvertRuleEdit_28", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        StringBuilder groupByTip = new StringBuilder();
        groupByTip.append(ResManager.loadKDString((String)"\u5206\u5355\u7b56\u7565\uff1a\u6309\u5206\u5355\u9009\u9879\uff0c\u628a\u6e90\u5355\u62c6\u5206\u6210\u4e0d\u540c\u7684\u76ee\u6807\u5355\uff1b\n\u5355\u636e\u4f53\u884c\u5408\u5e76\u7b56\u7565\uff1a\u6309\u5355\u636e\u4f53\u884c\u5408\u5e76\u9009\u9879\uff0c\u628a\u6e90\u5355\u5355\u636e\u4f53\u884c\u5408\u5e76\u4e3a\u76ee\u6807\u5355\u5355\u636e\u4f53\u884c\uff1b\n\u5b50\u5355\u636e\u4f53\u884c\u5408\u5e76\u7b56\u7565\uff1a\u6309\u5b50\u5355\u636e\u4f53\u884c\u5408\u5e76\u9009\u9879\uff0c\u6309\u628a\u6e90\u5355\u5b50\u5355\u636e\u4f53\u884c\u5408\u5e76\u4e3a\u76ee\u6807\u5355\u5b50\u5355\u636e\u4f53\u884c\uff1b", (String)"ConvertRuleEdit_34", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        StringBuilder filterTip = new StringBuilder();
        filterTip.append(ResManager.loadKDString((String)"\u6761\u4ef6\uff1a\u4e0b\u63a8\u65f6\uff0c\u53ea\u4f1a\u628a\u7b26\u5408\u6761\u4ef6\u7684\u6e90\u5355\u6570\u636e\u884c\uff0c\u4e0b\u63a8\u4e3a\u76ee\u6807\u5355\uff1b\u4e0d\u7b26\u5408\u6761\u4ef6\u7684\u6e90\u5355\u884c\uff0c\u4f1a\u81ea\u52a8\u6392\u9664\uff1b\u9009\u5355\u65f6\uff0c\u5728\u6e90\u5355\u6570\u636e\u5217\u8868\u4e2d\uff0c\u53ea\u4f1a\u5217\u51fa\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u884c", (String)"ConvertRuleEdit_37", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        StringBuilder plugTip = new StringBuilder();
        plugTip.append(ResManager.loadKDString((String)"\u63d2\u4ef6\uff1a\u53ef\u4ee5\u5f00\u53d1\u5355\u636e\u8f6c\u6362\u63d2\u4ef6\uff0c\u63a7\u5236\u5355\u636e\u4e0b\u63a8\u8fc7\u7a0b\uff1b\u5f00\u53d1\u7684\u63d2\u4ef6\uff0c\u9700\u8981\u5728\u6b64\u6ce8\u518c\uff0c\u624d\u4f1a\u5728\u8fd0\u884c\u65f6\u88ab\u542f\u7528\uff1b", (String)"ConvertRuleEdit_40", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        StringBuilder updateDataTip = new StringBuilder();
        updateDataTip.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\uff1a\u914d\u7f6e\u670d\u52a1\uff0c\u5bf9\u643a\u5e26\u5b8c\u6bd5\u7684\u76ee\u6807\u5355\u6570\u636e\u8fdb\u4e00\u6b65\u5904\u7406\uff1b", (String)"ConvertRuleEdit_43", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        model.setValue("fhelp_base", (Object)baseTip.toString());
        model.setValue("fhelp_link", (Object)linkEntityTip.toString());
        model.setValue("fhelp_billtypemap", (Object)billTypeMapTip.toString());
        model.setValue("fhelp_fieldmap", (Object)fieldMapTip.toString());
        model.setValue("fhelp_groupby", (Object)groupByTip.toString());
        model.setValue("fhelp_filter", (Object)filterTip.toString());
        model.setValue("fhelp_bizrule", (Object)updateDataTip.toString());
        model.setValue("fhelp_plug", (Object)plugTip.toString());
        Label lblIsv = (Label)view.getControl("lblisv");
        lblIsv.setText(ResManager.loadKDString((String)"\u672c\u89c4\u5219\u7531\u5176\u4ed6\u5f00\u53d1\u5546\u53d1\u5e03\uff0c\u8bf7\u52ff\u76f4\u63a5\u6539\u52a8\uff1b\u53ef\u4ee5\u6269\u5c55\u4e00\u4e2a\u65b0\u5206\u652f\u540e\u4fee\u6539", (String)"ConvertRuleEdit_45", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
    }
}

