/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.designer.botp.WBRuleGetHelper;
import kd.bos.designer.botp.WBRuleSetHelper;
import kd.bos.designer.botp.common.WBRuleFormConst;
import kd.bos.designer.botp.extcontrol.domain.WBExtControlDomain;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRBizRuleElement;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.ExcessCheckType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.DBServiceHelper;

class WBRuleEventHandler
implements WBRuleFormConst {
    private static final String BOS_DESIGNER_PLUGIN = "bos-botp-formplugin";
    private IFormView view;
    private IDataModel model;
    private AbstractFormPlugin plugin;
    private WBRuleSetHelper setHelper;
    private BillEntityType srcMainType;
    private BillEntityType tgtMainType;
    private WBExtControlDomain extControlDomain;

    private IFormView getView() {
        return this.view;
    }

    private IDataModel getModel() {
        return this.model;
    }

    private AbstractFormPlugin getPlugin() {
        return this.plugin;
    }

    private WBRuleSetHelper getSetHelper() {
        if (this.setHelper == null) {
            this.setHelper = new WBRuleSetHelper(this.view, this.plugin, this.extControlDomain);
        }
        return this.setHelper;
    }

    private BillEntityType getSourceMainType() {
        if (this.srcMainType == null) {
            this.srcMainType = WBRuleGetHelper.getSourceMainType(this.model);
        }
        return this.srcMainType;
    }

    private BillEntityType getTargetMainType() {
        if (this.tgtMainType == null) {
            this.tgtMainType = WBRuleGetHelper.getTargetMainType(this.model);
        }
        return this.tgtMainType;
    }

    public WBRuleEventHandler(IFormView view, AbstractFormPlugin plugin, WBExtControlDomain extControlDomain) {
        this.view = view;
        this.model = view.getModel();
        this.plugin = plugin;
        this.extControlDomain = extControlDomain;
    }

    public void initialize() {
        this.plugin.addClickListeners(new String[]{"wb_conditiondesc", "wb_formuladesc", "wb_commitfieldname", "br_preconditiondesc", "br_bizruletruedesc", "br_bizrulefalsedesc", "closecheckconditiondesc", "excesstypeconditiondesc", "excesscheckconditondesc"});
    }

    public void itemClick(ItemClickEvent e) {
        int row;
        String itemKey = e.getItemKey();
        if (itemKey.equalsIgnoreCase("btnaddformula")) {
            row = this.getModel().getEntryCurrentRowIndex("entryentity_wb");
            this.getModel().setValue("wb_id", (Object)DBServiceHelper.genGlobalLongId(), row);
        }
        if (itemKey.equalsIgnoreCase("btnaddaction")) {
            row = this.getModel().getEntryCurrentRowIndex("entryentity_br");
            this.getModel().setValue("br_id", (Object)Uuid16.create().toString(), row);
        }
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        if (ctl.getKey().equalsIgnoreCase("wb_conditiondesc")) {
            this.doClickWBItemCondition();
        } else if (ctl.getKey().equalsIgnoreCase("wb_formuladesc")) {
            this.doClickWBItemFormula();
        } else if (ctl.getKey().equalsIgnoreCase("wb_commitfieldname")) {
            this.doClickCommitField();
        } else if (ctl.getKey().equalsIgnoreCase("br_preconditiondesc")) {
            this.doClickBRCondition();
        } else if (ctl.getKey().equalsIgnoreCase("br_bizruletruedesc")) {
            this.doClickBizRule(true);
        } else if (ctl.getKey().equalsIgnoreCase("br_bizrulefalsedesc")) {
            this.doClickBizRule(false);
        } else if (ctl.getKey().equalsIgnoreCase("closecheckconditiondesc")) {
            this.doClickCloseCondition();
        } else if (ctl.getKey().equalsIgnoreCase("excesstypeconditiondesc")) {
            this.doClickExcessTypeCondition();
        } else if (ctl.getKey().equalsIgnoreCase("excesscheckconditondesc")) {
            this.doClickExcessCondition();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getActionId().equalsIgnoreCase("wb_commitfieldname")) {
            BillEntityType mainType = this.getSourceMainType();
            this.receiveSelectField(mainType, (String)e.getReturnData(), "entryentity_wb", "wb_commitfieldkey", "wb_commitfieldname");
        } else if (e.getActionId().equalsIgnoreCase("wb_formuladesc")) {
            this.receiveFormula((String)e.getReturnData(), "entryentity_wb", "wb_formula", "wb_formuladesc");
        } else if (e.getActionId().equalsIgnoreCase("wb_conditiondesc")) {
            this.receiveCondition((String)e.getReturnData(), "entryentity_wb", "wb_condition", "wb_conditiondesc");
        } else if (e.getActionId().equalsIgnoreCase("closecheckconditiondesc")) {
            this.receiveCondition((String)e.getReturnData(), null, "closecheckcondition", "closecheckconditiondesc");
        } else if (e.getActionId().equalsIgnoreCase("excesstypeconditiondesc")) {
            this.receiveCondition((String)e.getReturnData(), null, "excesstypecondition", "excesstypeconditiondesc");
        } else if (e.getActionId().equalsIgnoreCase("excesscheckconditondesc")) {
            this.receiveCondition((String)e.getReturnData(), null, "excesscheckconditon", "excesscheckconditondesc");
        } else if (e.getActionId().equalsIgnoreCase("br_preconditiondesc")) {
            this.receiveCondition((String)e.getReturnData(), "entryentity_br", "br_precondition", "br_preconditiondesc");
        } else if (e.getActionId().equalsIgnoreCase("br_bizruletruedesc")) {
            this.doReceiveBizRule((String)e.getReturnData(), true);
        } else if (e.getActionId().equalsIgnoreCase("br_bizrulefalsedesc")) {
            this.doReceiveBizRule((String)e.getReturnData(), false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (key.equalsIgnoreCase("targetentitynumber")) {
            WBRuleSetHelper setHelper = this.getSetHelper();
            setHelper.changeTargetBill();
        } else if (key.equalsIgnoreCase("sourceentitynumber")) {
            WBRuleSetHelper setHelper = this.getSetHelper();
            setHelper.changeSourceBill();
        } else if (key.equalsIgnoreCase("wb_commitfieldkey")) {
            WBRuleSetHelper setHelper = this.getSetHelper();
            setHelper.fillCloseFields();
        } else if (key.equalsIgnoreCase("entryclosefieldkey")) {
            this.entryCloseFieldChanged();
        } else if (key.equalsIgnoreCase("billclosefieldkey")) {
            this.billCloseFieldChanged();
        } else if (key.equalsIgnoreCase("excesschecktype")) {
            this.excessCheckTypeChanged();
        } else if (key.equalsIgnoreCase("wb_conditiondesc")) {
            this.doClearFieldValue("wb_condition", e.getChangeSet());
        } else if (key.equalsIgnoreCase("wb_formuladesc")) {
            this.doClearFieldValue("wb_formula", e.getChangeSet());
        } else if (key.equalsIgnoreCase("wb_commitfieldname")) {
            this.doClearFieldValue("wb_commitfieldkey", e.getChangeSet());
        } else if (key.equalsIgnoreCase("br_preconditiondesc")) {
            this.doClearFieldValue("br_precondition", e.getChangeSet());
        } else if (key.equalsIgnoreCase("br_bizruletruedesc")) {
            this.doClearFieldValue("br_bizruletrueitem", e.getChangeSet());
        } else if (key.equalsIgnoreCase("br_bizrulefalsedesc")) {
            this.doClearFieldValue("br_bizrulefalseitem", e.getChangeSet());
        } else if (key.equalsIgnoreCase("closecheckconditiondesc")) {
            this.doClearFieldValue("closecheckcondition", e.getChangeSet());
        } else if (key.equalsIgnoreCase("excesstypeconditiondesc")) {
            this.doClearFieldValue("excesstypecondition", e.getChangeSet());
        } else if (key.equalsIgnoreCase("excesscheckconditondesc")) {
            this.doClearFieldValue("excesscheckconditon", e.getChangeSet());
        }
    }

    private void doClearFieldValue(String key, ChangeData[] changeDatas) {
        for (ChangeData changeData : changeDatas) {
            if (!StringUtils.isBlank((Object)changeData.getNewValue())) continue;
            this.getModel().setValue(key, null, changeData.getRowIndex());
        }
    }

    private void doClickWBItemCondition() {
        BillEntityType mainType = this.getTargetMainType();
        if (mainType == null) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u5b9a\u4e0b\u6e38\u76ee\u6807\u5355", (String)"WriteBackRuleEdit_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        int row = this.model.getEntryCurrentRowIndex("entryentity_wb");
        String conditionJson = (String)this.getModel().getValue("wb_condition", row);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter((MainEntityType)mainType);
        parameter.getForbidRefPropFieldTypes().add(MulBasedataProp.class);
        TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes(parameter);
        String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        this.showConditionForm(conditionJson, mainType.getName(), fldNodes, "wb_conditiondesc");
    }

    private void doClickWBItemFormula() {
        BillEntityType mainType = this.getTargetMainType();
        if (mainType == null) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u5b9a\u4e0b\u6e38\u76ee\u6807\u5355", (String)"WriteBackRuleEdit_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        int row = this.model.getEntryCurrentRowIndex("entryentity_wb");
        String formulaJson = (String)this.getModel().getValue("wb_formula", row);
        if (!WBRuleGetHelper.checkWritebackType(this.getView(), this.model)) {
            return;
        }
        Class<?> fldType = WBRuleGetHelper.getCommitFieldType(this.model);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter((MainEntityType)mainType);
        parameter.setMatchedClassType(fldType);
        parameter.setForbidClassType(WBRuleGetHelper.getForbidFieldTypes(this.model));
        parameter.getForbidRefPropFieldTypes().add(MulBasedataProp.class);
        TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes(parameter);
        String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        this.showFormulaForm(formulaJson, fldNodes, "wb_formuladesc");
    }

    private void doClickCommitField() {
        BillEntityType sourceMainType = this.getSourceMainType();
        if (sourceMainType == null) {
            this.view.showTipNotification(this.getMultiLConfirmSourceBill());
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity_wb");
        HashSet<String> selectEntitys = WBRuleGetHelper.getSrcCommitEntity(this.model, sourceMainType, true, rowIndex);
        if (!WBRuleGetHelper.checkWritebackType(this.getView(), this.model)) {
            return;
        }
        Class<?> fldType = WBRuleGetHelper.getCommitFieldType(this.model);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter((MainEntityType)sourceMainType, selectEntitys, fldType);
        parameter.setForbidClassType(WBRuleGetHelper.getForbidFieldTypes(this.model));
        parameter.getForbidRefPropFieldTypes().add(MulBasedataProp.class);
        TreeNode srcBillNode = EntityParseHelper.buildBillTreeNodes(parameter);
        this.showSelectFieldForm(srcBillNode, "wb_commitfieldname");
    }

    private void doClickBRCondition() {
        BillEntityType mainType = this.getSourceMainType();
        if (mainType == null) {
            this.view.showTipNotification(this.getMultiLConfirmSourceBill());
            return;
        }
        int row = this.model.getEntryCurrentRowIndex("entryentity_br");
        String conditionJson = (String)this.getModel().getValue("br_precondition", row);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter((MainEntityType)mainType);
        parameter.setForbidClassType(WBRuleGetHelper.getForbidFieldTypes(this.model));
        parameter.getForbidRefPropFieldTypes().add(MulBasedataProp.class);
        TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes(parameter);
        String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        this.showConditionForm(conditionJson, mainType.getName(), fldNodes, "br_preconditiondesc");
    }

    private void doClickBizRule(boolean condition) {
        String entityKey = "entryentity_br";
        int row = this.getModel().getEntryCurrentRowIndex(entityKey);
        String bizRuleField = condition ? "br_bizruletrueitem" : "br_bizrulefalseitem";
        String bizRuleDescField = condition ? "br_bizruletruedesc" : "br_bizrulefalsedesc";
        String bizRuleJson = (String)this.getModel().getValue(bizRuleField, row);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_updatedataservice");
        showParameter.getCustomParams().put("crbizruleelement", bizRuleJson);
        showParameter.getCustomParams().put("targetentitynumber", WBRuleGetHelper.getSourceEntityNumber(this.model));
        showParameter.getCustomParams().put("hideprecondition", "true");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, bizRuleDescField));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void doReceiveBizRule(String returnData, boolean condition) {
        if (StringUtils.isBlank((CharSequence)returnData)) {
            return;
        }
        String bizRuleJson = returnData;
        CRBizRuleElement bizRule = (CRBizRuleElement)SerializationUtils.fromJsonString((String)bizRuleJson, CRBizRuleElement.class);
        String entityKey = "entryentity_br";
        int row = this.getModel().getEntryCurrentRowIndex(entityKey);
        String bizRuleField = condition ? "br_bizruletrueitem" : "br_bizrulefalseitem";
        String bizRuleDescField = condition ? "br_bizruletruedesc" : "br_bizrulefalsedesc";
        this.getModel().setValue(bizRuleField, (Object)bizRuleJson, row);
        this.getModel().setValue(bizRuleDescField, (Object)bizRule.getDescription().toString(), row);
    }

    private void doClickCloseCondition() {
        BillEntityType mainType = this.getSourceMainType();
        if (mainType == null) {
            this.view.showTipNotification(this.getMultiLConfirmSourceBill());
            return;
        }
        String conditionJson = (String)this.getModel().getValue("closecheckcondition");
        HashSet<String> selectEntitys = WBRuleGetHelper.getSrcCommitEntity(this.model, mainType, true, -1);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter((MainEntityType)mainType);
        parameter.setForbidClassType(WBRuleGetHelper.getForbidFieldTypes(this.model));
        parameter.getForbidRefPropFieldTypes().add(MulBasedataProp.class);
        parameter.getSelectedEntity().addAll(selectEntitys);
        TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes(parameter);
        String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        this.showConditionForm(conditionJson, mainType.getName(), fldNodes, "closecheckconditiondesc");
    }

    private void doClickExcessTypeCondition() {
        BillEntityType mainType = this.getSourceMainType();
        if (mainType == null) {
            this.view.showTipNotification(this.getMultiLConfirmSourceBill());
            return;
        }
        String conditionJson = (String)this.getModel().getValue("excesstypecondition");
        HashSet<String> selectEntitys = WBRuleGetHelper.getSrcCommitEntity(this.model, mainType, true, -1);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter((MainEntityType)mainType);
        parameter.setForbidClassType(WBRuleGetHelper.getForbidFieldTypes(this.model));
        parameter.getSelectedEntity().addAll(selectEntitys);
        TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes(parameter);
        String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        this.showConditionForm(conditionJson, mainType.getName(), fldNodes, "excesstypeconditiondesc");
    }

    private void doClickExcessCondition() {
        BillEntityType mainType = this.getSourceMainType();
        if (mainType == null) {
            this.view.showTipNotification(this.getMultiLConfirmSourceBill());
            return;
        }
        String conditionJson = (String)this.getModel().getValue("excesscheckconditon");
        HashSet<String> selectEntitys = WBRuleGetHelper.getSrcCommitEntity(this.model, mainType, true, -1);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter((MainEntityType)mainType);
        parameter.setForbidClassType(WBRuleGetHelper.getForbidFieldTypes(this.model));
        parameter.getForbidRefPropFieldTypes().add(MulBasedataProp.class);
        parameter.getSelectedEntity().addAll(selectEntitys);
        TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes(parameter);
        String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        this.showConditionForm(conditionJson, mainType.getName(), fldNodes, "excesscheckconditondesc");
    }

    private void entryCloseFieldChanged() {
        WBRuleSetHelper setHelper = this.getSetHelper();
        String entryCloseFieldKey = (String)this.model.getValue("entryclosefieldkey");
        setHelper.fillCloseStatusComboItems(entryCloseFieldKey, "entryclosesuccess", "entryclosefail");
    }

    private void billCloseFieldChanged() {
        WBRuleSetHelper setHelper = this.getSetHelper();
        String billCloseFieldKey = (String)this.model.getValue("billclosefieldkey");
        setHelper.fillCloseStatusComboItems(billCloseFieldKey, "billclosesuccess", "billclosefail");
    }

    private void excessCheckTypeChanged() {
        String excessCheckType = (String)this.model.getValue("excesschecktype");
        ExcessCheckType type = ExcessCheckType.valueOf((int)Integer.parseInt(excessCheckType));
        WBRuleSetHelper setHelper = this.getSetHelper();
        setHelper.setExcessVisiable(type);
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveSelectField(BillEntityType mainType, String returnPropName, String entityKey, String sourceCtrlKey, String descFldKey) {
        if (StringUtils.isBlank((CharSequence)returnPropName)) {
            return;
        }
        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)mainType, returnPropName);
        if (StringUtils.isBlank((CharSequence)entityKey)) {
            this.getModel().setValue(sourceCtrlKey, (Object)returnPropName);
            this.getModel().setValue(descFldKey, (Object)fieldCaption);
        } else {
            int row = this.getModel().getEntryCurrentRowIndex(entityKey);
            this.getModel().setValue(sourceCtrlKey, (Object)returnPropName, row);
            this.getModel().setValue(descFldKey, (Object)fieldCaption, row);
        }
    }

    private void showFormulaForm(String formulaJson, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_formula");
        showParameter.getCustomParams().put("formula", formulaJson);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveFormula(String formulaJson, String entryEntityKey, String formulaFldKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)formulaJson)) {
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaJson, CRFormula.class);
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                this.getModel().setValue(formulaFldKey, (Object)formulaJson);
                this.getModel().setValue(descFldKey, (Object)formula.getDescription().toString());
            } else {
                int row = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
                this.getModel().setValue(formulaFldKey, (Object)formulaJson, row);
                this.getModel().setValue(descFldKey, (Object)formula.getExprDesc(), row);
            }
        }
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveCondition(String conditionJson, String entryEntityKey, String conditionFldKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            String exprTran = condition.getExprDesc();
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                this.getModel().setValue(conditionFldKey, (Object)conditionJson);
                this.getModel().setValue(descFldKey, (Object)exprTran);
            } else {
                int row = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
                this.getModel().setValue(conditionFldKey, (Object)conditionJson, row);
                this.getModel().setValue(descFldKey, (Object)exprTran, row);
            }
        }
    }

    private String getMultiLConfirmSourceBill() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u5b9a\u4e0a\u6e38\u6e90\u5355", (String)"WriteBackRuleEdit_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
    }
}

