/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.common.WBRuleFormConst;
import kd.bos.designer.botp.extcontrol.domain.WBExtControlDomain;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.BillCloseType;
import kd.bos.entity.botp.CRBizRuleElement;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.ExcessCheckType;
import kd.bos.entity.botp.WriteBackBizRule;
import kd.bos.entity.botp.WriteBackFormula;
import kd.bos.entity.botp.WriteBackOpType;
import kd.bos.entity.botp.WriteBackRuleElement;
import kd.bos.entity.botp.WriteBackType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.DBServiceHelper;

class WBRuleGetHelper
implements WBRuleFormConst {
    private static final String BOS_DESIGNER_PLUGIN = "bos-botp-formplugin";
    private IFormView view;
    private IDataModel model;
    private AbstractFormPlugin plugin;
    private WBExtControlDomain extControlDomain;

    private IFormView getView() {
        return this.view;
    }

    private IDataModel getModel() {
        return this.model;
    }

    private AbstractFormPlugin getPlugin() {
        return this.plugin;
    }

    public WBRuleGetHelper(IFormView view, AbstractFormPlugin plugin, WBExtControlDomain extControlDomain) {
        this.view = view;
        this.model = view.getModel();
        this.plugin = plugin;
        this.extControlDomain = extControlDomain;
    }

    public void getRule(WriteBackRuleElement rule) {
        this.getBase(rule);
        this.getFormulas(rule);
        this.getBizRules(rule);
        this.getCloseBill(rule);
        this.getExcessCheck(rule);
        this.extControlDomain.setExtControlDataToConvertRule(this.plugin, rule);
    }

    private void getBase(WriteBackRuleElement rule) {
        ILocaleString name = (ILocaleString)this.model.getValue("name");
        DynamicObject target = (DynamicObject)this.model.getValue("targetentitynumber");
        DynamicObject source = (DynamicObject)this.model.getValue("sourceentitynumber");
        if (name != null) {
            for (Map.Entry entry : name.entrySet()) {
                rule.getName().setItem((String)entry.getKey(), entry.getValue());
            }
        }
        if (target == null) {
            rule.setTargetEntityNumber("");
        } else {
            rule.setTargetEntityNumber((String)target.getPkValue());
        }
        if (source == null) {
            rule.setSourceEntityNumber("");
        } else {
            rule.setSourceEntityNumber((String)source.getPkValue());
        }
        boolean enable = (Boolean)this.model.getValue("enable");
        if (!StringUtils.equals((CharSequence)"1", (CharSequence)rule.getCustStatus()) && enable) {
            rule.setCustStatus("1");
        } else if (StringUtils.equals((CharSequence)"1", (CharSequence)rule.getCustStatus()) && !enable) {
            rule.setCustStatus("2");
        }
    }

    private void getFormulas(WriteBackRuleElement rule) {
        String opType = (String)this.model.getValue("optype");
        rule.setOpType(WriteBackOpType.valueOf((int)Integer.parseInt(opType)));
        rule.getFormulas().clear();
        int rowCount = this.model.getEntryRowCount("entryentity_wb");
        for (int row = 0; row < rowCount; ++row) {
            WriteBackFormula formula = this.getFormula(row);
            if (formula == null) continue;
            rule.getFormulas().add(formula);
        }
    }

    private WriteBackFormula getFormula(int row) {
        WriteBackFormula formula = new WriteBackFormula();
        long id = (Long)this.model.getValue("wb_id", row);
        boolean enabled = (Boolean)this.model.getValue("wb_enabled", row);
        String condition = (String)this.model.getValue("wb_condition", row);
        String expression = (String)this.model.getValue("wb_formula", row);
        String srcField = (String)this.model.getValue("wb_commitfieldkey", row);
        String wbType = (String)this.model.getValue("wb_writebacktype", row);
        if (id == 0L) {
            id = DBServiceHelper.genGlobalLongId();
            this.model.setValue("wb_id", (Object)id, row);
        }
        formula.setId(id);
        formula.setDisabled(!enabled);
        if (StringUtils.isBlank((CharSequence)condition)) {
            formula.setCondition(null);
        } else {
            CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
            formula.setCondition(crCondition);
        }
        if (StringUtils.isBlank((CharSequence)expression)) {
            formula.setFormula(null);
        } else {
            CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)expression, CRFormula.class);
            formula.setFormula(crFormula);
        }
        formula.setSourceCommitFieldKey(srcField);
        formula.setWriteBackType(WriteBackType.valueOf((int)Integer.parseInt(wbType)));
        return formula;
    }

    private void getBizRules(WriteBackRuleElement rule) {
        String entityKey = "entryentity_br";
        int rowCount = this.getModel().getEntryRowCount(entityKey);
        rule.getBizRules().clear();
        for (int row = 0; row < rowCount; ++row) {
            CRBizRuleElement bizRuleTrue = null;
            String bizRuleTrueJson = (String)this.getModel().getValue("br_bizruletrueitem", row);
            if (StringUtils.isNotBlank((CharSequence)bizRuleTrueJson)) {
                bizRuleTrue = (CRBizRuleElement)SerializationUtils.fromJsonString((String)bizRuleTrueJson, CRBizRuleElement.class);
            }
            CRBizRuleElement bizRuleFalse = null;
            String bizRuleFalseJson = (String)this.getModel().getValue("br_bizrulefalseitem", row);
            if (StringUtils.isNotBlank((CharSequence)bizRuleFalseJson)) {
                bizRuleFalse = (CRBizRuleElement)SerializationUtils.fromJsonString((String)bizRuleFalseJson, CRBizRuleElement.class);
            }
            if (bizRuleTrue == null && bizRuleFalse == null) continue;
            String preConditionJson = (String)this.getModel().getValue("br_precondition", row);
            CRCondition preCondition = null;
            if (StringUtils.isNotBlank((CharSequence)preConditionJson)) {
                preCondition = (CRCondition)SerializationUtils.fromJsonString((String)preConditionJson, CRCondition.class);
            }
            WriteBackBizRule bizRule = new WriteBackBizRule();
            String id = (String)this.getModel().getValue("br_id", row);
            if (StringUtils.isNotBlank((CharSequence)id)) {
                bizRule.setId(id);
            }
            bizRule.setSeq(row + 1);
            bizRule.setEnabled(((Boolean)this.getModel().getValue("br_enabled", row)).booleanValue());
            bizRule.setPreCondition(preCondition);
            bizRule.setBizRuleTrue(bizRuleTrue);
            bizRule.setBizRuleFalse(bizRuleFalse);
            rule.getBizRules().add(bizRule);
        }
    }

    private void getCloseBill(WriteBackRuleElement rule) {
        String entryCloseField = (String)this.model.getValue("entryclosefieldkey");
        String entryCloseCondition = (String)this.model.getValue("closecheckcondition");
        String entryCloseSuccess = (String)this.model.getValue("entryclosesuccess");
        String entryCloseFail = (String)this.model.getValue("entryclosefail");
        String billCloseType = (String)this.model.getValue("billclosetype");
        String billCloseField = (String)this.model.getValue("billclosefieldkey");
        String billCloseSuccess = (String)this.model.getValue("billclosesuccess");
        String billCloseFail = (String)this.model.getValue("billclosefail");
        rule.setEntryCloseFieldKey(entryCloseField);
        if (StringUtils.isBlank((CharSequence)entryCloseCondition)) {
            rule.setCloseCheckCondition(null);
        } else {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)entryCloseCondition, CRCondition.class);
            rule.setCloseCheckCondition(condition);
        }
        rule.setEntryCloseFieldSuccesStatus(entryCloseSuccess);
        rule.setEntryCloseFieldFailStatus(entryCloseFail);
        rule.setBillCloseType(BillCloseType.valueOf((int)Integer.parseInt(billCloseType)));
        rule.setBillCloseFieldKey(billCloseField);
        rule.setBillCloseFieldSuccesStatus(billCloseSuccess);
        rule.setBillCloseFieldFailStatus(billCloseFail);
    }

    private void getExcessCheck(WriteBackRuleElement rule) {
        CRCondition condition;
        String excessCheckType = (String)this.model.getValue("excesschecktype");
        String excessTypeCondition = (String)this.model.getValue("excesstypecondition");
        String excessSelectTrue = (String)this.model.getValue("excessselecttrue");
        String excessSelectFalse = (String)this.model.getValue("excessselectfalse");
        String excessCheckCondition = (String)this.model.getValue("excesscheckconditon");
        ILocaleString excessCheckMessage = (ILocaleString)this.model.getValue("excesscheckmessage");
        rule.setExcessCheckType(ExcessCheckType.valueOf((int)Integer.parseInt(excessCheckType)));
        if (StringUtils.isBlank((CharSequence)excessTypeCondition)) {
            rule.setExcessTypeSelectCondition(null);
        } else {
            condition = (CRCondition)SerializationUtils.fromJsonString((String)excessTypeCondition, CRCondition.class);
            rule.setExcessTypeSelectCondition(condition);
        }
        rule.setExcessSelectTrue(ExcessCheckType.valueOf((int)Integer.parseInt(excessSelectTrue)));
        rule.setExcessSelectFalse(ExcessCheckType.valueOf((int)Integer.parseInt(excessSelectFalse)));
        if (StringUtils.isBlank((CharSequence)excessCheckCondition)) {
            rule.setExcessCheckConditon(null);
        } else {
            condition = (CRCondition)SerializationUtils.fromJsonString((String)excessCheckCondition, CRCondition.class);
            rule.setExcessCheckConditon(condition);
        }
        if (excessCheckMessage != null) {
            for (Map.Entry entry : excessCheckMessage.entrySet()) {
                rule.getExcessCheckMessage().setItem((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public static String getTargetEntityNumber(IDataModel model) {
        DynamicObject target = (DynamicObject)model.getValue("targetentitynumber");
        if (target == null) {
            return null;
        }
        String entityNumber = (String)target.getPkValue();
        return entityNumber;
    }

    public static BillEntityType getTargetMainType(IDataModel model) {
        DynamicObject target = (DynamicObject)model.getValue("targetentitynumber");
        if (target == null) {
            return null;
        }
        String entityNumber = (String)target.getPkValue();
        BillEntityType tgtMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        return tgtMainType;
    }

    public static String getSourceEntityNumber(IDataModel model) {
        DynamicObject source = (DynamicObject)model.getValue("sourceentitynumber");
        if (source == null) {
            return null;
        }
        String entityNumber = (String)source.getPkValue();
        return entityNumber;
    }

    public static BillEntityType getSourceMainType(IDataModel model) {
        DynamicObject source = (DynamicObject)model.getValue("sourceentitynumber");
        if (source == null) {
            return null;
        }
        String entityNumber = (String)source.getPkValue();
        BillEntityType srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        return srcMainType;
    }

    public static HashSet<String> getSrcCommitEntity(IDataModel model, BillEntityType srcMainType, boolean includeParent, int expRowIndex) {
        HashSet<String> entityKeys = new HashSet<String>();
        int rowCount = model.getEntryRowCount("entryentity_wb");
        for (int row = 0; row < rowCount; ++row) {
            IDataEntityProperty property;
            String commitFldKey;
            if (expRowIndex == row || StringUtils.isBlank((CharSequence)(commitFldKey = (String)model.getValue("wb_commitfieldkey", row))) || (property = srcMainType.findProperty(commitFldKey)) == null) continue;
            if (!entityKeys.contains(property.getParent().getName())) {
                entityKeys.add(property.getParent().getName());
            }
            if (!includeParent) continue;
            for (IDataEntityType parent = property.getParent().getParent(); parent != null; parent = parent.getParent()) {
                if (entityKeys.contains(parent.getName())) continue;
                entityKeys.add(parent.getName());
            }
        }
        return entityKeys;
    }

    public static Class<?> getCommitFieldType(IDataModel model) {
        int row = model.getEntryCurrentRowIndex("entryentity_wb");
        String wbType = (String)model.getValue("wb_writebacktype", row);
        WriteBackType type = WriteBackType.valueOf((int)Integer.parseInt(wbType));
        Class<DecimalProp> fldType = null;
        fldType = type == WriteBackType.Cover ? null : DecimalProp.class;
        return fldType;
    }

    public static Set<Class<?>> getForbidFieldTypes(IDataModel model) {
        HashSet types = new HashSet();
        types.add(AttachmentProp.class);
        types.add(PictureProp.class);
        return types;
    }

    public static boolean checkWritebackType(IFormView view, IDataModel model) {
        int row = model.getEntryCurrentRowIndex("entryentity_wb");
        String wbType = (String)model.getValue("wb_writebacktype", row);
        if (StringUtils.isBlank((CharSequence)wbType)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53cd\u5199\u65b9\u5f0f", (String)"WriteBackRuleEdit_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

