/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.designer.botp.WBRuleGetHelper;
import kd.bos.designer.botp.common.WBRuleFormConst;
import kd.bos.designer.botp.extcontrol.domain.WBExtControlDomain;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.botp.ExcessCheckType;
import kd.bos.entity.botp.WriteBackBizRule;
import kd.bos.entity.botp.WriteBackFormula;
import kd.bos.entity.botp.WriteBackRuleElement;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;

class WBRuleSetHelper
implements WBRuleFormConst {
    private IFormView view;
    private IDataModel model;
    private AbstractFormPlugin plugin;
    private BillEntityType srcMainType;
    private BillEntityType tgtMainType;
    private WBExtControlDomain extControlDomain;

    public WBRuleSetHelper(IFormView view, AbstractFormPlugin plugin, WBExtControlDomain extControlDomain) {
        this.view = view;
        this.model = view.getModel();
        this.plugin = plugin;
        this.extControlDomain = extControlDomain;
    }

    private IFormView getView() {
        return this.view;
    }

    private IDataModel getModel() {
        return this.model;
    }

    private AbstractFormPlugin getPlugin() {
        return this.plugin;
    }

    private BillEntityType getSourceMainType() {
        if (this.srcMainType == null) {
            this.srcMainType = WBRuleGetHelper.getSourceMainType(this.model);
        }
        return this.srcMainType;
    }

    private BillEntityType getTargetMainType() {
        if (this.tgtMainType == null) {
            this.tgtMainType = WBRuleGetHelper.getTargetMainType(this.model);
        }
        return this.tgtMainType;
    }

    public void setRule(WriteBackRuleElement rule) {
        this.setBase(rule);
        this.setFormulas(rule);
        this.setBizRules(rule);
        this.setCloseBill(rule);
        this.setExcessCheck(rule);
        this.extControlDomain.updateExtControlDataFromConvertRule(this.getView(), rule);
    }

    private void setBase(WriteBackRuleElement rule) {
        this.model.setValue("id", (Object)rule.getId());
        ILocaleString name = (ILocaleString)this.model.getValue("name");
        if (rule.getName() != null) {
            for (Map.Entry entry : rule.getName().entrySet()) {
                name.setItem((String)entry.getKey(), entry.getValue());
            }
        }
        this.model.setValue("name", (Object)name);
        String sourceEntityNumber = rule.getSourceEntityNumber();
        String targetEntityNumber = rule.getTargetEntityNumber();
        this.model.setValue("sourceentitynumber", (Object)sourceEntityNumber);
        this.model.setValue("targetentitynumber", (Object)targetEntityNumber);
        this.model.setValue("sysstatus", (Object)rule.getSysStatus());
        this.model.setValue("custstatus", (Object)rule.getCustStatus());
        if (StringUtils.equals((CharSequence)"1", (CharSequence)rule.getCustStatus())) {
            this.model.setValue("enable", (Object)true);
        } else {
            this.model.setValue("enable", (Object)false);
        }
    }

    private void setFormulas(WriteBackRuleElement rule) {
        this.model.setValue("optype", (Object)String.valueOf(rule.getOpType().ordinal()));
        int rowCount = this.model.getEntryRowCount("entryentity_wb");
        if (rowCount < rule.getFormulas().size()) {
            this.model.batchCreateNewEntryRow("entryentity_wb", rule.getFormulas().size() - rowCount);
        }
        for (int row = 0; row < rule.getFormulas().size(); ++row) {
            WriteBackFormula formula = (WriteBackFormula)rule.getFormulas().get(row);
            this.setFormula(rule, formula, row);
        }
    }

    private void setFormula(WriteBackRuleElement rule, WriteBackFormula formula, int row) {
        String json;
        this.model.setValue("wb_id", (Object)formula.getId(), row);
        this.model.setValue("wb_enabled", (Object)(!formula.isDisabled() ? 1 : 0), row);
        if (formula.getCondition() == null) {
            this.model.setValue("wb_condition", (Object)"", row);
            this.model.setValue("wb_conditiondesc", (Object)"", row);
        } else {
            json = SerializationUtils.toJsonString((Object)formula.getCondition());
            this.model.setValue("wb_condition", (Object)json, row);
            this.model.setValue("wb_conditiondesc", (Object)formula.getCondition().getExprDesc(), row);
        }
        if (formula.getFormula() == null) {
            this.model.setValue("wb_formula", (Object)"", row);
            this.model.setValue("wb_formuladesc", (Object)"", row);
        } else {
            json = SerializationUtils.toJsonString((Object)formula.getFormula());
            this.model.setValue("wb_formula", (Object)json, row);
            this.model.setValue("wb_formuladesc", (Object)formula.getFormula().getExprDesc(), row);
        }
        String commitFldKey = formula.getSourceCommitFieldKey();
        this.model.setValue("wb_commitfieldkey", (Object)commitFldKey, row);
        if (StringUtils.isBlank((CharSequence)rule.getSourceEntityNumber()) || StringUtils.isBlank((CharSequence)commitFldKey)) {
            this.model.setValue("wb_commitfieldname", (Object)commitFldKey, row);
        } else {
            BillEntityType mainType = this.getSourceMainType();
            if (mainType != null) {
                String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)mainType, formula.getSourceCommitFieldKey());
                this.model.setValue("wb_commitfieldname", (Object)fieldCaption, row);
            }
        }
        this.model.setValue("wb_writebacktype", (Object)String.valueOf(formula.getWriteBackType().ordinal()), row);
    }

    private void setBizRules(WriteBackRuleElement rule) {
        String entityKey = "entryentity_br";
        int rowCount = this.getModel().getEntryRowCount(entityKey);
        if (rule.getBizRules().size() == 0) {
            this.getModel().deleteEntryData(entityKey);
        } else if (rule.getBizRules().size() > rowCount) {
            this.getModel().batchCreateNewEntryRow(entityKey, rule.getBizRules().size() - rowCount);
        } else {
            for (int i = rowCount; i > rule.getBizRules().size(); --i) {
                this.getModel().deleteEntryRow(entityKey, i - 1);
            }
        }
        ArrayList<WriteBackBizRule> bizRules = new ArrayList<WriteBackBizRule>();
        bizRules.addAll(rule.getBizRules());
        bizRules.sort(new Comparator<WriteBackBizRule>(){

            @Override
            public int compare(WriteBackBizRule o1, WriteBackBizRule o2) {
                if (o1.getSeq() < o2.getSeq()) {
                    return -1;
                }
                if (o1.getSeq() > o2.getSeq()) {
                    return 1;
                }
                return 0;
            }
        });
        int i = 0;
        for (WriteBackBizRule bizRule : bizRules) {
            this.getModel().setValue("br_id", (Object)bizRule.getId(), i);
            this.getModel().setValue("br_enabled", (Object)bizRule.isEnabled(), i);
            if (bizRule.getPreCondition() == null) {
                this.getModel().setValue("br_precondition", (Object)"", i);
                this.getModel().setValue("br_preconditiondesc", (Object)"", i);
            } else {
                this.getModel().setValue("br_precondition", (Object)SerializationUtils.toJsonString((Object)bizRule.getPreCondition()), i);
                this.getModel().setValue("br_preconditiondesc", (Object)bizRule.getPreCondition().getExprDesc(), i);
            }
            if (bizRule.getBizRuleTrue() == null) {
                this.getModel().setValue("br_bizruletrueitem", (Object)"", i);
                this.getModel().setValue("br_bizruletruedesc", (Object)"", i);
            } else {
                this.getModel().setValue("br_bizruletrueitem", (Object)SerializationUtils.toJsonString((Object)bizRule.getBizRuleTrue()), i);
                this.getModel().setValue("br_bizruletruedesc", (Object)bizRule.getBizRuleTrue().getDescription().toString(), i);
            }
            if (bizRule.getBizRuleFalse() == null) {
                this.getModel().setValue("br_bizrulefalseitem", (Object)"", i);
                this.getModel().setValue("br_bizrulefalsedesc", (Object)"", i);
            } else {
                this.getModel().setValue("br_bizrulefalseitem", (Object)SerializationUtils.toJsonString((Object)bizRule.getBizRuleFalse()), i);
                this.getModel().setValue("br_bizrulefalsedesc", (Object)bizRule.getBizRuleFalse().getDescription().toString(), i);
            }
            ++i;
        }
    }

    private void setCloseBill(WriteBackRuleElement rule) {
        this.model.setValue("entryclosefieldkey", (Object)rule.getEntryCloseFieldKey());
        this.model.setValue("entryclosesuccess", (Object)rule.getEntryCloseFieldSuccesStatus());
        this.model.setValue("entryclosefail", (Object)rule.getEntryCloseFieldFailStatus());
        if (rule.getCloseCheckCondition() == null) {
            this.model.setValue("closecheckcondition", (Object)"");
            this.model.setValue("closecheckconditiondesc", (Object)"");
        } else {
            String json = SerializationUtils.toJsonString((Object)rule.getCloseCheckCondition());
            this.model.setValue("closecheckcondition", (Object)json);
            this.model.setValue("closecheckconditiondesc", (Object)rule.getCloseCheckCondition().getExprDesc());
        }
        this.model.setValue("billclosetype", (Object)String.valueOf(rule.getBillCloseType().ordinal()));
        this.model.setValue("billclosefieldkey", (Object)rule.getBillCloseFieldKey());
        this.model.setValue("billclosesuccess", (Object)rule.getBillCloseFieldSuccesStatus());
        this.model.setValue("billclosefail", (Object)rule.getBillCloseFieldFailStatus());
        this.fillCloseFields();
        this.fillCloseStatusComboItems(rule.getEntryCloseFieldKey(), "entryclosesuccess", "entryclosefail");
        this.fillCloseStatusComboItems(rule.getBillCloseFieldKey(), "billclosesuccess", "billclosefail");
    }

    private void setExcessCheck(WriteBackRuleElement rule) {
        String json;
        this.model.setValue("excesschecktype", (Object)String.valueOf(rule.getExcessCheckType().ordinal()));
        this.model.setValue("excessselecttrue", (Object)String.valueOf(rule.getExcessSelectTrue().ordinal()));
        this.model.setValue("excessselectfalse", (Object)String.valueOf(rule.getExcessSelectFalse().ordinal()));
        if (rule.getExcessTypeSelectCondition() == null) {
            this.model.setValue("excesstypecondition", (Object)"");
            this.model.setValue("excesstypeconditiondesc", (Object)"");
        } else {
            json = SerializationUtils.toJsonString((Object)rule.getExcessTypeSelectCondition());
            this.model.setValue("excesstypecondition", (Object)json);
            this.model.setValue("excesstypeconditiondesc", (Object)rule.getExcessTypeSelectCondition().getExprDesc());
        }
        if (rule.getExcessCheckConditon() == null) {
            this.model.setValue("excesscheckconditon", (Object)"");
            this.model.setValue("excesscheckconditondesc", (Object)"");
        } else {
            json = SerializationUtils.toJsonString((Object)rule.getExcessCheckConditon());
            this.model.setValue("excesscheckconditon", (Object)json);
            this.model.setValue("excesscheckconditondesc", (Object)rule.getExcessCheckConditon().getExprDesc());
        }
        ILocaleString excessCheckMessage = (ILocaleString)this.model.getValue("excesscheckmessage");
        if (rule.getExcessCheckMessage() != null) {
            for (Map.Entry entry : rule.getExcessCheckMessage().entrySet()) {
                excessCheckMessage.setItem((String)entry.getKey(), entry.getValue());
            }
        }
        this.model.setValue("excesscheckmessage", (Object)excessCheckMessage);
        this.setExcessVisiable(rule.getExcessCheckType());
    }

    public void changeSourceBill() {
        this.srcMainType = null;
        BillEntityType mainType = this.getSourceMainType();
        int rowCount = this.model.getEntryRowCount("entryentity_wb");
        for (int row = 0; row < rowCount; ++row) {
            String commitField = (String)this.model.getValue("wb_commitfieldkey", row);
            if (StringUtils.isBlank((CharSequence)commitField)) continue;
            if (mainType == null) {
                this.model.setValue("wb_commitfieldkey", (Object)"", row);
                this.model.setValue("wb_commitfieldname", (Object)"", row);
                continue;
            }
            IDataEntityProperty property = mainType.findProperty(commitField);
            if (property == null) {
                this.model.setValue("wb_commitfieldkey", (Object)"", row);
                this.model.setValue("wb_commitfieldname", (Object)"", row);
                continue;
            }
            this.model.setValue("wb_commitfieldname", (Object)EntityParseHelper.buildPropFullCaption(property), row);
        }
        this.model.setValue("closecheckcondition", (Object)"");
        this.model.setValue("closecheckconditiondesc", (Object)"");
        this.model.setValue("entryclosefieldkey", (Object)"");
        this.model.setValue("entryclosesuccess", (Object)"");
        this.model.setValue("entryclosefail", (Object)"");
        this.model.setValue("billclosefieldkey", (Object)"");
        this.model.setValue("billclosesuccess", (Object)"");
        this.model.setValue("billclosefail", (Object)"");
        this.fillCloseFields();
        this.fillCloseStatusComboItems(null, "entryclosesuccess", "entryclosefail", "billclosesuccess", "billclosefail");
        this.model.setValue("excesstypecondition", (Object)"");
        this.model.setValue("excesstypeconditiondesc", (Object)"");
        this.model.setValue("excesscheckconditon", (Object)"");
        this.model.setValue("excesscheckconditondesc", (Object)"");
    }

    public void changeTargetBill() {
        this.tgtMainType = null;
        int rowCount = this.model.getEntryRowCount("entryentity_wb");
        for (int row = 0; row < rowCount; ++row) {
            this.model.setValue("wb_condition", (Object)"", row);
            this.model.setValue("wb_conditiondesc", (Object)"", row);
            this.model.setValue("wb_formula", (Object)"", row);
            this.model.setValue("wb_formuladesc", (Object)"", row);
        }
    }

    public void fillCloseFields() {
        BillEntityType mainType = this.getSourceMainType();
        ArrayList<ComboItem> entryCloseitems = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString(""));
        entryCloseitems.add(blankItem);
        if (mainType != null) {
            HashSet<String> selectEntitys = WBRuleGetHelper.getSrcCommitEntity(this.model, mainType, false, -1);
            for (String string : selectEntitys) {
                EntityType entityType = (EntityType)mainType.getAllEntities().get(string);
                for (IDataEntityProperty property : entityType.getProperties()) {
                    if (!(property instanceof BillStatusProp)) continue;
                    ComboItem item = new ComboItem();
                    item.setValue(property.getName());
                    item.setCaption(((BillStatusProp)property).getDisplayName());
                    entryCloseitems.add(item);
                }
            }
        }
        ComboEdit entryCloseEdit = (ComboEdit)this.view.getControl("entryclosefieldkey");
        entryCloseEdit.setComboItems(entryCloseitems);
        ArrayList<ComboItem> billCloseItems = new ArrayList<ComboItem>();
        billCloseItems.add(blankItem);
        if (mainType != null) {
            for (IDataEntityProperty property : mainType.getProperties()) {
                if (!(property instanceof BillStatusProp)) continue;
                ComboItem item = new ComboItem();
                item.setValue(property.getName());
                item.setCaption(((BillStatusProp)property).getDisplayName());
                billCloseItems.add(item);
            }
        }
        ComboEdit comboEdit = (ComboEdit)this.view.getControl("billclosefieldkey");
        comboEdit.setComboItems(billCloseItems);
    }

    public void fillCloseStatusComboItems(String statusFldKey, String ... comboFldKeys) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString(""));
        items.add(blankItem);
        BillStatusProp prop = null;
        BillEntityType srcMainType = this.getSourceMainType();
        if (srcMainType != null && StringUtils.isNotBlank((CharSequence)statusFldKey)) {
            prop = (BillStatusProp)srcMainType.findProperty(statusFldKey);
        }
        if (prop != null) {
            for (ValueMapItem statusItem : prop.getComboItems()) {
                ComboItem item = new ComboItem();
                item.setValue(statusItem.getValue());
                item.setCaption(statusItem.getName());
                items.add(item);
            }
        }
        for (String comboFldKey : comboFldKeys) {
            ComboEdit comboEdit = (ComboEdit)this.view.getControl(comboFldKey);
            comboEdit.setComboItems(items);
        }
    }

    public void setExcessVisiable(ExcessCheckType excessCheckType) {
        if (excessCheckType == ExcessCheckType.SelectByFormula) {
            this.view.setVisible(Boolean.valueOf(true), new String[]{"excesstypeconditiondesc", "excessselecttrue", "excessselectfalse"});
        } else {
            this.view.setVisible(Boolean.valueOf(false), new String[]{"excesstypeconditiondesc", "excessselecttrue", "excessselectfalse"});
        }
    }
}

