/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.designer.botp.WBRuleEventHandler;
import kd.bos.designer.botp.WBRuleGetHelper;
import kd.bos.designer.botp.WBRuleSetHelper;
import kd.bos.designer.botp.common.WBRuleFormConst;
import kd.bos.designer.botp.extcontrol.domain.WBExtControlEditDomain;
import kd.bos.designer.botp.extcontrol.domain.WBExtControlLockDomain;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CheckResult;
import kd.bos.entity.botp.WriteBackRuleElement;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.botp.WriteBackRuleMetadata;
import kd.bos.metadata.botp.WriteBackRuleReader;
import kd.bos.metadata.botp.WriteBackRuleTemplate;
import kd.bos.metadata.botp.WriteBackRuleWriter;
import kd.bos.metadata.botp.common.RuleIsvHelper;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.TimeServiceHelper;

public class WriteBackRuleEdit
extends AbstractFormPlugin
implements WBRuleFormConst {
    private static Log log = LogFactory.getLog(WriteBackRuleEdit.class);
    public static final String FormId_WriteBackRuleEdit = "botp_writebackruleedit";
    public static final String CustParam_RuleId = "ruleid";
    public static final String NEW_WRITE_BACK_RULE_ISV = "NewWriteBackRuleIsv";
    private static final String BOS_DESIGNER_PLUGIN = "bos-botp-formplugin";
    private WBRuleEventHandler eventHandler;
    private WBRuleSetHelper setHelper;
    private WBRuleGetHelper getHelper;
    private WriteBackRuleMetadata ruleMetadata;
    private WBExtControlEditDomain extControlEditDomain = new WBExtControlEditDomain(this::getRuleIsv);
    private WBExtControlLockDomain extControlLockDomain = new WBExtControlLockDomain(this::getRuleIsv);

    private String getRuleIsv() {
        if (this.ruleMetadata != null) {
            return this.ruleMetadata.getIsv();
        }
        String ruleId = (String)this.getView().getFormShowParameter().getCustomParam(CustParam_RuleId);
        if (StringUtils.isBlank((CharSequence)ruleId)) {
            ruleId = this.getView().getPageCache().get(CustParam_RuleId);
        }
        if (StringUtils.isNotBlank((CharSequence)ruleId)) {
            WriteBackRuleReader reader = new WriteBackRuleReader();
            WriteBackRuleMetadata ruleMetadataTmp = reader.loadMeta(ruleId, false);
            if (ruleMetadataTmp != null) {
                return ruleMetadataTmp.getIsv();
            }
            return this.getView().getPageCache().get(NEW_WRITE_BACK_RULE_ISV);
        }
        return "";
    }

    private WBRuleEventHandler getEventHandler() {
        if (this.eventHandler == null) {
            this.eventHandler = new WBRuleEventHandler(this.getView(), this, this.extControlLockDomain);
        }
        return this.eventHandler;
    }

    private WBRuleSetHelper getSetHelper() {
        if (this.setHelper == null) {
            this.setHelper = new WBRuleSetHelper(this.getView(), this, this.extControlLockDomain);
        }
        return this.setHelper;
    }

    private WBRuleGetHelper getGetHelper() {
        if (this.getHelper == null) {
            this.getHelper = new WBRuleGetHelper(this.getView(), this, this.extControlLockDomain);
        }
        return this.getHelper;
    }

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"bar_main", "advcontoolbarap", "tbar_bizrule"});
        WBRuleEventHandler eventHandler = this.getEventHandler();
        eventHandler.initialize();
        this.addClickListeners(new String[]{"button_down_extclose", "button_up_extclose"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String ruleId = (String)this.getView().getFormShowParameter().getCustomParam(CustParam_RuleId);
        if (StringUtils.isNotBlank((CharSequence)ruleId)) {
            WriteBackRuleReader reader = new WriteBackRuleReader();
            this.ruleMetadata = reader.loadMeta(ruleId, false);
        } else {
            WriteBackRuleTemplate template = new WriteBackRuleTemplate();
            this.ruleMetadata = template.CreateBlankRule();
            this.ruleMetadata.setIsv(RuleIsvHelper.getUserIsv());
            this.getView().getPageCache().put(CustParam_RuleId, this.ruleMetadata.getId());
            this.getView().getPageCache().put(NEW_WRITE_BACK_RULE_ISV, this.ruleMetadata.getIsv());
        }
        WBRuleSetHelper setHelper = this.getSetHelper();
        setHelper.setRule(this.ruleMetadata.getRuleElement());
        this.getModel().setValue("devtype", (Object)this.ruleMetadata.getDevType());
        this.getModel().setValue("masterid", (Object)this.ruleMetadata.getMasterId());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String currentIsv = RuleIsvHelper.getUserIsv();
        boolean isKingdee = RuleIsvHelper.isKindeeIsv();
        if (isKingdee && StringUtils.isBlank((CharSequence)this.ruleMetadata.getIsv())) {
            this.ruleMetadata.setIsv(currentIsv);
        }
        BillOperationStatus status = BillOperationStatus.ADDNEW;
        if (!StringUtils.equals((CharSequence)currentIsv, (CharSequence)this.ruleMetadata.getIsv())) {
            status = BillOperationStatus.EDIT;
            Label lblIsv = (Label)this.getView().getControl("lblisv");
            lblIsv.setText(ResManager.loadKDString((String)"\u672c\u89c4\u5219\u7531\u5176\u4ed6\u5f00\u53d1\u5546\u53d1\u5e03\uff0c\u8bf7\u52ff\u76f4\u63a5\u6539\u52a8\uff1b\u53ef\u4ee5\u6269\u5c55\u4e00\u4e2a\u65b0\u5206\u652f\u540e\u4fee\u6539", (String)"WriteBackRuleEdit_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"enable"});
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.removeAction("setFormStatus");
        clientViewProxy.addAction("setFormStatus", (Object)status.getValue());
        this.getView().setVisible(Boolean.valueOf(status == BillOperationStatus.EDIT), new String[]{"lblisv"});
        this.putRuleToCache(this.ruleMetadata);
        this.extControlEditDomain.visitExtControlButton(this.getView());
        this.extControlLockDomain.lockControls(this.getView());
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        this.extControlLockDomain.stopAndTipsButton(evt, this.getView());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().equalsIgnoreCase("btnsave")) {
            this.doSave();
        } else {
            WBRuleEventHandler eventHandler = this.getEventHandler();
            eventHandler.itemClick(evt);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        WBRuleEventHandler eventHandler = this.getEventHandler();
        eventHandler.click(evt);
        Control source = (Control)evt.getSource();
        this.extControlEditDomain.clickExtControlButton(this, source.getKey());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        WBRuleEventHandler eventHandler = this.getEventHandler();
        eventHandler.closedCallBack(closedCallBackEvent);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        WBRuleEventHandler eventHandler = this.getEventHandler();
        eventHandler.propertyChanged(e);
    }

    private void doSave() {
        WriteBackRuleMetadata ruleMetadata = this.getRuleFromCache();
        if (ruleMetadata == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u5143\u6570\u636e\u4e3a\u7a7a", (String)"WriteBackRuleEdit_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        WBRuleGetHelper getHelper = this.getGetHelper();
        getHelper.getRule(ruleMetadata.getRuleElement());
        if (!this.checkRule(ruleMetadata.getRuleElement())) {
            return;
        }
        ruleMetadata.setModifierId(RequestContext.get().getUserId());
        ruleMetadata.setModifyDate(new Date());
        Map saveResult = WriteBackRuleWriter.save((WriteBackRuleMetadata)ruleMetadata);
        boolean success = (Boolean)saveResult.get("success");
        String message = (String)saveResult.get("message");
        if (success) {
            this.writeLog(ruleMetadata);
            if (StringUtils.isNotBlank((CharSequence)message)) {
                this.getView().showSuccessNotification(message);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"WriteBackRuleEdit_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            this.getView().returnDataToParent((Object)true);
            this.putRuleToCache(ruleMetadata);
        } else if (StringUtils.isNotBlank((CharSequence)message)) {
            this.getView().showTipNotification(message);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"WriteBackRuleEdit_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    private boolean checkRule(WriteBackRuleElement rule) {
        if (StringUtils.isBlank((CharSequence)rule.getSourceEntityNumber())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6e90\u5355", (String)"WriteBackRuleEdit_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)rule.getTargetEntityNumber())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u76ee\u6807\u5355", (String)"WriteBackRuleEdit_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (!rule.isNormual()) {
            return true;
        }
        CheckResult checkResult = new CheckResult();
        rule.check(null, checkResult);
        if (checkResult.isPass()) {
            return true;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_rulecheckreport");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u89c4\u5219\u542f\u7528\u68c0\u67e5\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"WriteBackRuleEdit_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        String json = SerializationUtils.toJsonString((Object)checkResult);
        showParameter.setCustomParam("checkresult", (Object)json);
        this.getView().showForm(showParameter);
        return false;
    }

    private void putRuleToCache(WriteBackRuleMetadata ruleMetadata) {
        WriteBackRuleTemplate template = new WriteBackRuleTemplate();
        String json = template.serializeToJSONString(ruleMetadata, null);
        this.getPageCache().put("rule", json);
    }

    private WriteBackRuleMetadata getRuleFromCache() {
        String json = this.getPageCache().get("rule");
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        WriteBackRuleTemplate template = new WriteBackRuleTemplate();
        WriteBackRuleMetadata ruleMetadata = (WriteBackRuleMetadata)template.deserializeFromJSONString(json, null);
        return ruleMetadata;
    }

    private void writeLog(WriteBackRuleMetadata rule) {
        if (rule == null) {
            return;
        }
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        ArrayList<OpLogAppInfo> appLogInfoList = new ArrayList<OpLogAppInfo>(10);
        MainEntityType targetMainType = null;
        targetMainType = EntityMetadataCache.getDataEntityType((String)rule.getRuleElement().getTargetEntityNumber());
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        String appNumber = targetMainType == null ? "" : targetMainType.getBizAppNumber();
        String appId = " ";
        if (StringUtils.isNotEmpty((CharSequence)appNumber)) {
            try {
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
                if (null != appInfo) {
                    appId = appInfo.getId();
                }
            }
            catch (KDException e) {
                log.error((Throwable)e);
            }
        }
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID("botp_writebackrule");
        logInfo.setOrgID(Long.valueOf(0L));
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "WriteBackRuleEdit_14", BOS_DESIGNER_PLUGIN);
        logInfo.setOpName("save", opNameBridge);
        logInfo.setModifyBillNo(rule.getId());
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u53cd\u5199\u89c4\u5219(%1$s)\uff0c\u4fdd\u5b58\u6210\u529f", "WriteBackRuleEdit_8", BOS_DESIGNER_PLUGIN);
        logInfo.setOpDesc(opDescBridge, new String[]{rule.getId()});
        appLogInfoList.add(logInfo);
        logService.addBatchLog(appLogInfoList);
        this.writeBotpMetaLog(rule);
    }

    private void writeBotpMetaLog(WriteBackRuleMetadata rule) {
        short metaLogType = MetaLogType.BotpSave.getValue();
        boolean isNeedInit = false;
        StringBuilder remarkBuilder = new StringBuilder(ResManager.loadKDString((String)"\u53cd\u5199\u89c4\u5219", (String)"WriteBackRuleEdit_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        WriteBackRuleMetadata oldRule = this.getRuleFromCache();
        if (oldRule != null && (oldRule.getRuleElement().getSourceEntityNumber() != null || oldRule.getRuleElement().getTargetEntityNumber() != null)) {
            isNeedInit = true;
            remarkBuilder.append(ResManager.loadKDString((String)"_\u4fee\u6539", (String)"WriteBackRuleEdit_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        } else {
            remarkBuilder.append(ResManager.loadKDString((String)"_\u65b0\u589e", (String)"WriteBackRuleEdit_13", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        WriteBackRuleTemplate template = new WriteBackRuleTemplate();
        long logId = DB.genGlobalLongId();
        String metaId = rule.getId();
        String metaNumber = rule.getRuleElement().getSourceEntityNumber() + "-" + rule.getRuleElement().getTargetEntityNumber();
        MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
        if (isNeedInit && CollectionUtils.isEmpty((Collection)logService.queryMetaIds(Stream.of(metaId).collect(Collectors.toList())))) {
            long initLogId = DB.genGlobalLongId();
            logService.addBotpMetaLog(metaId, metaNumber, template.buildDiffXml(oldRule, null, false), (int)MetaLogType.BotpInit.getValue(), initLogId, rule.getBizappId(), remarkBuilder.toString());
        }
        logService.addBotpMetaLog(metaId, metaNumber, template.buildDiffXml(rule, null, false), (int)metaLogType, logId, rule.getBizappId(), remarkBuilder.toString());
    }
}

