/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.designer.botp.extcontrol.domain.WBExtControlLockDomain;
import kd.bos.entity.botp.WriteBackRuleElement;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.operate.IEntityOperate;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.botp.DesignWriteBackRuleMeta;
import kd.bos.metadata.botp.WriteBackRuleMetadata;
import kd.bos.metadata.botp.WriteBackRuleReader;
import kd.bos.metadata.botp.WriteBackRuleTemplate;
import kd.bos.metadata.botp.WriteBackRuleWriter;
import kd.bos.metadata.botp.common.RuleIsvHelper;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.WriteBackMetaServiceHelper;

public class WriteBackRuleList
extends AbstractListPlugin {
    private static Log log = LogFactory.getLog(WriteBackRuleList.class);
    public static final String FormId_WriteBackRule = "botp_writebackrule";
    private static String BOS_DESIGNER_PLUGIN = "bos-botp-formplugin";
    private static final String OP_ADD = "new";
    private static final String OP_COPY = "copy";
    private static final String OP_MODIFY = "modify";
    private static final String OP_EXT = "ext";
    private static final String OP_INHERIT = "inherit";
    private static final String TARGETENTIRYNUMBER_ID = "targetentitynumber.id";
    private static final String SOURCEENTIRYNUMBER_ID = "sourceentitynumber.id";
    private static final String KEY_SOURCE_APPNAME = "sourceentitynumber.bizappid.name";
    private static final String KEY_Target_APPNAME = "targetentitynumber.bizappid.name";
    private static final String KEY_CUSTSTATUS = "custstatus";
    private String Msg_UnSelectedRow = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"WriteBackRuleList_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
    private static final String KEY_WRITEBACK_RULE_TAG = "writebackrule_";
    private WBExtControlLockDomain extControlLockDomain = new WBExtControlLockDomain(this::getRuleIsv);

    private String getRuleIsv() {
        String ruleId = this.getCurrSelectedRuleId();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ruleId)) {
            return "";
        }
        IDataEntityType dType = OrmUtils.getDataEntityType(DesignWriteBackRuleMeta.class);
        DesignWriteBackRuleMeta designMeta = (DesignWriteBackRuleMeta)BusinessDataReader.read((Object)ruleId, (IDataEntityType)dType, (Boolean)false);
        return designMeta == null ? "" : designMeta.getIsv();
    }

    public void initialize() {
        super.initialize();
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)listShowParameter.getCustomParam(SOURCEENTIRYNUMBER_ID))) || StringUtils.isNotBlank((CharSequence)((CharSequence)listShowParameter.getCustomParam(TARGETENTIRYNUMBER_ID)))) {
            FilterColumn targetBillFilterColum = args.getFilterColumn(TARGETENTIRYNUMBER_ID);
            FilterColumn srcBillFilterColum = args.getFilterColumn(SOURCEENTIRYNUMBER_ID);
            targetBillFilterColum.setDefaultValue((String)listShowParameter.getCustomParam(TARGETENTIRYNUMBER_ID));
            srcBillFilterColum.setDefaultValue((String)listShowParameter.getCustomParam(SOURCEENTIRYNUMBER_ID));
        }
        super.filterContainerInit(args);
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection datas = e.getPageData();
        if (datas == null) {
            return;
        }
        for (DynamicObject data : datas) {
            if (StringUtils.equals((CharSequence)"2", (CharSequence)data.getString(KEY_CUSTSTATUS))) continue;
            data.set(KEY_CUSTSTATUS, (Object)"1");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
        IEntityOperate op = null;
        if (e.getSource() instanceof IEntityOperate) {
            op = (IEntityOperate)e.getSource();
        }
        switch (e.getOperateKey()) {
            case "new": {
                this.doAdd();
                break;
            }
            case "copy": {
                this.doCopy(op);
                break;
            }
            case "ext": {
                this.doExt(op);
                break;
            }
            case "inherit": {
                this.doInherit(op);
                break;
            }
            case "modify": {
                this.doModify();
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (itemKey.equals("btnext") || itemKey.equals("btninherit") || itemKey.equals("btncopy")) {
            String ruleId = this.getCurrSelectedRuleId();
            if (StringUtils.isBlank((CharSequence)ruleId)) {
                this.getView().showTipNotification(this.Msg_UnSelectedRow);
                return;
            }
            IDataEntityType dType = OrmUtils.getDataEntityType(DesignWriteBackRuleMeta.class);
            DesignWriteBackRuleMeta designMeta = (DesignWriteBackRuleMeta)BusinessDataReader.read((Object)ruleId, (IDataEntityType)dType, (Boolean)false);
            if (designMeta.getDevType().equals("2")) {
                ruleId = designMeta.getMasterId();
            }
            WriteBackRuleElement ruleElement = WriteBackMetaServiceHelper.loadWriteBackRule((String)ruleId);
            this.extControlLockDomain.stopAndTipsButtonForExtBtn(evt, this.getView(), ruleElement.getExtElements());
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        this.getView().invokeOperation(OP_MODIFY);
        evt.setCancel(true);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equalsIgnoreCase(OP_MODIFY) && closedCallBackEvent.getReturnData() != null && this.getView() instanceof AbstractListView) {
            ((AbstractListView)this.getView()).setNeedRefreshTree(false);
            ((IListView)this.getView()).refresh();
        }
    }

    private void writeMetadataLog(WriteBackRuleMetadata rule, WriteBackRuleTemplate template, int metaLogType, String tag) {
        long logId = DB.genGlobalLongId();
        String metaId = rule.getId();
        String metaNumber = rule.getRuleElement().getSourceEntityNumber() + "-" + rule.getRuleElement().getTargetEntityNumber();
        String remark = String.format(ResManager.loadKDString((String)"\u53cd\u5199\u89c4\u5219_%s", (String)"WriteBackRuleList_14", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), tag);
        MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
        logService.addBotpMetaLog(metaId, metaNumber, template.buildDiffXml(rule, null, false), metaLogType, logId, rule.getBizappId(), remark);
    }

    private void doAdd() {
        this.showRuleEditForm("");
    }

    private void doCopy(IEntityOperate op) {
        String ruleId = this.getCurrSelectedRuleId();
        if (StringUtils.isBlank((CharSequence)ruleId)) {
            this.getView().showTipNotification(this.Msg_UnSelectedRow);
            return;
        }
        IDataEntityType dType = OrmUtils.getDataEntityType(DesignWriteBackRuleMeta.class);
        DesignWriteBackRuleMeta designMeta = (DesignWriteBackRuleMeta)BusinessDataReader.read((Object)ruleId, (IDataEntityType)dType, (Boolean)false);
        if (designMeta.getDevType().equals("2")) {
            ruleId = designMeta.getMasterId();
        }
        WriteBackRuleElement ruleElement = WriteBackMetaServiceHelper.loadWriteBackRule((String)ruleId);
        WriteBackRuleTemplate template = new WriteBackRuleTemplate();
        WriteBackRuleMetadata newRuleMeta = template.CreateBlankRule();
        newRuleMeta.setRuleElement(ruleElement);
        newRuleMeta.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
        newRuleMeta.getName().setLocaleValue_zh_CN(String.format(ResManager.loadKDString((String)"%s_\u590d\u5236", (String)"WriteBackRuleList_15", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ruleElement.getName().getLocaleValue_zh_CN()));
        newRuleMeta.setBizappId(designMeta.getBizappId());
        newRuleMeta.setIsv(RuleIsvHelper.getUserIsv());
        newRuleMeta.setCreateDate(TimeServiceHelper.getCurrentSystemTime());
        newRuleMeta.getRuleElement().setCustStatus("2");
        Map saveResult = WriteBackRuleWriter.save((WriteBackRuleMetadata)newRuleMeta);
        if (((Boolean)saveResult.get("success")).booleanValue()) {
            this.writeMetadataLog(newRuleMeta, template, MetaLogType.BotpSave.getValue(), ResManager.loadKDString((String)"\u590d\u5236", (String)"WriteBackRuleList_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        this.checkSaveResult(op, saveResult, ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"WriteBackRuleList_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
    }

    private void doModify() {
        String ruleId = this.getCurrSelectedRuleId();
        if (StringUtils.isBlank((CharSequence)ruleId)) {
            this.getView().showTipNotification(this.Msg_UnSelectedRow);
            return;
        }
        this.showRuleEditForm(ruleId);
    }

    private void doExt(IEntityOperate op) {
        String inheritPath;
        String ruleId = this.getCurrSelectedRuleId();
        if (StringUtils.isBlank((CharSequence)ruleId)) {
            this.getView().showTipNotification(this.Msg_UnSelectedRow);
            return;
        }
        WriteBackRuleReader reader = new WriteBackRuleReader();
        boolean hadExtRules = reader.hadExtRules(ruleId);
        if (hadExtRules) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u89c4\u5219\uff0c\u5df2\u6709\u6269\u5c55\u89c4\u5219\uff0c\u4e0d\u80fd\u518d\u6b21\u6269\u5c55\u3002", (String)"WriteBackRuleList_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        WriteBackRuleMetadata ruleMetadata = reader.loadMeta(ruleId, false, true);
        ruleMetadata.setParentId(ruleMetadata.getId());
        if (StringUtils.isBlank((CharSequence)ruleMetadata.getMasterId())) {
            ruleMetadata.setMasterId(ruleId);
        }
        inheritPath = StringUtils.isBlank((CharSequence)(inheritPath = ruleMetadata.getInheritPath())) ? ruleMetadata.getId() : inheritPath + "," + ruleMetadata.getId();
        ruleMetadata.setInheritPath(inheritPath);
        ruleMetadata.setDevType("2");
        ruleMetadata.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
        ruleMetadata.getName().setLocaleValue_zh_CN(String.format(ResManager.loadKDString((String)"%s_\u6269\u5c55", (String)"WriteBackRuleList_16", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ruleMetadata.getName().getLocaleValue_zh_CN()));
        ruleMetadata.setIsv(RuleIsvHelper.getUserIsv());
        ruleMetadata.setCreateDate(TimeServiceHelper.getCurrentSystemTime());
        Map saveResult = WriteBackRuleWriter.save((WriteBackRuleMetadata)ruleMetadata);
        if (((Boolean)saveResult.get("success")).booleanValue()) {
            WriteBackRuleTemplate template = new WriteBackRuleTemplate();
            this.writeMetadataLog(ruleMetadata, template, MetaLogType.BotpSave.getValue(), ResManager.loadKDString((String)"\u6269\u5c55", (String)"WriteBackRuleList_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        this.checkSaveResult(op, saveResult, ResManager.loadKDString((String)"\u6269\u5c55\u6210\u529f\u3002", (String)"WriteBackRuleList_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
    }

    private void doInherit(IEntityOperate op) {
        String ruleId = this.getCurrSelectedRuleId();
        if (StringUtils.isBlank((CharSequence)ruleId)) {
            this.getView().showTipNotification(this.Msg_UnSelectedRow);
            return;
        }
        IDataEntityType dType = OrmUtils.getDataEntityType(DesignWriteBackRuleMeta.class);
        DesignWriteBackRuleMeta designMeta = (DesignWriteBackRuleMeta)BusinessDataReader.read((Object)ruleId, (IDataEntityType)dType, (Boolean)false);
        if (designMeta.getDevType().equals("2")) {
            ruleId = designMeta.getMasterId();
        }
        WriteBackRuleReader reader = new WriteBackRuleReader();
        WriteBackRuleMetadata ruleMetadata = reader.loadMeta(ruleId, false, true);
        ruleMetadata.setParentId(ruleMetadata.getId());
        ruleMetadata.setMasterId("");
        String inheritPath = ruleMetadata.getInheritPath();
        inheritPath = StringUtils.isBlank((CharSequence)inheritPath) ? ruleMetadata.getId() : inheritPath + "," + ruleMetadata.getId();
        ruleMetadata.setInheritPath(inheritPath);
        ruleMetadata.setDevType("1");
        ruleMetadata.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
        ruleMetadata.getName().setLocaleValue_zh_CN(String.format(ResManager.loadKDString((String)"%s_\u7ee7\u627f", (String)"WriteBackRuleList_17", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ruleMetadata.getName().getLocaleValue_zh_CN()));
        ruleMetadata.setIsv(RuleIsvHelper.getUserIsv());
        ruleMetadata.setCreateDate(TimeServiceHelper.getCurrentSystemTime());
        ruleMetadata.getRuleElement().setCustStatus("2");
        Map saveResult = WriteBackRuleWriter.save((WriteBackRuleMetadata)ruleMetadata);
        if (((Boolean)saveResult.get("success")).booleanValue()) {
            WriteBackRuleTemplate template = new WriteBackRuleTemplate();
            this.writeMetadataLog(ruleMetadata, template, MetaLogType.BotpSave.getValue(), ResManager.loadKDString((String)"\u7ee7\u627f", (String)"WriteBackRuleList_13", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        this.checkSaveResult(op, saveResult, ResManager.loadKDString((String)"\u7ee7\u627f\u6210\u529f\u3002", (String)"WriteBackRuleList_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
    }

    private void checkSaveResult(IEntityOperate op, Map<String, Object> saveResult, String successMessage) {
        boolean success = (Boolean)saveResult.get("success");
        String message = (String)saveResult.get("message");
        if (success) {
            if (StringUtils.isNotBlank((CharSequence)successMessage)) {
                this.getView().showSuccessNotification(successMessage);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"WriteBackRuleList_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            if (op != null) {
                op.setCancelRefresh(false);
            }
        } else if (StringUtils.isNotBlank((CharSequence)message)) {
            this.getView().showTipNotification(message);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002", (String)"WriteBackRuleList_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void showRuleEditForm(String ruleId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_writebackruleedit");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("ruleid", (Object)ruleId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, OP_MODIFY);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private String getCurrSelectedRuleId() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.size() == 0) {
            return "";
        }
        String ruleId = String.valueOf(((IListView)this.getView()).getFocusRowPkId());
        return ruleId;
    }
}

