/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp.command;

import java.util.Optional;
import kd.bos.designer.botp.command.AbstractCommand;
import kd.bos.designer.botp.command.sql.AbstractStatement;
import kd.bos.designer.botp.command.sql.LKStatement;
import kd.bos.designer.botp.command.sql.TCStatement;
import kd.bos.designer.botp.command.sql.UnStatement;
import kd.bos.designer.botp.command.sql.WBStatement;
import kd.bos.entity.botp.helper.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;

public class SqlCommand
extends AbstractCommand {
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";

    public SqlCommand(IDataModel dataModel, IFormView formView) {
        super(dataModel, formView);
    }

    @Override
    public void command(String[] params) {
        AbstractStatement sqlStatement;
        if (params.length <= 0) {
            return;
        }
        SqlEnum sqlEnum = SqlEnum.getEnum(params[0]);
        if (null == sqlEnum) {
            return;
        }
        switch (sqlEnum) {
            case TC: {
                sqlStatement = new TCStatement(this, this.dataModel);
                break;
            }
            case WB: {
                sqlStatement = new WBStatement(this, this.dataModel);
                break;
            }
            case LK: {
                sqlStatement = new LKStatement(this, this.dataModel);
                break;
            }
            default: {
                sqlStatement = new UnStatement(this, this.dataModel);
            }
        }
        sqlStatement.execute(params);
    }

    public Optional<String> analyseParamForSBillId(String[] params) {
        String id = null;
        if (params != null && params.length > 0) {
            for (String param : params) {
                if (!param.contains("sbillid")) continue;
                id = param.split(":")[1];
            }
        }
        return Optional.ofNullable(id);
    }

    public Optional<String> analyseParamForTBillId(String[] params) {
        String id = null;
        if (params != null && params.length > 0) {
            for (String param : params) {
                if (!param.contains("tbillid")) continue;
                id = param.split(":")[1];
            }
        }
        return Optional.ofNullable(id);
    }

    static enum SqlEnum {
        TC("tc", new MultiLangEnumBridge("\u5206\u5f55\u5173\u8054\u5173\u7cfb\u8868", "SqlCommand_0", "bos-botp-formplugin")),
        WB("wb", new MultiLangEnumBridge("\u53cd\u5199\u5feb\u7167\u8868", "SqlCommand_1", "bos-botp-formplugin")),
        LK("lk", new MultiLangEnumBridge("\u5173\u8054\u5b50\u8868", "SqlCommand_2", "bos-botp-formplugin"));

        private String code;
        private MultiLangEnumBridge desc;

        private SqlEnum(String code, MultiLangEnumBridge desc) {
            this.code = code;
            this.desc = desc;
        }

        public static SqlEnum getEnum(String code) {
            for (SqlEnum value : SqlEnum.values()) {
                if (!value.getCode().equals(code)) continue;
                return value;
            }
            return null;
        }

        public String getCode() {
            return this.code;
        }
    }
}

