/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp.command.sql;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.designer.botp.command.SqlCommand;
import kd.bos.designer.botp.command.sql.AbstractStatement;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.IDataModel;

public class TCStatement
extends AbstractStatement {
    public TCStatement(SqlCommand botpCommand, IDataModel dataModel) {
        super(botpCommand, dataModel);
    }

    @Override
    public void execute(String[] params) {
        String sourceEntityNumber = this.command.getSourceEntityNumber();
        String targetEntityNumber = this.command.getTargetEntityNumber();
        Optional<String> optionalSourceBillId = this.command.analyseParamForSBillId(params);
        Optional<String> optionalTargetBillId = this.command.analyseParamForTBillId(params);
        ConvertDataService reader = new ConvertDataService();
        TableDefine sourceTableDefine = reader.loadTableDefine(sourceEntityNumber, sourceEntityNumber);
        TableDefine targetTableDefine = reader.loadTableDefine(targetEntityNumber, targetEntityNumber);
        MainEntityType targetEntityType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)targetEntityNumber);
        if (linkSet == null || StringUtils.isBlank((CharSequence)linkSet.getTrackerTable())) {
            return;
        }
        StringBuilder whereStrb = new StringBuilder().append(String.format("FSTableId='%s' and FTTableId='%s' ", sourceTableDefine.getTableId(), targetTableDefine.getTableId()));
        optionalSourceBillId.ifPresent(sbillid -> whereStrb.append(String.format("and FSBillId='%s'", sbillid)));
        optionalTargetBillId.ifPresent(tbillid -> whereStrb.append(String.format("and FTBillId='%s'", tbillid)));
        SqlBuilder sBuilder = new SqlBuilder();
        sBuilder.append("SELECT FSBillId, FSTableId, FTBillId, FTTableId ", new Object[0]);
        sBuilder.append("FROM ", new Object[0]).append(linkSet.getTrackerTable(), new Object[0]).append(" ", new Object[0]);
        sBuilder.append("WHERE", new Object[0]).append(whereStrb.toString(), new Object[0]);
        ResultSetHandler action = rs -> {
            HashSet<BFRow> rows = new HashSet<BFRow>(16);
            while (rs.next()) {
                Long sBillId = rs.getLong(1);
                Long sTableId = rs.getLong(2);
                Long sMainTableId = this.loadMainTableId(sTableId);
                Long tBillId = rs.getLong(3);
                Long tTableId = rs.getLong(4);
                Long tMainTableId = this.loadMainTableId(tTableId);
                BFRowId sRowId = new BFRowId(sMainTableId, sBillId, sMainTableId, sBillId);
                BFRowId tRowid = new BFRowId(tMainTableId, tBillId, tMainTableId, tBillId);
                BFRow row = new BFRow();
                row.setSId(sRowId);
                row.setId(tRowid);
                rows.add(row);
            }
            return rows;
        };
        Set bfRows = (Set)DB.query((DBRoute)new DBRoute(targetEntityType.getDBRouteKey()), (SqlBuilder)sBuilder, (ResultSetHandler)action);
        System.out.println();
    }

    private Long loadMainTableId(Long tableId) {
        ConvertDataService reader = new ConvertDataService();
        TableDefine entityTableDefine = reader.loadTableDefine(tableId);
        TableDefine mainTableDefine = reader.loadTableDefine(entityTableDefine.getEntityNumber(), entityTableDefine.getEntityNumber());
        return mainTableDefine.getTableId();
    }
}

