/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp.common;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class RuleFormHelper {
    private static final String BOS_DESIGNER_PLUGIN = "bos-botp-formplugin";
    private static final String ENABLE = "enable";
    private MainEntityType srcMainType;
    private MainEntityType tgtMainType;
    private AbstractFormPlugin plugin;

    public RuleFormHelper(AbstractFormPlugin plugin) {
        this.plugin = plugin;
    }

    public Map<String, ComboItem> buildSourceBillTypeItems() {
        LinkedHashMap<String, ComboItem> items = new LinkedHashMap<String, ComboItem>(16);
        ComboItem all = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8\u7c7b\u578b", (String)"ConvertRuleEdit_15", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "All");
        items.put(all.getValue(), all);
        ComboItem other = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0a\u8ff0\u7c7b\u578b\u4e4b\u5916", (String)"ConvertRuleEdit_16", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "Others");
        items.put(other.getValue(), other);
        Map<Object, Object> objs = new HashMap();
        if (this.getSrcMainType() != null) {
            objs = this.loadBillTypeObjs(this.srcMainType.getName());
        }
        for (DynamicObject obj : objs.values()) {
            String enable = obj.getString(ENABLE);
            String id = String.valueOf(obj.getPkValue());
            String name = obj.get("name").toString();
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)"1", (CharSequence)enable)) {
                name = String.format(ResManager.loadKDString((String)"%s(\u5df2\u7981\u7528)", (String)"ConvertRuleEdit_17", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), name);
            }
            ComboItem item = new ComboItem(new LocaleString(name), id);
            items.put(item.getValue(), item);
        }
        return items;
    }

    public Map<String, ComboItem> buildTargetBillTypeItems() {
        LinkedHashMap<String, ComboItem> items = new LinkedHashMap<String, ComboItem>(16);
        Map<Object, Object> objs = new HashMap(16);
        if (this.getTgtMainType() != null) {
            objs = this.loadBillTypeObjs(this.tgtMainType.getName());
        }
        for (DynamicObject obj : objs.values()) {
            String enable = obj.getString(ENABLE);
            String id = String.valueOf(obj.getPkValue());
            String name = obj.get("name").toString();
            if (!StringUtils.equals((CharSequence)"1", (CharSequence)enable)) {
                name = String.format(ResManager.loadKDString((String)"%s(\u5df2\u7981\u7528)", (String)"ConvertRuleEdit_17", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), name);
            }
            ComboItem item = new ComboItem(new LocaleString(name), id);
            items.put(item.getValue(), item);
        }
        return items;
    }

    public MainEntityType getSrcMainType() {
        String srcEntityNumber;
        if (this.srcMainType == null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(srcEntityNumber = this.getSourceEntityNumber()))) {
            this.srcMainType = EntityMetadataCache.getDataEntityType((String)srcEntityNumber);
        }
        return this.srcMainType;
    }

    public MainEntityType getTgtMainType() {
        String tgtEntityNumber;
        if (this.tgtMainType == null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(tgtEntityNumber = this.getTargetEntityNumber()))) {
            this.tgtMainType = EntityMetadataCache.getDataEntityType((String)tgtEntityNumber);
        }
        return this.tgtMainType;
    }

    private Map<Object, DynamicObject> loadBillTypeObjs(String entityNumber) {
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)entityNumber)};
        return BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"id, number, name, status, enable, isdefault", (QFilter[])filters);
    }

    public String getSourceEntityNumber() {
        return RuleFormHelper.getSourceEntityNumber(this.plugin.getView());
    }

    public String getTargetEntityNumber() {
        return RuleFormHelper.getTargetEntityNumber(this.plugin.getView());
    }

    public static String getSourceEntityNumber(IFormView view) {
        return (String)view.getFormShowParameter().getCustomParam("SourceBill");
    }

    public static String getTargetEntityNumber(IFormView view) {
        return (String)view.getFormShowParameter().getCustomParam("TargetBill");
    }
}

