/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp.extcontrol.domain;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.designer.botp.extcontrol.helper.CarryParamDataHelper;
import kd.bos.designer.botp.extcontrol.model.CarryEntryRowExtControlModel;
import kd.bos.designer.botp.extcontrol.model.CarryExtControlModel;
import kd.bos.designer.botp.extcontrol.model.CarryFieldExtControlModel;
import kd.bos.designer.botp.extcontrol.model.factory.ExtControlModelFactory;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.extcontrol.ExtControlElement;
import kd.bos.form.IFormView;
import kd.bos.metadata.botp.ConvertRuleMetadata;
import kd.bos.metadata.botp.common.RuleIsvHelper;
import org.apache.commons.lang3.StringUtils;

public class ExtControlCarryDomain {
    private Map<Integer, CarryExtControlModel> carryModelListener = ExtControlModelFactory.getCarryModelListener();
    private CarryParamDataHelper carryParamDataHelper;
    private Supplier<String> getSourceBillFunc;
    private Supplier<String> getTargetBillFunc;

    public ExtControlCarryDomain(Supplier<String> getSourceBillFunc, Supplier<String> getTargetBillFunc) {
        this(getSourceBillFunc, getTargetBillFunc, new CarryParamDataHelper());
    }

    public ExtControlCarryDomain(Supplier<String> getSourceBillFunc, Supplier<String> getTargetBillFunc, CarryParamDataHelper carryParamDataHelper) {
        this.carryParamDataHelper = carryParamDataHelper;
        this.getSourceBillFunc = getSourceBillFunc;
        this.getTargetBillFunc = getTargetBillFunc;
    }

    public boolean enableNew() {
        if (RuleIsvHelper.isKindeeIsv()) {
            return true;
        }
        String sourceBill = this.getSourceBillFunc.get();
        String targetBill = this.getTargetBillFunc.get();
        if (StringUtils.isBlank((CharSequence)sourceBill) || StringUtils.isBlank((CharSequence)targetBill)) {
            return false;
        }
        return this.carryParamDataHelper.isDisableCreateRule(sourceBill, targetBill) == false;
    }

    public boolean enableCarry() {
        if (RuleIsvHelper.isKindeeIsv()) {
            return false;
        }
        String sourceBill = this.getSourceBillFunc.get();
        String targetBill = this.getTargetBillFunc.get();
        if (StringUtils.isBlank((CharSequence)sourceBill) || StringUtils.isBlank((CharSequence)targetBill)) {
            return false;
        }
        return this.carryParamDataHelper.isEnableCarryCreateRule(sourceBill, targetBill);
    }

    public void visitExtControlButton(IFormView parentView) {
        parentView.setVisible(Boolean.valueOf(RuleIsvHelper.isKindeeIsv()), new String[]{"btn_control_create_rule"});
    }

    public void carryRule(ConvertRuleMetadata newMetadata, ConvertRuleMetadata templateRuleMeta) {
        if (!this.enableCarry()) {
            return;
        }
        ConvertRuleElement newRuleElement = newMetadata.getRuleElement();
        ConvertRuleElement templateRuleElement = templateRuleMeta.getRuleElement();
        List extElements = templateRuleElement.getExtElements();
        newRuleElement.setExtElements(extElements);
        for (ExtControlElement extElement : extElements) {
            CarryExtControlModel carryExtControlModel;
            if (extElement.getType() != ExtControlElement.TypeEnum.MULTISELECT_CONDITION.getType() || (carryExtControlModel = this.carryModelListener.get(extElement.getModelType())) == null) continue;
            if (carryExtControlModel instanceof CarryFieldExtControlModel) {
                ((CarryFieldExtControlModel)carryExtControlModel).carryField(newRuleElement, templateRuleElement, extElement);
            }
            if (!(carryExtControlModel instanceof CarryEntryRowExtControlModel)) continue;
            ((CarryEntryRowExtControlModel)carryExtControlModel).carryEntryRow(newRuleElement, templateRuleElement, extElement);
        }
    }
}

