/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp.extcontrol.helper;

import dm.jdbc.util.IDGenerator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.botp.common.WBRuleFormConst;
import kd.bos.designer.botp.extcontrol.common.WBExtControlConstant;
import kd.bos.designer.botp.extcontrol.helper.WBDataHelper;
import kd.bos.entity.botp.extcontrol.ExtControlParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class WBShowFormHelper
implements WBExtControlConstant,
WBRuleFormConst {
    private static final String CHILD_PAGEID = "child_pageid";
    private AbstractFormPlugin formPlugin;
    private DataTransferHelper dataTransferHelper;
    private WBDataHelper dataHelper;

    public WBShowFormHelper(AbstractFormPlugin formPlugin) {
        this.formPlugin = formPlugin;
        this.dataTransferHelper = new DataTransferHelper();
        this.dataHelper = new WBDataHelper();
    }

    public void unshowExtCloseFlex(boolean close) {
        this.dataHelper.doReceiveXML(this.formPlugin, this.getChildPageId());
        this.clearChildPageId();
        if (close) {
            this.formPlugin.getPageCache().put("PAGECACHE_KEY_FLEX_SHOW", Boolean.FALSE.toString());
            this.formPlugin.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_extclose"});
            this.formPlugin.getView().setVisible(Boolean.valueOf(false), new String[]{"button_down_extclose"});
            this.formPlugin.getView().setVisible(Boolean.valueOf(true), new String[]{"button_up_extclose"});
        }
    }

    public void showExtControlFlex(String formId) {
        this.formPlugin.getPageCache().put("PAGECACHE_KEY_FLEX_SHOW", Boolean.TRUE.toString());
        this.formPlugin.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_extclose"});
        FormShowParameter flexFormParameter = this.getFormShowParameter(formId);
        this.formPlugin.getView().showForm(flexFormParameter);
        this.formPlugin.getView().setVisible(Boolean.valueOf(true), new String[]{"button_down_extclose"});
        this.formPlugin.getView().setVisible(Boolean.valueOf(false), new String[]{"button_up_extclose"});
    }

    private FormShowParameter getFormShowParameter(String formId) {
        FormShowParameter flexFormParameter = new FormShowParameter();
        flexFormParameter.setFormId(formId);
        flexFormParameter.getOpenStyle().setTargetKey("flex_extclose");
        flexFormParameter.getOpenStyle().setShowType(ShowType.InContainer);
        flexFormParameter.setPageId(this.getChildPageId());
        this.dataTransferHelper.tryBuildRewriteFormula(flexFormParameter);
        this.dataTransferHelper.tryBuildBusinessRule(flexFormParameter);
        return flexFormParameter;
    }

    public String getChildPageId() {
        String childPageId = this.formPlugin.getPageCache().get(CHILD_PAGEID);
        if (StringUtils.isNotBlank((CharSequence)childPageId)) {
            return childPageId;
        }
        childPageId = IDGenerator.generateStrId();
        this.formPlugin.getPageCache().put(CHILD_PAGEID, childPageId);
        return childPageId;
    }

    private void clearChildPageId() {
        this.formPlugin.getPageCache().remove(CHILD_PAGEID);
    }

    class DataTransferHelper {
        DataTransferHelper() {
        }

        private void tryBuildRewriteFormula(FormShowParameter flexFormParameter) {
            ExtControlParam extControlParam = new ExtControlParam();
            DynamicObjectCollection entryEntity = WBShowFormHelper.this.formPlugin.getView().getModel().getEntryEntity("entryentity_wb");
            for (DynamicObject dynamicObject : entryEntity) {
                String fieldKey = String.valueOf(dynamicObject.get("wb_id"));
                String fieldName = (String)dynamicObject.get("wb_formuladesc");
                extControlParam.addParam(new ExtControlParam.Param(fieldKey, fieldName));
            }
            flexFormParameter.getCustomParams().put("formparmeter_customparam_rewriteformual_wb", SerializationUtils.toJsonString((Object)extControlParam));
        }

        private void tryBuildBusinessRule(FormShowParameter flexFormParameter) {
            ExtControlParam extControlParam = new ExtControlParam();
            DynamicObjectCollection entryEntity = WBShowFormHelper.this.formPlugin.getView().getModel().getEntryEntity("entryentity_br");
            for (DynamicObject dynamicObject : entryEntity) {
                String fieldKey = (String)dynamicObject.get("br_id");
                String fieldName = (String)dynamicObject.get("br_bizruletruedesc");
                extControlParam.addParam(new ExtControlParam.Param(fieldKey, fieldName));
            }
            flexFormParameter.getCustomParams().put("formparmeter_customparam_businessrule_wb", SerializationUtils.toJsonString((Object)extControlParam));
        }
    }
}

