/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp.extcontrol.model;

import java.util.List;
import java.util.Optional;
import kd.bos.designer.botp.extcontrol.common.PageLockModel;
import kd.bos.designer.botp.extcontrol.model.IExtControlModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;

public interface LockExtControlModel
extends IExtControlModel {
    public List<PageLockModel> buildLockModels(IFormView var1);

    default public void extendLock(IFormView parentFormView) {
        List<PageLockModel> pageLocks = this.buildLockModels(parentFormView);
        for (PageLockModel pageLock : pageLocks) {
            if (pageLock.getType() == 0 && pageLock.getLockFields() != null && pageLock.getLockFields().length > 0) {
                parentFormView.setEnable(Boolean.valueOf(false), pageLock.getLockFields());
                continue;
            }
            if (pageLock.getType() != 1 || !CollectionUtils.isNotEmpty(pageLock.getLockRows())) continue;
            EntryGrid grid = (EntryGrid)parentFormView.getControl(pageLock.getEntryGridNumber());
            grid.setRowLock(true, ArrayUtils.toPrimitive((Integer[])pageLock.getLockRowsArr()));
        }
    }

    default public void extendUnlock(IFormView parentFormView) {
        List<PageLockModel> pageLocks = this.buildLockModels(parentFormView);
        for (PageLockModel pageLock : pageLocks) {
            if (pageLock.getType() == 0 && pageLock.getLockFields() != null && pageLock.getLockFields().length > 0) {
                parentFormView.setEnable(Boolean.valueOf(true), pageLock.getLockFields());
                continue;
            }
            if (pageLock.getType() != 1 || !CollectionUtils.isNotEmpty(pageLock.getLockRows())) continue;
            EntryGrid grid = (EntryGrid)parentFormView.getControl(pageLock.getEntryGridNumber());
            grid.setRowLock(false, ArrayUtils.toPrimitive((Integer[])pageLock.getLockRowsArr()));
        }
    }

    default public Optional<PageLockModel> extendNoLink(IFormView parentFormView) {
        List<PageLockModel> pageLocks = this.buildLockModels(parentFormView);
        for (PageLockModel pageLock : pageLocks) {
            if (pageLock.getType() != 1 || !CollectionUtils.isNotEmpty(pageLock.getLockRows()) || !CollectionUtils.isNotEmpty(pageLock.getNoLinkNums())) continue;
            return Optional.of(pageLock);
        }
        return Optional.empty();
    }

    default public Optional<PageLockModel> extendButtonTip(IFormView parentFormView) {
        List<PageLockModel> pageLocks = this.buildLockModels(parentFormView);
        for (PageLockModel pageLock : pageLocks) {
            if (pageLock.getType() != 1 || !CollectionUtils.isNotEmpty(pageLock.getLockRows()) && !CollectionUtils.isNotEmpty(pageLock.getDelRows()) || !MapUtils.isNotEmpty(pageLock.getButtonForLockRows())) continue;
            return Optional.of(pageLock);
        }
        return Optional.empty();
    }
}

