/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp.extcontrol.model.convert;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.botp.extcontrol.common.PageLockModel;
import kd.bos.designer.botp.extcontrol.model.AbstractEntryExtControlModel;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.AttachmentPanelMapItem;
import kd.bos.entity.botp.AttachmentPanelMapPolicy;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.extcontrol.ExtControlElement;
import kd.bos.entity.botp.extcontrol.ExtControlParam;
import kd.bos.entity.botp.extcontrol.enums.ExtControlModelEnum;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

public class AttachmentMappingModel
extends AbstractEntryExtControlModel {
    @Override
    public ExtControlModelEnum getModelEnum() {
        return ExtControlModelEnum.ATTACHMENT_MAPPING;
    }

    @Override
    public String getTitle() {
        return ResManager.loadKDString((String)"\u9644\u4ef6\u9762\u677f\u6620\u5c04\u53ef\u4fee\u6539\u914d\u7f6e", (String)"AttachmentMappingModel_0", (String)"bos-botp-formplugin", (Object[])new Object[0]);
    }

    @Override
    public String getTableColName() {
        return ResManager.loadKDString((String)"\u76ee\u6807\u5355\u9644\u4ef6\u9762\u677f", (String)"AttachmentMappingModel_1", (String)"bos-botp-formplugin", (Object[])new Object[0]);
    }

    @Override
    public String getTabKeyInParentView() {
        return "tabpageap";
    }

    @Override
    public ExtControlParam buildParamExtclose4MultiSelectRow(FormShowParameter formShowParameter) {
        ExtControlParam extControlParam = new ExtControlParam();
        Optional<MainEntityType> mainType = this.getTgtMainType(formShowParameter);
        if (!mainType.isPresent()) {
            return extControlParam;
        }
        List<ControlAp<?>> attachmentPanels = this.getAttachmentPanels(mainType.get().getName());
        for (ControlAp<?> attachmentPanel : attachmentPanels) {
            extControlParam.addParam(new ExtControlParam.Param(attachmentPanel.getKey(), attachmentPanel.getName().getLocaleValue()));
        }
        return extControlParam;
    }

    private Optional<MainEntityType> getTgtMainType(FormShowParameter formShowParameter) {
        String tgtEntityNumber = (String)formShowParameter.getCustomParam("TargetBill");
        if (StringUtils.isBlank((CharSequence)tgtEntityNumber)) {
            return Optional.empty();
        }
        return Optional.ofNullable(EntityMetadataCache.getDataEntityType((String)tgtEntityNumber));
    }

    private List<ControlAp<?>> getAttachmentPanels(String formId) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        List<ControlAp<?>> aps = formMetadata.getItems().stream().filter(item -> item instanceof AttachmentPanelAp).sorted((o1, o2) -> {
            int compareValue = 0;
            compareValue = o1.getParentId() == null && o2.getParentId() == null ? 0 : (o1.getParentId() == null && o2.getParentId() != null ? -1 : (o1.getParentId() != null && o2.getParentId() == null ? 1 : o1.getParentId().compareTo(o2.getParentId())));
            if (compareValue != 0) {
                return compareValue;
            }
            return Integer.compare(o1.getIndex(), o2.getIndex());
        }).collect(Collectors.toList());
        return aps;
    }

    @Override
    protected PageLockModel buildPageLockForMultiSelect(IFormView parentFormView) {
        Set<Integer> rows = this.matchEntryRow(parentFormView, "attachmentpanelmappolicy", "targetattachmentpanel", false);
        return PageLockModel.createInstanceByRows("attachmentpanelmappolicy", rows);
    }

    @Override
    public Method getReadMethodFromEntryPk() throws Exception {
        PropertyDescriptor searchPropertyDesc = PropertyUtils.getPropertyDescriptor((Object)new AttachmentPanelMapItem(), (String)"targetAttachmentPanel");
        return searchPropertyDesc.getReadMethod();
    }

    @Override
    public Class getCarryType() {
        return AttachmentPanelMapPolicy.class;
    }

    @Override
    public Object getCarryObject(ConvertRuleElement ruleElement) {
        return ruleElement.getAttachmentPanelMapPolicy();
    }

    @Override
    public Set<String> getNameProperties(ExtControlElement multiSelectExtElement) {
        Set<String> namePropertiesForAttachmentMaping = multiSelectExtElement.getExtControlParam().getParams().stream().filter(ExtControlParam.Param::isEnable).map(ExtControlParam.Param::getKey).collect(Collectors.toSet());
        return namePropertiesForAttachmentMaping;
    }
}

