/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp.extcontrol.plugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.extcontrol.common.ExtControlConstant;
import kd.bos.designer.botp.extcontrol.helper.ControlApHelper;
import kd.bos.designer.botp.extcontrol.helper.ControlHelper;
import kd.bos.designer.botp.extcontrol.helper.DataHelper;
import kd.bos.designer.botp.extcontrol.helper.EntityTypeHelper;
import kd.bos.designer.botp.extcontrol.model.ViewExtControlModel;
import kd.bos.designer.botp.extcontrol.model.convert.DataRangeModel;
import kd.bos.designer.botp.extcontrol.model.factory.ExtControlModelFactory;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.extcontrol.ExtControlParam;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.EntryGridColAllCheckedEvent;
import kd.bos.form.control.events.EntryGridColAllCheckedListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;

public class ExtControlEdit
extends AbstractFormPlugin
implements ExtControlConstant,
EntryGridBindDataListener,
EntryGridColAllCheckedListener {
    private static final Log log = LogFactory.getLog(ExtControlEdit.class);
    private Map<String, ViewExtControlModel> extControlModelByTabKey;
    private DataHelper dataHelper;

    public ExtControlEdit() {
        List<ViewExtControlModel> extControlModelListenter = ExtControlModelFactory.getViewModelListener();
        this.extControlModelByTabKey = extControlModelListenter.stream().collect(Collectors.toMap(ViewExtControlModel::getTabKeyInParentView, view -> view));
        this.dataHelper = new DataHelper();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("flex_multi_select_entry");
        entryGrid.addColAllCheckedListener((EntryGridColAllCheckedListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().getDataEntity(true);
        this.getModel().setValue("text_title", (Object)this.getTitle());
        this.getModel().setValue("text_desc", (Object)this.getTitleDesc());
        EntryGrid grid = (EntryGrid)this.getView().getControl("flex_multi_select_entry");
        grid.setColumnProperty("text_table_title", "header", (Object)this.getTableColName());
        ExtControlParam extControlParam = this.buildParamExtclose4MultiSelectRow();
        if (extControlParam.getParams().size() > 0) {
            this.getModel().batchCreateNewEntryRow("flex_multi_select_entry", extControlParam.getParams().size());
        }
        String tabKey = (String)this.getView().getFormShowParameter().getCustomParam("tab_select");
        for (int i = 0; i < extControlParam.getParams().size(); ++i) {
            this.getModel().setValue("text_table_title_number", (Object)((ExtControlParam.Param)extControlParam.getParams().get(i)).getKey(), i);
            this.getModel().setValue("text_table_title", (Object)((ExtControlParam.Param)extControlParam.getParams().get(i)).getDesc(), i);
            if (!((ExtControlParam.Param)extControlParam.getParams().get(i)).isMustInputDisable()) continue;
            this.setLockMapCache("check_table_title_col_3", i);
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"check_table_title_col_3"});
            if (tabKey == null || !tabKey.equals("tbpage_link")) continue;
            this.getModel().setValue("check_table_title_col_3", (Object)true, i);
        }
        if (tabKey != null && (tabKey.equals("tbpage_filter") || tabKey.equals("tbpage_updatedata") || tabKey.equals("tbpage_plugin") || tabKey.equals("adv_filter") || tabKey.equals("tabpage_billtype"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"check_table_title_col_3"});
            if (this.extControlModelByTabKey.get(tabKey) instanceof DataRangeModel) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"check_table_title_col_4"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"check_table_title_col_4"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"check_table_title_col_4"});
        }
        ViewExtControlModel extControlFlexModel = this.choseTabPage(null);
        this.dataHelper.loadView(this, extControlFlexModel);
        this.getView().getParentView().hideLoading();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"text_table_title_number"});
    }

    private ViewExtControlModel choseTabPage(FormShowParameter formShowParameter) {
        String tabKey;
        if (formShowParameter == null) {
            formShowParameter = this.getView().getFormShowParameter();
        }
        if (StringUtils.isBlank((CharSequence)(tabKey = (String)formShowParameter.getCustomParam("tab_select")))) {
            tabKey = "tbpage_base";
        }
        return this.extControlModelByTabKey.get(tabKey);
    }

    private String getTitle() {
        ViewExtControlModel extControlFlexModel = this.choseTabPage(null);
        return extControlFlexModel.getTitle();
    }

    private String getTitleDesc() {
        ViewExtControlModel extControlFlexModel = this.choseTabPage(null);
        return extControlFlexModel.getTitleDesc();
    }

    private String getTableColName() {
        ViewExtControlModel extControlFlexModel = this.choseTabPage(null);
        return extControlFlexModel.getTableColName();
    }

    protected ExtControlParam buildParamExtclose4GlobalConditionCol() {
        ViewExtControlModel extControlFlexModel = this.choseTabPage(null);
        return extControlFlexModel.buildParamExtclose4GlobalConditionCol();
    }

    protected ExtControlParam buildParamExtclose4GlobalConditionCol(FormShowParameter formShowParameter) {
        ViewExtControlModel extControlFlexModel = this.choseTabPage(formShowParameter);
        return extControlFlexModel.buildParamExtclose4GlobalConditionCol();
    }

    private ExtControlParam buildParamExtclose4MultiSelectRow() {
        ViewExtControlModel extControlFlexModel = this.choseTabPage(null);
        return extControlFlexModel.buildParamExtclose4MultiSelectRow(this.getView().getFormShowParameter());
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter source = (FormShowParameter)e.getSource();
        FlexPanelAp flexPanelAp4GlobalCondition = new ControlApHelper(this.buildParamExtclose4GlobalConditionCol(source)).buildGlobalCondition();
        HashMap<String, String> map4GlobalCondition = new HashMap<String, String>();
        map4GlobalCondition.put("id", flexPanelAp4GlobalCondition.getKey());
        map4GlobalCondition.put("items", (String)flexPanelAp4GlobalCondition.createControl().get("items"));
        e.getItems().add(map4GlobalCondition);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        Optional<Control> control = ControlHelper.createControl(this.getView(), e.getKey());
        control.ifPresent(arg_0 -> ((OnGetControlArgs)e).setControl(arg_0));
        if (e.getKey().equals("flex_global_condition")) {
            Container container4GlobalCondition = new Container();
            container4GlobalCondition.setKey(e.getKey());
            container4GlobalCondition.setView(this.getView());
            container4GlobalCondition.setModel(this.getView().getModel());
            new ControlHelper(this.getView(), this.buildParamExtclose4GlobalConditionCol()).buildGlobalCondition(container4GlobalCondition);
            e.setControl((Control)container4GlobalCondition);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException ex) {
            log.info(ex.getMessage());
        }
        new EntityTypeHelper(this.buildParamExtclose4GlobalConditionCol()).buildGlobalCondition((EntityType)newMainType);
        e.setNewEntityType(newMainType);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Container container4GlobalCondition = (Container)this.getView().getControl("flex_global_condition");
        new ControlHelper(this.getView(), this.buildParamExtclose4GlobalConditionCol()).buildGlobalCondition(container4GlobalCondition);
        this.getView().createControlIndex(container4GlobalCondition.getItems());
    }

    public void entryGridColAllChecked(EntryGridColAllCheckedEvent e) {
        boolean oldValue;
        int i;
        e.setCancel(true);
        EntryGrid entryGrid = (EntryGrid)this.getControl("flex_multi_select_entry");
        int startIndex = 0;
        int endIndex = entryGrid.getModel().getEntryRowCount("flex_multi_select_entry");
        String locks = this.getPageCache().get("lockMap");
        Map lockMap = new HashMap(16);
        if (StringUtils.isNotBlank((CharSequence)locks)) {
            lockMap = (Map)SerializationUtils.fromJsonString((String)locks, Map.class);
        }
        List rows = (List)lockMap.get(e.getColKey());
        HashSet<Integer> rowSet = new HashSet<Integer>(16);
        if (rows != null) {
            for (i = startIndex; i < endIndex; ++i) {
                if (rows.contains(i) || (oldValue = ((Boolean)this.getModel().getValue(e.getColKey(), i)).booleanValue()) == e.isChecked()) continue;
                this.getModel().setValue(e.getColKey(), (Object)e.isChecked(), i);
                rowSet.add(i);
            }
        } else {
            for (i = startIndex; i < endIndex; ++i) {
                oldValue = (Boolean)this.getModel().getValue(e.getColKey(), i);
                if (oldValue == e.isChecked()) continue;
                this.getModel().setValue(e.getColKey(), (Object)e.isChecked(), i);
                rowSet.add(i);
            }
        }
        String changeRows = this.getPageCache().get("changeRows");
        HashSet<Integer> changeRowsSet = null;
        if (StringUtils.isNotBlank((CharSequence)changeRows)) {
            changeRowsSet = (HashSet<Integer>)SerializationUtils.fromJsonString((String)changeRows, Set.class);
        }
        if (changeRowsSet == null) {
            changeRowsSet = new HashSet<Integer>();
        }
        changeRowsSet.addAll(rowSet);
        this.getPageCache().put("changeRows", SerializationUtils.toJsonString(changeRowsSet));
        this.setGridColAllValue("flex_multi_select_entry", e.getColKey(), e.isChecked());
    }

    private void setGridColAllValue(String entryGrid, String colKey, boolean checked) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> ret = new HashMap<String, Object>(2);
        ret.put("c", colKey);
        ret.put("v", checked);
        clientViewProxy.invokeControlMethod(entryGrid, "setGridColAllValue", new Object[]{ret});
    }

    private void setLockMapCache(String feature, int i) {
        Map<String, HashSet<Integer>> lockMap = new HashMap(16);
        HashSet<Integer> rows = new HashSet<Integer>(10);
        String lock = this.getPageCache().get("lockMap");
        if (StringUtils.isNotBlank((CharSequence)lock) && (lockMap = (Map)SerializationUtils.fromJsonString((String)lock, Map.class)).get(feature) != null) {
            rows = new HashSet((Collection)lockMap.get(feature));
        }
        rows.add(i);
        lockMap.put(feature, rows);
        this.getPageCache().put("lockMap", SerializationUtils.toJsonString(lockMap));
    }
}

