/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.opbizrule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.botp.ConvertPath;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.metadata.entity.operation.AbstractOpBizRuleParameterEdit;
import kd.bos.metadata.entity.operation.PushAndSaveParameter;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.botp.CustomParamsUtil;

public class AutoPushOpBizPlugin
extends AbstractOpBizRuleParameterEdit {
    private static final String KEY_F_BILL = "targetbill";
    private static final String KEY_F_RULE = "rule";
    private static final String KEY_F_OPERATION = "afteroperation";
    private static final String KEY_CHECK_NEW_RIGHT = "checknewright";
    private static final String KEY_CHECK_SUBMIT_RIGHT = "checksubmitright";
    private static final String KEY_CHECK_AUDIT_RIGHT = "checkauditright";
    private static final String KEY_BATCH_PUSH = "batchpush";
    private static final String ALL_RULE = "@all";

    public void afterCreateNewData(EventObject arg0) {
        this.getModel().setValue(KEY_F_BILL, this.getOriParameterValue("targetBill", ""));
        this.getModel().setValue(KEY_F_RULE, this.getOriParameterValue("ruleId", ALL_RULE));
        this.getModel().setValue(KEY_F_OPERATION, this.getOriParameterValue("afterOperation", "default"));
        if (this.getModel().getProperty(KEY_CHECK_NEW_RIGHT) != null) {
            this.getModel().setValue(KEY_CHECK_NEW_RIGHT, this.getOriParameterValue("checkNewRight", false));
        }
        if (this.getModel().getProperty(KEY_CHECK_SUBMIT_RIGHT) != null) {
            this.getModel().setValue(KEY_CHECK_SUBMIT_RIGHT, this.getOriParameterValue("checkSubmitRight", false));
        }
        if (this.getModel().getProperty(KEY_CHECK_AUDIT_RIGHT) != null) {
            this.getModel().setValue(KEY_CHECK_AUDIT_RIGHT, this.getOriParameterValue("checkAuditRight", false));
        }
        if (this.getModel().getProperty(KEY_BATCH_PUSH) != null) {
            this.getModel().setValue(KEY_BATCH_PUSH, this.getOriParameterValue("batchPush", false));
        }
    }

    public void afterBindData(EventObject e) {
        this.hideAudit();
        this.fillBillCombo();
        this.fillRuleCombo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equals((CharSequence)KEY_F_BILL, (CharSequence)e.getProperty().getName())) {
            this.fillRuleCombo();
        }
    }

    public boolean checkParameter() {
        String targetBill = (String)this.getModel().getValue(KEY_F_BILL);
        if (StringUtils.isBlank((CharSequence)targetBill)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4e0b\u63a8\u76ee\u6807\u5355\u3002", (String)"AutoPushOpBizPlugin_2", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public String getParameter() {
        PushAndSaveParameter parameter = new PushAndSaveParameter();
        parameter.setTargetBill((String)this.getModel().getValue(KEY_F_BILL));
        parameter.setRuleId((String)this.getModel().getValue(KEY_F_RULE));
        parameter.setAfterOperation((String)this.getModel().getValue(KEY_F_OPERATION));
        if (this.getModel().getProperty(KEY_CHECK_NEW_RIGHT) != null) {
            parameter.setCheckNewRight(((Boolean)this.getModel().getValue(KEY_CHECK_NEW_RIGHT)).booleanValue());
        }
        if (this.getModel().getProperty(KEY_CHECK_SUBMIT_RIGHT) != null) {
            parameter.setCheckSubmitRight(((Boolean)this.getModel().getValue(KEY_CHECK_SUBMIT_RIGHT)).booleanValue());
        }
        if (this.getModel().getProperty(KEY_CHECK_AUDIT_RIGHT) != null) {
            parameter.setCheckAuditRight(((Boolean)this.getModel().getValue(KEY_CHECK_AUDIT_RIGHT)).booleanValue());
        }
        if (this.getModel().getProperty(KEY_BATCH_PUSH) != null) {
            parameter.setBatchPush(((Boolean)this.getModel().getValue(KEY_BATCH_PUSH)).booleanValue());
        }
        return SerializationUtils.toJsonString((Object)parameter);
    }

    private void hideAudit() {
        if (this.getModel().getProperty(KEY_F_OPERATION) == null) {
            return;
        }
        ComboProp comboProp = (ComboProp)this.getModel().getProperty(KEY_F_OPERATION);
        ArrayList<ComboItem> billItems = new ArrayList<ComboItem>(8);
        List valueMapItems = comboProp.getComboItems();
        if (CollectionUtils.isEmpty((Collection)valueMapItems)) {
            return;
        }
        boolean hideAudit = CustomParamsUtil.getBooleanCusParams((String)"BOS_BOTP_AUTOPUSH_NOHIDE_AUDIT");
        for (ValueMapItem valueMapItem : valueMapItems) {
            ComboItem billItem = new ComboItem();
            billItem.setValue(valueMapItem.getValue());
            billItem.setCaption(valueMapItem.getName());
            billItem.setImageKey(valueMapItem.getImageKey());
            if (valueMapItem.getValue().equals("audit") && !hideAudit) {
                billItem.setItemVisible(false);
            }
            billItems.add(billItem);
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_F_OPERATION);
        billEditor.setComboItems(billItems);
    }

    private void fillBillCombo() {
        String srcEntityNumber = this.getEntityNumber();
        List convertPaths = ConvertMetaServiceHelper.loadAllConvertPaths();
        ArrayList<ComboItem> billItems = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        billItems.add(blankItem);
        for (ConvertPath path : convertPaths) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)srcEntityNumber, (CharSequence)path.getSourceEntityNumber())) continue;
            ComboItem billItem = new ComboItem();
            billItem.setValue(path.getTargetEntityNumber());
            billItem.setCaption(new LocaleString(Lang.defaultLang().toString(), path.getTargetEntityName()));
            billItems.add(billItem);
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_F_BILL);
        billEditor.setComboItems(billItems);
    }

    private void fillRuleCombo() {
        String srcEntityNumber = this.getEntityNumber();
        String targetEntityNumber = (String)this.getModel().getValue(KEY_F_BILL);
        List rules = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)targetEntityNumber)) {
            rules = ConvertMetaServiceHelper.loadRules((String)srcEntityNumber, (String)targetEntityNumber);
        }
        ArrayList<ComboItem> ruleItems = new ArrayList<ComboItem>(10);
        ComboItem blankItem = new ComboItem();
        blankItem.setValue(ALL_RULE);
        blankItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u5339\u914d\u89c4\u5219", (String)"AutoPushOpBizPlugin_1", (String)"bos-botp-formplugin", (Object[])new Object[0])));
        ruleItems.add(blankItem);
        for (ConvertRuleElement rule : rules) {
            ComboItem ruleItem = new ComboItem();
            ruleItem.setValue(rule.getId());
            ruleItem.setCaption(rule.getName());
            ruleItems.add(ruleItem);
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_F_RULE);
        billEditor.setComboItems(ruleItems);
    }
}

