/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.parameter;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertPath;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.operation.AbstractOpParameterPlugin;
import kd.bos.metadata.entity.operation.DrawParameter;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class DrawOpEditPlugin
extends AbstractOpParameterPlugin<DrawParameter> {
    private static final String KEY_HIDE_DRAW_FORM = "hidedrawform";
    private static final String KEY_DUPLICATE_REMOVE = "duplicateremove";
    private static final String KEY_DUPLICATE_ENTRY_REMOVE = "duplicateentryremove";
    private static final String KEY_SOURCE_BILL = "sourcebill";
    private static final String KEY_RULE = "rule";
    private static final String KEY_CLEARENTRYS = "clearentrys";
    private static final String BOS_DESIGNER_PLUGIN = "bos-botp-formplugin";

    public boolean check(StringBuilder sbMsg) {
        boolean hideDrawForm = (Boolean)this.getModel().getValue(KEY_HIDE_DRAW_FORM);
        String sourceBill = (String)this.getModel().getValue(KEY_SOURCE_BILL);
        String ruleId = (String)this.getModel().getValue(KEY_RULE);
        if (hideDrawForm) {
            if (StringUtils.isBlank((CharSequence)sourceBill) && StringUtils.isBlank((CharSequence)ruleId)) {
                sbMsg.append(ResManager.loadKDString((String)"\u60a8\u52fe\u9009\u4e86\u201c\u8df3\u8fc7\u9009\u5355\u754c\u9762\u201d\u9009\u9879\uff0c\u8bf7\u8bbe\u7f6e\u6e90\u5355\u3001\u8f6c\u6362\u89c4\u5219\u3002", (String)"DrawOpEditPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.isBlank((CharSequence)sourceBill)) {
                sbMsg.append(ResManager.loadKDString((String)"\u60a8\u52fe\u9009\u4e86\u201c\u8df3\u8fc7\u9009\u5355\u754c\u9762\u201d\u9009\u9879\uff0c\u8bf7\u8bbe\u7f6e\u6e90\u5355\u3002", (String)"DrawOpEditPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.isBlank((CharSequence)ruleId)) {
                sbMsg.append(ResManager.loadKDString((String)"\u60a8\u52fe\u9009\u4e86\u201c\u8df3\u8fc7\u9009\u5355\u754c\u9762\u201d\u9009\u9879\uff0c\u8bf7\u8bbe\u7f6e\u8f6c\u6362\u89c4\u5219\u3002", (String)"DrawOpEditPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected DrawParameter createNewOpParameter() {
        return new DrawParameter();
    }

    protected IDataEntityType getDataEntityType() {
        return DataEntityType.getDataEntityType(DrawParameter.class);
    }

    protected void showParameter(DrawParameter v) {
        this.getModel().setValue(KEY_HIDE_DRAW_FORM, (Object)v.isHideDrawForm());
        this.getModel().setValue(KEY_SOURCE_BILL, (Object)v.getSourceBill());
        this.getModel().setValue(KEY_RULE, (Object)v.getRuleId());
        this.getModel().setValue(KEY_CLEARENTRYS, (Object)v.getClearEntrys());
        this.getModel().setValue(KEY_DUPLICATE_REMOVE, (Object)v.isDuplicateRemove());
        this.getModel().setValue(KEY_DUPLICATE_ENTRY_REMOVE, (Object)v.isDuplicateEntryRemove());
    }

    protected void returnParameter(DrawParameter v) {
        v.setHideDrawForm(((Boolean)this.getModel().getValue(KEY_HIDE_DRAW_FORM)).booleanValue());
        v.setSourceBill((String)this.getModel().getValue(KEY_SOURCE_BILL));
        v.setRuleId((String)this.getModel().getValue(KEY_RULE));
        v.setClearEntrys((String)this.getModel().getValue(KEY_CLEARENTRYS));
        v.setDuplicateRemove(((Boolean)this.getModel().getValue(KEY_DUPLICATE_REMOVE)).booleanValue());
        v.setDuplicateEntryRemove(((Boolean)this.getModel().getValue(KEY_DUPLICATE_ENTRY_REMOVE)).booleanValue());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.showDuplicateEntryRemove();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillBillCombo();
        this.fillRuleCombo();
        this.fillClearEntrys();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equals((CharSequence)KEY_SOURCE_BILL, (CharSequence)e.getProperty().getName())) {
            this.fillRuleCombo();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_DUPLICATE_REMOVE, (CharSequence)e.getProperty().getName())) {
            this.showDuplicateEntryRemove();
        }
    }

    private void fillBillCombo() {
        EntityMetadata entityMetadata = this.getEntityMetadata();
        List<ComboItem> billItems = DrawOpEditPlugin.buildBillItems(entityMetadata);
        if (billItems != null) {
            ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_SOURCE_BILL);
            billEditor.setComboItems(billItems);
        }
    }

    private void fillRuleCombo() {
        EntityMetadata entityMetadata = this.getEntityMetadata();
        String targetEntityNumber = (String)this.getModel().getValue(KEY_SOURCE_BILL);
        List<ComboItem> ruleItems = DrawOpEditPlugin.buildRuleItems(entityMetadata, targetEntityNumber);
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_RULE);
        billEditor.setComboItems(ruleItems);
    }

    private void fillClearEntrys() {
        EntityMetadata entityMetadata = this.getEntityMetadata();
        List<ComboItem> entryItems = DrawOpEditPlugin.buildEntryItems(entityMetadata);
        ComboEdit entryEditor = (ComboEdit)this.getView().getControl(KEY_CLEARENTRYS);
        entryEditor.setComboItems(entryItems);
    }

    private void showDuplicateEntryRemove() {
        boolean duplicateremoveFlag = (Boolean)this.getModel().getValue(KEY_DUPLICATE_REMOVE);
        if (duplicateremoveFlag) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_DUPLICATE_ENTRY_REMOVE});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_DUPLICATE_ENTRY_REMOVE});
            this.getModel().setValue(KEY_DUPLICATE_ENTRY_REMOVE, (Object)false);
        }
    }

    public static List<ComboItem> buildBillItems(EntityMetadata entityMetadata) {
        if (entityMetadata == null) {
            return new ArrayList<ComboItem>();
        }
        String id = entityMetadata.getRootEntity().getId();
        String masterId = MetadataDao.getMasterId((String)id);
        String targetEntityNumber = MetadataDao.getNumberById((String)(StringUtils.isBlank((CharSequence)masterId) ? id : masterId));
        List convertPaths = ConvertMetaServiceHelper.loadAllConvertPaths();
        ArrayList<ComboItem> billItems = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        billItems.add(blankItem);
        for (ConvertPath path : convertPaths) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)targetEntityNumber, (CharSequence)path.getTargetEntityNumber())) continue;
            ComboItem billItem = new ComboItem();
            billItem.setValue(path.getSourceEntityNumber());
            billItem.setCaption(new LocaleString(Lang.defaultLang().toString(), path.getSourceEntityName()));
            billItems.add(billItem);
        }
        return billItems;
    }

    public static List<ComboItem> buildRuleItems(EntityMetadata targetEntityMetadata, String sourcetEntityNumber) {
        if (targetEntityMetadata == null) {
            return new ArrayList<ComboItem>();
        }
        String id = targetEntityMetadata.getRootEntity().getId();
        String masterId = MetadataDao.getMasterId((String)id);
        String targetEntityNumber = MetadataDao.getNumberById((String)(StringUtils.isBlank((CharSequence)masterId) ? id : masterId));
        List rules = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)sourcetEntityNumber)) {
            rules = ConvertMetaServiceHelper.loadRules((String)sourcetEntityNumber, (String)targetEntityNumber);
        }
        ArrayList<ComboItem> ruleItems = new ArrayList<ComboItem>(10);
        for (ConvertRuleElement rule : rules) {
            ComboItem ruleItem = new ComboItem();
            ruleItem.setValue(rule.getId());
            ruleItem.setCaption(rule.getName());
            ruleItems.add(ruleItem);
        }
        return ruleItems;
    }

    public static List<ComboItem> buildEntryItems(EntityMetadata targetEntityMetadata) {
        if (targetEntityMetadata == null) {
            return new ArrayList<ComboItem>();
        }
        ArrayList<ComboItem> entryItems = new ArrayList<ComboItem>(10);
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString(""));
        entryItems.add(blankItem);
        for (EntityItem entityItem : targetEntityMetadata.getItems()) {
            if (!(entityItem instanceof EntryEntity) || entityItem instanceof SubEntryEntity) continue;
            ComboItem entryItem = new ComboItem();
            entryItem.setValue(entityItem.getKey());
            entryItem.setCaption(entityItem.getName());
            entryItems.add(entryItem);
        }
        return entryItems;
    }
}

