/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.parameter;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.parameter.PushOpEditPlugin;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.AbstractOpParameterPlugin;
import kd.bos.metadata.entity.operation.PushAndSaveParameter;

public class PushAndSaveOpEditPlugin
extends AbstractOpParameterPlugin<PushAndSaveParameter> {
    private static final String KEY_BILL = "targetbill";
    private static final String KEY_RULE = "rule";
    private static final String KEY_OPTERATION = "afteroperation";
    private static final String KEY_HASRIGHT = "hasright";
    private static final String KEY_CHECKNEWRIGHT = "checknewright";
    private static final String KEY_CHECKSUBMITRIGHT = "checksubmitright";
    private static final String KEY_CHECKAUDITRIGHT = "checkauditright";
    private static final String KEY_BATCHPUSH = "batchpush";
    private static final String KEY_BATCHPUSHSIZE = "batchpushsize";

    public boolean check(StringBuilder sbMsg) {
        String targetBill = (String)this.getModel().getValue(KEY_BILL);
        if (StringUtils.isBlank((CharSequence)targetBill)) {
            sbMsg.append(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4e0b\u63a8\u76ee\u6807\u5355\u3002", (String)"PushAndSaveOpEditPlugin_0", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected PushAndSaveParameter createNewOpParameter() {
        return new PushAndSaveParameter();
    }

    protected IDataEntityType getDataEntityType() {
        return DataEntityType.getDataEntityType(PushAndSaveParameter.class);
    }

    protected void showParameter(PushAndSaveParameter v) {
        this.getModel().setValue(KEY_BILL, (Object)v.getTargetBill());
        this.getModel().setValue(KEY_RULE, (Object)v.getRuleId());
        this.getModel().setValue(KEY_OPTERATION, (Object)v.getTargetOperation());
        if (this.getModel().getProperty(KEY_HASRIGHT) != null) {
            this.getModel().setValue(KEY_HASRIGHT, (Object)v.isHasRight());
        }
        if (this.getModel().getProperty(KEY_CHECKNEWRIGHT) != null) {
            this.getModel().setValue(KEY_CHECKNEWRIGHT, (Object)v.isCheckNewRight());
        }
        if (this.getModel().getProperty(KEY_CHECKSUBMITRIGHT) != null) {
            this.getModel().setValue(KEY_CHECKSUBMITRIGHT, (Object)v.isCheckSubmitRight());
        }
        if (this.getModel().getProperty(KEY_CHECKAUDITRIGHT) != null) {
            this.getModel().setValue(KEY_CHECKAUDITRIGHT, (Object)v.isCheckAuditRight());
        }
        if (this.getModel().getProperty(KEY_BATCHPUSH) != null) {
            this.getModel().setValue(KEY_BATCHPUSH, (Object)v.isBatchPush());
        }
        if (this.getModel().getProperty(KEY_BATCHPUSHSIZE) != null) {
            this.getModel().setValue(KEY_BATCHPUSHSIZE, (Object)v.getBatchpushsize());
        }
    }

    protected void returnParameter(PushAndSaveParameter v) {
        v.setTargetBill((String)this.getModel().getValue(KEY_BILL));
        v.setRuleId((String)this.getModel().getValue(KEY_RULE));
        v.setTargetOperation((String)this.getModel().getValue(KEY_OPTERATION));
        if (this.getModel().getProperty(KEY_HASRIGHT) != null) {
            v.setHasRight(((Boolean)this.getModel().getValue(KEY_HASRIGHT)).booleanValue());
        }
        if (this.getModel().getProperty(KEY_CHECKNEWRIGHT) != null) {
            v.setCheckNewRight(((Boolean)this.getModel().getValue(KEY_CHECKNEWRIGHT)).booleanValue());
        }
        if (this.getModel().getProperty(KEY_CHECKSUBMITRIGHT) != null) {
            v.setCheckSubmitRight(((Boolean)this.getModel().getValue(KEY_CHECKSUBMITRIGHT)).booleanValue());
        }
        if (this.getModel().getProperty(KEY_CHECKAUDITRIGHT) != null) {
            v.setCheckAuditRight(((Boolean)this.getModel().getValue(KEY_CHECKAUDITRIGHT)).booleanValue());
        }
        if (this.getModel().getProperty(KEY_BATCHPUSH) != null) {
            v.setBatchPush(((Boolean)this.getModel().getValue(KEY_BATCHPUSH)).booleanValue());
        }
        if (this.getModel().getProperty(KEY_BATCHPUSHSIZE) != null) {
            v.setBatchpushsize(((Integer)this.getModel().getValue(KEY_BATCHPUSHSIZE)).intValue());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillBillCombo();
        this.fillRuleCombo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equals((CharSequence)KEY_BILL, (CharSequence)e.getProperty().getName())) {
            this.fillRuleCombo();
        }
    }

    private void fillBillCombo() {
        EntityMetadata entityMetadata = this.getEntityMetadata();
        List<ComboItem> billItems = PushOpEditPlugin.buildBillItems(entityMetadata);
        if (billItems != null) {
            ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_BILL);
            billEditor.setComboItems(billItems);
        }
    }

    private void fillRuleCombo() {
        EntityMetadata entityMetadata = this.getEntityMetadata();
        String targetEntityNumber = (String)this.getModel().getValue(KEY_BILL);
        List<ComboItem> ruleItems = PushOpEditPlugin.buildRuleItems(entityMetadata, targetEntityNumber);
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_RULE);
        billEditor.setComboItems(ruleItems);
    }
}

