/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.parameter;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.AbstractOpParameterPlugin;
import kd.bos.metadata.entity.operation.TrackDownParameter;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class TrackDownOpEditPlugin
extends AbstractOpParameterPlugin<TrackDownParameter> {
    private static final String KEY_TRACKALL = "trackall";
    private static final String KEY_SEARCHENTRY = "searchentry";
    private static final String KEY_SPECTARGETBILL = "spectargetbill";
    private static final String KEY_BILL = "targetbill";
    private static final String KEY_CHECK_RIGHT_BILL = "checkRightBill";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    protected TrackDownParameter createNewOpParameter() {
        return new TrackDownParameter();
    }

    protected IDataEntityType getDataEntityType() {
        return DataEntityType.getDataEntityType(TrackDownParameter.class);
    }

    public boolean check(StringBuilder arg0) {
        return true;
    }

    protected void showParameter(TrackDownParameter v) {
        this.setTrackAll(v.isTrackAll());
        this.setSearchEntry(v.isSearchEntry());
        if (StringUtils.isBlank((CharSequence)v.getTargetBill())) {
            this.getModel().setValue(KEY_BILL, (Object)"");
            this.setSpecTargetBill(false);
        } else {
            this.getModel().setValue(KEY_BILL, (Object)v.getTargetBill());
            this.setSpecTargetBill(true);
        }
        if (this.getModel().getProperty(KEY_CHECK_RIGHT_BILL) != null) {
            this.getModel().setValue(KEY_CHECK_RIGHT_BILL, (Object)v.getCheckRightBill());
        }
        this.fillBillCombo();
    }

    protected void returnParameter(TrackDownParameter v) {
        v.setTrackAll(this.isTrackAll());
        v.setSearchEntry(this.isSearchEntry());
        boolean specTargetBill = this.getSpecTargetBill();
        if (!specTargetBill) {
            v.setTargetBill(null);
        } else {
            String bill = (String)this.getModel().getValue(KEY_BILL);
            v.setTargetBill(bill);
        }
        if (this.getModel().getProperty(KEY_CHECK_RIGHT_BILL) != null) {
            v.setCheckRightBill((String)this.getModel().getValue(KEY_CHECK_RIGHT_BILL));
        }
    }

    private void fillBillCombo() {
        EntityMetadata entityMetadata = this.getEntityMetadata();
        if (entityMetadata == null) {
            return;
        }
        List<ComboItem> billItems = TrackDownOpEditPlugin.buildBillItems(entityMetadata);
        if (billItems != null) {
            ComboEdit billEditors = (ComboEdit)this.getView().getControl(KEY_BILL);
            billEditors.setComboItems(billItems);
            ComboEdit checkRightEditors = (ComboEdit)this.getView().getControl(KEY_CHECK_RIGHT_BILL);
            if (checkRightEditors != null) {
                checkRightEditors.setComboItems(billItems);
            }
        }
    }

    public static List<ComboItem> buildBillItems(EntityMetadata entityMetadata) {
        String id = entityMetadata.getRootEntity().getId();
        String masterId = MetadataDao.getMasterId((String)id);
        String srcEntityNumber = MetadataDao.getNumberById((String)(StringUtils.isBlank((CharSequence)masterId) ? id : masterId));
        List bills = ConvertMetaServiceHelper.loadConvertBills((String)srcEntityNumber, (ConvertOpType)ConvertOpType.Push);
        ArrayList<ComboItem> billItems = new ArrayList<ComboItem>(10);
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        billItems.add(blankItem);
        for (ConvertBill bill : bills) {
            ComboItem billItem = new ComboItem();
            billItem.setValue(bill.getEntityNumber());
            billItem.setCaption(new LocaleString(Lang.defaultLang().toString(), bill.getEntityName()));
            billItems.add(billItem);
        }
        return billItems;
    }

    private boolean getSpecTargetBill() {
        if (this.getModel().getProperty(KEY_SPECTARGETBILL) == null) {
            return true;
        }
        return (Boolean)this.getModel().getValue(KEY_SPECTARGETBILL);
    }

    private void setSpecTargetBill(boolean value) {
        if (this.getModel().getProperty(KEY_SPECTARGETBILL) != null) {
            this.getModel().setValue(KEY_SPECTARGETBILL, (Object)value);
        }
    }

    private boolean isTrackAll() {
        if (this.getModel().getProperty(KEY_TRACKALL) == null) {
            return false;
        }
        return (Boolean)this.getModel().getValue(KEY_TRACKALL);
    }

    private void setTrackAll(boolean value) {
        if (this.getModel().getProperty(KEY_TRACKALL) != null) {
            this.getModel().setValue(KEY_TRACKALL, (Object)value);
        }
    }

    private boolean isSearchEntry() {
        if (this.getModel().getProperty(KEY_SEARCHENTRY) == null) {
            return false;
        }
        return (Boolean)this.getModel().getValue(KEY_SEARCHENTRY);
    }

    private void setSearchEntry(boolean value) {
        if (this.getModel().getProperty(KEY_SEARCHENTRY) != null) {
            this.getModel().setValue(KEY_SEARCHENTRY, (Object)value);
        }
    }
}

