/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin.botp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.hosting.SVNUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.plugin.botp.RuleCompatibleImport;
import kd.bos.devportal.plugin.botp.ShaUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.CustomParam;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.balance.DesignBalanceRuleMeta;
import kd.bos.metadata.balance.DesignBalanceRuleMetaL;
import kd.bos.metadata.botp.DesignConvertRuleMeta;
import kd.bos.metadata.botp.DesignWriteBackRuleMeta;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.orm.query.QFilter;
import kd.bos.param.impl.ParameterReaderServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class BOTPFileUtil {
    private static final Log logger = LogFactory.getLog(BOTPFileUtil.class);
    private static final String SUBPATH_METADATA = "metadata";
    public static final String Type_ConvertRule = "cr";
    public static final String Type_WriteBackRule = "wb";
    public static final String Type_BalanceUpdateRule = "bur";
    private static final String KEY_ERROR = "error";
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";
    private String ruleType;
    private MainEntityType targetMainEntityType;
    private MainEntityType sourceMainEntityType;
    private static final String IGNORE_IMPORT_EXT_CHECK_PARAM_KEY = "ignoreImportExtCheckParamKey";

    public BOTPFileUtil(String ruleType) {
        this.ruleType = ruleType;
    }

    public FormShowParameter buildExportShowParameter() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_exportpath");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }

    public String exportRule(String exportPath, String[] ruleIds, JSONObject exportResult) {
        ArrayList<String> exportFiles = new ArrayList<String>();
        this.exportRulesFile(exportPath, ruleIds, exportFiles, exportResult);
        if (exportResult.get((Object)KEY_ERROR) != null) {
            return "";
        }
        this.zipFiles(ruleIds[0], exportPath);
        AppUtils.deleteFiles((String)exportPath);
        exportResult.put("success", (Object)ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"BOTPFileUtil_19", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
        File zipFile = new File(DevportalUtil.checkFilePath((String)(exportPath + File.separator + ruleIds[0] + ".zip")));
        if (zipFile.exists()) {
            return zipFile.getPath();
        }
        return "";
    }

    public FormShowParameter buildImportShowParameter() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_importfile");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }

    public boolean importRule(String zipFileName, JSONObject importResult) {
        String localPath = DevportalUtil.unZipSingleFile((String)zipFileName, (JSONObject)importResult);
        if (importResult.get((Object)KEY_ERROR) != null) {
            return false;
        }
        String xmlFileSuffix = "." + this.ruleType;
        String langFileSuffix = "." + this.ruleType + "x";
        String MetadataFilePath = localPath + File.separator + SUBPATH_METADATA;
        String checkMetadataFilePath = DevportalUtil.checkFilePath((String)MetadataFilePath);
        File MetadataFile = new File(checkMetadataFilePath);
        String[] MetadataFileList = MetadataFile.list();
        for (int i = 0; i < MetadataFileList.length; ++i) {
            String fullFileName;
            File file;
            String fileName = MetadataFileList[i];
            if (!fileName.endsWith(xmlFileSuffix) && !fileName.endsWith(langFileSuffix) || !(file = new File(fullFileName = checkMetadataFilePath + File.separator + fileName)).exists()) continue;
            Path filePath = Paths.get(DevportalUtil.checkFilePath((String)fullFileName), new String[0]);
            try (InputStream in = Files.newInputStream(filePath, new OpenOption[0]);){
                byte[] b = new byte[(int)file.length()];
                int count = 0;
                while ((count = in.read(b)) > 0) {
                    String content = new String(b, StandardCharsets.UTF_8);
                    MetadataDao.deployMetadata((String)content, null, null);
                }
                continue;
            }
            catch (IOException e) {
                importResult.put(KEY_ERROR, (Object)String.format(ResManager.loadKDString((String)"%s\u683c\u5f0f\u6587\u4ef6\u5bfc\u5165\u51fa\u9519\u3002", (String)"BOTPFileUtil_11", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), this.ruleType));
            }
        }
        AppUtils.deleteFiles((String)localPath);
        importResult.put("success", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"BOTPFileUtil_10", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean uploadRule(String fileUrl, JSONObject importResult) {
        String xmlFileSuffix = "." + this.ruleType;
        String langFileSuffix = "." + this.ruleType + "x";
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        TempFileCacheDownloadable.Content zipContent = null;
        TempFileCacheDownloadable.Content zipCodeContent = null;
        try {
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>(queryParams.length);
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            zipContent = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
            zipCodeContent = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
        }
        catch (MalformedURLException exp) {
            logger.error("import error\uff1a" + exp);
            importResult.put("ERROR", (Object)exp);
            return false;
        }
        int limitsiz = 0x500000;
        HashMap<String, String> map = new HashMap<String, String>(16);
        ShaUtil.getCode(zipCodeContent.getInputStream(), limitsiz, map);
        try (InputStream inStream = zipContent.getInputStream();
             ZipInputStream zipIn = new ZipInputStream(inStream);){
            ZipEntry zipEntry = null;
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                String metaName = zipEntry.getName();
                if (!metaName.startsWith(SUBPATH_METADATA)) {
                    importResult.put("ERROR", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u4e0e\u5bfc\u51fa\u7684\u6587\u4ef6\u683c\u5f0f\u5fc5\u987b\u4fdd\u6301\u4e00\u81f4\u3002", (String)"BOTPFileUtil_12", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
                    boolean bl = false;
                    return bl;
                }
                int readLength = 0;
                int len = 0;
                byte[] buf = new byte[limitsiz];
                if (!metaName.endsWith(xmlFileSuffix) && !metaName.endsWith(langFileSuffix)) continue;
                while ((readLength = zipIn.read()) != -1) {
                    buf[len] = (byte)readLength;
                    ++len;
                }
                String xmlContent = new String(buf, 0, len, "UTF-8");
                if (metaName.endsWith(Type_ConvertRule) || metaName.endsWith(Type_WriteBackRule)) {
                    boolean flag;
                    boolean bl;
                    RuleCompatibleImport ruleCompatibleImport = new RuleCompatibleImport(0);
                    Document document = DocumentHelper.parseText((String)xmlContent);
                    String fileName = metaName.substring(metaName.lastIndexOf("/") + 1);
                    String shaCode = ShaUtil.encryptSha256Salt(xmlContent, fileName);
                    if (map.size() > 0 && !shaCode.equals(map.get(fileName.substring(0, fileName.lastIndexOf("."))))) {
                        importResult.put("ImportDataWarnMsg", (Object)ResManager.loadKDString((String)"\u51fa\u5382\u89c4\u5219\u5b58\u5728\u5bfc\u5165\u9632\u7be1\u6539\u63a7\u5236\uff0c\u4ec5\u5141\u8bb8\u5bfc\u5165\u7b26\u5408\u51fa\u5382\u89c4\u5219\u7ba1\u63a7\u7b56\u7565\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"BOTPFileUtil_6", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
                        bl = false;
                        return bl;
                    }
                    if (metaName.endsWith(Type_ConvertRule)) {
                        this.checkBaseDataIsExist(xmlContent, importResult);
                        if (importResult.get((Object)"ImportDataWarnMsg") != null) {
                            bl = false;
                            return bl;
                        }
                        flag = true;
                        if (!BOTPFileUtil.ignoreCheck()) {
                            flag = ruleCompatibleImport.checkConvertImport(document, importResult, map.size() > 0);
                        }
                        if (!flag) continue;
                        MetadataDao.deployMetadata((String)xmlContent, null, null);
                        continue;
                    }
                    flag = true;
                    if (!BOTPFileUtil.ignoreCheck()) {
                        flag = ruleCompatibleImport.checkWriteBackImport(document, importResult, map.size() > 0);
                    }
                    if (!flag) continue;
                    MetadataDao.deployMetadata((String)xmlContent, null, null);
                    continue;
                }
                MetadataDao.deployMetadata((String)xmlContent, null, null);
            }
        }
        catch (Exception e) {
            logger.error("import error\uff1a");
            logger.error((Throwable)e);
            importResult.put("ERROR", (Object)e);
            return false;
        }
        importResult.put("SUCCESS", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"BOTPFileUtil_10", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
        return true;
    }

    private static boolean ignoreCheck() {
        boolean ignoreCheckParamFlag = false;
        ParameterReaderServiceImpl service = new ParameterReaderServiceImpl();
        HashSet<String> set = new HashSet<String>(1);
        set.add(IGNORE_IMPORT_EXT_CHECK_PARAM_KEY);
        CustomParam customParam = new CustomParam(set);
        Map map = service.loadCustomParameterFromCache(customParam);
        if (map != null && map.get(IGNORE_IMPORT_EXT_CHECK_PARAM_KEY) != null) {
            ignoreCheckParamFlag = Boolean.parseBoolean((String)map.get(IGNORE_IMPORT_EXT_CHECK_PARAM_KEY));
        }
        return ignoreCheckParamFlag;
    }

    private void checkBaseDataIsExist(String xmlContent, JSONObject importResult) {
        try {
            Document document = DocumentHelper.parseText((String)xmlContent);
            Element rootElement = document.getRootElement();
            StringBuilder warnMsg = new StringBuilder();
            if (!this.checkXmlElementIsExist(rootElement, importResult)) {
                return;
            }
            this.doCycleCheck(rootElement, warnMsg);
            String msg = warnMsg.toString();
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                importResult.put("checkBaseDataWarnMsg", (Object)msg);
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
    }

    private boolean checkXmlElementIsExist(Element rootElement, JSONObject importResult) {
        if (rootElement.element("DesignMetas") == null || rootElement.element("DesignMetas").element("DesignConvertRuleMeta") == null) {
            return false;
        }
        String target = rootElement.element("DesignMetas").element("DesignConvertRuleMeta").element("TargetEntityNumber").getText();
        StringBuilder warnMsg = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)target)) {
            warnMsg.append(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219\u672a\u7ed1\u5b9a\u76ee\u6807\u5355\u636e\uff1b", (String)"BOTPFileUtil_13", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
            this.addImportResult(importResult, warnMsg);
            return false;
        }
        String source = rootElement.element("DesignMetas").element("DesignConvertRuleMeta").element("SourceEntityNumber").getText();
        if (StringUtils.isEmpty((CharSequence)source)) {
            warnMsg.append(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219\u672a\u7ed1\u5b9a\u6e90\u5355\u636e\uff1b", (String)"BOTPFileUtil_14", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
            this.addImportResult(importResult, warnMsg);
            return false;
        }
        this.targetMainEntityType = this.getFormMainEntityType(target);
        if (this.targetMainEntityType == null) {
            warnMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u76ee\u6807\u5355\u636e\u4e0d\u5b58\u5728\uff1b", (String)"BOTPFileUtil_15", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), target));
            importResult.put("ImportDataWarnMsg", (Object)warnMsg.toString());
            return false;
        }
        this.sourceMainEntityType = this.getFormMainEntityType(source);
        if (this.sourceMainEntityType == null) {
            warnMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u6e90\u5355\u636e\u4e0d\u5b58\u5728\uff1b", (String)"BOTPFileUtil_16", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), source));
            importResult.put("ImportDataWarnMsg", (Object)warnMsg.toString());
            return false;
        }
        return true;
    }

    private void addImportResult(JSONObject importResult, StringBuilder warnMsg) {
        importResult.put("checkBaseDataWarnMsg", (Object)warnMsg.toString());
    }

    private MainEntityType getFormMainEntityType(String entityNumber) {
        try {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            return mainEntityType;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void doCycleCheck(Element element, StringBuilder warnMsg) {
        block7: {
            List elements;
            block5: {
                String name;
                block6: {
                    elements = element.elements();
                    if (elements.size() != 0) break block5;
                    name = element.getName();
                    if (!"ValByCondiionsString".equals(name)) break block6;
                    String valByCondiions = element.getStringValue();
                    if (!StringUtils.isNotEmpty((CharSequence)valByCondiions)) break block7;
                    JSONObject valByCondiionsObj = JSON.parseObject((String)valByCondiions);
                    JSONArray jsonArray = valByCondiionsObj.getJSONArray("items");
                    if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                        return;
                    }
                    for (Object item : jsonArray) {
                        JSONObject jsonObject = (JSONObject)item;
                        JSONObject conditionJson = jsonObject.getJSONObject("condition");
                        if (conditionJson == null) {
                            return;
                        }
                        String filterString = conditionJson.getString("filterString");
                        if (!StringUtils.isNotEmpty((CharSequence)filterString)) continue;
                        this.checkBaseData(filterString, this.targetMainEntityType, warnMsg);
                    }
                    break block7;
                }
                if (!"FilterString".equals(name)) break block7;
                String val = element.getStringValue();
                if (StringUtils.isEmpty((CharSequence)val)) {
                    return;
                }
                this.checkBaseData(val, this.sourceMainEntityType, warnMsg);
                break block7;
            }
            for (Element elem : elements) {
                this.doCycleCheck(elem, warnMsg);
            }
        }
    }

    private void checkBaseData(String filterJsong, MainEntityType mainEntityType, StringBuilder warnMsg) {
        JSONObject jsonObject = JSON.parseObject((String)filterJsong);
        Object filterRowObject = jsonObject.get((Object)"filterRow");
        if (filterRowObject == null) {
            return;
        }
        for (Object filterRow : (JSONArray)filterRowObject) {
            String fieldName;
            JSONArray baseDataIds;
            JSONObject filterRowJson;
            if (filterRow == null || (filterRowJson = (JSONObject)filterRow).get((Object)"baseDataIds") == null || CollectionUtils.isEmpty((Collection)(baseDataIds = (JSONArray)filterRowJson.get((Object)"baseDataIds"))) || !StringUtils.isNotEmpty((CharSequence)(fieldName = filterRowJson.getString("fieldName")))) continue;
            String baseDataName = fieldName.split("\\.")[0];
            DynamicProperty property = mainEntityType.getProperty(baseDataName);
            if (property == null) {
                String noBaseData = String.format(ResManager.loadKDString((String)"\u6807\u8bc6\u4e3a%s\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\uff1b", (String)"BOTPFileUtil_17", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), baseDataName);
                if (!warnMsg.toString().contains(noBaseData)) {
                    warnMsg.append(noBaseData);
                }
            }
            if (!(property instanceof BasedataProp)) continue;
            BasedataProp bdProp = (BasedataProp)property;
            BasedataEntityType bdType = (BasedataEntityType)bdProp.getComplexType();
            String bdName = bdType.getName();
            String displayName = bdType.getDisplayName() == null ? bdName : bdType.getDisplayName().getLocaleValue();
            JSONObject baseDataId = (JSONObject)baseDataIds.get(0);
            String id = baseDataId.get((Object)"value").toString();
            if (bdType.getPrimaryKey() == null || StringUtils.isBlank((CharSequence)bdType.getPrimaryKey().getName())) continue;
            String idProp = bdType.getPrimaryKey().getName();
            QFilter[] filter = new QFilter[]{bdType.getPrimaryKey() instanceof LongProp ? new QFilter(idProp, "=", (Object)Long.parseLong(id)) : new QFilter(idProp, "=", (Object)id)};
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)bdName, (QFilter[])filter);
            if (dynamicObject != null && dynamicObject.getPkValue() != null) continue;
            String noBaseDataId = String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u3010%1$s\u3011\u4e0d\u5b58\u5728id\u4e3a%2$s\u6570\u636e\uff1b", (String)"BOTPFileUtil_20", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), displayName, id);
            if (warnMsg.toString().contains(noBaseDataId)) continue;
            warnMsg.append(noBaseDataId);
        }
    }

    public FormShowParameter buildCheckInShowParameter(String[] ruleIds, JSONObject buildResult) {
        if (ruleIds == null || ruleIds.length == 0) {
            buildResult.put(KEY_ERROR, (Object)ResManager.loadKDString((String)"\u8bf7\u63d0\u4ea4\u9700\u8981\u7684\u89c4\u5219\u201cruleIds\u201d\u3002", (String)"BOTPFileUtil_1", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
            return null;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("bos_devportal_svn_login");
        showParameter.setCustomParam("type", (Object)this.ruleType);
        showParameter.setCustomParam("issave", (Object)Boolean.FALSE);
        Class<DesignConvertRuleMeta> designMetaClass = null;
        if (this.ruleType.equals(Type_ConvertRule)) {
            designMetaClass = DesignConvertRuleMeta.class;
        } else if (this.ruleType.equals(Type_WriteBackRule)) {
            designMetaClass = DesignWriteBackRuleMeta.class;
        } else if (this.ruleType.equals(Type_BalanceUpdateRule)) {
            designMetaClass = DesignBalanceRuleMeta.class;
        }
        if (designMetaClass == null) {
            buildResult.put(KEY_ERROR, (Object)ResManager.loadKDString((String)"ruleType\u53ea\u80fd\u652f\u6301cr, wb, bur", (String)"BOTPFileUtil_2", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
            return null;
        }
        Object[] designMetas = BusinessDataReader.load((Object[])ruleIds, (IDataEntityType)OrmUtils.getDataEntityType(designMetaClass));
        JSONArray idsArray = new JSONArray();
        HashSet<String> bizAppIds = new HashSet<String>();
        for (Object designMeta : designMetas) {
            String ruleId = ((DesignMeta)designMeta).getId();
            String bizAppId = ((DesignMeta)designMeta).getBizappId();
            idsArray.add((Object)ruleId);
            if (!StringUtils.isNotBlank((CharSequence)bizAppId) || bizAppIds.contains(bizAppId)) continue;
            bizAppIds.add(bizAppId);
        }
        if (idsArray.size() == 0) {
            buildResult.put(KEY_ERROR, (Object)ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u89c4\u5219\u3002", (String)"BOTPFileUtil_3", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
            return null;
        }
        if (bizAppIds.size() == 0) {
            buildResult.put(KEY_ERROR, (Object)String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u63d0\u4ea4\uff0c\u627e\u4e0d\u5230\u9700\u8981\u63d0\u4ea4\u7684%s\u8def\u5f84\uff0c\u539f\u56e0\u662f\u672a\u660e\u786e\u89c4\u5219\u6240\u5c5e\u7684\u5e94\u7528\u3002", (String)"BOTPFileUtil_4", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), "svn"));
            return null;
        }
        if (bizAppIds.size() > 1) {
            buildResult.put(KEY_ERROR, (Object)ResManager.loadKDString((String)"\u8bf7\u5206\u5f00\u63d0\u4ea4\uff0c\u6bcf\u6b21\u53ea\u80fd\u63d0\u4ea4\u5c5e\u4e8e\u4e00\u4e2a\u5e94\u7528\u7684\u89c4\u5219\u3002", (String)"BOTPFileUtil_5", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
            return null;
        }
        showParameter.setCustomParam("ruleids", (Object)idsArray.toJSONString());
        showParameter.setCustomParam("bizappid", bizAppIds.iterator().next());
        return showParameter;
    }

    public JSONObject chickInRule(JSONObject svnMsg, JSONArray idsArray, String bizAppId) {
        String property = System.getProperty("user.home");
        String filePath = property + File.separator + SUBPATH_METADATA;
        String localPath = svnMsg.getString("localpath");
        String checkLocalPath = DevportalUtil.checkFilePath((String)localPath);
        AppUtils.deleteFile((String)localPath);
        File file = new File(checkLocalPath);
        if (file.exists()) {
            AppUtils.deleteFile((String)localPath);
        }
        HashSet<String> ruleIds = new HashSet<String>();
        for (int i = 0; i < idsArray.size(); ++i) {
            String ruleId = idsArray.getString(i);
            if (!StringUtils.isNotBlank((CharSequence)ruleId) || ruleIds.contains(ruleId)) continue;
            ruleIds.add(ruleId);
        }
        if ((svnMsg = SVNUtil.checkOutFiles((JSONObject)svnMsg)).get((Object)KEY_ERROR) != null) {
            return svnMsg;
        }
        ArrayList<String> exportFiles = new ArrayList<String>();
        this.exportRulesFile(localPath, ruleIds.toArray(new String[ruleIds.size()]), exportFiles, svnMsg);
        if (svnMsg.get((Object)KEY_ERROR) != null) {
            return svnMsg;
        }
        if (exportFiles.size() > 0) {
            svnMsg = SVNUtil.commitToSVN(exportFiles, (JSONObject)svnMsg);
        } else {
            svnMsg.put(KEY_ERROR, (Object)ResManager.loadKDString((String)"\u7b7e\u5165\u6587\u4ef6\u4e3a\u7a7a", (String)"BOTPFileUtil_8", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
        }
        return svnMsg;
    }

    public void exportRulesFile(String exportPath, String[] ruleIds, List<String> exportFiles, JSONObject checkInMsg) {
        for (String ruleId : ruleIds) {
            this.exportRuleFile(exportPath, ruleId, exportFiles, checkInMsg);
        }
    }

    public void exportRuleFile(String exportPath, String ruleId, List<String> exportFiles, JSONObject checkInMsg) {
        List list = null;
        if (this.ruleType.equals(Type_ConvertRule)) {
            list = MetadataDao.getConvertRuleDeployFile((String)ruleId);
        } else if (this.ruleType.equals(Type_WriteBackRule)) {
            list = MetadataDao.getWriteBackRuleDeployFile((String)ruleId);
        } else if (this.ruleType.equals(Type_BalanceUpdateRule)) {
            IDataEntityType designMetaType = OrmUtils.getDataEntityType(DesignBalanceRuleMeta.class);
            IDataEntityType designMetaType_Lang = OrmUtils.getDataEntityType(DesignBalanceRuleMetaL.class);
            list = MetadataDao.getCustMetadataDeployFile((String)ruleId, (IDataEntityType)designMetaType, (IDataEntityType)designMetaType_Lang, (String)Type_BalanceUpdateRule);
        } else {
            return;
        }
        for (DeployFile deployFile : list) {
            String shaCode;
            String exportShaCodeFile;
            String fileName = deployFile.getFileName();
            String fileContent = deployFile.getFileContent();
            String exportFile = this.saveMetaXmlFile(exportPath, fileName, fileContent, checkInMsg);
            if ((fileName.endsWith(Type_ConvertRule) || fileName.endsWith(Type_WriteBackRule)) && StringUtils.isNotBlank((CharSequence)(exportShaCodeFile = ShaUtil.saveShaCodeFile(exportPath, shaCode = ShaUtil.encryptSha256Salt(fileContent, fileName), fileName)))) {
                exportFiles.add(exportShaCodeFile);
            }
            if (!StringUtils.isNotBlank((CharSequence)exportFile)) continue;
            exportFiles.add(exportFile);
        }
    }

    public static List<DeployFile> getRuleFile(String ruleType, String ruleId) {
        List list = null;
        if (ruleType.endsWith(Type_ConvertRule)) {
            list = MetadataDao.getConvertRuleDeployFile((String)ruleId);
        } else if (ruleType.endsWith(Type_WriteBackRule)) {
            list = MetadataDao.getWriteBackRuleDeployFile((String)ruleId);
        } else if (ruleType.endsWith(Type_BalanceUpdateRule)) {
            IDataEntityType designMetaType = OrmUtils.getDataEntityType(DesignBalanceRuleMeta.class);
            IDataEntityType designMetaType_Lang = OrmUtils.getDataEntityType(DesignBalanceRuleMetaL.class);
            list = MetadataDao.getCustMetadataDeployFile((String)ruleId, (IDataEntityType)designMetaType, (IDataEntityType)designMetaType_Lang, (String)Type_BalanceUpdateRule);
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    private String saveMetaXmlFile(String exportPath, String fileName, String fileContext, JSONObject checkInMsg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getMetaXmlPath(String exportPath, String filename) {
        String fullPath = String.format("%s/%s/%s", exportPath, SUBPATH_METADATA, filename);
        return fullPath;
    }

    private void zipFiles(String zipName, String zipPath) {
        JSONArray files = new JSONArray();
        String zipCheckPath = DevportalUtil.checkFilePath((String)zipPath);
        File file = new File(DevportalUtil.checkFilePath((String)zipCheckPath));
        if (file.exists()) {
            files.add((Object)zipCheckPath);
        }
        String zipFilePath = zipCheckPath + File.separator + zipName + ".zip";
        Path customZipPath = Paths.get(zipFilePath, new String[0]);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(customZipPath, new OpenOption[0]));){
            this.zipFile(files, out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void zipFile(JSONArray files, ZipOutputStream out) {
        for (int i = 0; i < files.size(); ++i) {
            File file = new File(DevportalUtil.checkFilePath((String)((String)files.get(i))));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                JSONArray tempFiles = new JSONArray();
                if (listFiles != null) {
                    for (File tempFile : listFiles) {
                        try {
                            tempFiles.add((Object)tempFile.getCanonicalPath());
                        }
                        catch (IOException e) {
                            logger.error((Throwable)e);
                        }
                    }
                }
                this.zipFile(tempFiles, out);
                continue;
            }
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            if (path == null) continue;
            Path zipPath = Paths.get(DevportalUtil.checkFilePath((String)path), new String[0]);
            int t = -1;
            if (path != null && path.contains(SUBPATH_METADATA)) {
                t = path.indexOf(SUBPATH_METADATA);
            }
            if (t == -1) continue;
            if ((path = path.substring(t, path.length())) != null && path.contains("\\")) {
                path = path.replace('\\', '/');
            }
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(zipPath, new OpenOption[0]));){
                ZipEntry entry = new ZipEntry(path);
                entry.setMethod(8);
                out.putNextEntry(entry);
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.closeEntry();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

