/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin.botp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.attach.IAttachmentPanel;

public class ImportFilePlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log logger = LogFactory.getLog(ImportFilePlugin.class);
    public static final String FormId_ImportFile = "botp_importfile";
    private static final String KEY_FN = "filename";
    private static final String KEY_FP = "filepanel";
    private static final String KEY_BTNOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNOK});
        IAttachmentPanel filePanel = (IAttachmentPanel)this.getControl(KEY_FP);
        filePanel.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
    }

    public void afterUpload(UploadEvent evt) {
        List<String> uploadFileUrls = this.getUploadFileUrls(evt);
        String fieldValue = (String)this.getModel().getValue(KEY_FN);
        String[] fieldValues = new String[]{};
        if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
            fieldValues = StringUtils.split((String)fieldValue, (String)";");
        }
        HashSet<String> fileUrls = new HashSet<String>(uploadFileUrls.size());
        for (String fileUrl : uploadFileUrls) {
            fileUrls.add(fileUrl);
        }
        for (String fileUrl : fieldValues) {
            fileUrls.add(fileUrl);
        }
        fieldValue = StringUtils.join((Object[])fileUrls.toArray(), (String)";");
        this.getModel().setValue(KEY_FN, (Object)fieldValue);
    }

    public void remove(UploadEvent evt) {
    }

    public void afterRemove(UploadEvent evt) {
        String fieldValue = (String)this.getModel().getValue(KEY_FN);
        String[] fieldValues = new String[]{};
        if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
            fieldValues = StringUtils.split((String)fieldValue, (String)";");
        }
        HashSet<String> fileUrls = new HashSet<String>(fieldValues.length);
        for (String fileUrl : fieldValues) {
            fileUrls.add(fileUrl);
        }
        List<String> removeFileUrls = this.getUploadFileUrls(evt);
        for (String fileUrl : removeFileUrls) {
            boolean removeFlag = fileUrls.remove(fileUrl);
            if (!removeFlag) continue;
            logger.info(fileUrl + "delete");
        }
        fieldValue = StringUtils.join((Object[])fileUrls.toArray(), (String)";");
        this.getModel().setValue(KEY_FN, (Object)fieldValue);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcCtrl = (Control)evt.getSource();
        if (srcCtrl.getKey().equalsIgnoreCase(KEY_BTNOK)) {
            this.doOK();
        }
    }

    private void doOK() {
        String fileNames = (String)this.getModel().getValue(KEY_FN);
        if (StringUtils.isBlank((CharSequence)fileNames)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u9700\u8981\u5bfc\u5165\u7684\u89c4\u5219\u6587\u4ef6(*.zip)\u3002", (String)"ImportFilePlugin_0", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)fileNames);
        this.getView().close();
    }

    private List<String> getUploadFileUrls(UploadEvent evt) {
        ArrayList<String> fileUrls = new ArrayList<String>(evt.getUrls().length);
        for (Object url : evt.getUrls()) {
            fileUrls.add((String)((Map)url).get("url"));
        }
        return fileUrls;
    }
}

