/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin.botp;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.extcontrol.helper.CarryParamDataHelper;
import kd.bos.devportal.plugin.botp.RuleCompatibleAbstract;
import kd.bos.entity.botp.constants.RuleModuleEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.botp.ConvertRuleMetadata;
import kd.bos.metadata.botp.WriteBackRuleMetadata;
import kd.bos.metadata.botp.WriteBackRuleReader;
import kd.bos.metadata.botp.common.RuleIsvHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class RuleCompatibleImport
extends RuleCompatibleAbstract {
    private static final Log logger = LogFactory.getLog(RuleCompatibleImport.class);

    public RuleCompatibleImport(int type) {
        this.setType(type);
    }

    public void doCompatible(Document document, JSONObject importResult) {
        Element rootElement = document.getRootElement();
        this.checkXmlElementIsExist(rootElement);
        this.checkBaseDataElement(rootElement);
        String msg = this.warnMsg.toString();
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            importResult.put("checkBaseDataWarnMsg", (Object)msg);
        }
    }

    public Boolean checkConvertImport(Document document, JSONObject importResult, boolean isEncrypt) {
        ConvertRuleMetadata parentRuleMetadata;
        Boolean flag = true;
        Element rootElement = document.getRootElement();
        String devType = rootElement.element("DesignMetas").element("DesignConvertRuleMeta").element("DevType").getText();
        String parentId = rootElement.element("DesignMetas").element("DesignConvertRuleMeta").element("ParentId").getText();
        String sourceBill = rootElement.element("DesignMetas").element("DesignConvertRuleMeta").element("SourceEntityNumber").getText();
        String targetBill = rootElement.element("DesignMetas").element("DesignConvertRuleMeta").element("TargetEntityNumber").getText();
        String ruleId = rootElement.element("Id").getText();
        CarryParamDataHelper carryParamDataHelper = new CarryParamDataHelper();
        DynamicObject data = carryParamDataHelper.loadData(sourceBill, targetBill);
        if (devType.equals("0") && data != null) {
            ConvertRuleMetadata ruleMetadata = ConvertMetaServiceHelper.loadMeta((String)ruleId, (boolean)false);
            Boolean disableCreateRule = carryParamDataHelper.isDisableCreateRule(data);
            Boolean enableCarryCreateRule = carryParamDataHelper.isEnableCarryCreateRule(data);
            if (disableCreateRule.booleanValue() || enableCarryCreateRule.booleanValue()) {
                String msg;
                if (ruleMetadata == null) {
                    flag = false;
                    this.warnMsg.append(ruleId);
                    this.warnMsg.append(",");
                }
                if (StringUtils.isNotEmpty((CharSequence)(msg = this.warnMsg.toString()))) {
                    importResult.put("ImportDataDetailWarnMsg", (Object)msg);
                }
                return flag;
            }
        }
        if (!devType.equals("0") && (parentRuleMetadata = ConvertMetaServiceHelper.loadMeta((String)parentId, (boolean)false)) != null && parentRuleMetadata.getRuleElement().getExtElements().size() > 0) {
            if (isEncrypt) {
                flag = true;
            } else {
                flag = false;
                this.warnMsg.append(ruleId);
                this.warnMsg.append(",");
                String msg = this.warnMsg.toString();
                if (StringUtils.isNotEmpty((CharSequence)msg)) {
                    importResult.put("ImportDataDetailWarnMsg", (Object)msg);
                }
            }
        }
        return flag;
    }

    public Boolean checkWriteBackImport(Document document, JSONObject importResult, boolean isEncrypt) {
        WriteBackRuleReader reader;
        WriteBackRuleMetadata parentRuleMetadata;
        Boolean flag = true;
        Element rootElement = document.getRootElement();
        String devType = rootElement.element("DesignMetas").element("DesignWriteBackRuleMeta").element("DevType").getText();
        String parentId = rootElement.element("DesignMetas").element("DesignWriteBackRuleMeta").element("ParentId").getText();
        String ruleId = rootElement.element("Id").getText();
        if (!devType.equals("0") && (parentRuleMetadata = (reader = new WriteBackRuleReader()).loadMeta(parentId, false)) != null && parentRuleMetadata.getRuleElement().getExtElements().size() > 0) {
            if (isEncrypt) {
                flag = true;
            } else {
                flag = false;
                this.warnMsg.append(ruleId);
                this.warnMsg.append(",");
                String msg = this.warnMsg.toString();
                if (StringUtils.isNotEmpty((CharSequence)msg)) {
                    importResult.put("ImportDataDetailWarnMsg", (Object)msg);
                }
            }
        }
        return flag;
    }

    private void checkBaseDataElement(Element element) {
        List filterPolicyEleList;
        this.doFieleMappolicy(element);
        List runConditionEleList = this.getNodesByName(element, RuleModuleEnum.RUNCONDITION);
        if (CollectionUtils.isNotEmpty((Collection)runConditionEleList)) {
            Element runConditionEle = (Element)runConditionEleList.get(0);
            this.doFilterStringWitchCheck(runConditionEle);
        }
        if (CollectionUtils.isNotEmpty((Collection)(filterPolicyEleList = this.getNodesByName(element, RuleModuleEnum.FILTERPOLICY)))) {
            Element filterPolicyEle = (Element)filterPolicyEleList.get(0);
            this.doFilterStringWitchCheck(filterPolicyEle);
        }
    }

    private boolean enableLockability(String ruleIsv) {
        if (RuleIsvHelper.isKindeeIsv()) {
            return false;
        }
        String userIsv = RuleIsvHelper.getUserIsv();
        if (userIsv == null) {
            return true;
        }
        return userIsv.equals(ruleIsv);
    }
}

