/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillView;
import kd.bos.botp.LastBillRuleService;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.LastBillRuleRecord;
import kd.bos.entity.botp.PushAndDrawUtil;
import kd.bos.entity.botp.helper.AttachmentPanelConvertHelper;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.AttachmentItemInfo;
import kd.bos.entity.botp.runtime.BeforeDrawArgs;
import kd.bos.entity.botp.runtime.BeforeDrawOpResult;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.botp.runtime.ConvertOpProgressCache;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.botp.runtime.GetTargetOptionalOrgsArgs;
import kd.bos.entity.botp.runtime.GetTargetOptionalOrgsResult;
import kd.bos.entity.botp.runtime.OpInfo;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.args.PushArgsFactory;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.Plugin;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.operate.botp.PushBigDataExecuter;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.botp.ConvertOpFormEditAbstract;
import kd.bos.form.plugin.botp.ConvertOpFormEditForThird;
import kd.bos.form.plugin.botp.ConvertProgressEdit;
import kd.bos.form.plugin.botp.ReleaseConvertDataMutexPlugin;
import kd.bos.form.plugin.botp.jobtask.BackgroundTaskManager;
import kd.bos.form.plugin.botp.layout.BotpLayoutManager;
import kd.bos.form.plugin.botp.util.FilterRuleUtils;
import kd.bos.lang.Lang;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import org.apache.commons.collections4.MapUtils;

public class ConvertOpFormEdit
extends ConvertOpFormEditAbstract {
    private static final Log log = LogFactory.getLog(ConvertOpFormEdit.class);
    private static final String BOS_FORM_BUSINESS = "bos-botp-formplugin";
    public static final String FormId_ConvertOp = "botp_convertop";
    public static final String FormId_ConvertResult = "botp_convertresult";
    public static final String CustParam_OpParam = "opparam";
    private static final String KEY_FRULE = "frule";
    private static final String KEY_FRELATIONORG = "frelationorg";
    private static final String KEY_WHOLECONVERT = "wholeconvert";
    private static final String KEY_SHOWREPORT = "showreport";
    private static final String KEY_OUTFORMULA = "outformula";
    private static final String KEY_PUSHANDSAVE = "pushandsave";
    private static final String KEY_BACKGROUND_OPTION = "backgroundoption";
    private static final String KEY_OK = "btnok";
    private static final String BILLPARAMETER_SHOWREPORT = "default_showreport";
    private static final String BILLPARAMETER_WHOLECONVERT = "wholeconvert";
    private static final String CLOSECALLACTIONID_DRAW = "draw";
    private static final String CLOSECALLACTIONID_CONVERTPROGRESS = "convertprogress";
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";
    private static final String ONLY_RUN_CONDITION_RULE = "onlyrunconditionrule";
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ConvertOpFormEdit", (int)5);
    private BotpLayoutManager botpLayoutManager = new BotpLayoutManager();
    private FilterRuleUtils filterRuleUtils = new FilterRuleUtils();
    private LastBillRuleService lastBillRuleService = new LastBillRuleService();
    private Map<String, Object> billParameter;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_OK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fillBillCombo();
        String entityNumber = this.opParameter.getEntityNumber();
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return;
        }
        this.billParameter = SystemParamServiceHelper.loadBillParameterObjectFromCache((String)entityNumber);
        this.setShowReportByBillParameter();
        this.setWholeConvertByBillParameter();
    }

    private void setShowReportByBillParameter() {
        try {
            ConvertOpType opType = this.opParameter.getOpType();
            if (opType != ConvertOpType.Push) {
                return;
            }
            if (MapUtils.isEmpty(this.billParameter)) {
                return;
            }
            boolean defaultShowReport = (Boolean)this.billParameter.get(BILLPARAMETER_SHOWREPORT);
            this.getModel().setValue(KEY_SHOWREPORT, (Object)defaultShowReport);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void setWholeConvertByBillParameter() {
        if (MapUtils.isEmpty(this.billParameter)) {
            return;
        }
        boolean wholeconvert = (Boolean)this.billParameter.get("wholeconvert");
        if (wholeconvert) {
            this.getModel().setValue("wholeconvert", (Object)wholeconvert);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"wholeconvert"});
            HashMap value = new HashMap(8);
            HashMap<String, LocaleString> tipValue = new HashMap<String, LocaleString>(8);
            tipValue.put("content", ResManager.getLocaleString((String)"\u5f53\u524d\u5355\u636e\u5df2\u63a7\u5236\u6309\u6574\u5355\u8f6c\u6362\u3002", (String)"ConvertOpFormEdit_11", (String)"bos-botp-formplugin"));
            value.put("tips", tipValue);
            this.getView().updateControlMetadata("wholeconvert", value);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getConvertOpParamter().getOpType().compareTo((Enum)ConvertOpType.Push) != 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_SHOWREPORT, KEY_OUTFORMULA});
        }
        if (this.getConvertOpParamter().getOpType().compareTo((Enum)ConvertOpType.Draw) != 0 && !this.isListView()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"wholeconvert"});
        }
    }

    private boolean isListView() {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (StringUtils.isEmpty((CharSequence)parentPageId)) {
            return false;
        }
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        if (parentView == null) {
            return false;
        }
        return parentView instanceof IListView;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcCtrl = (Control)evt.getSource();
        if (KEY_OK.equalsIgnoreCase(srcCtrl.getKey())) {
            ConvertOpParameter opParameter = this.getConvertOpParamter();
            if (opParameter.getOpType() == ConvertOpType.Push) {
                this.doPush(opParameter);
            } else if (opParameter.getOpType() == ConvertOpType.Draw) {
                this.doBeforeDraw(opParameter);
            }
            String fldValue = this.botpLayoutManager.getBillItemValue(this.getModel(), "fbill");
            if (this.lastBillRuleService.isEnabled() && !ConvertOpFormEditForThird.isThirdConvertBill(fldValue)) {
                LastBillRuleRecord record = this.lastBillRuleService.getLastBillRuleRecord(Long.valueOf(RequestContext.get().getCurrUserId()), opParameter.getEntityNumber(), opParameter.getOpType() == ConvertOpType.Push ? "push" : CLOSECALLACTIONID_DRAW);
                record.setBill(fldValue);
                record.setRule((String)this.getModel().getValue(KEY_FRULE));
                this.lastBillRuleService.addRecord(record);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase("fbill") && this.botpLayoutManager.billItemValueChange(e)) {
            this.fillRuleCombo(null);
            this.fillOrgCombo(null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equalsIgnoreCase(CLOSECALLACTIONID_DRAW)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            this.doDraw(rows);
        } else if (closedCallBackEvent.getActionId().equalsIgnoreCase(CLOSECALLACTIONID_CONVERTPROGRESS)) {
            String taskId = (String)closedCallBackEvent.getReturnData();
            this.showPushBigDataResult(taskId);
        }
    }

    private void doPush(ConvertOpParameter opParameter) {
        String targetEntityNumber = this.botpLayoutManager.getBillItemValue(this.getModel(), "fbill");
        String ruleId = (String)this.getModel().getValue(KEY_FRULE);
        String defOrgId = (String)this.getModel().getValue(KEY_FRELATIONORG);
        Boolean showReport = (Boolean)this.getModel().getValue(KEY_SHOWREPORT);
        String backGroundOption = "1";
        if (this.getModel().getProperty(KEY_BACKGROUND_OPTION) != null) {
            backGroundOption = (String)this.getModel().getValue(KEY_BACKGROUND_OPTION);
        }
        PushArgs args = this.buildPushArgs(opParameter, ConvertOpFormEditForThird.getRealTargetEntityNumber(targetEntityNumber), ruleId, defOrgId);
        ConvertOpFormEditForThird convertOpFormEditForThird = new ConvertOpFormEditForThird((IFormPlugin)this);
        convertOpFormEditForThird.overWriteArgsByThirdPushArgs(args, targetEntityNumber, ruleId, defOrgId);
        if (args == null) {
            return;
        }
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        Push.addPushByBillOption((IFormView)parentView, (AbstractConvertServiceArgs)args);
        try {
            if (this.isListView() && !((ListShowParameter)parentView.getFormShowParameter()).getListUserOption().isMergeRow()) {
                Boolean wholeConvert = (Boolean)this.getModel().getValue("wholeconvert");
                args.addCustomParam("botp_pushByBill", String.valueOf(wholeConvert));
                if (Boolean.TRUE.equals(wholeConvert)) {
                    List selectedRows = args.getSelectedRows();
                    for (ListSelectedRow selectedRow : selectedRows) {
                        selectedRow.setEntryPrimaryKeyValue(null);
                        selectedRow.setSubEntryPrimaryKeyValue(null);
                    }
                    args.setSelectedRows(selectedRows);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        if ("1".equals(backGroundOption) && args.getSelectedRows().size() > 20000 || "2".equals(backGroundOption)) {
            args.setShowReport(showReport.booleanValue());
            this.pushAndSaveBackGround(args);
            return;
        }
        log.info("\u4e0b\u63a8\u53c2\u6570\uff1a" + SerializationUtils.toJsonString((Object)args));
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        if (!result.isSuccess() || result.getCachePageIds().size() + result.getTargetBillIds().size() == 0) {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)args, (ConvertOperationResult)result);
            return;
        }
        if (result.getCachePageIds().size() + result.getTargetBillIds().size() == 1) {
            Push.showTargetBill((IFormView)parentView, (PushArgs)args, (ConvertOperationResult)result, (boolean)showReport);
            this.getView().sendFormAction(parentView);
            this.getView().close();
            return;
        }
        Push.showMultiTargetBills((IFormView)parentView, (PushArgs)args, (ConvertOperationResult)result, (boolean)showReport);
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }

    private PushArgs buildPushArgs(ConvertOpParameter opParameter, String targetEntityNumber, String ruleId, String defOrgId) {
        PushArgs args = PushArgsFactory.newInstances();
        if (StringUtils.isNotBlank((CharSequence)opParameter.getAppId())) {
            args.setAppId(opParameter.getAppId());
        } else {
            args.setAppId(this.getView().getFormShowParameter().getCheckRightAppId());
        }
        args.setSourceEntityNumber(opParameter.getEntityNumber());
        args.setTargetEntityNumber(targetEntityNumber);
        args.setHasRight(opParameter.isHasRight());
        args.addCustomParam("botp_requiredatamutex", String.valueOf(true));
        args.setAutoSave(true);
        for (ConvertBill bill : opParameter.getBills()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)targetEntityNumber, (CharSequence)bill.getEntityNumber())) continue;
            for (ConvertOpRule rule : bill.getRules()) {
                args.getRuleIds().add(rule.getRuleId());
            }
        }
        if (!"@all".equals(ruleId)) {
            args.setRuleId(ruleId);
        } else if (this.getConvertOpParamter().isMustSelectRule()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8f6c\u6362\u89c4\u5219\u3002", (String)"ConvertOpFormEdit_5", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (!StringUtils.isBlank((CharSequence)defOrgId) && !StringUtils.equals((CharSequence)"0", (CharSequence)defOrgId)) {
            args.setDefOrgId(Long.valueOf(defOrgId));
        }
        args.setSelectedRows((List)opParameter.getSelectedRows());
        args.setBuildConvReport(true);
        args.getCustomParams().putAll(opParameter.getCustomParams());
        args.setOpInfo(opParameter.getOpInfo());
        if (this.getModel().getProperty(KEY_OUTFORMULA) != null) {
            Boolean outFormula = (Boolean)this.getModel().getValue(KEY_OUTFORMULA);
            args.addCustomParam("botp_outformula", String.valueOf(outFormula));
        }
        return args;
    }

    private void pushAndSaveBackGround(PushArgs args) {
        BackgroundTaskManager pushAndSaveJob = BackgroundTaskManager.newInstance(this.getView());
        pushAndSaveJob.dispatchBackgroundTask(args);
        IFormView view = this.getView().getParentView();
        view.showTipNotification(ResManager.loadKDString((String)"\u4e0b\u63a8\u6570\u91cf\u8d85\u8fc720000\u6761\uff0c\u5df2\u8f6c\u540e\u53f0\u6267\u884c\u3002", (String)"ConvertOpFormEdit_7", (String)"bos-botp-formplugin", (Object[])new Object[0]));
        this.getView().sendFormAction(view);
        this.getView().close();
    }

    private void doPushAndSave(PushArgs args) {
        ConvertProgressEdit.showConvertProgressForm(this.getView(), (AbstractConvertServiceArgs)args, new CloseCallBack((IFormPlugin)this, CLOSECALLACTIONID_CONVERTPROGRESS));
        String argJson = SerializationUtils.toJsonString((Object)args);
        ConvertOpProgressCache.setConvertArgs((String)args.getTaskId(), (String)argJson);
        PushBigDataExecuter executer = new PushBigDataExecuter(args);
        threadPool.execute((Runnable)executer);
    }

    private void showPushBigDataResult(String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        ConvertOperationResult result = ConvertOpProgressCache.getCacheOperateResult((String)taskId);
        if (result != null) {
            boolean fail = false;
            for (SourceBillReport billReport : result.getBillReports()) {
                if (billReport.isFullSuccess()) continue;
                fail = true;
                break;
            }
            if (!fail && !result.getTargetBillIds().isEmpty()) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5927\u5355\u4e0b\u63a8\u6267\u884c\u5b8c\u6bd5\uff0c\u81ea\u52a8\u751f\u6210\u4e86%1$s\u5f20\u76ee\u6807\u5355\uff0c\u5171\u8017\u8d39%2$s\u79d2", (String)"ConvertOpFormEdit_8", (String)"bos-botp-formplugin", (Object[])new Object[0]), result.getTargetBillIds().size(), result.getRunSecond()));
            } else {
                String argJson = ConvertOpProgressCache.getConvertArgs((String)taskId);
                PushArgs args = (PushArgs)SerializationUtils.fromJsonString((String)argJson, PushArgs.class);
                Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)args, (ConvertOperationResult)result);
            }
        }
        ConvertOpProgressCache.clearCache((String)taskId);
    }

    private void doBeforeDraw(ConvertOpParameter opParameter) {
        ConvertOperationResult opResult;
        String sourceEntityNumber = this.botpLayoutManager.getBillItemValue(this.getModel(), "fbill");
        String ruleId = (String)this.getModel().getValue(KEY_FRULE);
        BeforeDrawArgs args = new BeforeDrawArgs();
        args.setSourceEntityNumber(sourceEntityNumber);
        args.setTargetEntityNumber(opParameter.getEntityNumber());
        args.setTargetPageId(opParameter.getTargetBillPageId());
        args.setRuleId(ruleId);
        boolean duplicateRemove = false;
        boolean duplicateEntryRemove = false;
        if (this.getView().getFormShowParameter().getCustomParam("duplicateremove") != null) {
            duplicateRemove = (Boolean)this.getView().getFormShowParameter().getCustomParam("duplicateremove");
        }
        if (this.getView().getFormShowParameter().getCustomParam("duplicateentryremove") != null) {
            duplicateEntryRemove = (Boolean)this.getView().getFormShowParameter().getCustomParam("duplicateentryremove");
        }
        args.setDuplicateRemove(duplicateRemove);
        args.setDuplicateEntryRemove(duplicateEntryRemove);
        args.getCustomParams().putAll(opParameter.getCustomParams());
        try {
            opResult = ConvertServiceHelper.beforeDraw((BeforeDrawArgs)args);
        }
        catch (KDException e) {
            PushAndDrawUtil.nonMetaNotFound((KDException)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"number\u4e3a%s\uff08\u6e90\u5355\u6807\u8bc6\uff09\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"PushAndDrawUtil_0", (String)"bos-botp-core", (Object[])new Object[0]), args.getSourceEntityNumber()));
        }
        BeforeDrawOpResult result = (BeforeDrawOpResult)opResult;
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(result.getMessage());
        } else {
            String filter = result.getDrawFilter();
            String sourceFormId = StringUtils.isNotBlank((CharSequence)result.getDrawSourceLayout()) ? result.getDrawSourceLayout() : sourceEntityNumber;
            ListShowParameter showParameter = PushAndDrawUtil.tryCreateShowListForm((String)sourceFormId, (String)sourceEntityNumber);
            String errmsg = (String)showParameter.getCustomParam("errmsg");
            if (StringUtils.isNotBlank((CharSequence)errmsg)) {
                this.getView().showErrorNotification(errmsg);
            }
            showParameter.setShowFullScreen(true);
            showParameter.getCustomParams().put("isIgnoreLicense", true);
            showParameter.getCustomParams().put("bos_call_source_type", "botp_draw");
            showParameter.getListFilterParameter().setQFilter(filter);
            if (result.getDrawSelectedEntity().size() > 0) {
                String selectEntity = (String)result.getDrawSelectedEntity().get(result.getDrawSelectedEntity().size() - 1);
                showParameter.getListFilterParameter().setSelectEntity(selectEntity);
                showParameter.getCustomParams().put("ismergerows", false);
            }
            if (result.getSrcMainOrgId() != null) {
                showParameter.setIsolationOrg(true);
                showParameter.setUseOrgId(result.getSrcMainOrgId().longValue());
            } else {
                showParameter.setIsolationOrg(false);
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSECALLACTIONID_DRAW);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void doDraw(ListSelectedRowCollection rows) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        ConvertOpParameter opParameter = this.getConvertOpParamter();
        String sourceEntityNumber = this.botpLayoutManager.getBillItemValue(this.getModel(), "fbill");
        String ruleId = (String)this.getModel().getValue(KEY_FRULE);
        DrawArgs args = new DrawArgs();
        args.setSourceEntityNumber(sourceEntityNumber);
        args.setTargetEntityNumber(opParameter.getEntityNumber());
        args.addCustomParam("botp_requiredatamutex", String.valueOf(true));
        args.getSelectedRows().addAll(rows);
        args.setTargetPageId(opParameter.getTargetBillPageId());
        args.setRuleId(ruleId);
        args.setBuildConvReport(true);
        args.getClearEntrys().addAll(opParameter.getClearEntrys());
        args.getCustomParams().putAll(opParameter.getCustomParams());
        args.setOpInfo(opParameter.getOpInfo());
        try {
            Boolean wholeConvert = (Boolean)this.getModel().getValue("wholeconvert");
            args.addCustomParam("botp_pushByBill", String.valueOf(wholeConvert));
            if (Boolean.TRUE.equals(wholeConvert)) {
                List selectedRows = args.getSelectedRows();
                for (ListSelectedRow selectedRow : selectedRows) {
                    selectedRow.setEntryPrimaryKeyValue(null);
                    selectedRow.setSubEntryPrimaryKeyValue(null);
                }
                args.getSelectedRows().addAll(selectedRows);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        ConvertOperationResult result = ConvertServiceHelper.draw((DrawArgs)args);
        if (!result.isSuccess() || result.getCachePageIds().size() == 0) {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)args, (ConvertOperationResult)result);
        } else {
            IBillView billView = (IBillView)this.getView().getView(opParameter.getTargetBillPageId());
            IRefrencedataProvider refProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType type) {
                    BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)type);
                }
            };
            List dataEntitys = result.loadTargetDataObjects(refProvider, (MainEntityType)((BillEntityType)billView.getModel().getDataEntityType()));
            this.addReleaseSourceDataMutexPlugin((IFormView)billView, result);
            ((IBillModel)billView.getModel()).push(dataEntitys.get(0));
            this.bindDrawAttachments(billView, result.getBillAttachmentPanelInfos());
            billView.updateView();
            this.getView().sendFormAction((IFormView)billView);
            this.getView().close();
            result.release(refProvider, (MainEntityType)((BillEntityType)billView.getModel().getDataEntityType()));
        }
    }

    private void bindDrawAttachments(IBillView billView, Map<Object, Map<String, List<AttachmentItemInfo>>> billAttachmentPanelInfos) {
        if (billAttachmentPanelInfos == null || billAttachmentPanelInfos.size() == 0) {
            return;
        }
        Map attachmentMap = AttachmentPanelConvertHelper.convertBillAttachmentInfosToBillAttachmentInfoMaps(billAttachmentPanelInfos.values().iterator().next());
        attachmentMap.replaceAll((key, value) -> AttachmentPanelConvertHelper.convertAttachmentInfoMapForTempCache((List)value));
        String tempAttCacheKey = "TampAttCache" + billView.getPageId();
        IPageCache cache = billView.getPageCache();
        this.mergeTempAttachments(cache, tempAttCacheKey, attachmentMap);
        for (Map.Entry entry : attachmentMap.entrySet()) {
            AttachmentPanel panel = (AttachmentPanel)billView.getControl((String)entry.getKey());
            if (panel != null) {
                List attachs = panel.getAttachmentData();
                AttachmentPanelConvertHelper.distinctTempAttachmentsForDraw((List)attachs, (List)((List)entry.getValue()));
                continue;
            }
            AttachmentPanelConvertHelper.distinctTempAttachmentsForDraw((List)((List)entry.getValue()));
        }
        cache.put(tempAttCacheKey, SerializationUtils.toJsonString((Object)attachmentMap));
    }

    private void mergeTempAttachments(IPageCache cache, String tempAttCacheKey, Map<String, List<Map<String, Object>>> attachmentMap) {
        String tempCache = cache.get(tempAttCacheKey);
        if (StringUtils.isNotBlank((CharSequence)tempCache)) {
            Map tempCacheAttachmentMap = (Map)SerializationUtils.fromJsonString((String)tempCache, Map.class);
            for (Map.Entry entry : tempCacheAttachmentMap.entrySet()) {
                List<Map<String, Object>> attachs = attachmentMap.get(entry.getKey());
                List tempAttachs = (List)entry.getValue();
                if (attachs == null) {
                    attachmentMap.put((String)entry.getKey(), tempAttachs);
                    continue;
                }
                if (tempAttachs == null || tempAttachs.isEmpty()) continue;
                attachs.addAll(0, tempAttachs);
            }
        }
    }

    private void addReleaseSourceDataMutexPlugin(IFormView billView, ConvertOperationResult drawResult) {
        boolean exist = false;
        String plugInName = ReleaseConvertDataMutexPlugin.class.getName();
        for (Plugin plugin : billView.getFormShowParameter().getFormConfig().getPlugins()) {
            if (!StringUtils.equals((CharSequence)plugin.getClassName(), (CharSequence)plugInName)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            billView.getFormShowParameter().addCustPlugin(plugInName);
            billView.cacheFormShowParameter();
        }
        ReleaseConvertDataMutexPlugin.addConvertDataMutex(billView, drawResult.getSourceEntityNumber(), drawResult.getDataMutexSrcBillIds());
    }

    private void fillBillCombo() {
        ConvertOpParameter opParameter = this.getConvertOpParamter();
        String recordBill = null;
        if (StringUtils.isBlank((CharSequence)opParameter.getDefTargetBill()) && StringUtils.isBlank((CharSequence)opParameter.getDefSourceBill()) && this.lastBillRuleService.isEnabled()) {
            LastBillRuleRecord record = this.lastBillRuleService.getLastBillRuleRecord(Long.valueOf(RequestContext.get().getCurrUserId()), opParameter.getEntityNumber(), opParameter.getOpType() == ConvertOpType.Push ? "push" : CLOSECALLACTIONID_DRAW);
            recordBill = StringUtils.isNotBlank((CharSequence)record.getBill()) ? record.getBill() : null;
        }
        ConvertBill defTargetBill = null;
        ArrayList<ComboItem> billItems = new ArrayList<ComboItem>(10);
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        billItems.add(blankItem);
        List<ConvertBill> billList = opParameter.getBills();
        if (this.onlyRunConditionRule(opParameter.getEntityNumber()).booleanValue() && opParameter.getOpType() == ConvertOpType.Push && (billList = this.filterRuleUtils.getFilterBills(billList, opParameter)).size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6b63\u5e38\u542f\u7528\u7684\u8f6c\u6362\u8def\u7ebf\u3002", (String)"ConvertOpFormEdit_10", (String)"bos-botp-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Integer> entityNameCounts = new HashMap<String, Integer>(opParameter.getBills().size());
        for (ConvertBill bill : billList) {
            Integer count;
            if (StringUtils.isBlank((CharSequence)bill.getEntityName())) {
                bill.setEntityName(bill.getEntityNumber());
            }
            if ((count = (Integer)entityNameCounts.get(bill.getEntityName())) == null) {
                entityNameCounts.put(bill.getEntityName(), 1);
                continue;
            }
            entityNameCounts.put(bill.getEntityName(), count + 1);
        }
        for (ConvertBill bill : billList) {
            ComboItem billItem = new ComboItem();
            billItem.setValue(bill.getEntityNumber());
            ConvertOpFormEditForThird.setComboItemValue(bill, billItem);
            String thirdCaption = ConvertOpFormEditForThird.getThirdCaption(opParameter.getBills(), bill);
            if (StringUtils.isBlank((CharSequence)bill.getEntityName())) {
                billItem.setCaption(new LocaleString(Lang.get().toString(), bill.getEntityNumber() + thirdCaption));
            } else if ((Integer)entityNameCounts.get(bill.getEntityName()) > 1) {
                billItem.setCaption(new LocaleString(Lang.get().toString(), bill.getEntityName() + " (" + bill.getEntityNumber() + ")" + thirdCaption));
            } else {
                billItem.setCaption(new LocaleString(Lang.get().toString(), bill.getEntityName() + thirdCaption));
            }
            billItems.add(billItem);
            if (StringUtils.equalsIgnoreCase((CharSequence)bill.getEntityNumber(), (CharSequence)opParameter.getDefTargetBill()) || StringUtils.equalsIgnoreCase((CharSequence)bill.getEntityNumber(), (CharSequence)opParameter.getDefSourceBill())) {
                defTargetBill = bill;
            }
            if (recordBill == null || !StringUtils.equalsIgnoreCase((CharSequence)bill.getEntityNumber(), (CharSequence)recordBill)) continue;
            defTargetBill = bill;
        }
        List<ComboItem> layoutComboItemList = this.botpLayoutManager.convertLayoutComboItemList(billItems, this.opParameter, true, this.getView());
        ComboEdit billEditor = (ComboEdit)this.getView().getControl("fbill");
        billEditor.setComboItems(layoutComboItemList);
        if (opParameter.getBills().size() > 0) {
            if (defTargetBill == null) {
                defTargetBill = (ConvertBill)opParameter.getBills().get(0);
            }
            this.botpLayoutManager.setDefaultBill(defTargetBill.getEntityNumber(), layoutComboItemList, this.getModel(), "fbill");
        }
        this.fillRuleCombo(defTargetBill);
        this.fillOrgCombo(defTargetBill);
    }

    private void fillRuleCombo(ConvertBill bill) {
        ConvertBill currBill = bill;
        if (currBill == null) {
            currBill = this.getCurrConvertBill();
        }
        boolean isPush = false;
        if (this.opParameter.getOpType() == ConvertOpType.Push || this.opParameter.getOpType() == ConvertOpType.SpecPush) {
            isPush = true;
        }
        ArrayList<Object> ruleItems = new ArrayList<Object>();
        String defRuleId = "";
        boolean isDefTargetBill = false;
        if (isPush) {
            if (!this.onlyRunConditionRule(this.opParameter.getEntityNumber()).booleanValue()) {
                ComboItem blankItem = new ComboItem();
                blankItem.setValue("@all");
                blankItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u5339\u914d\u89c4\u5219", (String)"ConvertOpFormEdit_3", (String)"bos-botp-formplugin", (Object[])new Object[0])));
                ruleItems.add(blankItem);
            }
            if (currBill != null) {
                isDefTargetBill = StringUtils.equalsIgnoreCase((CharSequence)currBill.getEntityNumber(), (CharSequence)this.opParameter.getDefTargetBill());
            }
        }
        if (this.opParameter.getOpType() == ConvertOpType.Draw) {
            isDefTargetBill = StringUtils.equalsIgnoreCase((CharSequence)currBill.getEntityNumber(), (CharSequence)this.opParameter.getDefSourceBill());
        }
        if (currBill != null) {
            for (Object rule : currBill.getRules()) {
                if (!rule.isVisibled() && isPush || rule.isVisibledCtrl() && !rule.isDrawVisibled() && !isPush || !rule.isVisibled() && !rule.isVisibledCtrl() && !isPush) continue;
                ComboItem ruleItem = new ComboItem();
                ruleItem.setValue(rule.getRuleId());
                ruleItem.setCaption(new LocaleString(rule.getRuleName()));
                ruleItems.add(ruleItem);
                if (!isDefTargetBill || !StringUtils.equalsIgnoreCase((CharSequence)rule.getRuleId(), (CharSequence)this.opParameter.getDefRuleId())) continue;
                defRuleId = rule.getRuleId();
            }
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_FRULE);
        billEditor.setComboItems(ruleItems);
        if (ruleItems.size() == 0) {
            this.getModel().setValue(KEY_FRULE, (Object)"");
        } else {
            Object rule;
            if (StringUtils.isBlank((CharSequence)defRuleId)) {
                defRuleId = ((ComboItem)ruleItems.get(0)).getValue();
                this.opParameter.setDefRuleIdPara("");
            }
            if (StringUtils.isBlank((CharSequence)this.opParameter.getDefRuleIdPara()) && this.lastBillRuleService.isEnabled()) {
                LastBillRuleRecord record = this.lastBillRuleService.getLastBillRuleRecord(Long.valueOf(RequestContext.get().getCurrUserId()), this.opParameter.getEntityNumber(), this.opParameter.getOpType() == ConvertOpType.Push ? "push" : CLOSECALLACTIONID_DRAW);
                String fbill = this.botpLayoutManager.getBillItemValue(this.getModel(), "fbill");
                this.getModel().setValue(KEY_FRULE, (Object)(StringUtils.isNotBlank((CharSequence)record.getRule()) && StringUtils.equalsIgnoreCase((CharSequence)fbill, (CharSequence)record.getBill()) ? record.getRule() : defRuleId));
            } else {
                this.getModel().setValue(KEY_FRULE, (Object)defRuleId);
            }
            rule = (String)this.getModel().getValue(KEY_FRULE);
            boolean exist = ruleItems.stream().anyMatch(arg_0 -> ConvertOpFormEdit.lambda$fillRuleCombo$1((String)rule, arg_0));
            if (!exist) {
                this.getModel().setValue(KEY_FRULE, (Object)((ComboItem)ruleItems.get(0)).getValue());
            }
        }
    }

    private void fillOrgCombo(ConvertBill bill) {
        ConvertBill currBill = bill;
        if (currBill == null) {
            currBill = this.getCurrConvertBill();
        }
        if (currBill == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_FRELATIONORG});
            return;
        }
        ConvertOpParameter opParameter = this.getConvertOpParamter();
        ArrayList orgIds = new ArrayList();
        if (opParameter.getOpType() == ConvertOpType.Push) {
            String targetEntityNumber = currBill.getEntityNumber();
            String ruleId = (String)this.getModel().getValue(KEY_FRULE);
            GetTargetOptionalOrgsArgs args = new GetTargetOptionalOrgsArgs();
            args.setAppId(opParameter.getAppId());
            args.setSourceEntityNumber(opParameter.getEntityNumber());
            args.setTargetEntityNumber(targetEntityNumber);
            for (ConvertOpRule rule : currBill.getRules()) {
                args.getRuleIds().add(rule.getRuleId());
            }
            if (!"@all".equals(ruleId)) {
                args.setRuleId(ruleId);
            }
            args.setSelectedRows((List)opParameter.getSelectedRows());
            ConvertOpFormEditForThird convertOpFormEditForThird = new ConvertOpFormEditForThird((IFormPlugin)this);
            convertOpFormEditForThird.setThirdPushOrgsArgs(args, currBill);
            GetTargetOptionalOrgsResult orgsResult = ConvertServiceHelper.getTargetOptionalOrgs((GetTargetOptionalOrgsArgs)args);
            if (!orgsResult.isSuccess() || !orgsResult.isHasMainOrg()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_FRELATIONORG});
            } else if (!orgsResult.isShowTargetOrgCombo()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_FRELATIONORG});
            } else {
                orgIds.addAll(orgsResult.getOrgIds());
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_FRELATIONORG});
            return;
        }
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
        String comboDisplay = ResManager.loadKDString((String)"\u81ea\u52a8\u8ba1\u7b97", (String)"ConvertOpFormEdit_4", (String)"bos-botp-formplugin", (Object[])new Object[0]);
        ComboItem blankItem = new ComboItem(new LocaleString(comboDisplay), "0");
        orgItems.add(blankItem);
        if (orgIds.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_FRELATIONORG});
        } else {
            Object[] arrOrgIds;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_FRELATIONORG});
            if (orgIds.size() > 10) {
                arrOrgIds = new Object[10];
                for (int i = 0; i < 10; ++i) {
                    arrOrgIds[i] = orgIds.get(i);
                }
            } else {
                arrOrgIds = orgIds.toArray();
            }
            DynamicObjectType orgMainType = EntityMetadataCache.getSubDataEntityType((String)"bos_org", new ArrayList());
            Map orgs = BusinessDataServiceHelper.loadFromCache((Object[])arrOrgIds, (DynamicObjectType)orgMainType);
            for (Map.Entry orgItem : orgs.entrySet()) {
                ComboItem ruleItem = new ComboItem();
                ruleItem.setValue(orgItem.getKey().toString());
                ruleItem.setCaption(new LocaleString(((DynamicObject)orgItem.getValue()).get("name").toString()));
                orgItems.add(ruleItem);
            }
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_FRELATIONORG);
        billEditor.setComboItems(orgItems);
        if (orgItems.size() == 0) {
            this.getModel().setValue(KEY_FRELATIONORG, (Object)"");
        } else {
            this.getModel().setValue(KEY_FRELATIONORG, (Object)blankItem.getValue());
        }
    }

    private ConvertBill getCurrConvertBill() {
        ConvertBill currBill = null;
        ConvertOpParameter opParameter = this.getConvertOpParamter();
        String fldValue = this.botpLayoutManager.getBillItemValue(this.getModel(), "fbill");
        if (opParameter == null || StringUtils.isBlank((CharSequence)fldValue)) {
            return null;
        }
        List<ConvertBill> billList = opParameter.getBills();
        if (this.onlyRunConditionRule(opParameter.getEntityNumber()).booleanValue() && opParameter.getOpType() == ConvertOpType.Push) {
            billList = this.filterRuleUtils.getFilterBills(billList, opParameter);
        }
        for (ConvertBill convertBill : billList) {
            if (StringUtils.equals((CharSequence)fldValue, (CharSequence)convertBill.getEntityNumber())) {
                currBill = convertBill;
                break;
            }
            if (!ConvertOpFormEditForThird.isCurrConvertBill(fldValue, convertBill)) continue;
            currBill = convertBill;
            break;
        }
        return currBill;
    }

    private ConvertOpParameter getConvertOpParamter() {
        if (this.opParameter == null) {
            String opParamJson = (String)this.getView().getFormShowParameter().getCustomParam(CustParam_OpParam);
            if (StringUtils.isNotBlank((CharSequence)opParamJson)) {
                this.opParameter = (ConvertOpParameter)SerializationUtils.fromJsonString((String)opParamJson, ConvertOpParameter.class);
            } else {
                this.opParameter = new ConvertOpParameter();
                this.opParameter.setOpType(ConvertOpType.Push);
            }
            String opInfoJson = (String)this.getView().getFormShowParameter().getCustomParam("opinfo");
            if (StringUtils.isNotBlank((CharSequence)opInfoJson)) {
                OpInfo opInfo = (OpInfo)SerializationUtils.fromJsonString((String)opInfoJson, OpInfo.class);
                this.opParameter.setOpInfo(opInfo);
            }
        }
        return this.opParameter;
    }

    private Boolean onlyRunConditionRule(String sourceEntityNumber) {
        boolean onlyRunConditionRule = false;
        Map billParameter = SystemParamServiceHelper.loadBillParameterObjectFromCache((String)sourceEntityNumber);
        if (MapUtils.isNotEmpty((Map)billParameter)) {
            onlyRunConditionRule = (Boolean)billParameter.get(ONLY_RUN_CONDITION_RULE);
        }
        return onlyRunConditionRule;
    }

    private static /* synthetic */ boolean lambda$fillRuleCombo$1(String rule, ComboItem a) {
        return a.getValue().equals(rule);
    }
}

