/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.botp.LastBillRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.SelectedDisplayField;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.LastBillRuleRecord;
import kd.bos.entity.botp.runtime.BeforeDrawArgs;
import kd.bos.entity.botp.runtime.BeforeDrawOpResult;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Steps;
import kd.bos.form.control.events.PullRefreshEvent;
import kd.bos.form.control.events.PullRefreshListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.botp.ConvertOpMobFormEdit;
import kd.bos.form.plugin.botp.layout.BotpLayoutManager;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;

public class ConvertOpMobFormEditNew
extends AbstractFormPlugin
implements PullRefreshListener {
    private static Log log = LogFactory.getLog(ConvertOpMobFormEdit.class);
    private static final String SOURCE_BILL = "sourceBill";
    private static final String RULE_ID = "ruleId";
    private static final String MOB_FORM_SHOW_PARAMETER = "mobFormShowParameter";
    private static final String STEPSAP = "stepsap";
    private static final String FILTER_PARAMETER = "listFilterParameter";
    private static final String CANCEL = "cancel";
    private static final String NEXTSTEP_1 = "nextstep1";
    private static final String MTOOLBARAP = "mtoolbarap";
    private static final String DRAW_MTOOLBARAP = "drawmtoolbarap";
    private static final String FLEXPANELAP2 = "flexpanelap2";
    private static final String ENTRYENTITY = "entryentity";
    private static final String COMBOFIELD = "combofield";
    private static final String COMBOFIELD1 = "combofield1";
    private static final String CUSTPARAM_OPPARAM = "opparam";
    private static final String HIDEDRAWFORM = "hideDrawForm";
    private ConvertOpParameter opParameter;
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";
    protected static final String CACHEKEY_BILLCOMBOLISTDATA = "BILLCOMBOLISTDATA";
    private LastBillRuleService lastBillRuleService = new LastBillRuleService();
    private BotpLayoutManager botpLayoutManager = new BotpLayoutManager();

    public void click(EventObject evt) {
        super.click(evt);
        Control srcCtrl = (Control)evt.getSource();
        if (NEXTSTEP_1.equalsIgnoreCase(srcCtrl.getKey())) {
            String entityNumber = this.botpLayoutManager.getBillItemValue(this.getModel(), COMBOFIELD);
            if (StringUtils.isBlank((CharSequence)entityNumber)) {
                log.info("please select sourcebill...");
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u5355\u636e\u3002", (String)"ConvertOpMobFormEditNew_0", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            String ruleNumber = (String)this.getModel().getValue(COMBOFIELD1);
            if (StringUtils.isBlank((CharSequence)ruleNumber)) {
                log.info("please select ruleId...");
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8f6c\u6362\u89c4\u5219\u3002", (String)"ConvertOpMobFormEditNew_1", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.setStep(1);
            this.opParameter = this.getConvertOpParamter();
            this.getPageCache().put(SOURCE_BILL, entityNumber);
            this.getPageCache().put(RULE_ID, ruleNumber);
            String sourceBill = this.getPageCache().get(SOURCE_BILL);
            ListShowParameter listShowParameter = this.doBeforeDraw(sourceBill, ruleNumber, this.opParameter);
            if (null == listShowParameter) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u79fb\u52a8\u5217\u8868\u663e\u793a\u53c2\u6570\u5931\u8d25\u3002", (String)"ConvertOpMobFormEditNew_2", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.initMobileList(listShowParameter);
            this.opParameter.setDefSourceBill(sourceBill);
            this.opParameter.setDefRuleId(ruleNumber);
            String callBackActionId = (String)this.getView().getFormShowParameter().getCustomParam("callBackActionId");
            IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
            pageCache.put(callBackActionId, SerializationUtils.toJsonString((Object)this.opParameter));
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAP2});
            this.getView().updateView();
            this.getView().setVisible(Boolean.FALSE, new String[]{ENTRYENTITY, CANCEL, NEXTSTEP_1, DRAW_MTOOLBARAP});
            this.getModel().updateCache();
            if (this.lastBillRuleService.isEnabled()) {
                LastBillRuleRecord lastBillRuleRecord = this.lastBillRuleService.getLastBillRuleRecord(Long.valueOf(RequestContext.get().getCurrUserId()), this.opParameter.getEntityNumber(), this.opParameter.getOpType() == ConvertOpType.Push ? "push" : "draw");
                lastBillRuleRecord.setBill(entityNumber);
                lastBillRuleRecord.setRule(ruleNumber);
                this.lastBillRuleService.addRecord(lastBillRuleRecord);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        ConvertOpParameter convertOpParamter = this.getConvertOpParamter();
        List convertBills = convertOpParamter.getBills();
        ArrayList<ComboItem> billItems = new ArrayList<ComboItem>();
        for (ConvertBill convertBill : convertBills) {
            String entityNumber = convertBill.getEntityNumber();
            String entityName = convertBill.getEntityName();
            this.addComboItem(billItems, entityNumber, new LocaleString(Lang.get().toString(), entityName));
        }
        List<ComboItem> layoutComboItemList = this.botpLayoutManager.convertLayoutComboItemList(billItems, this.opParameter, false, this.getView());
        ComboEdit comboField = (ComboEdit)this.getView().getControl(COMBOFIELD);
        comboField.setComboItems(layoutComboItemList);
        this.getPageCache().put(CACHEKEY_BILLCOMBOLISTDATA, SerializationUtils.toJsonString(layoutComboItemList));
        String defSourceBill = this.getConvertOpParamter().getSrcDefSourceBill();
        if (StringUtils.isNotBlank((CharSequence)defSourceBill)) {
            this.setConvertOpRule(defSourceBill);
        } else if (this.lastBillRuleService.isEnabled()) {
            LastBillRuleRecord record = this.lastBillRuleService.getLastBillRuleRecord(Long.valueOf(RequestContext.get().getCurrUserId()), this.opParameter.getEntityNumber(), this.opParameter.getOpType() == ConvertOpType.Push ? "push" : "draw");
            defSourceBill = StringUtils.isNotBlank((CharSequence)record.getBill()) ? record.getBill() : null;
            this.setConvertOpRule(defSourceBill);
            this.botpLayoutManager.setDefaultBill(defSourceBill, layoutComboItemList, this.getModel(), COMBOFIELD);
        }
    }

    public void beforeBindData(EventObject e) {
        String defRuleId;
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{MTOOLBARAP});
        if (this.isHideDrawForm()) {
            String defSourceBill = this.getConvertOpParamter().getDefSourceBill();
            defRuleId = this.getConvertOpParamter().getDefRuleId();
            this.getPageCache().put(SOURCE_BILL, defSourceBill);
            this.getPageCache().put(RULE_ID, defRuleId);
            this.getView().setVisible(Boolean.FALSE, new String[]{STEPSAP, ENTRYENTITY, NEXTSTEP_1, DRAW_MTOOLBARAP});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAP2});
            ListShowParameter listShowParameter = this.doBeforeDraw(defSourceBill, defRuleId, this.opParameter);
            if (null == listShowParameter) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u79fb\u52a8\u5217\u8868\u663e\u793a\u53c2\u6570\u5931\u8d25\u3002", (String)"ConvertOpMobFormEditNew_2", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.initMobileList(listShowParameter);
        } else {
            String sourceBill = this.getPageCache().get(SOURCE_BILL);
            String ruleId = this.getPageCache().get(RULE_ID);
            if (StringUtils.isNotBlank((CharSequence)sourceBill) && StringUtils.isNotBlank((CharSequence)ruleId)) {
                return;
            }
            this.setStep(0);
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP2});
            this.getView().setVisible(Boolean.TRUE, new String[]{CANCEL, NEXTSTEP_1});
        }
        if (StringUtils.isNotBlank((CharSequence)this.getConvertOpParamter().getSrcDefSourceBill())) {
            String billcombolistdataJson = this.getPageCache().get(CACHEKEY_BILLCOMBOLISTDATA);
            if (StringUtils.isNotBlank((CharSequence)billcombolistdataJson)) {
                List comboItemList = SerializationUtils.fromJsonStringToList((String)billcombolistdataJson, ComboItem.class);
                this.botpLayoutManager.setDefaultBill(this.getConvertOpParamter().getSrcDefSourceBill(), comboItemList, this.getModel(), COMBOFIELD);
            }
            defRuleId = this.getConvertOpParamter().getSrcDefRuleId();
            if (StringUtils.isBlank((CharSequence)this.getConvertOpParamter().getDefRuleIdPara()) && this.lastBillRuleService.isEnabled()) {
                LastBillRuleRecord record = this.lastBillRuleService.getLastBillRuleRecord(Long.valueOf(RequestContext.get().getCurrUserId()), this.opParameter.getEntityNumber(), this.opParameter.getOpType() == ConvertOpType.Push ? "push" : "draw");
                defRuleId = StringUtils.isNotBlank((CharSequence)record.getRule()) && StringUtils.equalsIgnoreCase((CharSequence)this.getConvertOpParamter().getSrcDefSourceBill(), (CharSequence)record.getBill()) ? record.getRule() : defRuleId;
            }
            this.getModel().setValue(COMBOFIELD1, (Object)defRuleId);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{NEXTSTEP_1, CANCEL});
    }

    public void pullRefesh(PullRefreshEvent pullRefreshEvent) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)COMBOFIELD, (CharSequence)name) && this.botpLayoutManager.billItemValueChange(e)) {
            String entityNumberSel = this.botpLayoutManager.getBillItemValue(this.getModel(), COMBOFIELD);
            if (StringUtils.isBlank((CharSequence)entityNumberSel)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u5355\u636e\u3002", (String)"ConvertOpMobFormEditNew_0", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
                this.getModel().setValue(COMBOFIELD1, (Object)"");
                return;
            }
            this.setConvertOpRule(entityNumberSel);
        }
    }

    private void setConvertOpRule(String sourceEntityNumberSel) {
        String defRuleId = "";
        Boolean isDefTargetBill = StringUtils.equalsIgnoreCase((CharSequence)sourceEntityNumberSel, (CharSequence)this.getConvertOpParamter().getSrcDefSourceBill());
        ConvertOpParameter convertOpParamter = this.getConvertOpParamter();
        List convertBills = convertOpParamter.getBills();
        ArrayList<ComboItem> ruleItems = new ArrayList<ComboItem>();
        for (ConvertBill convertBill : convertBills) {
            String entityNumber = convertBill.getEntityNumber();
            if (!StringUtils.equalsIgnoreCase((CharSequence)sourceEntityNumberSel, (CharSequence)entityNumber)) continue;
            defRuleId = this.addRuleItem(convertBill, ruleItems, isDefTargetBill);
            break;
        }
        ComboEdit comboField = (ComboEdit)this.getView().getControl(COMBOFIELD1);
        comboField.setComboItems(ruleItems);
        if (ruleItems.size() == 0) {
            this.getModel().setValue(COMBOFIELD1, (Object)"");
        } else {
            if (this.lastBillRuleService.isEnabled()) {
                LastBillRuleRecord record = this.lastBillRuleService.getLastBillRuleRecord(Long.valueOf(RequestContext.get().getCurrUserId()), this.opParameter.getEntityNumber(), this.opParameter.getOpType() == ConvertOpType.Push ? "push" : "draw");
                defRuleId = StringUtils.isNotBlank((CharSequence)record.getRule()) && StringUtils.equalsIgnoreCase((CharSequence)sourceEntityNumberSel, (CharSequence)record.getBill()) ? record.getRule() : defRuleId;
            }
            this.getModel().setValue(COMBOFIELD1, (Object)defRuleId);
        }
    }

    private String addRuleItem(ConvertBill convertBill, List<ComboItem> items, Boolean isDefTargetBill) {
        String defRuleId = "";
        List rules = convertBill.getRules();
        if (rules == null || rules.size() <= 0) {
            return defRuleId;
        }
        for (ConvertOpRule rule : rules) {
            if (!rule.isVisibled()) continue;
            String ruleId = rule.getRuleId();
            String ruleName = rule.getRuleName();
            this.addComboItem(items, ruleId, new LocaleString(Lang.get().toString(), ruleName));
            if (!isDefTargetBill.booleanValue() || !StringUtils.equalsIgnoreCase((CharSequence)rule.getRuleId(), (CharSequence)this.getConvertOpParamter().getSrcDefRuleId())) continue;
            defRuleId = ruleId;
        }
        return defRuleId;
    }

    private void addComboItem(List<ComboItem> items, String value, LocaleString caption) {
        ComboItem comboItem = new ComboItem();
        comboItem.setValue(value);
        comboItem.setCaption(caption);
        items.add(comboItem);
    }

    private ConvertOpParameter getConvertOpParamter() {
        if (this.opParameter == null) {
            String opParamJson = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_OPPARAM);
            if (StringUtils.isNotBlank((CharSequence)opParamJson)) {
                this.opParameter = (ConvertOpParameter)SerializationUtils.fromJsonString((String)opParamJson, ConvertOpParameter.class);
            } else {
                this.opParameter = new ConvertOpParameter();
                this.opParameter.setOpType(ConvertOpType.Push);
            }
        }
        return this.opParameter;
    }

    private boolean isHideDrawForm() {
        return (Boolean)this.getView().getFormShowParameter().getCustomParam(HIDEDRAWFORM);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        this.getView().returnDataToParent(e.getReturnData());
        this.getView().close();
    }

    private void setStep(int step) {
        Steps steps = (Steps)this.getControl(STEPSAP);
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>();
        currentStepMap.put("currentStep", step);
        currentStepMap.put("currentStatus", "process");
        steps.setCurrentStep(currentStepMap);
    }

    private ListShowParameter doBeforeDraw(String sourceEntityNumber, String ruleId, ConvertOpParameter opParameter) {
        BeforeDrawArgs args = new BeforeDrawArgs();
        args.setSourceEntityNumber(sourceEntityNumber);
        args.setTargetEntityNumber(opParameter.getEntityNumber());
        args.setTargetPageId(opParameter.getTargetBillPageId());
        args.setRuleId(ruleId);
        args.setDuplicateRemove(((Boolean)this.getView().getFormShowParameter().getCustomParam("duplicateremove")).booleanValue());
        args.setDuplicateEntryRemove(((Boolean)this.getView().getFormShowParameter().getCustomParam("duplicateentryremove")).booleanValue());
        args.getCustomParams().putAll(opParameter.getCustomParams());
        ConvertOperationResult opResult = ConvertServiceHelper.beforeDraw((BeforeDrawArgs)args);
        BeforeDrawOpResult result = (BeforeDrawOpResult)opResult;
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(result.getMessage());
            return null;
        }
        String filter = result.getDrawFilter();
        String sourceFormId = StringUtils.isNotBlank((CharSequence)result.getMobDrawSourceLayout()) ? result.getMobDrawSourceLayout() : (StringUtils.isNotBlank((CharSequence)result.getDrawSourceLayout()) ? result.getDrawSourceLayout() : sourceEntityNumber);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)sourceFormId, (boolean)true);
        if (null == showParameter) {
            return null;
        }
        showParameter.getCustomParams().put("isIgnoreLicense", true);
        showParameter.getListFilterParameter().setQFilter(filter);
        if (result.getDrawSelectedEntity().size() > 0) {
            String selectEntity = (String)result.getDrawSelectedEntity().get(result.getDrawSelectedEntity().size() - 1);
            showParameter.getListFilterParameter().setSelectEntity(selectEntity);
            showParameter.getCustomParams().put("ismergerows", false);
        }
        if (result.getSrcMainOrgId() != null) {
            showParameter.setIsolationOrg(true);
            showParameter.setUseOrgId(result.getSrcMainOrgId().longValue());
        } else {
            showParameter.setIsolationOrg(false);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(FILTER_PARAMETER, this.serializeListShowParameter(showParameter));
        this.getPageCache().put(MOB_FORM_SHOW_PARAMETER, SerializationUtils.toJsonString(paramMap));
        return showParameter;
    }

    private void initMobileList(ListShowParameter parameter) {
        MobileFormShowParameter showParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        MobileListShowParameter mobileListShowParameter = new MobileListShowParameter();
        mobileListShowParameter.setBillFormId(parameter.getBillFormId());
        mobileListShowParameter.setListFilterParameter(parameter.getListFilterParameter());
        mobileListShowParameter.setFormId("bos_moblisttabf7");
        FormConfig formConfig = FormMetadataCache.getMobListFormConfig((String)parameter.getBillFormId());
        mobileListShowParameter.setCaption(formConfig.getCaption().toString());
        mobileListShowParameter.setLookUp(true);
        mobileListShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        mobileListShowParameter.getOpenStyle().setTargetKey(FLEXPANELAP2);
        mobileListShowParameter.setListFilterParameter(parameter.getListFilterParameter());
        mobileListShowParameter.setMultiSelect(true);
        mobileListShowParameter.setMustInput(true);
        mobileListShowParameter.setCustomParam("isIgnoreLicense", (Object)true);
        mobileListShowParameter.setCustomParam("ismergerows", (Object)false);
        mobileListShowParameter.setCustomParam("bos_call_source_type", (Object)"botp_draw");
        SelectedDisplayField selectedDisplayField = new SelectedDisplayField();
        selectedDisplayField.setMainField((String)showParameter.getCustomParam("primaryField"));
        mobileListShowParameter.setSelectedDisplayField(selectedDisplayField);
        mobileListShowParameter.setListFilterParameter(parameter.getListFilterParameter());
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), DBServiceHelper.genStringId());
        mobileListShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)mobileListShowParameter);
    }

    private ListShowParameter getListFilterParameter(String serializeString) {
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>(10);
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(MobileListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRowCollection.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRow.class));
        DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
        return (ListShowParameter)dcJsonSerializer.deserializeFromString(serializeString, null);
    }

    private String serializeListShowParameter(ListShowParameter listShowParameter) {
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>();
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(MobileListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRowCollection.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRow.class));
        DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
        return dcJsonSerializer.serializeToString((Object)listShowParameter, null);
    }
}

