/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import java.util.EventObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOpProgressCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ConvertProgressEdit
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String FORMID_CONVERTPROGRESS = "botp_convertprogress";
    private static final String CUSTPARAM_TASKID = "taskid";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String KEY_LBLPROGRESS = "lblprogress";

    public static void showConvertProgressForm(IFormView parentView, AbstractConvertServiceArgs args, CloseCallBack closeCallBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_CONVERTPROGRESS);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put(CUSTPARAM_TASKID, args.getTaskId());
        showParameter.setCloseCallBack(closeCallBack);
        parentView.showForm(showParameter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
    }

    public void onProgress(ProgressEvent e) {
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            ProgressBar bar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
            bar.stop();
            return;
        }
        boolean completed = ConvertOpProgressCache.isCompleted((String)taskId);
        boolean finished = ConvertOpProgressCache.isFinished((String)taskId);
        boolean isError = ConvertOpProgressCache.isError((String)taskId);
        ProgressBar bar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        if (completed) {
            this.complete();
            bar.stop();
        } else if (isError) {
            this.getView().getParentView().showErrMessage(ConvertOpProgressCache.getErrorMessage((String)taskId), "");
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
            bar.stop();
        } else if (finished) {
            this.getView().close();
            bar.stop();
        } else {
            int progress = ConvertOpProgressCache.getProgress((String)taskId);
            String tip = ConvertOpProgressCache.getProgressTip((String)taskId);
            e.setProgress(progress);
            if (StringUtils.isNotBlank((CharSequence)tip)) {
                this.setProgressTip(tip);
            }
            if (progress >= 100) {
                this.getView().close();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent((Object)this.getTaskId());
    }

    private void complete() {
        this.getView().close();
    }

    private String getTaskId() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_TASKID);
    }

    private void setProgressTip(String tip) {
        Label lblTip = (Label)this.getControl(KEY_LBLPROGRESS);
        lblTip.setText(tip);
    }
}

