/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.SourceRowReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.botp.PushStatus;

public class ConvertReportEdit
extends AbstractFormPlugin {
    private static final String KEY_REPORTENTRY = "report";
    private static final String KEY_SRCBILLNO = "srcbillno";
    private static final String KEY_PUSHSTATUS = "pushstatus";
    private static final String KEY_REPORTMESSAGE = "reportmessage";
    private static final String KEY_LBLREPORT = "lblreport";

    public void afterCreateNewData(EventObject e) {
        if (this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()) == null) {
            return;
        }
        ConvertOperationResult convertResult = this.getConvertResult();
        this.fillReportEntry(convertResult);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getView().getFormShowParameter().getOpenStyle().getShowType() == ShowType.InContainer && this.getView().getControl("operatepanel") != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"operatepanel"});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.releaseResult();
    }

    private void fillReportEntry(ConvertOperationResult convertResult) {
        int rowCount = 0;
        for (SourceBillReport billReport : convertResult.getBillReports()) {
            ++rowCount;
            rowCount += billReport.getLinkEntityRowReports().size();
            for (Map.Entry otherEntity : billReport.getDependEntityRowReports().entrySet()) {
                rowCount += ((List)otherEntity.getValue()).size();
            }
        }
        int defRowCount = this.getModel().getEntryRowCount(KEY_REPORTENTRY);
        if (rowCount > defRowCount) {
            this.getModel().batchCreateNewEntryRow(KEY_REPORTENTRY, rowCount - defRowCount);
        } else {
            for (int i = defRowCount - 1; i >= rowCount; --i) {
                this.getModel().deleteEntryRow(KEY_REPORTENTRY, i);
            }
        }
        MainEntityType srcMainType = null;
        MainEntityType targetMainType = null;
        if (StringUtils.isNotBlank((CharSequence)convertResult.getTargetEntityNumber())) {
            targetMainType = EntityMetadataCache.getDataEntityType((String)convertResult.getTargetEntityNumber());
        }
        if (StringUtils.isNotBlank((CharSequence)convertResult.getSourceEntityNumber())) {
            srcMainType = EntityMetadataCache.getDataEntityType((String)convertResult.getSourceEntityNumber());
        }
        boolean pushSuccess = convertResult.isSuccess();
        int rowIndex = 0;
        int successBillCount = 0;
        int failBillCount = 0;
        for (SourceBillReport billReport : convertResult.getBillReports()) {
            this.getModel().setValue(KEY_SRCBILLNO, (Object)billReport.getRowInfo(), rowIndex);
            if (pushSuccess && billReport.isSuccess()) {
                this.getModel().setValue(KEY_PUSHSTATUS, (Object)String.valueOf(PushStatus.Success.getValue()), rowIndex);
            } else {
                this.getModel().setValue(KEY_PUSHSTATUS, (Object)String.valueOf(PushStatus.Fail.getValue()), rowIndex);
            }
            this.getModel().setValue(KEY_REPORTMESSAGE, (Object)billReport.buildSummary(targetMainType), rowIndex);
            for (SourceRowReport rowReport : billReport.getLinkEntityRowReports()) {
                this.getModel().setValue(KEY_SRCBILLNO, (Object)("    " + rowReport.getRowInfo(billReport)), ++rowIndex);
                this.getModel().setValue(KEY_PUSHSTATUS, (Object)String.valueOf(PushStatus.Fail.getValue()), rowIndex);
                this.getModel().setValue(KEY_REPORTMESSAGE, (Object)rowReport.getFailMessage(), rowIndex);
            }
            String billNo = StringUtils.isBlank((CharSequence)billReport.getBillNo()) ? String.valueOf(billReport.getBillId()) : billReport.getBillNo();
            for (Map.Entry otherEntity : billReport.getDependEntityRowReports().entrySet()) {
                EntityType entityType = srcMainType == null ? null : (EntityType)srcMainType.getAllEntities().get(otherEntity.getKey());
                String entryName = "";
                String subEntryName = "";
                if (entityType instanceof SubEntryType) {
                    entryName = entityType.getParent().getDisplayName().toString();
                    subEntryName = entityType.getDisplayName().toString();
                } else if (entityType instanceof EntryType) {
                    entryName = entityType.getDisplayName().toString();
                }
                for (SourceRowReport rowReport : (List)otherEntity.getValue()) {
                    this.getModel().setValue(KEY_SRCBILLNO, (Object)("    " + rowReport.getRowInfo(billNo, entryName, subEntryName)), ++rowIndex);
                    this.getModel().setValue(KEY_PUSHSTATUS, (Object)String.valueOf(PushStatus.Fail.getValue()), rowIndex);
                    this.getModel().setValue(KEY_REPORTMESSAGE, (Object)rowReport.getFailMessage(), rowIndex);
                }
            }
            if (billReport.isSuccess()) {
                ++successBillCount;
            } else {
                ++failBillCount;
            }
            ++rowIndex;
        }
        String tips = null;
        tips = !convertResult.isSuccess() ? String.format(ResManager.loadKDString((String)"\u9009\u62e9\u4e86 %1$s \u5f20\u5355\u636e\u4e0b\u63a8\uff0c\u5168\u90e8\u5931\u8d25%2$s\uff1b\u5171\u8017\u65f6 %3$s \u79d2", (String)"ConvertReportEdit_5", (String)"bos-botp-formplugin", (Object[])new Object[0]), convertResult.getBillReports().size(), StringUtils.isBlank((CharSequence)convertResult.getMessage()) ? "" : "\uff1a" + convertResult.getMessage(), convertResult.getRunSecond()) : String.format(ResManager.loadKDString((String)"\u9009\u62e9\u4e86 %1$d \u5f20\u5355\u636e\u4e0b\u63a8\uff0c\u6210\u529f %2$s \u5f20\uff0c\u5931\u8d25 %3$s \u5f20\uff1b\u751f\u6210 %4$s \u5f20\u76ee\u6807\u5355\uff0c\u5171\u8017\u8d39 %5$s \u79d2", (String)"ConvertReportEdit_6", (String)"bos-botp-formplugin", (Object[])new Object[0]), convertResult.getBillReports().size(), successBillCount, failBillCount, convertResult.getTargetBillIds().size() + convertResult.getCachePageIds().size(), convertResult.getRunSecond());
        Label label = (Label)this.getView().getControl(KEY_LBLREPORT);
        label.setText(tips);
    }

    private void releaseResult() {
        String targetEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam("targetentitynumber");
        String parentPageId = (String)this.getView().getFormShowParameter().getCustomParam("convertresultpageid");
        String releaseResult = (String)this.getView().getFormShowParameter().getCustomParam("releaseresult");
        if (StringUtils.isBlank((CharSequence)releaseResult) || StringUtils.isBlank((CharSequence)targetEntityNumber) || StringUtils.isBlank((CharSequence)parentPageId)) {
            return;
        }
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        String convertResultJson = pageCache.get("ConvertOperationResult");
        if (StringUtils.isNotBlank((CharSequence)convertResultJson)) {
            ConvertOperationResult convertResult = (ConvertOperationResult)SerializationUtils.fromJsonString((String)convertResultJson, ConvertOperationResult.class);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
            convertResult.release(new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType type) {
                    BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)type);
                }
            }, mainType);
        }
        pageCache.remove("ConvertOperationResult");
    }

    private ConvertOperationResult getConvertResult() {
        String pageId = (String)this.getView().getFormShowParameter().getCustomParam("convertresultpageid");
        if (StringUtils.isBlank((CharSequence)pageId)) {
            return new ConvertOperationResult();
        }
        IFormView parentView = this.getView().getViewNoPlugin(pageId);
        if (parentView == null) {
            return new ConvertOperationResult();
        }
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        String convertResultJson = pageCache.get("ConvertOperationResult");
        if (StringUtils.isBlank((CharSequence)convertResultJson)) {
            return new ConvertOperationResult();
        }
        ConvertOperationResult convertResult = (ConvertOperationResult)SerializationUtils.fromJsonString((String)convertResultJson, ConvertOperationResult.class);
        return convertResult;
    }
}

