/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.helper.AttachmentPanelConvertHelper;
import kd.bos.entity.botp.runtime.AttachmentInfoPackage;
import kd.bos.entity.botp.runtime.AttachmentItemInfo;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.attach.IAttachmentFieldModelProxy;
import kd.bos.service.ServiceFactory;

final class ConvertResultAttachment {
    private static Log log = LogFactory.getLog(ConvertResultAttachment.class);
    private static final String CUSTPARAMKEY_TARGETENTITYNUMBER = "targetentitynumber";
    private static final String CACHEKEY_ATTACHMENTPANAL = "convertresult_attachmentpanel";
    private static final String CACHEKEY_CHILDPAGEID = "childpageid";
    private static final String ATTACHMENTINFO = "AttachmentInfo";
    private static final String SHAREATTSMSG = "ShareAttsMsg";
    private static final String EMPTY_ATTACHMENT_MAP_FOR_CLEAR_CACHE = "{}";
    private static final String KEY_URL = "url";
    private static final String KEY_PREVIEWURL = "previewurl";
    private IFormView view;
    private BillEntityType targetMainType;

    public ConvertResultAttachment(IFormView view) {
        this.view = view;
    }

    private IFormView getView() {
        return this.view;
    }

    private IFormView getChildBillView() {
        return this.view.getView(this.getPageCache().get(CACHEKEY_CHILDPAGEID));
    }

    private IPageCache getPageCache() {
        return (IPageCache)this.view.getService(IPageCache.class);
    }

    private String getTargetEntityNumber() {
        String targetEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAMKEY_TARGETENTITYNUMBER);
        return targetEntityNumber;
    }

    private BillEntityType getTargetMainType() {
        if (this.targetMainType == null) {
            String entityNUmber = this.getTargetEntityNumber();
            this.targetMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNUmber);
        }
        return this.targetMainType;
    }

    protected void updateChildViewAttachment(Object pkId, IFormView childView) {
        String childTempAttCacheKey;
        IPageCache childViewPageCache = (IPageCache)childView.getService(IPageCache.class);
        String cacheTempJsonString = childViewPageCache.get(childTempAttCacheKey = this.buildTempAttCacheKey(childView));
        Map<String, List<Map<String, Object>>> tempAttachmentInfoMap = StringUtils.isNotEmpty((CharSequence)cacheTempJsonString) ? (Map)SerializationUtils.fromJsonString((String)cacheTempJsonString, Map.class) : new HashMap(8);
        tempAttachmentInfoMap.replaceAll((key, value) -> AttachmentPanelConvertHelper.convertBindAttachmentsToAttachmentInfoMaps((List)value));
        this.mergeToParentViewAttachment(tempAttachmentInfoMap, pkId);
    }

    private void mergeToParentViewAttachment(Map<String, List<Map<String, Object>>> tempAttachmentInfoMap, Object pkId) {
        Map<Object, Map<String, List<Map<String, Object>>>> attachments = this.getAttachmentPanelCache();
        attachments.put(String.valueOf(pkId), tempAttachmentInfoMap);
        this.cacheAttachmentInfoMaps(attachments);
    }

    protected void saveAttachmentPanals(String appId, String formId, Set<Object> successRowIds) {
        Map<Object, Map<String, List<Map<String, Object>>>> attachmentInfoMaps = this.getAttachmentPanelCache();
        for (Object pkId : successRowIds) {
            Map<String, List<Map<String, Object>>> attachmentInfoMap = attachmentInfoMaps.get(String.valueOf(pkId));
            if (attachmentInfoMap == null) continue;
            Map<String, String> shareAttsMsg = this.getShareAttsMsg(this.getPageCache(), attachmentInfoMap.keySet());
            AttachmentInfoPackage pkg = new AttachmentInfoPackage();
            pkg.setAppId(appId);
            pkg.setFormId(formId);
            pkg.setPkId(pkId);
            pkg.setShareAttsMsg(shareAttsMsg);
            HashMap<String, List> attInfoMap = new HashMap<String, List>(attachmentInfoMap.size());
            for (Map.Entry<String, List<Map<String, Object>>> attInfoEntry : attachmentInfoMap.entrySet()) {
                List attItemInfoList = AttachmentPanelConvertHelper.convertAttachmentInfoMapsToAttachmentInfos(attInfoEntry.getValue());
                attItemInfoList.removeIf(itemInfo -> Boolean.FALSE.equals(itemInfo.getTempBotpAttachment()));
                attInfoMap.put(attInfoEntry.getKey(), attItemInfoList);
            }
            pkg.setAttachmentInfo(attInfoMap);
            Map attachmentUrls = pkg.persist();
            this.clearSavedAttachments(attachmentInfoMap, attachmentUrls);
        }
        this.cacheAttachmentInfoMaps(attachmentInfoMaps);
    }

    private void clearSavedAttachments(Map<String, List<Map<String, Object>>> attachmentInfoMap, Map<String, String> attachmentUrls) {
        attachmentInfoMap.values().forEach(list -> list.removeIf(att -> attachmentUrls.containsKey(att.get("uid"))));
    }

    protected void setAttachmentOption(OperateOption option) {
        IAttachmentFieldModelProxy attachmentModel = (IAttachmentFieldModelProxy)ServiceFactory.getService(IAttachmentFieldModelProxy.class);
        if (attachmentModel.checkIfHasAttProp(this.getTargetEntityNumber())) {
            HashMap<String, Object> attachmentField = new HashMap<String, Object>();
            IFormView childView = this.getChildBillView();
            Object pkId = this.genPKValue(childView);
            attachmentField.put("PkId", pkId);
            attachmentField.put("PageId", this.getPageCache().get(CACHEKEY_CHILDPAGEID));
            option.setVariableValue("AttachmentField", SerializationUtils.toJsonString(attachmentField));
        }
    }

    Map<Object, Map<String, List<Map<String, Object>>>> getAttachmentPanelCache() {
        HashMap<Object, Map<String, List<Map<String, Object>>>> attachmentPanelCache = new HashMap<Object, Map<String, List<Map<String, Object>>>>();
        String cacheValue = this.getPageCache().get(CACHEKEY_ATTACHMENTPANAL);
        if (StringUtils.isBlank((CharSequence)cacheValue)) {
            return attachmentPanelCache;
        }
        return (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
    }

    private String buildTempAttCacheKey(IFormView childView) {
        return "TampAttCache" + childView.getPageId();
    }

    private Object genPKValue(IFormView childView) {
        BillEntityType mainType = this.getTargetMainType();
        PKFieldProp pkProp = (PKFieldProp)mainType.getPrimaryKey();
        DynamicObject billObj = childView.getModel().getDataEntity(true);
        Object pkId = billObj.getPkValue();
        if (pkProp.getValueComparator().compareValue(pkId)) {
            pkId = pkProp instanceof VarcharProp ? DB.genStringId((String)"") : Long.valueOf(DB.genGlobalLongId());
            pkProp.setValueFast((Object)billObj, pkId);
        }
        return pkId;
    }

    private Map<String, String> getShareAttsMsg(IPageCache cache, Set<String> attachPanelKeys) {
        HashMap<String, String> shareAttsMsg = new HashMap<String, String>();
        for (String attPanelKey : attachPanelKeys) {
            String entityId = cache.get("AttEntityId" + attPanelKey);
            if (StringUtils.isEmpty((CharSequence)entityId)) continue;
            shareAttsMsg.put(attPanelKey, entityId);
        }
        return shareAttsMsg;
    }

    private void cacheAttachmentInfoMaps(Map<Object, Map<String, List<Map<String, Object>>>> attachmentInfos) {
        this.getPageCache().put(CACHEKEY_ATTACHMENTPANAL, SerializationUtils.toJsonString(attachmentInfos));
    }

    private void cacheAttachmentItemInfos(Map<Object, Map<String, List<AttachmentItemInfo>>> attachmentInfos) {
        this.getPageCache().put(CACHEKEY_ATTACHMENTPANAL, SerializationUtils.toJsonString(attachmentInfos));
    }

    public void cacheAttachmentInfosAndCleanConvertResult(ConvertOperationResult convertResult) {
        Map attachmentInfos = convertResult.getBillAttachmentPanelInfos();
        if (attachmentInfos == null) {
            return;
        }
        this.cacheAttachmentItemInfos(attachmentInfos);
        convertResult.setBillAttachmentPanelInfos(null);
    }

    public void updateCurrentChildViewAttachment(IFormView childView) {
        String cacheTempJsonString = childView.getPageCache().get(this.buildTempAttCacheKey(childView));
        Map<String, List> tempAttachmentInfoMap = StringUtils.isNotEmpty((CharSequence)cacheTempJsonString) ? (Map)SerializationUtils.fromJsonString((String)cacheTempJsonString, Map.class) : new HashMap();
        tempAttachmentInfoMap.replaceAll((key, value) -> {
            for (Map att : value) {
                String url = (String)att.get(KEY_URL);
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    String path = UrlUtil.getParam((String)url, (String)"path");
                    if (path != null) {
                        att.put(KEY_URL, AttachmentPanelConvertHelper.trimPath((String)path));
                    }
                } else {
                    log.error("\u9644\u4ef6url\u4e3anull\uff0c\u5f02\u5e38\u9644\u4ef6\u4fe1\u606f\uff1a" + att);
                }
                String previewurl = (String)att.get(KEY_PREVIEWURL);
                if (StringUtils.isNotBlank((CharSequence)previewurl)) {
                    String path = UrlUtil.getParam((String)previewurl, (String)"path");
                    if (path == null) continue;
                    att.put(KEY_PREVIEWURL, AttachmentPanelConvertHelper.trimPath((String)path));
                    continue;
                }
                log.error("\u9644\u4ef6previewurl\u4e3anull\u5f02\u5e38\u9644\u4ef6\u4fe1\u606f\uff1a" + att);
            }
            return value;
        });
        childView.getPageCache().put(this.buildTempAttCacheKey(childView), SerializationUtils.toJsonString(tempAttachmentInfoMap));
    }

    public void clearChildViewTempAttCache(IBillView childView) {
        String childTempAttCacheKey = this.buildTempAttCacheKey((IFormView)childView);
        childView.getPageCache().remove(childTempAttCacheKey);
    }
}

