/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertResultMutex;
import kd.bos.entity.botp.helper.AttachmentPanelConvertHelper;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.SourceRowReport;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.Audit;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.botp.util.ConvertResultFormUtil;
import kd.bos.mutex.AutoReleaseLock;
import kd.bos.mutex.DataMutex;
import kd.bos.service.botp.facade.ConvertResultFormEditFacade;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.log4j.Logger;

public class ConvertTrackerEdit
extends AbstractBillPlugIn {
    private static Logger log = Logger.getLogger(ConvertTrackerEdit.class);
    private static final String KEY_TITLE_PANEL_BILL = "titlepanel";
    private static final String KEY_TITLE_PANEL_BASE = "titleapanel";
    private static final String CACHEKEY_CURRBILLINDEX = "currbillindex";
    private static final String KEY_CACHEPAGEID = "pageid";
    private static final String KEY_SAVESTATUS = "savestatus";
    private static final String KEY_BILLSTATUS = "billstatus";
    private static final String KEY_PKVALUE = "pkvalue";
    private static final String KEY_BILLNO = "billno";
    private static final String CACHEKEY_SAVECOUNT = "savecount";
    private static final String CACHEKEY_SUBMITCOUNT = "submitcount";
    private static final String CACHEKEY_AUDITCOUNT = "auditcount";
    private static final String CACHEKEY_BILLCOUNT = "billcount";
    private static final String KEY_LBLSAVESTATUS = "lblsavestatus";
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";
    private static final String MUTEX_OPERATIONKEY = "modify";
    private static final String MUTEX_REQUIRE_ERROR = "MUTEX_REQUIRE_ERROR";
    private static final String CACHEKEY_MUTEX = "mutxt";
    private static final String ISEXISTCONFIRMMSG = "isExistConfirmMsg";
    private ConvertOperationResult convertOperationResult;
    private ConvertResultFormEditFacade convertFormEditFacade = ConvertResultFormEditFacade.getInstance();
    private Boolean updateTempAttachmentFlag = false;
    private static final String TEMP_ATTACHMENT_FLAG = "TempAttachmentFlag";
    private static final String KEY_FALSE = "false";

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        String currRowIndex = parentView.getPageCache().get(CACHEKEY_CURRBILLINDEX);
        String cachePageId = null;
        if (currRowIndex != null) {
            int rowIndex = Integer.parseInt(currRowIndex);
            cachePageId = (String)parentView.getModel().getValue(KEY_CACHEPAGEID, rowIndex);
        }
        if (StringUtils.isBlank(cachePageId) && StringUtils.isBlank((CharSequence)(cachePageId = ((BillShowParameter)this.getView().getFormShowParameter()).getCachePageId()))) {
            return;
        }
        ConvertOperationResult convertResult = this.getConvertResult();
        if (convertResult == null) {
            return;
        }
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = this.getModel().getDataEntityType();
        DynamicObject dataEntity = convertResult.loadTargetDataObject(refDataProvider, mainType, cachePageId);
        if (dataEntity != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            this.convertFormEditFacade.beforeCreateDataForChildView(pageCache, dataEntity);
            ExtendedDataEntitySet dataEntitySet = new ExtendedDataEntitySet();
            dataEntitySet.Parse(new DynamicObject[]{dataEntity}, mainType);
            for (EntityType entityType : mainType.getAllEntities().values()) {
                ExtendedDataEntity[] extDataEntitys = dataEntitySet.FindByEntityKey(entityType.getName());
                if (extDataEntitys == null) continue;
                for (ExtendedDataEntity extDataEntity : extDataEntitys) {
                    if (!extDataEntity.getDataEntity().getDataEntityState().isBizChanged()) continue;
                    extDataEntity.getDataEntity().getDataEntityState().setPushChanged(true);
                }
            }
        }
        e.setDataEntity((Object)dataEntity);
        e.setFireAfterCreateNewData(false);
    }

    public void beforeBindData(EventObject e) {
        IFormView parentView;
        super.beforeBindData(e);
        boolean isConvertResultPage = false;
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (StringUtils.isNotBlank((CharSequence)parentPageId) && (parentView = this.getView().getViewNoPlugin(parentPageId)) != null) {
            isConvertResultPage = "botp_convertresult".equals(parentView.getEntityId());
        }
        this.getPageCache().put("isConvertResultPage", String.valueOf(isConvertResultPage));
        if (!this.updateTempAttachmentFlag.booleanValue()) {
            this.updateTempAttachmentCache();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (!this.isConvertResultPage()) {
            return;
        }
        Object source = args.getSource();
        if (source instanceof Audit) {
            Audit audit = (Audit)args.getSource();
            OperateOption operateOption = audit.getOption();
            if (!operateOption.containsVariable("isshowmessage")) {
                operateOption.setVariableValue("isshowmessage", KEY_FALSE);
            }
            if (!operateOption.containsVariable("isStrict")) {
                operateOption.setVariableValue("isStrict", KEY_FALSE);
            }
        } else if (source instanceof Save) {
            ((Save)source).getParameter().remove("afterOperation");
        } else if (source instanceof Submit) {
            ((Submit)source).getParameter().remove("afterOperation");
        }
    }

    private void updateTempAttachmentCache() {
        IPageCache cache = this.getPageCache();
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        IPageCache parentCache = (IPageCache)parentView.getService(IPageCache.class);
        Object pkId = this.getModel().getDataEntity().getPkValue();
        if (!this.isConvertResultPage() && parentCache.get(pkId + TEMP_ATTACHMENT_FLAG) != null) {
            return;
        }
        Map<String, List<Map<String, Object>>> attachmentMap = this.getAttachmentPanelCache(parentCache, pkId);
        if (attachmentMap == null) {
            return;
        }
        attachmentMap.replaceAll((key, value) -> AttachmentPanelConvertHelper.convertAttachmentInfoMapForTempCache((List)value));
        cache.put(this.buildChildAttCacheKey(), SerializationUtils.toJsonString(attachmentMap));
        parentCache.put(pkId + TEMP_ATTACHMENT_FLAG, TEMP_ATTACHMENT_FLAG);
    }

    public void afterBindData(EventObject e) {
        IPageCache parentPageCache;
        String cacheProcessing;
        super.afterBindData(e);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null && StringUtils.isNotBlank((CharSequence)(cacheProcessing = (parentPageCache = (IPageCache)parentView.getService(IPageCache.class)).get("isload")))) {
            parentPageCache.put("isload", String.valueOf(false));
        }
        this.hideMainBar();
        this.showReport();
    }

    private String removeCache(String key) {
        String val = this.getPageCache().get(key);
        this.getPageCache().remove(key);
        return val;
    }

    private String buildChildAttCacheKey() {
        return "TampAttCache" + this.getView().getPageId();
    }

    Map<String, List<Map<String, Object>>> getAttachmentPanelCache(IPageCache parentCache, Object pkId) {
        String cacheValue = parentCache.get("convertresult_attachmentpanel");
        if (StringUtils.isBlank((CharSequence)cacheValue)) {
            Map billAttachmentInfos;
            String convertResultJson = parentCache.get("ConvertOperationResult");
            if (StringUtils.isBlank((CharSequence)convertResultJson)) {
                log.error((Object)"\u9875\u9762\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\u8f6c\u6362\u7ed3\u679c\uff1acachekey=ConvertOperationResult");
                return null;
            }
            ConvertOperationResult convertResult = (ConvertOperationResult)SerializationUtils.fromJsonString((String)convertResultJson, ConvertOperationResult.class);
            if (convertResult != null && convertResult.getBillAttachmentPanelInfos() != null && (billAttachmentInfos = (Map)convertResult.getBillAttachmentPanelInfos().get(String.valueOf(pkId))) != null && !billAttachmentInfos.isEmpty()) {
                return AttachmentPanelConvertHelper.convertBillAttachmentInfosToBillAttachmentInfoMaps((Map)billAttachmentInfos);
            }
            return new HashMap<String, List<Map<String, Object>>>();
        }
        Map attachmentInfoMaps = (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
        Map attachmentInfo = (Map)attachmentInfoMaps.get(String.valueOf(pkId));
        return attachmentInfo != null ? attachmentInfo : new HashMap();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getSource() instanceof FormOperate) {
            OperationResult operationResult = e.getOperationResult();
            FormOperate op = (FormOperate)e.getSource();
            String opType = op.getType();
            boolean clearCachePage = false;
            if (StringUtils.equals((CharSequence)"new", (CharSequence)opType) || StringUtils.equals((CharSequence)"copy", (CharSequence)opType)) {
                clearCachePage = true;
            } else if ((StringUtils.equals((CharSequence)"save", (CharSequence)opType) || StringUtils.equals((CharSequence)"submit", (CharSequence)opType) || StringUtils.equals((CharSequence)"audit", (CharSequence)opType)) && operationResult != null && !operationResult.getSuccessPkIds().isEmpty()) {
                clearCachePage = true;
            }
            if (clearCachePage) {
                ((BillShowParameter)this.getView().getFormShowParameter()).setCachePageId(null);
                this.getView().cacheFormShowParameter();
            }
            boolean isConvertResultPage = this.isConvertResultPage();
            String saveStatus = "0";
            String opName = "";
            if (StringUtils.equals((CharSequence)"save", (CharSequence)opType)) {
                saveStatus = "1";
                opName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ConvertResultFormEdit_2", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)"submit", (CharSequence)opType)) {
                saveStatus = "2";
                opName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"ConvertResultFormEdit_8", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)"audit", (CharSequence)opType)) {
                saveStatus = "3";
                opName = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"ConvertResultFormEdit_18", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]);
            } else {
                return;
            }
            if (!isConvertResultPage || operationResult == null) {
                return;
            }
            if (!this.getSubmitAndAudit().booleanValue() || this.getSubmitAndAudit().booleanValue() && !opType.equals("submit")) {
                if (!operationResult.getSuccessPkIds().isEmpty()) {
                    String parentPageId = this.getView().getFormShowParameter().getParentPageId();
                    IFormView parentView = this.getView().getView(parentPageId);
                    Long billId = (Long)this.getView().getModel().getDataEntity().getPkValue();
                    this.requestMutex(new Object[]{billId}, parentView);
                    this.updateParentViewStatus(operationResult, saveStatus);
                }
                this.showOperationResult(opType, opName, operationResult);
            } else if (!operationResult.getSuccessPkIds().isEmpty()) {
                this.updateParentViewStatus(operationResult, saveStatus);
            } else {
                this.showOperationResult(opType, opName, operationResult);
            }
        }
    }

    private void updateParentViewStatus(OperationResult operationResult, String saveStatus) {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentView = this.getView().getView(parentPageId);
        int currRowIndex = Integer.parseInt(parentView.getPageCache().get(CACHEKEY_CURRBILLINDEX));
        Long billId = (Long)this.getView().getModel().getDataEntity().getPkValue();
        BillEntityType mainType = (BillEntityType)this.getModel().getDataEntityType();
        DynamicObject[] fromDBObjs = BusinessDataServiceHelper.load((Object[])operationResult.getSuccessPkIds().toArray(), (DynamicObjectType)mainType);
        if (fromDBObjs != null && fromDBObjs.length == 1) {
            DynamicObject billObj = fromDBObjs[0];
            ((IBillModel)this.getView().getModel()).push((Object)billObj);
            this.updateTempAttachmentFlag = true;
            this.getView().updateView();
            this.getView().getModel().updateCache();
        }
        String billStatus = (String)this.getView().getModel().getDataEntity().get(mainType.getBillStatus());
        BillStatusProp billStatusProp = (BillStatusProp)mainType.getAllFields().get(mainType.getBillStatus());
        billStatus = billStatusProp.getStatusItem(billStatus).getStatusName().getLocaleValue();
        if (StringUtils.isNotBlank((CharSequence)mainType.getBillNo())) {
            IDataEntityProperty billNoProp = mainType.findProperty(mainType.getBillNo());
            String billNo = (String)this.getView().getModel().getValue(billNoProp.getName());
            parentView.getModel().setValue(KEY_BILLNO, (Object)billNo, currRowIndex);
        }
        if ("1".equals(saveStatus)) {
            int saveCount = Integer.parseInt(parentView.getPageCache().get(CACHEKEY_SAVECOUNT));
            parentView.getPageCache().put(CACHEKEY_SAVECOUNT, String.valueOf(++saveCount));
        } else if ("2".equals(saveStatus)) {
            int saveCount = Integer.parseInt(parentView.getPageCache().get(CACHEKEY_SAVECOUNT));
            int submitCount = Integer.parseInt(parentView.getPageCache().get(CACHEKEY_SUBMITCOUNT));
            String status = (String)parentView.getModel().getValue(KEY_SAVESTATUS, currRowIndex);
            if (saveCount > 0 && "1".equals(status)) {
                --saveCount;
            }
            parentView.getPageCache().put(CACHEKEY_SAVECOUNT, String.valueOf(saveCount));
            parentView.getPageCache().put(CACHEKEY_SUBMITCOUNT, String.valueOf(++submitCount));
        } else if ("3".equals(saveStatus)) {
            int submitCount = Integer.parseInt(parentView.getPageCache().get(CACHEKEY_SUBMITCOUNT));
            int auditCount = Integer.parseInt(parentView.getPageCache().get(CACHEKEY_AUDITCOUNT));
            if (submitCount > 0) {
                --submitCount;
            }
            parentView.getPageCache().put(CACHEKEY_SUBMITCOUNT, String.valueOf(submitCount));
            parentView.getPageCache().put(CACHEKEY_AUDITCOUNT, String.valueOf(++auditCount));
        }
        parentView.getModel().setValue(KEY_BILLSTATUS, (Object)billStatus, currRowIndex);
        parentView.getModel().setValue(KEY_SAVESTATUS, (Object)saveStatus, currRowIndex);
        parentView.getModel().setValue(KEY_PKVALUE, (Object)billId, currRowIndex);
        ConvertResultFormUtil.refreshSaveTips(parentView);
        this.getView().sendFormAction(parentView);
    }

    private void showOperationResult(String opType, String opName, OperationResult opResult) {
        if (opResult == null) {
            return;
        }
        if (!this.getSubmitAndAudit().booleanValue() || this.getSubmitAndAudit().booleanValue() && !"submit".equals(opType) || this.getSubmitAndAudit().booleanValue() && !opResult.isSuccess()) {
            if (opResult.isSuccess() && opResult.getAllErrorOrValidateInfo().isEmpty() && StringUtils.isBlank((CharSequence)opResult.getMessage())) {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"ConvertResultFormEdit_10", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), opName));
            } else if (opResult.isShowMessage() && opResult.getInteractionContext() == null) {
                this.getView().showOperationResult(opResult, opName);
            }
        }
    }

    protected void requestMutex(Object[] pkValues, IFormView parentView) {
        if (MutexHelper.isOpenIntentLocks()) {
            return;
        }
        String netGroupId = this.loadMutexGroupId();
        if (StringUtils.isBlank((CharSequence)netGroupId)) {
            return;
        }
        String entityId = this.getModel().getDataEntityType().getName();
        boolean isStrict = false;
        ArrayList mutexRequireList = new ArrayList(10);
        for (Object pkValue : pkValues) {
            String objId = String.valueOf(pkValue);
            HashMap<String, Object> requireParam = new HashMap<String, Object>(16);
            requireParam.put("dataObjId", objId);
            requireParam.put("groupId", netGroupId);
            requireParam.put("entityKey", entityId);
            requireParam.put("operationKey", MUTEX_OPERATIONKEY);
            requireParam.put("isStrict", isStrict);
            mutexRequireList.add(requireParam);
        }
        HashSet<String> failObjIds = new HashSet<String>();
        HashSet<String> successObjIds = new HashSet<String>();
        try {
            Object pkValue;
            DataMutex dataMutex = DataMutex.create();
            pkValue = null;
            try {
                Map mutexResult = dataMutex.batchrequire(mutexRequireList);
                for (Map.Entry mutexItem : mutexResult.entrySet()) {
                    String objId = (String)mutexItem.getKey();
                    Boolean isMutexLocked = (Boolean)mutexItem.getValue();
                    if (Boolean.FALSE.equals(isMutexLocked)) {
                        failObjIds.add(objId);
                        continue;
                    }
                    AutoReleaseLock.create().register(objId, entityId, MUTEX_OPERATIONKEY);
                    successObjIds.add(objId);
                }
            }
            catch (Throwable throwable) {
                pkValue = throwable;
                throw throwable;
            }
            finally {
                if (dataMutex != null) {
                    if (pkValue != null) {
                        try {
                            dataMutex.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)pkValue).addSuppressed(throwable);
                        }
                    } else {
                        dataMutex.close();
                    }
                }
            }
        }
        catch (IOException e) {
            ErrorCode ec = new ErrorCode(MUTEX_REQUIRE_ERROR, String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"ConvertResultFormEdit_30", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), e.getMessage()));
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        this.cacheMutexPKValue(successObjIds.toArray(new String[0]), parentView);
        if (!failObjIds.isEmpty()) {
            ErrorCode ec = new ErrorCode(MUTEX_REQUIRE_ERROR, ResManager.loadKDString((String)"\u7528\u6237\u81ea\u5df1\u521a\u4e0b\u63a8\u7684\u5355\u636e\u9a6c\u4e0a\u88ab\u5176\u4ed6\u4eba\u9501\u5b9a\uff0c\u4e0d\u53ef\u601d\u8bae", (String)"ConvertResultFormEdit_11", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
    }

    private String loadMutexGroupId() {
        String entityNumber = this.getModel().getDataEntityType().getName();
        Map netCtrlConf = EntityMetadataCache.getDataEntityNetCtrlOperate((String)entityNumber);
        if (netCtrlConf == null) {
            return "";
        }
        for (Map.Entry groupId : netCtrlConf.entrySet()) {
            for (Map oper : (List)groupId.getValue()) {
                String operKey = (String)oper.get("operationKey");
                if (!StringUtils.equals((CharSequence)MUTEX_OPERATIONKEY, (CharSequence)operKey)) continue;
                return (String)groupId.getKey();
            }
        }
        return "";
    }

    private void cacheMutexPKValue(String[] pkValues, IFormView parentView) {
        String mutexString = parentView.getPageCache().get(CACHEKEY_MUTEX);
        List cachePKValues = null;
        cachePKValues = StringUtils.isBlank((CharSequence)mutexString) ? new ArrayList() : (List)SerializationUtils.fromJsonString((String)mutexString, List.class);
        HashSet<String> set = new HashSet<String>(cachePKValues);
        for (String pkValue : pkValues) {
            if (!set.add(pkValue)) continue;
            cachePKValues.add(pkValue);
        }
        parentView.getPageCache().put(CACHEKEY_MUTEX, SerializationUtils.toJsonString(cachePKValues));
    }

    public void pageRelease(EventObject e) {
        Boolean keepResult;
        String paramValue = (String)this.getView().getFormShowParameter().getCustomParam("keepresult");
        if (StringUtils.isNotBlank((CharSequence)paramValue) && (keepResult = Boolean.valueOf(paramValue)).booleanValue()) {
            return;
        }
        this.releaseResult();
        this.releasePushaMutex();
    }

    private void hideMainBar() {
        String parmValue = (String)this.getView().getFormShowParameter().getCustomParam("hidemainbar");
        if (StringUtils.isBlank((CharSequence)parmValue)) {
            return;
        }
        boolean hide = Boolean.parseBoolean(parmValue);
        if (!hide) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_TITLE_PANEL_BILL, KEY_TITLE_PANEL_BASE});
    }

    private void showReport() {
        String parmValue = this.getPageCache().get("showreport");
        boolean showReport = true;
        if (StringUtils.isNotBlank((CharSequence)parmValue) && !(showReport = Boolean.parseBoolean(parmValue))) {
            return;
        }
        this.getPageCache().put("showreport", String.valueOf(false));
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        ConvertOperationResult convertResult = this.getConvertResult();
        if (convertResult == null || parentView == null) {
            return;
        }
        parmValue = (String)this.getView().getFormShowParameter().getCustomParam("showreport");
        if (StringUtils.isBlank((CharSequence)parmValue)) {
            return;
        }
        showReport = Boolean.parseBoolean(parmValue);
        if (!showReport) {
            return;
        }
        if (this.getView() instanceof IMobileView) {
            ConvertTrackerEdit.showMobileReport(this.getView(), convertResult);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_convertreport");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setInlineStyleCss(new StyleCss());
        showParameter.getOpenStyle().getInlineStyleCss().setHeight("410px");
        showParameter.getOpenStyle().getInlineStyleCss().setWidth("850px");
        showParameter.setShowTitle(true);
        showParameter.getCustomParams().put("convertresultpageid", this.getView().getFormShowParameter().getParentPageId());
        this.getView().showForm(showParameter);
    }

    private ConvertOperationResult getConvertResult() {
        if (this.convertOperationResult != null) {
            return this.convertOperationResult;
        }
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return null;
        }
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        String convertResultJson = pageCache.get("ConvertOperationResult");
        if (StringUtils.isBlank((CharSequence)convertResultJson)) {
            return null;
        }
        this.convertOperationResult = (ConvertOperationResult)SerializationUtils.fromJsonString((String)convertResultJson, ConvertOperationResult.class);
        return this.convertOperationResult;
    }

    private void releaseResult() {
        ConvertOperationResult convertResult = this.getConvertResult();
        if (convertResult == null) {
            return;
        }
        MainEntityType mainType = this.getModel().getDataEntityType();
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
            }
        };
        convertResult.release(refDataProvider, mainType);
        this.getPageCache().remove("ConvertOperationResult");
    }

    private void releasePushaMutex() {
        Set srcBillIds;
        ConvertResultMutex convertResultMutex = null;
        String botpMutexMessage = (String)this.getView().getFormShowParameter().getCustomParam("botp_mutex_message");
        ConvertOperationResult convertResult = this.getConvertResult();
        String sourceEntityNumber = "";
        if (StringUtils.isNotBlank((CharSequence)botpMutexMessage)) {
            convertResultMutex = (ConvertResultMutex)SerializationUtils.fromJsonString((String)botpMutexMessage, ConvertResultMutex.class);
            sourceEntityNumber = convertResultMutex.getSrcEntityNumber();
            srcBillIds = convertResultMutex.getSrcBillIds();
        } else {
            if (convertResult == null) {
                return;
            }
            sourceEntityNumber = convertResult.getSourceEntityNumber();
            srcBillIds = convertResult.getDataMutexSrcBillIds();
        }
        if (srcBillIds.isEmpty()) {
            return;
        }
        ConvertServiceHelper.releasePushMutex((String)sourceEntityNumber, (Set)srcBillIds);
        if (convertResult != null && CollectionUtils.isNotEmpty((Collection)convertResult.getDataMutexSrcBillIds())) {
            convertResult.getDataMutexSrcBillIds().removeAll(srcBillIds);
        }
        if (convertResultMutex != null && CollectionUtils.isNotEmpty((Collection)convertResultMutex.getSrcBillIds())) {
            convertResultMutex.getSrcBillIds().clear();
        }
    }

    private static void showMobileReport(IFormView view, ConvertOperationResult convertResult) {
        String failMessage = convertResult.getMessage();
        if (!convertResult.getBillReports().isEmpty()) {
            SourceBillReport billReport = (SourceBillReport)convertResult.getBillReports().get(0);
            if (!billReport.getFailMessages().isEmpty()) {
                failMessage = (String)billReport.getFailMessages().get(0);
            } else if (!billReport.getLinkEntityRowReports().isEmpty()) {
                failMessage = ((SourceRowReport)billReport.getLinkEntityRowReports().get(0)).getFailMessage();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)failMessage)) {
            view.showErrorNotification(failMessage);
        }
    }

    private Boolean getSubmitAndAudit() {
        Boolean autoAudit = Boolean.FALSE;
        try {
            MainEntityType mainType = this.getModel().getDataEntityType();
            Object optionValue = SystemParamServiceHelper.getBillParameter((String)mainType.getName(), (String)"submitandaudit");
            if (optionValue != null) {
                autoAudit = (Boolean)optionValue;
            }
        }
        catch (Throwable exp) {
            log.error((Object)exp);
        }
        return autoAudit;
    }

    private boolean isConvertResultPage() {
        String isConvertResultPage = this.getPageCache().get("isConvertResultPage");
        if (StringUtils.isNotBlank((CharSequence)isConvertResultPage)) {
            return Boolean.parseBoolean(isConvertResultPage);
        }
        return false;
    }
}

