/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.botp.ConvertDataMutex;
import kd.bos.form.plugin.botp.ConvertDataMutexs;
import kd.bos.servicehelper.botp.ConvertServiceHelper;

public class ReleaseConvertDataMutexPlugin
extends AbstractBillPlugIn {
    private static final String CACHEKEY_CONVERTDATAMUTEX = "convertdatamutex";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ConvertOperationResult convertResult = this.getConvertResult();
        if (convertResult == null) {
            return;
        }
        ReleaseConvertDataMutexPlugin.addConvertDataMutex(this.getView(), convertResult.getSourceEntityNumber(), convertResult.getDataMutexSrcBillIds());
    }

    public void pageRelease(EventObject e) {
        this.releaseDataMutex();
    }

    public static void addConvertDataMutex(IFormView view, String srcEntityNumber, Collection<String> srcBillIds) {
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        String str = pageCache.get(CACHEKEY_CONVERTDATAMUTEX);
        ConvertDataMutexs dataMutexs = null;
        dataMutexs = StringUtils.isBlank((CharSequence)str) ? new ConvertDataMutexs() : (ConvertDataMutexs)SerializationUtils.fromJsonString((String)str, ConvertDataMutexs.class);
        dataMutexs.addItem(srcEntityNumber, srcBillIds);
        str = SerializationUtils.toJsonString((Object)dataMutexs);
        pageCache.put(CACHEKEY_CONVERTDATAMUTEX, str);
    }

    private ConvertOperationResult getConvertResult() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return null;
        }
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        String convertResultJson = pageCache.get("ConvertOperationResult");
        if (StringUtils.isBlank((CharSequence)convertResultJson)) {
            return null;
        }
        ConvertOperationResult convertResult = (ConvertOperationResult)SerializationUtils.fromJsonString((String)convertResultJson, ConvertOperationResult.class);
        return convertResult;
    }

    private ConvertDataMutexs getConvertDataMutexs() {
        String str = this.getPageCache().get(CACHEKEY_CONVERTDATAMUTEX);
        if (StringUtils.isNotBlank((CharSequence)str)) {
            return (ConvertDataMutexs)SerializationUtils.fromJsonString((String)str, ConvertDataMutexs.class);
        }
        return new ConvertDataMutexs();
    }

    private boolean releaseDataMutex() {
        ConvertDataMutexs convertDataMutexs = this.getConvertDataMutexs();
        if (convertDataMutexs.getItems().isEmpty()) {
            return true;
        }
        for (ConvertDataMutex item : convertDataMutexs.getItems().values()) {
            HashSet<String> srcBillIds = new HashSet<String>(item.getSrcBillIds());
            ConvertServiceHelper.releasePushMutex((String)item.getSrcEntityNumber(), srcBillIds);
        }
        return true;
    }
}

