/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp.batchop;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.SignCallbackEvent;
import kd.bos.form.plugin.botp.CommonDoOperation;
import kd.bos.form.plugin.botp.batchop.OpStatus;
import kd.bos.param.ParameterReader;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class BatchCallOperation
implements Callable<OperationResult> {
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";
    private IFormView view;
    private String opKey;
    private List<List<DynamicObject>> subOpObjs;
    private List<List<Long>> subOpIds;
    private BillEntityType mainType;
    private Integer totalOpObjCount;
    private boolean signCallback;
    private SignCallbackEvent evt;
    private static final String CACHEKEY_PROGRESS = "progress";
    protected static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"BotpBatchOpThreadPool", (int)2, (int)12);

    public BatchCallOperation(IFormView view, String opKey, List<List<DynamicObject>> subOpObjs, List<List<Long>> subOpIds, BillEntityType mainType, Integer totalOpObjCount, boolean signCallback, SignCallbackEvent evt) {
        this.view = view;
        this.opKey = opKey;
        this.subOpObjs = subOpObjs;
        this.subOpIds = subOpIds;
        this.mainType = mainType;
        this.totalOpObjCount = totalOpObjCount;
        this.signCallback = signCallback;
        this.evt = evt;
    }

    @Override
    public OperationResult call() throws Exception {
        OperationResult mergeResult = null;
        try {
            OperationResult operationResult = mergeResult = this.isAsyncBatchEnabled() ? this.doAsyncBatchCallOp(this.subOpObjs, this.subOpIds) : this.doBatchCallOp(this.subOpObjs, this.subOpIds);
            if (mergeResult != null) {
                this.view.getPageCache().put(this.opKey + "allresult", SerializationUtils.toJsonString((Object)mergeResult));
            }
        }
        finally {
            this.view.getPageCache().put(CACHEKEY_PROGRESS, String.valueOf(100));
            this.view.getPageCache().saveChanges();
        }
        return mergeResult;
    }

    private OperationResult doBatchCallOp(List<List<DynamicObject>> subOpObjs, List<List<Long>> subOpIds) {
        OperationResult operationResult;
        Future<OperationResult> opResultFuture;
        ArrayList<OperationResult> batchResults = new ArrayList<OperationResult>(subOpObjs.size());
        for (List<DynamicObject> list : subOpObjs) {
            opResultFuture = this.doAsyncBatch(this.view, list.toArray(new DynamicObject[0]), null, this.totalOpObjCount, this.signCallback, this.evt);
            operationResult = this.getFutureResult(opResultFuture, batchResults.size() + 1);
            batchResults.add(operationResult);
        }
        for (List<Object> list : subOpIds) {
            opResultFuture = this.doAsyncBatch(this.view, null, list.toArray(new Long[0]), this.totalOpObjCount, this.signCallback, this.evt);
            operationResult = this.getFutureResult(opResultFuture, batchResults.size() + 1);
            batchResults.add(operationResult);
        }
        OperationResult mergeResult = null;
        for (OperationResult result : batchResults) {
            if (mergeResult == null) {
                mergeResult = result;
                continue;
            }
            mergeResult.mergeOperateResult(result);
        }
        return mergeResult;
    }

    private OperationResult doAsyncBatchCallOp(List<List<DynamicObject>> subOpObjs, List<List<Long>> subOpIds) {
        Future<OperationResult> opResultFuture;
        ArrayList<Future<OperationResult>> batchResultFutures = new ArrayList<Future<OperationResult>>(subOpObjs.size());
        for (List<DynamicObject> list : subOpObjs) {
            opResultFuture = this.doAsyncBatch(this.view, list.toArray(new DynamicObject[0]), null, this.totalOpObjCount, this.signCallback, this.evt);
            batchResultFutures.add(opResultFuture);
        }
        for (List<Object> list : subOpIds) {
            opResultFuture = this.doAsyncBatch(this.view, null, list.toArray(new Long[0]), this.totalOpObjCount, this.signCallback, this.evt);
            batchResultFutures.add(opResultFuture);
        }
        OperationResult mergeResult = null;
        Object var5_8 = null;
        int size = batchResultFutures.size();
        for (int i = 0; i < size; ++i) {
            OperationResult operationResult = this.getFutureResult((Future)batchResultFutures.get(i), i + 1);
            if (mergeResult == null) {
                mergeResult = operationResult;
                continue;
            }
            mergeResult.mergeOperateResult(operationResult);
        }
        return mergeResult;
    }

    private Future<OperationResult> doAsyncBatch(final IFormView view, final DynamicObject[] billObjs, final Object[] billIds, final int totalOpObjCount, final boolean signCallback, final SignCallbackEvent evt) {
        return threadPool.submit((Callable)new Callable<OperationResult>(){

            @Override
            public OperationResult call() throws Exception {
                CommonDoOperation commonDoOperation = new CommonDoOperation();
                OperationResult opResult = commonDoOperation.batchCallOpService(view, BatchCallOperation.this.mainType, BatchCallOperation.this.opKey, OpStatus.Submit, billObjs, billIds, signCallback, evt);
                int length = billObjs != null ? billObjs.length : billIds.length;
                BatchCallOperation.this.updateAsyncBatchProgress(view, totalOpObjCount, length);
                return opResult;
            }
        });
    }

    private void updateAsyncBatchProgress(IFormView view, int totalOpObjCount, int currentBatchSize) {
        IPageCache cache = view.getPageCache();
        String oldProgressStr = cache.get(CACHEKEY_PROGRESS);
        double oldProgress = StringUtils.isBlank((CharSequence)oldProgressStr) ? 0.0 : Double.parseDouble(oldProgressStr);
        String currentOpCountKey = "current" + this.opKey + "Count";
        String oldOpCountStr = cache.get(currentOpCountKey);
        int oldOpCount = StringUtils.isBlank((CharSequence)oldOpCountStr) ? 0 : Integer.parseInt(oldOpCountStr);
        int currentOpCount = oldOpCount + currentBatchSize;
        double progress = (double)currentOpCount * 100.0 / (double)totalOpObjCount;
        if (progress > oldProgress) {
            cache.put(currentOpCountKey, String.valueOf(currentOpCount));
        }
        cache.put(CACHEKEY_PROGRESS, progress < 100.0 ? String.valueOf(progress) : "99");
        cache.saveChanges();
    }

    private boolean isAsyncBatchEnabled() {
        DynamicObject billParams = ParameterReader.getBillParameter((String)this.mainType.getName());
        return billParams != null && billParams.getDataEntityType().getProperties().containsKey((Object)"asyncdobatchsave") && billParams.getBoolean("asyncdobatchsave");
    }

    private OperationResult getFutureResult(Future<OperationResult> future, int batchSeq) {
        try {
            return future.get();
        }
        catch (Throwable e) {
            String submit = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"ConvertResultFormEdit_8", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]);
            String audit = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"ConvertResultFormEdit_18", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]);
            return this.buildExceptionResult(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u7ed3\u679c\u5168\u90e8%1$s\u65f6\uff0c\u7b2c%2$d\u6279\u6570\u636e\u7684%1$s\u5931\u8d25\uff1a%3$s", (String)"ConvertResultFormEdit_35", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), this.opKey.equals("submit") ? submit : audit, batchSeq, e.getMessage()), e);
        }
    }

    private OperationResult buildExceptionResult(String msg, Throwable e) {
        OperationResult result = new OperationResult();
        result.setSuccess(false);
        result.setMessage(msg);
        return result;
    }
}

