/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp.jobtask;

import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOpProgressCache;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.botp.Push;
import kd.bos.krpc.common.json.JSON;
import kd.bos.krpc.common.json.ParseException;
import kd.bos.schedule.api.TaskInfo;

public class JobFormTaskCloseManager
implements ICloseCallBack {
    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getView() == null) {
            return;
        }
        if (e.getReturnData() == null) {
            return;
        }
        Map returnData = (Map)e.getReturnData();
        if (!returnData.containsKey("taskinfo")) {
            return;
        }
        String str = (String)returnData.get("taskinfo");
        if (StringUtils.isBlank((CharSequence)str)) {
            return;
        }
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)str, TaskInfo.class);
        if (!taskInfo.isTaskEnd()) {
            return;
        }
        String dataStr = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)dataStr)) {
            return;
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)dataStr, Map.class);
        try {
            Object pushArgsStr = data.get("pushArgs");
            PushArgs pushArgs = (PushArgs)JSON.parse((String)pushArgsStr.toString(), PushArgs.class);
            if (ConvertOpProgressCache.isError((String)pushArgs.getTaskId())) {
                e.getView().showErrMessage(ConvertOpProgressCache.getErrorMessage((String)pushArgs.getTaskId()), "");
                return;
            }
            Object convertOperationResultStr = data.get("ConvertOperationResult");
            if (convertOperationResultStr == null) {
                e.getView().showErrorNotification("convertOperationResult is not found");
                return;
            }
            ConvertOperationResult operateResult = (ConvertOperationResult)SerializationUtils.fromJsonString((String)convertOperationResultStr.toString(), ConvertOperationResult.class);
            if (!operateResult.isSuccess()) {
                Push.showReport((IFormView)e.getView(), (AbstractConvertServiceArgs)pushArgs, (ConvertOperationResult)operateResult);
                return;
            }
            if (operateResult.getCachePageIds().size() + operateResult.getTargetBillIds().size() == 1) {
                Push.showTargetBill((IFormView)e.getView(), (PushArgs)pushArgs, (ConvertOperationResult)operateResult, (boolean)pushArgs.isShowReport());
                return;
            }
            Push.showMultiTargetBills((IFormView)e.getView(), (PushArgs)pushArgs, (ConvertOperationResult)operateResult, (boolean)pushArgs.isShowReport());
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
    }
}

