/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.botp.layout.BotpLayoutManager;
import kd.bos.form.plugin.botp.layout.LayoutConfigItem;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BaseLayoutConfigEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    protected static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";
    protected static final String KEY_ENTRYENTITY = "entryentity";
    protected static final String KEY_OPTION = "option";
    protected static final String KEY_BILL = "bill";
    protected static final String KEY_PCLAYOUT = "pclayout";
    protected static final String KEY_MOBILELAYOUT = "mobilelayout";
    protected static final String BUTTION_OK = "btnok";
    protected static final String FIELD_NUMBER = "number";
    protected static final String FIELD_MODELTYPE = "modeltype";
    protected static final String FIELD_NAME = "name";
    protected static final String SHOWCONTENT = "showContent";
    protected static final String CONSTANT_CONFIGDATA = "configData";
    protected static final String CONSTANT_FORMID = "formId";
    protected static final String CACHEKEY_BILLF7 = "billF7:%s:%s";
    private BotpLayoutManager botpLayoutManager = new BotpLayoutManager();

    public void registerListener(EventObject e) {
        MulBasedataEdit mobileLayout;
        MulBasedataEdit pcLayout;
        super.registerListener(e);
        BasedataEdit bill = (BasedataEdit)this.getView().getControl(KEY_BILL);
        if (bill != null) {
            bill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((pcLayout = (MulBasedataEdit)this.getView().getControl(KEY_PCLAYOUT)) != null) {
            pcLayout.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((mobileLayout = (MulBasedataEdit)this.getView().getControl(KEY_MOBILELAYOUT)) != null) {
            mobileLayout.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{BUTTION_OK});
    }

    protected String getFromFormId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        return (String)customParams.get(CONSTANT_FORMID);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String configData = (String)customParams.get(CONSTANT_CONFIGDATA);
        if (StringUtils.isBlank((CharSequence)configData)) {
            return;
        }
        List layoutConfigItemList = SerializationUtils.fromJsonStringToList((String)configData, LayoutConfigItem.class);
        if (CollectionUtils.isEmpty((Collection)layoutConfigItemList)) {
            return;
        }
        IDataModel model = this.getModel();
        int rowcount = layoutConfigItemList.size();
        this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, rowcount);
        MainEntityType formMetaType = EntityMetadataCache.getDataEntityType((String)"bos_formmeta");
        for (int i = 0; i < rowcount; ++i) {
            LayoutConfigItem layoutConfigItem = (LayoutConfigItem)layoutConfigItemList.get(i);
            model.setValue(KEY_OPTION, (Object)layoutConfigItem.getOption(), i);
            model.setValue(KEY_BILL, (Object)layoutConfigItem.getToFormId(), i);
            model.setValue(KEY_PCLAYOUT, (Object)layoutConfigItem.getPcLayoutIds(), i);
            if (layoutConfigItem.getMobileLayoutIds() == null || layoutConfigItem.getMobileLayoutIds().length <= 0) continue;
            Map mobileLayoutMap = BusinessDataServiceHelper.loadFromCache((Object[])layoutConfigItem.getMobileLayoutIds(), (DynamicObjectType)formMetaType);
            DynamicObjectCollection mobileLayoutCol = new DynamicObjectCollection();
            int index = 0;
            for (DynamicObject mobileLayout : mobileLayoutMap.values()) {
                mobileLayout.set(FIELD_NUMBER, (Object)layoutConfigItem.getMobileLayoutNumbers()[index]);
                mobileLayout.set(FIELD_NAME, (Object)layoutConfigItem.getMobileLayoutNames()[index]);
                mobileLayoutCol.add((Object)mobileLayout);
                ++index;
            }
            model.setValue(KEY_MOBILELAYOUT, (Object)mobileLayoutCol, i);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        if (!"getLookUpList".equals(e.getSourceMethod()) && !"click".equals(e.getSourceMethod())) {
            return;
        }
        String properKey = e.getProperty().getName();
        int row = e.getRow();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        DynamicObject[] entryDatas = entryGrid.getEntryData().getDataEntitys();
        String option = (String)this.getModel().getValue(KEY_OPTION, row);
        String fromFormId = this.getFromFormId();
        if (KEY_BILL.equals(properKey)) {
            if (!this.checkOptionData(e.getRow() + 1, option)) {
                e.setCancel(true);
                return;
            }
            List<String> billNumberList = this.queryBillNumberListFromCache(fromFormId, option);
            billNumberList = this.removeSelectedBillNumber(option, billNumberList);
            this.rebuildF7QFilter(e, billNumberList);
            e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6e90\u5355/\u76ee\u6807\u5355\u5217\u8868", (String)"BaseLayoutConfigEdit_5", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
        } else if (KEY_PCLAYOUT.equals(properKey)) {
            DynamicObject bill = entryDatas[row].getDynamicObject(KEY_BILL);
            if (!this.checkBillData(e.getRow() + 1, bill)) {
                e.setCancel(true);
                return;
            }
            String billNumber = bill.getString(FIELD_NUMBER);
            List<String> layoutNumberList = this.botpLayoutManager.queryLayoutNumberListFromCache(billNumber, this.getPageCache(), true);
            this.rebuildF7QFilter(e, layoutNumberList);
            e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"PC\u7aef\u5e03\u5c40\u5217\u8868", (String)"BaseLayoutConfigEdit_6", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
        } else if (KEY_MOBILELAYOUT.equals(properKey)) {
            DynamicObject bill = entryDatas[row].getDynamicObject(KEY_BILL);
            if (!this.checkBillData(e.getRow() + 1, bill)) {
                e.setCancel(true);
                return;
            }
            String billNumber = bill.getString(FIELD_NUMBER);
            List<String> layoutNumberList = this.botpLayoutManager.queryLayoutNumberListFromCache(billNumber, this.getPageCache(), false);
            ListShowParameter paramter = (ListShowParameter)e.getFormShowParameter();
            paramter.addCustPlugin("kd.bos.form.plugin.botp.layout.LayoutF7ListPlugin");
            paramter.setCaption(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u5e03\u5c40\u5217\u8868", (String)"BaseLayoutConfigEdit_7", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
            this.rebuildF7QFilter(e, layoutNumberList);
        }
    }

    protected void rebuildF7QFilter(BeforeF7SelectEvent e, List<String> numberList) {
        ListShowParameter paramter = (ListShowParameter)e.getFormShowParameter();
        ListFilterParameter filterParam = paramter.getListFilterParameter();
        if (CollectionUtils.isNotEmpty(numberList)) {
            QFilter qfilter = new QFilter(FIELD_NUMBER, "in", numberList);
            filterParam.getQFilters().add(qfilter);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8f6c\u6362\u8def\u7ebf\uff0c\u6216\u5df2\u5b58\u5728\u76f8\u540c\u7684\u914d\u7f6e\u9879\u3002", (String)"BaseLayoutConfigEdit_4", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private List<String> queryBillNumberListFromCache(String fromFormId, String option) {
        String cacheKey = String.format(CACHEKEY_BILLF7, option, fromFormId);
        String billNumberListJson = this.getPageCache().get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)billNumberListJson)) {
            return SerializationUtils.fromJsonStringToList((String)billNumberListJson, String.class);
        }
        List<String> billNumberList = this.queryBillNumberListFromDB(fromFormId, option);
        this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(billNumberList));
        return billNumberList;
    }

    protected List<String> queryBillNumberListFromDB(String fromFormId, String option) {
        return new ArrayList<String>();
    }

    private List<String> removeSelectedBillNumber(String option, List<String> billNumberList) {
        DynamicObject[] entryDatas;
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        for (DynamicObject entryRowData : entryDatas = entryGrid.getEntryData().getDataEntitys()) {
            DynamicObject bill;
            String entryOption = entryRowData.getString(KEY_OPTION);
            if (!entryOption.equals(option) || (bill = entryRowData.getDynamicObject(KEY_BILL)) == null) continue;
            String number = bill.getString(FIELD_NUMBER);
            billNumberList.remove(number);
        }
        return billNumberList;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        String propertyKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        if (KEY_OPTION.equals(propertyKey)) {
            this.clearRowFieldValue(rowIndex, new String[]{KEY_BILL, KEY_PCLAYOUT, KEY_MOBILELAYOUT});
        } else if (KEY_BILL.equals(propertyKey)) {
            this.clearRowFieldValue(rowIndex, new String[]{KEY_PCLAYOUT, KEY_MOBILELAYOUT});
        } else if (KEY_MOBILELAYOUT.equals(propertyKey) && (newValue = changeData.getNewValue()) instanceof MulBasedataDynamicObjectCollection) {
            MulBasedataDynamicObjectCollection curMobileLayoutCol = (MulBasedataDynamicObjectCollection)changeData.getNewValue();
            for (DynamicObject curMobileLayout : curMobileLayoutCol) {
                DynamicObject formMeta = curMobileLayout.getDynamicObject("fbasedataid");
                this.botpLayoutManager.resetMobileLayout(formMeta);
            }
            this.getView().updateView(KEY_MOBILELAYOUT, rowIndex);
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if (BUTTION_OK.equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
            DynamicObject[] entryDatas = entryGrid.getEntryData().getDataEntitys();
            ArrayList<LayoutConfigItem> layoutConfigItemList = new ArrayList<LayoutConfigItem>(entryDatas.length);
            StringBuilder showContent = new StringBuilder();
            int rowName = 0;
            for (DynamicObject entryRowData : entryDatas) {
                DynamicObjectCollection mobilelayout;
                DynamicObjectCollection pclayout;
                DynamicObject bill;
                String optioncombo = entryRowData.getString(KEY_OPTION);
                if (!this.checkRowData(++rowName, optioncombo, bill = entryRowData.getDynamicObject(KEY_BILL), pclayout = entryRowData.getDynamicObjectCollection(KEY_PCLAYOUT), mobilelayout = entryRowData.getDynamicObjectCollection(KEY_MOBILELAYOUT))) {
                    return;
                }
                String[] pcMulBasadataIds = new String[pclayout.size()];
                String[] pcMulBasadataNames = new String[pclayout.size()];
                String[] pcMulBasadataNumbers = new String[pclayout.size()];
                for (int i = 0; i < pclayout.size(); ++i) {
                    pcMulBasadataIds[i] = String.valueOf(((DynamicObject)pclayout.get(i)).get("fbasedataid_id"));
                    pcMulBasadataNames[i] = ((DynamicObject)pclayout.get(i)).getDynamicObject("fbasedataid").getString(FIELD_NAME);
                    pcMulBasadataNumbers[i] = ((DynamicObject)pclayout.get(i)).getDynamicObject("fbasedataid").getString(FIELD_NUMBER);
                }
                String[] mobileMulBasadataIds = new String[mobilelayout.size()];
                String[] mobileMulBasadataNames = new String[mobilelayout.size()];
                String[] mobileMulBasadataNumbers = new String[mobilelayout.size()];
                for (int i = 0; i < mobilelayout.size(); ++i) {
                    mobileMulBasadataIds[i] = String.valueOf(((DynamicObject)mobilelayout.get(i)).get("fbasedataid_id"));
                    String number = ((DynamicObject)mobilelayout.get(i)).getDynamicObject("fbasedataid").getString(FIELD_NUMBER);
                    String name = ((DynamicObject)mobilelayout.get(i)).getDynamicObject("fbasedataid").getString(FIELD_NAME);
                    String modelType = ((DynamicObject)mobilelayout.get(i)).getDynamicObject("fbasedataid").getString(FIELD_MODELTYPE);
                    try {
                        LocaleString mobileFormName = this.botpLayoutManager.queryMobileLayoutName(modelType, number, name);
                        mobileMulBasadataNames[i] = mobileFormName.getLocaleValue();
                        mobileMulBasadataNumbers[i] = number;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                LayoutConfigItem layoutConfigItem = new LayoutConfigItem(this.getFromFormId(), optioncombo, bill.getString(FIELD_NUMBER), pcMulBasadataIds, pcMulBasadataNumbers, pcMulBasadataNames, mobileMulBasadataIds, mobileMulBasadataNumbers, mobileMulBasadataNames);
                layoutConfigItemList.add(layoutConfigItem);
                showContent.append(bill.getString(FIELD_NAME)).append("\uff1b");
            }
            String showContentString = showContent.toString();
            if (showContent.length() >= 1) {
                showContentString = showContentString.substring(0, showContentString.length() - 1);
            }
            HashMap<String, String> returnData = new HashMap<String, String>(2);
            returnData.put(SHOWCONTENT, showContentString);
            returnData.put(CONSTANT_CONFIGDATA, SerializationUtils.toJsonString(layoutConfigItemList));
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(returnData));
            this.getView().close();
        }
    }

    private boolean checkRowData(int rowName, String optioncombo, DynamicObject bill, DynamicObjectCollection pclayout, DynamicObjectCollection mobilelayout) {
        return this.checkOptionData(rowName, optioncombo) && this.checkBillData(rowName, bill) && this.checkLayoutData(rowName, pclayout, mobilelayout);
    }

    private boolean checkOptionData(int rowName, String option) {
        if (StringUtils.isBlank((CharSequence)option)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u201c\u64cd\u4f5c\u201d\u672a\u5f55\u5165\u3002", (String)"BaseLayoutConfigEdit_1", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), rowName));
            return false;
        }
        return true;
    }

    private boolean checkBillData(int rowName, DynamicObject bill) {
        if (bill == null) {
            String description = this.getCheckBillDataTips();
            this.getView().showErrorNotification(String.format(description, rowName));
            return false;
        }
        return true;
    }

    protected String getCheckBillDataTips() {
        return ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u201c\u6e90\u5355/\u76ee\u6807\u5355\u201d\u672a\u5f55\u5165\u3002", (String)"BaseLayoutConfigEdit_2", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]);
    }

    private boolean checkLayoutData(int rowName, DynamicObjectCollection pclayout, DynamicObjectCollection mobilelayout) {
        if (CollectionUtils.isEmpty((Collection)pclayout) && CollectionUtils.isEmpty((Collection)mobilelayout)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u201cPC\u7aef\u5e03\u5c40\u201d\u6216\u201c\u79fb\u52a8\u7aef\u5e03\u5c40\u201d\u672a\u5f55\u5165\u3002", (String)"BaseLayoutConfigEdit_3", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), rowName));
            return false;
        }
        return true;
    }

    private void clearRowFieldValue(int rowIndex, String[] fieldArray) {
        for (String fieldKey : fieldArray) {
            this.getModel().setValue(fieldKey, null, rowIndex);
        }
    }
}

