/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp.link;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.botp.linkquery.LinkLkPo;
import kd.bos.entity.botp.linkquery.QueryLkLinkArgs;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.botp.QueryLinkServiceHelper;

public class LkQuery
extends AbstractListPlugin {
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_BTN_DELETE = "delete";
    private static final String KEY_BTN_REFRESH = "refresh";
    private static final String KEY_TBAR = "tbar_main";
    private static final String KEY_SEQ = "seq";
    private static final String KEY_SOURCE_BILLNO = "sourcebillno";
    private static final String KEY_FID = "fid";
    private static final String KEY_FPKID = "fpkid";
    private static final String KEY_FSEQ = "fseq";
    private static final String KEY_FSTABLEID = "fstableid";
    private static final String KEY_FSID = "fsid";
    private static final String KEY_FSBILLID = "fsbillid";
    private static final String KEY_TARGET_NUMBER = "targetNumber";
    private static final String KEY_TARGETENTITY = "targetEntity";
    private static final String KEY_SOURCEIDS = "sourceIds";
    private static final String KEY_SIDS = "sids";
    private static final String KEY_TIDS = "tids";
    private static final String KEY_BILLNOMAP = "billnoMap";
    private static final String KEY_DELETEMAP = "deleteMap";
    private static final String KEY_SOURCE_BILL_IDS = "sourcebillids";
    private static final String KEY_SOURCE_ENTRY_IDS = "sourceentryids";
    private static final String KEY_TARGET_ENTRY_IDS = "targetentryids";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.query();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar mbar = (Toolbar)this.getView().getControl(KEY_TBAR);
        mbar.addItemClickListener((ItemClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)KEY_BTN_REFRESH, (CharSequence)evt.getItemKey())) {
            this.query();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
    }

    private void query() {
        String targetNumber = (String)this.getView().getFormShowParameter().getCustomParam(KEY_TARGET_NUMBER);
        String targetEntity = (String)this.getView().getFormShowParameter().getCustomParam(KEY_TARGETENTITY);
        List sourceIds = (List)this.getView().getFormShowParameter().getCustomParam(KEY_SOURCEIDS);
        List sids = (List)this.getView().getFormShowParameter().getCustomParam(KEY_SIDS);
        ArrayList tids = (ArrayList)this.getView().getFormShowParameter().getCustomParam(KEY_TIDS);
        String mapJson = (String)this.getView().getFormShowParameter().getCustomParam(KEY_BILLNOMAP);
        HashMap map = (HashMap)JSON.parseObject((String)mapJson, HashMap.class);
        this.getView().getModel().setValue(KEY_TARGET_NUMBER, (Object)targetNumber);
        this.getView().getModel().setValue(KEY_SOURCE_BILL_IDS, (Object)String.join((CharSequence)",", sourceIds));
        this.getView().getModel().setValue(KEY_SOURCE_ENTRY_IDS, (Object)String.join((CharSequence)",", sids));
        this.getView().getModel().setValue(KEY_TARGET_ENTRY_IDS, (Object)String.join((CharSequence)",", tids));
        List<Object> sourceBillIds = new ArrayList(16);
        List<Object> sourceEntryIds = new ArrayList(16);
        String number = "";
        number = targetNumber != null ? targetNumber : (String)this.getView().getModel().getValue(KEY_TARGET_NUMBER);
        if (sourceIds != null) {
            sourceBillIds = sourceIds;
        } else {
            String sourceBill = (String)this.getModel().getValue(KEY_SOURCE_BILL_IDS);
            if (StringUtils.isNotBlank((CharSequence)sourceBill)) {
                sourceBillIds = Arrays.asList(sourceBill.split(","));
            }
        }
        if (sids != null) {
            sourceEntryIds = sids;
        } else {
            String sourceEntryId = (String)this.getModel().getValue(KEY_SOURCE_ENTRY_IDS);
            if (StringUtils.isNotBlank((CharSequence)sourceEntryId)) {
                sourceEntryIds = Arrays.asList(sourceEntryId.split(","));
            }
        }
        if (tids == null) {
            tids = new ArrayList(16);
        }
        QueryLkLinkArgs args = new QueryLkLinkArgs(number, targetEntity, sourceBillIds, sourceEntryIds, tids);
        List list = QueryLinkServiceHelper.queryLkLink((QueryLkLinkArgs)args);
        this.refreshEntryGrid(list, map);
    }

    private void refreshEntryGrid(List<LinkLkPo> linkLks, HashMap<String, String> map) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY);
        rows.clear();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRY_ENTITY);
        int seq = 1;
        for (LinkLkPo linkLk : linkLks) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set(KEY_SEQ, (Object)seq);
            if (map != null) {
                row.set(KEY_SOURCE_BILLNO, (Object)map.get(linkLk.getFsbillid()));
            }
            row.set(KEY_FID, (Object)linkLk.getFid());
            row.set(KEY_FPKID, (Object)linkLk.getFpkid());
            row.set(KEY_FSEQ, (Object)linkLk.getFseq());
            row.set(KEY_FSTABLEID, (Object)linkLk.getFstableid());
            row.set(KEY_FSID, (Object)linkLk.getFsid());
            row.set(KEY_FSBILLID, (Object)linkLk.getFsbillid());
            rows.add((Object)row);
            ++seq;
        }
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }
}

