/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.SearchLinkBill;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.botp.LookUpTrackerEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class LookUpTrackerUtil {
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";
    private static final Log log = LogFactory.getLog(LookUpTrackerUtil.class);
    private LookUpTrackerEdit lookUpTrackerEdit;
    private IFormView view;

    public LookUpTrackerUtil(LookUpTrackerEdit lookUpTrackerEdit, IFormView view) {
        this.lookUpTrackerEdit = lookUpTrackerEdit;
        this.view = view;
    }

    public Map<Long, SearchLinkBill> findMainTableIds() {
        if (this.lookUpTrackerEdit.isLookDown()) {
            return this.findLookDownMainTableIds();
        }
        if (this.lookUpTrackerEdit.isLookUp()) {
            return this.findLookUpMainTableIds();
        }
        return this.findLookDownMainTableIds();
    }

    public Map<Long, SearchLinkBill> findLookDownMainTableIds() {
        List<BFRowLinkDownNode> linkDownNodes = this.lookUpTrackerEdit.getLinkDownNodes();
        ArrayList targetNodes = new ArrayList();
        for (BFRowLinkDownNode node : linkDownNodes) {
            targetNodes.addAll(node.findAllChildNodes());
        }
        HashMap<Long, SearchLinkBill> targetTableIds = new HashMap<Long, SearchLinkBill>();
        for (BFRowLinkDownNode targetNode : targetNodes) {
            BFRowId rowId = targetNode.getRowId();
            if (rowId.getTableId() == null) continue;
            String entityKey = this.getEntryKey(rowId.getTableId());
            SearchLinkBill.addTableBillId(targetTableIds, (BFRowId)rowId, (String)entityKey);
        }
        return targetTableIds;
    }

    public Map<Long, SearchLinkBill> findLookUpMainTableIds() {
        List<BFRowLinkUpNode> linkDownNodes = this.lookUpTrackerEdit.getLinkUpNodes();
        ArrayList targetNodes = new ArrayList(8);
        for (BFRowLinkUpNode node : linkDownNodes) {
            targetNodes.addAll(node.findAllSourceNodes());
        }
        HashMap<Long, SearchLinkBill> targetTableIds = new HashMap<Long, SearchLinkBill>();
        for (BFRowLinkUpNode targetNode : targetNodes) {
            BFRowId rowId = targetNode.getRowId();
            if (rowId.getTableId() == null) continue;
            String entityKey = this.getEntryKey(rowId.getTableId());
            SearchLinkBill.addTableBillId(targetTableIds, (BFRowId)rowId, (String)entityKey);
        }
        return targetTableIds;
    }

    private String getEntryKey(Long tableId) {
        TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)tableId);
        if (tableDefine == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7684\u5b9e\u4f53\u8868\u683c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u5b9e\u4f53id\uff1a%s", (String)"LookUpTrackerUtil_0", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), tableId));
        }
        return tableDefine.getEntityKey();
    }
}

