/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.watermark;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.AppInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.events.LoadWaterMarkInfoEventArgs;
import kd.bos.form.plugin.IWaterMarkPlugin;
import kd.bos.form.watermark.WaterMark;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.session.SystemPropertyUtils;

public class WaterMarkCache {
    private static final Log log = LogFactory.getLog(WaterMarkCache.class);
    private static final String CACHE_KEY = "waterMark";
    private static final String CACHE_REF_KEY = "waterMarkRef";
    private static final String[] LEVELS = new String[]{"root", "cloud", "app", "object"};
    public static final String TYPE_INVISIBLE = "0";
    public static final String TYPE_TEXT = "1";
    public static final String TYPE_PICTURE = "2";
    public static final String TYPE_UPPIC_DOWNTEXT = "3";
    public static final String TYPE_LEFTPIC_RIGHTTEXT = "4";
    public static final String TEXTTYPE_CUSTOM = "1";
    public static final String TEXTTYPE_USERNAME = "2";
    public static final String TEXTTYPE_USERNAME_PHONE = "3";
    public static final String TEXTTYPE_USERNAME_JOBNUMBER = "4";
    public static final String TYPE_PLUGIN = "5";
    private static final WaterMark INVISIBLE_ROOT_WATER_MARK = new WaterMark();
    private static final String FH_S = "%s_%s_";
    private static final String OBJECTID = "objectid";
    private static DistributeSessionlessCache statelessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
    private static DistributeSessionlessCache userServiceCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("userservice", new DistributeCacheHAPolicy(true, true));

    public static void deleteCache(String tenantId, String accountId, String level, String objectId) {
        log.debug(String.format("begin delete cache, tenantId:[%s],accountId:[%s],level:[%s],objectId:[%s]", tenantId, accountId, level, objectId));
        if (StringUtils.isBlank((CharSequence)level) || StringUtils.isBlank((CharSequence)objectId)) {
            return;
        }
        if ("object".equalsIgnoreCase(level)) {
            LocalMemoryCache localCache = WaterMarkCache.getLocalCache(tenantId, accountId);
            String statelessCacheType = String.format(FH_S, tenantId, accountId) + CACHE_KEY;
            FormConfig fc = FormMetadataCache.getFormConfig((String)objectId);
            BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
            String appPkId = StringUtils.isBlank((CharSequence)fc.getBizAppNumber()) ? bizAppService.getAppIdByFormNum(objectId) : bizAppService.getAppIdByAppNumber(fc.getBizAppNumber());
            AppInfo info = EntityMetadataCache.getAppInfo((String)appPkId);
            String cloudPkId = info.getCloudId();
            String cachePath = "waterMark_" + cloudPkId + "_" + appPkId + "_" + objectId;
            statelessCache.remove(statelessCacheType, cachePath);
            log.debug(String.format("finish delete object redis cache, statelessCacheType:[%s],cachePath:[%s]", statelessCacheType, cachePath));
            String localCachePath = "waterMark_" + tenantId + "_" + accountId + "_" + objectId;
            localCache.remove(new String[]{localCachePath});
            log.debug(String.format("finish delete object local cache, cachePath:[%s]", localCachePath));
            return;
        }
        if ("app".equalsIgnoreCase(level)) {
            AppInfo info = EntityMetadataCache.getAppInfo((String)objectId);
            String cloudPkId = info.getCloudId();
            String prefix = cloudPkId + "_" + objectId + "_";
            WaterMarkCache.deleteCacheByPrefix(tenantId, accountId, "waterMark_" + prefix);
            return;
        }
        if ("cloud".equalsIgnoreCase(level)) {
            String prefix = objectId + "_";
            WaterMarkCache.deleteCacheByPrefix(tenantId, accountId, "waterMark_" + prefix);
            return;
        }
        if ("root".equalsIgnoreCase(level)) {
            WaterMarkCache.deleteCacheByPrefix(tenantId, accountId, "");
        }
    }

    private static void deleteCacheByPrefix(String tenantId, String accountId, String prefix) {
        String cacheRefKey = String.format(FH_S, tenantId, accountId) + CACHE_REF_KEY;
        String statelessCacheType = String.format(FH_S, tenantId, accountId) + CACHE_KEY;
        Object[] cachedAppIds = statelessCache.getSetValues(cacheRefKey);
        LocalMemoryCache localCache = WaterMarkCache.getLocalCache(tenantId, accountId);
        if (null == cachedAppIds || cachedAppIds.length == 0) {
            statelessCache.removeType(statelessCacheType);
            localCache.clear();
            log.debug(String.format("clear local cache in case of local data clear failed, statelessCacheType:[%s]", statelessCacheType));
            return;
        }
        log.debug(String.format("cachedAppIds:[%s]", StringUtils.join((Object[])cachedAppIds, (String)",")));
        Set<String> needDeleteIds = Arrays.stream(cachedAppIds).filter(s -> StringUtils.isBlank((CharSequence)prefix) || StringUtils.startsWith((CharSequence)s, (CharSequence)prefix)).collect(Collectors.toSet());
        if (needDeleteIds.isEmpty()) {
            log.debug("there is no ids need to remove.");
            return;
        }
        Object[] deleteKeysArr = needDeleteIds.toArray(new String[needDeleteIds.size()]);
        Object[] deleteLocalCacheKeysArr = new String[deleteKeysArr.length];
        for (int i = 0; i < deleteKeysArr.length; ++i) {
            String deleteKey = deleteKeysArr[i];
            String[] deleteKeySplit = deleteKey.split("_");
            if (deleteKeySplit.length < 3) {
                deleteLocalCacheKeysArr[i] = deleteKey;
                continue;
            }
            String beReplaceStr = deleteKeySplit[0] + "_" + deleteKeySplit[1] + "_" + deleteKeySplit[2];
            deleteLocalCacheKeysArr[i] = "waterMark_" + tenantId + "_" + accountId + deleteKey.substring(beReplaceStr.length());
        }
        statelessCache.remove(statelessCacheType, (String[])deleteKeysArr);
        statelessCache.removeSetValues(cacheRefKey, (String[])deleteKeysArr);
        log.debug(String.format("finish delete redis cache...statelessCacheType:[%s],deleteKeysArr:[%s]", statelessCacheType, StringUtils.join((Object[])deleteKeysArr, (String)",")));
        if (needDeleteIds.size() > 1000) {
            localCache.clear();
            log.debug("finish clear all local caches...");
        } else {
            localCache.remove((String[])deleteLocalCacheKeysArr);
            log.debug(String.format("finish clear local caches...deleteKeysArr:[%s]", StringUtils.join((Object[])deleteLocalCacheKeysArr, (String)",")));
        }
    }

    private static LocalMemoryCache getLocalCache(String tenantId, String accountId) {
        CacheConfigInfo cacheConfig = new CacheConfigInfo();
        cacheConfig.setTimeout(43200);
        cacheConfig.setMaxMemSize(10000);
        String region = String.format("%s_%s", tenantId, accountId);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, CACHE_KEY, cacheConfig);
    }

    public static WaterMark loadFromCache(String formPkId) {
        FormConfig fc;
        String cachePath;
        String accountId;
        if (StringUtils.isBlank((CharSequence)formPkId)) {
            return null;
        }
        WaterMark tempLicenseWaterMark = WaterMarkCache.tryGetTempLicenseWaterMark();
        if (tempLicenseWaterMark != null) {
            return tempLicenseWaterMark;
        }
        String tenantId = RequestContext.get().getTenantId();
        LocalMemoryCache localCache = WaterMarkCache.getLocalCache(tenantId, accountId = RequestContext.get().getAccountId());
        WaterMark waterMark = (WaterMark)localCache.get(cachePath = "waterMark_" + tenantId + "_" + accountId + "_" + formPkId);
        if (null != waterMark) {
            waterMark = waterMark.isVisible() ? waterMark.cloneObj() : null;
            return WaterMarkCache.setWaterMarkText(waterMark);
        }
        try {
            fc = FormMetadataCache.getFormConfig((String)formPkId);
        }
        catch (Exception e) {
            log.warn("FormMetadataCache#getFormConfig is error, formPkId: " + formPkId, (Throwable)e);
            return null;
        }
        BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
        String appPkId = StringUtils.isBlank((CharSequence)fc.getBizAppNumber()) ? bizAppService.getAppIdByFormNum(formPkId) : bizAppService.getAppIdByAppNumber(fc.getBizAppNumber());
        String cloudPkId = null;
        if (StringUtils.isNotBlank((CharSequence)appPkId)) {
            AppInfo info = EntityMetadataCache.getAppInfo((String)appPkId);
            cloudPkId = info.getCloudId();
        }
        waterMark = WaterMarkCache.loadFromRedisCache(tenantId, accountId, cloudPkId, appPkId, formPkId);
        localCache.put(cachePath, (Object)waterMark);
        waterMark = waterMark.isVisible() ? waterMark.cloneObj() : null;
        return WaterMarkCache.setWaterMarkText(waterMark);
    }

    private static WaterMark tryGetTempLicenseWaterMark() {
        String licenseType = LicenseServiceHelper.getLicenseType();
        if (StringUtils.isNotBlank((CharSequence)licenseType)) {
            WaterMark tempLicenseWaterMark = new WaterMark();
            tempLicenseWaterMark.setType("1");
            tempLicenseWaterMark.setText(licenseType + "\n" + WaterMarkCache.getUserInfoText("phone"));
            tempLicenseWaterMark.setColor("#212121");
            tempLicenseWaterMark.setGlobalAlpha(10);
            tempLicenseWaterMark.setFontSize("18px");
            tempLicenseWaterMark.setAddPreviewWatermark(true);
            tempLicenseWaterMark.setAddDownloadWatermark(false);
            if (WaterMarkCache.testDownloadWatermark()) {
                tempLicenseWaterMark.setAddDownloadWatermark(true);
            }
            return tempLicenseWaterMark;
        }
        return null;
    }

    private static boolean testDownloadWatermark() {
        Map publicParameterConfig = ((IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class)).loadPublicParameterFromCache("bos_publicparametertpl");
        String forbidfiletype = String.valueOf(publicParameterConfig.get("forbidfiletype"));
        return "downloadWatermarkForTest".equals(forbidfiletype);
    }

    private static WaterMark loadFromRedisCache(String tenantId, String accountId, String cloudPkId, String appPkId, String formPkId) {
        String cacheType = String.format(FH_S, tenantId, accountId) + CACHE_KEY;
        String cachePath = "waterMark_" + cloudPkId + "_" + appPkId + "_" + formPkId;
        String cachedWaterMark = (String)statelessCache.get(cacheType, cachePath);
        log.debug(String.format("begin loadFromRedisCache waterMark..., cacheType:[%s], cachePath:[%s]", cacheType, cachePath));
        if (StringUtils.isNotBlank((CharSequence)cachedWaterMark)) {
            WaterMark waterMark = (WaterMark)SerializationUtils.fromJsonString((String)cachedWaterMark, WaterMark.class);
            log.debug(String.format("load waterMark from redis cache, the value is:[%s]", SerializationUtils.toJsonString((Object)waterMark)));
            return waterMark;
        }
        WaterMark waterMark = WaterMarkCache.loadFromDb(cloudPkId, appPkId, formPkId);
        if (null != waterMark) {
            log.debug(String.format("load waterMark from db, the value is:[%s]", SerializationUtils.toJsonString((Object)waterMark)));
        } else {
            log.debug(String.format("can not found any waterMark, return the default waterMark:[%s]", SerializationUtils.toJsonString((Object)INVISIBLE_ROOT_WATER_MARK)));
        }
        waterMark = waterMark == null ? INVISIBLE_ROOT_WATER_MARK : waterMark;
        statelessCache.put(cacheType, cachePath, (Object)SerializationUtils.toJsonString((Object)waterMark));
        String cacheRefKey = String.format(FH_S, tenantId, accountId) + CACHE_REF_KEY;
        statelessCache.addToSet(cacheRefKey, new String[]{cachePath});
        return waterMark;
    }

    private static WaterMark loadFromDb(String cloudPkId, String appPkId, String formPkId) {
        String[] objectIds = new String[]{"rootNode", cloudPkId, appPkId, formPkId};
        QFilter[] filters = new QFilter[]{new QFilter(OBJECTID, "in", (Object)objectIds)};
        DynamicObjectCollection list = ORM.create().query("bos_watermark", "id,texttype,text,picture,type,level,objectid,fontsize,color,globalalpha,plugin,addpreviewwatermark,adddownloadwatermark", filters);
        if (null == list || list.isEmpty()) {
            return null;
        }
        for (int i = LEVELS.length - 1; i >= 0; --i) {
            WaterMark mark = WaterMarkCache.findMark(LEVELS[i], objectIds[i], list);
            if (mark == null) continue;
            return mark;
        }
        return null;
    }

    private static WaterMark findMark(String level, String objectId, DynamicObjectCollection list) {
        for (DynamicObject obj : list) {
            String type = obj.getString("type");
            String tObjectId = obj.getString(OBJECTID);
            String tLevel = obj.getString("level");
            log.debug("findMark type is " + type + " ,tObjectId is " + tObjectId + ",tLevel is " + tLevel + " ,level is " + level + ",objectId is " + objectId);
            if (StringUtils.isBlank((CharSequence)type) || !StringUtils.equals((CharSequence)level, (CharSequence)tLevel) || !StringUtils.equals((CharSequence)objectId, (CharSequence)tObjectId)) continue;
            if (TYPE_PLUGIN.equals(type)) {
                String pluginJson = obj.getString("plugin");
                WaterMark waterMark = WaterMarkCache.getWaterMarkByOverPlugin(pluginJson);
                waterMark.setPlugin(pluginJson);
                return waterMark;
            }
            WaterMark waterMark = new WaterMark();
            waterMark.setTextType(obj.getString("texttype"));
            waterMark.setText(obj.getString("text"));
            waterMark.setPicture(obj.getString("picture"));
            waterMark.setType(type);
            waterMark.setObjectId(obj.getString(OBJECTID));
            waterMark.setLevel(obj.getString("level"));
            waterMark.setFontSize(obj.getString("fontsize"));
            waterMark.setColor(obj.getString("color"));
            waterMark.setGlobalAlpha(obj.getInt("globalalpha"));
            waterMark.setAddPreviewWatermark(obj.getBoolean("addpreviewwatermark"));
            waterMark.setAddDownloadWatermark(obj.getBoolean("adddownloadwatermark"));
            return waterMark;
        }
        return null;
    }

    private static WaterMark getWaterMarkByOverPlugin(String pluginJson) {
        if (StringUtils.isBlank((CharSequence)pluginJson)) {
            return new WaterMark();
        }
        List pluginList = new ArrayList(10);
        try {
            pluginList = (List)SerializationUtils.fromJsonString((String)pluginJson, List.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        if (CollectionUtils.isEmpty(pluginList)) {
            return new WaterMark();
        }
        IWaterMarkPlugin waterMarkPlugin = null;
        try {
            waterMarkPlugin = (IWaterMarkPlugin)TypesContainer.createInstance((String)((String)((Map)pluginList.get(pluginList.size() - 1)).get("ClassName")));
        }
        catch (Exception ex) {
            log.error("FormShowParameter-setWaterMarkTextByOverPlugin-\u6c34\u5370\u7684\u5168\u5c40\u63d2\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (waterMarkPlugin == null) {
            return new WaterMark();
        }
        LoadWaterMarkInfoEventArgs e = new LoadWaterMarkInfoEventArgs(new Object());
        waterMarkPlugin.setWaterMarkInfo(e);
        return e.getWaterMark();
    }

    public static WaterMark setWaterMarkText(WaterMark waterMark) {
        if (waterMark != null) {
            String userName;
            if (TYPE_INVISIBLE.equals(waterMark.getType())) {
                return waterMark;
            }
            if (TYPE_PLUGIN.equals(waterMark.getType()) || StringUtils.isNotBlank((CharSequence)waterMark.getPlugin())) {
                return WaterMarkCache.getWaterMarkByOverPlugin(waterMark.getPlugin());
            }
            Map<String, Object> userMap = WaterMarkCache.getCurrentUserInfo();
            String string = userName = StringUtils.isBlank((CharSequence)((String)userMap.get("name"))) ? RequestContext.get().getUserName() : (String)userMap.get("name");
            if ("2".equals(waterMark.getTextType())) {
                waterMark.setText(userName);
            } else if ("3".equals(waterMark.getTextType())) {
                waterMark.setText(WaterMarkCache.getUserInfoText("phone"));
            } else if ("4".equals(waterMark.getTextType())) {
                waterMark.setText(WaterMarkCache.getUserInfoText("number"));
            }
        }
        return waterMark;
    }

    private static String getUserInfoText(String secondPart) {
        Map<String, Object> userMap = WaterMarkCache.getCurrentUserInfo();
        String userName = StringUtils.isBlank((CharSequence)((String)userMap.get("name"))) ? RequestContext.get().getUserName() : (String)userMap.get("name");
        String secondPartText = (String)userMap.get(secondPart);
        if (StringUtils.equals((CharSequence)"phone", (CharSequence)secondPart)) {
            secondPartText = StringUtils.isNotEmpty((CharSequence)secondPartText) && secondPartText.length() > 4 ? secondPartText.substring(secondPartText.length() - 4) : "";
        }
        return userName + secondPartText;
    }

    private static Map<String, Object> getCurrentUserInfo() {
        Boolean isDoLog = SystemPropertyUtils.getBoolean((String)RequestContext.get().getTenantId(), (String)"do.watermark.log", (Boolean)Boolean.FALSE);
        HashMap<String, Object> userMap = new HashMap(16);
        String cacheName = "watermark_userinfo";
        long userId = Long.parseLong(RequestContext.get().getUserId());
        DynamicObject userDynamicObject = null;
        log.debug("getCurrentUserInfo cache key is " + cacheName + userId);
        if (userServiceCache.get(cacheName + userId) == null) {
            log.debug("getCurrentUserInfo cache value is null ");
            userDynamicObject = ORM.create().queryOne("bos_user", "id,name,phone,number", new QFilter[]{new QFilter("id", "=", (Object)userId)});
            if (userDynamicObject != null) {
                userMap.put("id", userDynamicObject.get("id"));
                userMap.put("phone", userDynamicObject.get("phone"));
                userMap.put("number", userDynamicObject.get("number"));
                userMap.put("name", userDynamicObject.getLocaleString("name").getLocaleValue());
                userServiceCache.put(cacheName + userId, (Object)SerializationUtils.toJsonString(userMap), 3600);
                if (isDoLog.booleanValue()) {
                    log.debug("getCurrentUserInfo userDynamicObject value is not null, cache put value is " + SerializationUtils.toJsonString(userMap));
                }
            }
        } else {
            userMap = (Map)SerializationUtils.fromJsonString((String)((String)userServiceCache.get(cacheName + userId)), Map.class);
            if (isDoLog.booleanValue()) {
                log.debug("getCurrentUserInfo cache value is not null " + SerializationUtils.toJsonString(userMap));
            }
        }
        return userMap;
    }

    static {
        INVISIBLE_ROOT_WATER_MARK.setText("");
        INVISIBLE_ROOT_WATER_MARK.setPicture("");
        INVISIBLE_ROOT_WATER_MARK.setTextType("");
        INVISIBLE_ROOT_WATER_MARK.setType(TYPE_INVISIBLE);
        INVISIBLE_ROOT_WATER_MARK.setLevel("root");
        INVISIBLE_ROOT_WATER_MARK.setObjectId("rootNode");
        INVISIBLE_ROOT_WATER_MARK.setFontSize("12px");
        INVISIBLE_ROOT_WATER_MARK.setColor("#333");
        INVISIBLE_ROOT_WATER_MARK.setGlobalAlpha(10);
    }
}

