/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.picture;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.designer.property.picture.common.PictureResourceKit;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mc.webclient.WebClientFiles;
import kd.bos.mservice.svc.attach.IAttachmentPanel;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.dto.MCUploadFileDto;
import kd.bos.portal.util.MCUploadFileUtil;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;

public class ImportPicResourcePlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String URL_ARR = "urlarr";
    private static final String IMAGE = "image";
    private static final String IDE_PICTURE_RES_EDITER = "ide_pictureresediter";
    private static final String LONG_NUMBER = "longnumber";
    private static final String BOS_RESOURCE_CATEGORY = "bos_resourcecategory";
    private static final String FURL_0 = "furl0";
    private static final String FTYPE = "ftype";
    private Log logger = LogFactory.getLog(ImportPicResourcePlugin.class);
    private String EMPTY = ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u9700\u8981\u5bfc\u5165\u7684\u8d44\u6e90\u538b\u7f29\u5305\u3002", (String)"ImportPicResourcePlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]);
    private static final String ATTACH_FILES = "imgfiles";
    private static final String ROOT_PATH = "globalimgs";
    private static final String FILE_KEY = "_tenant_login_config_resoure";
    public static final String BOS_PICTURE = "bos-picture";
    private Map<String, Object> categoryMap = new HashMap<String, Object>();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        IAttachmentPanel dbspanel = (IAttachmentPanel)this.getView().getControl("attachmentpanelap");
        dbspanel.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                if (!this.checkZipPackage()) break;
                boolean isUploadToMC = true;
                String currentIsv = ISVService.getISVInfo().getId();
                if (StringUtils.isNotBlank((CharSequence)currentIsv) && !"kingdee".equalsIgnoreCase(currentIsv)) {
                    isUploadToMC = this.uploadToMC();
                }
                if (!isUploadToMC) break;
                this.saveToDB();
                break;
            }
        }
    }

    public void upload(UploadEvent arg) {
        if (arg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff01", (String)"ImportPicResourcePlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Object[] args = arg.getUrls();
        if (args == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff01", (String)"ImportPicResourcePlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        ArrayList mmpList = new ArrayList(10);
        for (int n = 0; n < args.length; ++n) {
            Map urlMsg = (Map)args[n];
            String name = (String)urlMsg.get("name");
            String id = (String)urlMsg.get("uid");
            String url = (String)urlMsg.get("url");
            HashMap<String, String> mp = new HashMap<String, String>();
            mp.put("id", id);
            mp.put("name", name);
            mp.put("url", url);
            mmpList.add(mp);
        }
        String urlString = SerializationUtils.toJsonString(mmpList);
        this.getPageCache().put(URL_ARR, urlString);
    }

    public void remove(UploadEvent arg) {
        Map urlMsg = (Map)arg.getUrls()[0];
        String currentId = (String)urlMsg.get("uid");
        String urlarr = this.getPageCache().get(URL_ARR);
        List mmpList = (List)SerializationUtils.fromJsonString((String)urlarr, List.class);
        if (!mmpList.isEmpty()) {
            Iterator iterator = mmpList.iterator();
            while (iterator.hasNext()) {
                Map urlObj = (Map)iterator.next();
                String id = (String)urlObj.get("id");
                if (!id.equals(currentId)) continue;
                iterator.remove();
            }
            this.getPageCache().put(URL_ARR, SerializationUtils.toJsonString((Object)mmpList));
        }
    }

    public static LoginMCService getMcService() {
        return LoginMCService.create();
    }

    public static void saveMcData(String key, String value) throws Exception {
        ImportPicResourcePlugin.getMcService().setMCData(RequestContext.get().getTenantId(), key, value);
    }

    public static String getMcData(String key) throws Exception {
        return ImportPicResourcePlugin.getMcService().getMCData(RequestContext.get().getTenantId(), key);
    }

    private void setWebClientFiles(List<kd.bos.mc.webclient.File> listFile) throws Exception {
        WebClientFiles client = new WebClientFiles();
        client.setDcid(RequestContext.get().getAccountId());
        client.setIsv(ISVServiceHelper.getISVInfo().getId());
        client.setKeys(this.getUniqueId(ATTACH_FILES));
        client.setTenantId(RequestContext.get().getTenantId());
        client.setFiles(listFile == null ? Collections.EMPTY_LIST : listFile);
        ImportPicResourcePlugin.getMcService().setWebClientFiles(client);
    }

    private String getUniqueId(String suffix) {
        return "_isv_resource_config_" + RequestContext.get().getTenantId() + "_" + suffix;
    }

    private List<kd.bos.mc.webclient.File> getListFile(List<Map<String, Object>> data, boolean useInputStream) {
        if (data != null) {
            ArrayList<kd.bos.mc.webclient.File> listFile = new ArrayList<kd.bos.mc.webclient.File>();
            data.forEach(item -> {
                String id = (String)item.get("id");
                String url = (String)item.get("url");
                String name = (String)item.get("name");
                String newURL = "";
                newURL = useInputStream ? (this.isTempUrl(url) ? this.save2FileServiceAndReturnPath(url, id, name) : url) : (this.isTempUrl(url) ? this.save2FileService(url, id, name) : this.replaceEnableSessionId(url));
                kd.bos.mc.webclient.File file = new kd.bos.mc.webclient.File();
                file.setDestPath(ROOT_PATH);
                file.setName(name);
                file.setServerType("FS");
                file.setNeedUpdate(true);
                file.setFileServerPath(newURL);
                listFile.add(file);
            });
            return listFile;
        }
        return Collections.EMPTY_LIST;
    }

    private boolean uploadToMC() {
        boolean successful = false;
        try {
            String attachFiles = this.getPageCache().get(URL_ARR);
            if (StringUtils.isNotEmpty((CharSequence)attachFiles)) {
                List data = (List)SerializationUtils.fromJsonString((String)attachFiles, List.class);
                this.upload2MC(data);
                String serialData = SerializationUtils.toJsonString((Object)data);
                ImportPicResourcePlugin.saveMcData(FILE_KEY, serialData);
                successful = true;
            } else {
                this.setWebClientFiles(null);
                ImportPicResourcePlugin.saveMcData(FILE_KEY, "null");
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            this.getView().showErrMessage(this.getErrorMsg(e), ResManager.loadKDString((String)"\u4e0a\u4f20\u5230\u7ba1\u7406\u4e2d\u5fc3\u5931\u8d25", (String)"ImportPicResourcePlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        return successful;
    }

    private void saveToDB() {
        String urlarr = this.getPageCache().get(URL_ARR);
        if (StringUtils.isBlank((CharSequence)urlarr)) {
            return;
        }
        List mmpList = (List)SerializationUtils.fromJsonString((String)urlarr, List.class);
        if (mmpList.isEmpty()) {
            this.getView().showTipNotification(this.EMPTY, Integer.valueOf(2000));
            return;
        }
        Map urlObj = (Map)mmpList.get(0);
        String url = (String)urlObj.get("url");
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        ZipEntry zipEntry = null;
        HashMap<String, List<String>> mmp = new HashMap<String, List<String>>();
        ArrayList<String> fullFilePaths = new ArrayList<String>();
        String currentIsv = ISVService.getISVInfo().getId();
        try (InputStream input = cache.getInputStream(url);
             ZipInputStream zipIn = new ZipInputStream(input, Charset.forName("GBK"));){
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                String metaName = zipEntry.getName();
                if (!(metaName = metaName.replace(File.separator, "/")).contains("images") && !metaName.contains("icons")) continue;
                if (StringUtils.isEmpty((CharSequence)currentIsv) || "kingdee".equalsIgnoreCase(currentIsv)) {
                    fullFilePaths.add(metaName);
                    continue;
                }
                String[] nameArry = metaName.split("/");
                String fileName = nameArry[nameArry.length - 1];
                if (metaName.contains("icon")) {
                    if (mmp.containsKey("icon")) {
                        ((List)mmp.get("icon")).add(fileName);
                        continue;
                    }
                    mmp.put("icon", new ArrayList());
                    ((List)mmp.get("icon")).add(fileName);
                    continue;
                }
                if (!metaName.contains(IMAGE)) continue;
                if (mmp.containsKey(IMAGE)) {
                    ((List)mmp.get(IMAGE)).add(fileName);
                    continue;
                }
                mmp.put(IMAGE, new ArrayList());
                ((List)mmp.get(IMAGE)).add(fileName);
            }
        }
        catch (Exception e) {
            this.getView().showErrMessage(this.getErrorMsg(e), ResManager.loadKDString((String)"\u8bfb\u53d6\u538b\u7f29\u5305\u5931\u8d25\u3002", (String)"ImportPicResourcePlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (!mmp.isEmpty()) {
            this.importISVResource(mmp);
            this.getView().returnDataToParent(this.retunData(true, ResManager.loadKDString((String)"\u5bfc\u5165\u8d44\u6e90\u6210\u529f\u3002", (String)"ImportPicResourcePlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
            this.getView().close();
        } else if (!fullFilePaths.isEmpty()) {
            this.importKingdeeResource(fullFilePaths);
            this.getView().returnDataToParent(this.retunData(true, ResManager.loadKDString((String)"\u5bfc\u5165\u8d44\u6e90\u6210\u529f\u3002", (String)"ImportPicResourcePlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
            this.getView().close();
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5bfc\u5165\u7684\u6587\u4ef6\u3002", (String)"ImportPicResourcePlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    private Object retunData(boolean status, String message) {
        HashMap<String, Object> mp = new HashMap<String, Object>();
        mp.put("successful", status);
        mp.put("message", message);
        return mp;
    }

    private void importKingdeeResource(List<String> resList) {
        String currentIsv = ISVService.getISVInfo().getId();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)IDE_PICTURE_RES_EDITER);
        ArrayList<DynamicObject> pics = new ArrayList<DynamicObject>();
        for (String res : resList) {
            String[] nameArry = res.split("/");
            String fileName = nameArry[nameArry.length - 1];
            String path = res.substring(0, res.lastIndexOf("/"));
            String longNumber = path.replace('/', '.');
            Object categoryPkId = "";
            if (this.categoryMap.containsKey(longNumber)) {
                categoryPkId = this.categoryMap.get(longNumber);
            } else {
                QFilter filter = new QFilter(LONG_NUMBER, "=", (Object)longNumber);
                DynamicObject categoryObj = QueryServiceHelper.queryOne((String)BOS_RESOURCE_CATEGORY, (String)"id", (QFilter[])new QFilter[]{filter});
                categoryPkId = categoryObj != null ? categoryObj.get("id") : Long.valueOf(0L);
                this.categoryMap.put(longNumber, categoryPkId);
            }
            if (!StringUtils.isNotBlank((Object)categoryPkId)) continue;
            String furl0 = "";
            furl0 = res.startsWith("/") ? res : "/" + res;
            QFilter filter = new QFilter(FURL_0, "=", (Object)furl0);
            boolean isExisted = QueryServiceHelper.exists((String)IDE_PICTURE_RES_EDITER, (QFilter[])new QFilter[]{filter});
            if (isExisted) continue;
            DynamicObject dynObj = new DynamicObject((DynamicObjectType)dt);
            dynObj.set("fnumber", (Object)furl0);
            dynObj.set("fname", (Object)fileName);
            dynObj.set("categoryid", categoryPkId);
            dynObj.set("fcreatedate", (Object)new Date());
            dynObj.set("fformat", (Object)"png");
            if (res.contains("icon")) {
                dynObj.set(FTYPE, (Object)"icon");
            } else {
                dynObj.set(FTYPE, (Object)IMAGE);
            }
            dynObj.set("fpath", (Object)path);
            dynObj.set(FURL_0, (Object)furl0);
            dynObj.set("isv", (Object)currentIsv);
            pics.add(dynObj);
        }
        BusinessDataServiceHelper.save((IDataEntityType)dt, (Object[])pics.toArray(new DynamicObject[pics.size()]));
    }

    private void importISVResource(Map<String, List<String>> map) {
        String currentIsv = ISVService.getISVInfo().getId();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)IDE_PICTURE_RES_EDITER);
        ArrayList<DynamicObject> pics = new ArrayList<DynamicObject>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String type = entry.getKey();
            String path = "/isv/" + currentIsv + "/" + ROOT_PATH;
            path = type.equals("icon") ? path + "/icons/" : path + "/images/";
            Object categoryId = this.getCategoryId(type);
            List<String> files = entry.getValue();
            for (String var : files) {
                if (!var.contains(".")) continue;
                String fullPath = path + var;
                QFilter filter = new QFilter(FURL_0, "=", (Object)fullPath);
                boolean isExisted = QueryServiceHelper.exists((String)IDE_PICTURE_RES_EDITER, (QFilter[])new QFilter[]{filter});
                if (isExisted) continue;
                String[] splitName = var.split("\\.");
                DynamicObject dynObj = new DynamicObject((DynamicObjectType)dt);
                dynObj.set("fnumber", (Object)(currentIsv + "_" + splitName[0]));
                dynObj.set("fname", (Object)splitName[0]);
                dynObj.set("categoryid", categoryId);
                dynObj.set("fcreatedate", (Object)new Date());
                dynObj.set("fformat", (Object)"png");
                dynObj.set(FTYPE, (Object)type);
                dynObj.set("fpath", (Object)path);
                dynObj.set(FURL_0, (Object)(path + var));
                dynObj.set("isv", (Object)currentIsv);
                pics.add(dynObj);
            }
        }
        BusinessDataServiceHelper.save((IDataEntityType)dt, (Object[])pics.toArray(new DynamicObject[pics.size()]));
    }

    private Object getCategoryId(String type) {
        Object categoryPkId = "";
        String currentIsv = ISVService.getISVInfo().getId();
        String cuttentIsvName = ISVService.getISVInfo().getName();
        String longNumber = type + "s." + currentIsv;
        String parentId = "397599676313912320";
        String fullname = String.format(ResManager.loadKDString((String)"\u56fe\u6807.%s", (String)"ImportPicResourcePlugin_1", (String)BOS_PICTURE, (Object[])new Object[0]), cuttentIsvName);
        if (IMAGE.equals(type)) {
            parentId = "397599972071064576";
            fullname = String.format(ResManager.loadKDString((String)"\u56fe\u7247.%s", (String)"ImportPicResourcePlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), cuttentIsvName);
        }
        QFilter filter = new QFilter(LONG_NUMBER, "=", (Object)longNumber);
        DynamicObject categoryObj = QueryServiceHelper.queryOne((String)BOS_RESOURCE_CATEGORY, (String)"id", (QFilter[])new QFilter[]{filter});
        if (categoryObj != null) {
            categoryPkId = categoryObj.get("id");
        } else {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)BOS_RESOURCE_CATEGORY);
            DynamicObject dynObj = new DynamicObject((DynamicObjectType)dt);
            dynObj.set("number", (Object)currentIsv);
            dynObj.set("name", (Object)cuttentIsvName);
            dynObj.set("level", (Object)2);
            dynObj.set(LONG_NUMBER, (Object)longNumber);
            dynObj.set("isleaf", (Object)false);
            dynObj.set("parent", (Object)parentId);
            dynObj.set("fullname", (Object)fullname);
            dynObj.set("status", (Object)"C");
            dynObj.set("enable", (Object)1);
            dynObj.set("createtime", (Object)new Date());
            dynObj.set("modifytime", (Object)new Date());
            Object[] pks = BusinessDataServiceHelper.save((IDataEntityType)dt, (Object[])new DynamicObject[]{dynObj});
            categoryPkId = pks[0];
        }
        return categoryPkId;
    }

    private String getErrorMsg(Exception e) {
        if (e == null) {
            return "";
        }
        if (e instanceof KDException) {
            KDException kde = (KDException)e;
            Object[] args = kde.getArgs();
            StringBuilder buf = new StringBuilder();
            if (args != null && args.length > 0) {
                for (Object o : args) {
                    buf.append(o);
                }
            }
            return buf.append("\r\n").append(kde.getMessage()).append("\r\n").append(kde.getStackTraceMessage()).toString();
        }
        return e.getMessage();
    }

    private String save2FileService(String tempUrl, String uid, String fileName) {
        if (this.isTempUrl(tempUrl)) {
            return AttachmentServiceHelper.getEncreptURL((String)UrlService.getAttachmentFullUrl((String)this.encodeUrl(AttachmentServiceHelper.saveTempToFileService((String)tempUrl, (String)this.getView().getFormShowParameter().getServiceAppId(), (String)this.getView().getFormShowParameter().getFormId(), (Object)uid, (String)fileName, (boolean)false))));
        }
        return tempUrl;
    }

    private boolean isTempUrl(String url) {
        return StringUtils.isNotEmpty((CharSequence)url) && url.contains("configKey");
    }

    private String encodeUrl(String url) {
        try {
            return StringUtils.isNotEmpty((CharSequence)url) ? URLEncoder.encode(url, "UTF-8") : url;
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Throwable)e);
            this.getView().showErrMessage(e.getMessage(), ResManager.loadKDString((String)"url\u7f16\u7801\u5f02\u5e38", (String)"ImportPicResourcePlugin_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return url;
        }
    }

    private String replaceEnableSessionId(String url) {
        String newUrl;
        if (!StringUtils.isNotEmpty((CharSequence)url)) {
            return url;
        }
        String _temp_url = url.replace("?", ";");
        String sessionIdStr = "";
        if (_temp_url.contains(";")) {
            String[] arr;
            for (String s : arr = _temp_url.split(";")[1].split("&")) {
                if (!"kdedcba".equals(s.split("=")[0])) continue;
                sessionIdStr = s;
                break;
            }
        }
        if ((newUrl = url.replace(sessionIdStr, "")).endsWith("&")) {
            newUrl = newUrl.substring(0, newUrl.length() - 1);
        }
        return StringUtils.isNotEmpty((CharSequence)sessionIdStr) ? AttachmentServiceHelper.getEncreptURL((String)newUrl) : url;
    }

    private boolean checkZipPackage() {
        boolean result = false;
        String urlarr = this.getPageCache().get(URL_ARR);
        if (StringUtils.isBlank((CharSequence)urlarr)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f13\u5b58\u4e2d\u7684\u538b\u7f29\u5305\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ImportPicResourcePlugin_13", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return result;
        }
        List mmpList = (List)SerializationUtils.fromJsonString((String)urlarr, List.class);
        if (mmpList.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53cd\u5e8f\u5217\u5316\u7f13\u5b58\u6570\u636e\u5931\u8d25\u3002", (String)"ImportPicResourcePlugin_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return result;
        }
        boolean isCheck = false;
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        for (int i = 0; i < mmpList.size(); ++i) {
            Map urlObj = (Map)mmpList.get(i);
            String url = (String)urlObj.get("url");
            try (InputStream inputStream = cache.getInputStream(url);
                 ZipInputStream zipInputStream = new ZipInputStream(inputStream, Charset.forName("GBK"));){
                if (PictureResourceKit.isKingdeeIsv() && this.pathValidityCheck(zipInputStream)) {
                    result = true;
                    isCheck = true;
                    break;
                }
                if (PictureResourceKit.isKingdeeIsv() || !this.pathValidityCheckV2(zipInputStream)) continue;
                result = true;
                isCheck = true;
                break;
            }
            catch (Exception e) {
                this.logger.error("**\u6821\u9a8c\u9759\u6001\u8d44\u6e90\u538b\u7f29\u5305\u51fa\u73b0\u5f02\u5e38**  URL\uff1a" + url);
                this.getView().showErrMessage(this.getErrorMsg(e), ResManager.loadKDString((String)"\u65e0\u6cd5\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u538b\u7f29\u5305\u6216\u538b\u7f29\u5305\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u5e76\u91cd\u65b0\u4e0a\u4f20\u538b\u7f29\u5305\u3002", (String)"ImportPicResourcePlugin_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return false;
            }
        }
        if (!PictureResourceKit.isKingdeeIsv() && !isCheck) {
            String message = ResManager.loadKDString((String)"\u538b\u7f29\u5305\u7684\u6839\u76ee\u5f55\u4e0b\u5fc5\u987b\u5b58\u5728\u540d\u79f0icons\u6216images\u7684\u76ee\u5f55\uff01", (String)"ImportPicResourcePlugin_3", (String)BOS_PICTURE, (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
        }
        if (PictureResourceKit.isKingdeeIsv() && !isCheck) {
            String message = ResManager.loadKDString((String)"\u538b\u7f29\u5305\u4e2d\u5b58\u5728\u56fe\u7247\u7684\u8def\u5f84\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u6839\u636e\u9759\u6001\u8d44\u6e90git\u4ed3\u5e93\u5730\u5740\u65b0\u5efa\u6587\u4ef6\u5939\u5b58\u653e\u56fe\u7247\uff0c\u8def\u5f84\u89c4\u8303\uff1a/icons/...\u3001/images/...\u3001/kingdee/\u9886\u57df\u6807\u8bc6/images/...", (String)"ImageAction_6", (String)BOS_PICTURE, (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
        }
        return result;
    }

    private boolean pathValidityCheck(ZipInputStream zipInputStream) throws IOException {
        ZipEntry zEntry = null;
        while ((zEntry = zipInputStream.getNextEntry()) != null) {
            if (zEntry.isDirectory()) continue;
            String path = zEntry.getName();
            if (PictureResourceKit.checkPathValidity(path = path.substring(0, path.lastIndexOf("/") + 1)) && PictureResourceKit.checkPathCategoryValidity(path)) continue;
            return false;
        }
        return true;
    }

    private boolean pathValidityCheckV2(ZipInputStream zipInputStream) throws IOException {
        ZipEntry zEntry = null;
        while ((zEntry = zipInputStream.getNextEntry()) != null) {
            String path;
            if (zEntry.isDirectory() || !(path = zEntry.getName()).startsWith("images") && !path.startsWith("icons")) continue;
            return true;
        }
        return false;
    }

    private void upload2MC(List<Map<String, Object>> data) {
        try {
            List<kd.bos.mc.webclient.File> fileList = this.getListFile(data, true);
            for (kd.bos.mc.webclient.File file : fileList) {
                MCUploadFileUtil.setWebClientFiles((MCUploadFileDto)this.buildMCUploadFileInfo(file));
            }
        }
        catch (Exception e) {
            this.logger.error("upload file to mc by stream failed", (Throwable)e);
            try {
                List<kd.bos.mc.webclient.File> fileList = this.getListFile(data, false);
                this.setWebClientFiles(fileList);
            }
            catch (Exception e1) {
                this.logger.error("upload file to mc by url failed", (Throwable)e1);
                this.getView().showErrMessage(this.getErrorMsg(e1), ResManager.loadKDString((String)"\u4e0a\u4f20\u5230\u7ba1\u7406\u4e2d\u5fc3\u5931\u8d25", (String)"ImportPicResourcePlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        }
    }

    private MCUploadFileDto buildMCUploadFileInfo(kd.bos.mc.webclient.File file) {
        MCUploadFileDto dto = new MCUploadFileDto();
        dto.setDcid(RequestContext.get().getAccountId());
        dto.setIsv(ISVServiceHelper.getISVInfo().getId());
        dto.setKeys(this.getUniqueId(ATTACH_FILES));
        dto.setTenantId(RequestContext.get().getTenantId());
        dto.setDestPath(file.getDestPath());
        dto.setName(file.getName());
        dto.setServerType(file.getServerType());
        dto.setNeedUpdate(file.isNeedUpdate());
        dto.setFileServerPath(file.getFileServerPath());
        InputStream in = FileServiceFactory.getAttachmentFileService().getInputStream(file.getFileServerPath());
        dto.setInputStream(in);
        return dto;
    }

    private String save2FileServiceAndReturnPath(String tempUrl, String uid, String fileName) {
        if (this.isTempUrl(tempUrl)) {
            String path = AttachmentServiceHelper.saveTempToFileService((String)tempUrl, (String)this.getView().getFormShowParameter().getServiceAppId(), (String)this.getView().getFormShowParameter().getFormId(), (Object)uid, (String)fileName, (boolean)false);
            path = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(path);
            return path;
        }
        return tempUrl;
    }
}

