/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.picture;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.picture.common.PictureResourceKit;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;

public class PictureSelectorPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener,
TabSelectListener,
SearchEnterListener,
ListboxClickListener {
    private static final String SHOW_ENTRYKEY = "showentry";
    private static final String PIC_LISTBOX = "piclistboxap";
    private static final String ICON_LISTBOX = "iconlistboxap";
    private static final String TAB_KEY = "tabap";
    private static final String KEY_SEARCH = "btnsearch";
    private static final String BTN_EDIT = "btnedit";
    private static final String IMAGE = "image";
    private static final String PIC_ITEM_ID_CACHE = "picitemIdCache";
    private static final String ICON_ITEM_ID_CACHE = "iconitemIdCache";
    private static final String ITEM_ID = "itemId";
    private static final String PIC_TAB_PAGE = "pictabpage";
    private static final String FNAME = "fname";
    private static final String NAME = "name";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", BTN_EDIT, "btnadd", "btnreset", "btncancel", "btnpresql"});
        Listbox picListbox = (Listbox)this.getView().getControl(PIC_LISTBOX);
        picListbox.addListboxClickListener((ListboxClickListener)this);
        Listbox iconListbox = (Listbox)this.getView().getControl(ICON_LISTBOX);
        iconListbox.addListboxClickListener((ListboxClickListener)this);
        Search search = (Search)this.getView().getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        AbstractGrid showGrid = (AbstractGrid)this.getView().getControl(SHOW_ENTRYKEY);
        showGrid.addRowClickListener((RowClickEventListener)this);
        Tab tab = (Tab)this.getView().getControl(TAB_KEY);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        Listbox picListbox = (Listbox)this.getView().getControl(PIC_LISTBOX);
        List<ListboxItem> picListboxItems = this.getCategoryNodes(IMAGE);
        picListbox.addItems(picListboxItems);
        Listbox iconListbox = (Listbox)this.getView().getControl(ICON_LISTBOX);
        List<ListboxItem> iconListboxItems = this.getCategoryNodes("icon");
        iconListbox.addItems(iconListboxItems);
        if (picListboxItems != null && picListboxItems.size() > 0) {
            ListboxItem firstItem = picListboxItems.get(0);
            this.getPageCache().put(PIC_ITEM_ID_CACHE, firstItem.getId());
            this.showPictureGrid(firstItem.getId(), IMAGE, "");
        }
        if (iconListboxItems != null && iconListboxItems.size() > 0) {
            ListboxItem iconfirstItem = iconListboxItems.get(0);
            this.getPageCache().put(ICON_ITEM_ID_CACHE, iconfirstItem.getId());
            this.getPageCache().put("iconListboxItemscache", SerializationUtils.toJsonString(iconListboxItems));
        }
    }

    public void listboxClick(ListboxEvent evt) {
        String type = null;
        String itemId = evt.getItemId();
        this.getPageCache().put(ITEM_ID, itemId);
        Listbox listbox = (Listbox)evt.getSource();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_EDIT});
        if (PIC_LISTBOX.equals(listbox.getKey())) {
            type = IMAGE;
            this.getPageCache().put(PIC_ITEM_ID_CACHE, itemId);
        } else {
            type = "icon";
            this.getPageCache().put(ICON_ITEM_ID_CACHE, itemId);
        }
        this.showPictureGrid(itemId, type, "");
    }

    public void click(EventObject evt) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(SHOW_ENTRYKEY);
        int rowIndex = grid.getEntryState().getFocusRow();
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase()) {
            case "btnedit": {
                Object idValue = this.getModel().getValue("id", rowIndex);
                this.showPictureEditer(idValue);
                break;
            }
            case "btnok": {
                if (rowIndex > -1) {
                    Object newValue = this.getModel().getValue("url0", rowIndex);
                    this.returnData(newValue);
                    break;
                }
                this.getView().close();
                break;
            }
            case "btnreset": {
                this.returnData("");
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        String itemId = this.getPageCache().get(ITEM_ID);
        this.showPictureGrid(itemId, IMAGE, "");
    }

    public void entryRowClick(RowClickEvent evt) {
        if (evt.getRow() >= 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_EDIT});
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        CardEntry cad = (CardEntry)evt.getSource();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(cad.getKey());
        int rowIndex = grid.getEntryState().getFocusRow();
        String urlKey = "url0";
        Object url = this.getModel().getValue(urlKey, rowIndex);
        if (StringUtils.isNotBlank((Object)url)) {
            String[] urls = new String[]{(String)url};
            this.getView().showPictureView(urls, 1);
        }
    }

    private void showPictureEditer(Object id) {
        Tab c = (Tab)this.getControl(TAB_KEY);
        String currentTab = c.getCurrentTab();
        if (currentTab == null) {
            c.activeTab(PIC_TAB_PAGE);
        }
        String categoryId = "";
        categoryId = PIC_TAB_PAGE.equals(currentTab) ? this.getPageCache().get(PIC_ITEM_ID_CACHE) : this.getPageCache().get(ICON_ITEM_ID_CACHE);
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("id", id);
        parameter.setCustomParam("categoryid", (Object)categoryId);
        parameter.setCustomParam("from", (Object)"selector");
        parameter.setFormId("ide_pictureresediter");
        String type = "view";
        if (ObjectUtils.isEmpty((Object)id)) {
            parameter.setStatus(OperationStatus.ADDNEW);
            type = "add";
        } else {
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setPkId(id);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, type));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void tabSelected(TabSelectEvent tabselectevent) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_EDIT});
        String itemId = null;
        String type = null;
        Listbox showListbox = (Listbox)this.getView().getControl(ICON_LISTBOX);
        List<ListboxItem> listboxItems = null;
        if ("icontabpage".equals(tabselectevent.getTabKey())) {
            type = "icon";
            itemId = this.getPageCache().get(ICON_ITEM_ID_CACHE);
            listboxItems = this.getCategoryNodes(type);
        } else {
            type = IMAGE;
            itemId = this.getPageCache().get(PIC_ITEM_ID_CACHE);
            listboxItems = this.getCategoryNodes(type);
        }
        this.getPageCache().put(ITEM_ID, itemId);
        showListbox.addItems(listboxItems);
        if (itemId == null && listboxItems != null && listboxItems.size() > 0) {
            this.showPictureGrid(listboxItems.get(0).getId(), type, "");
        } else {
            this.showPictureGrid(itemId, type, "");
        }
    }

    private void returnData(Object value) {
        String newValue = "";
        if (StringUtils.isNotBlank((Object)value)) {
            if (value.toString().contains("?")) {
                String[] arrValue = value.toString().split("\\?");
                if (arrValue.length > 1) {
                    newValue = arrValue[0];
                }
            } else {
                newValue = value.toString();
            }
            String rootUrl = UrlService.getDomainContextUrl();
            if (rootUrl.endsWith("/")) {
                rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
            }
            newValue = StringUtils.substringAfter((String)newValue, (String)rootUrl);
        }
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(SHOW_ENTRYKEY);
        int rowIndex = grid.getEntryState().getFocusRow();
        String name = (String)this.getModel().getValue(NAME, rowIndex);
        HashMap para = new HashMap();
        para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put("value", newValue);
        para.put(NAME, name);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private void showPictureGrid(String categoryId, String type, String searchtxt) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(SHOW_ENTRYKEY);
        model.getDataEntity(true);
        model.endInit();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        QFilter pathFilter = null;
        if (StringUtils.isNotBlank((CharSequence)categoryId)) {
            pathFilter = new QFilter("categoryid", "=", (Object)Long.parseLong(categoryId));
        }
        filters.add(pathFilter);
        if (StringUtils.isNotBlank((CharSequence)searchtxt)) {
            String tt = searchtxt;
            if (tt.contains(",")) {
                ArrayList<QFilter> searchFilters = new ArrayList<QFilter>(10);
                String[] arrSearchTxt = tt.split(",");
                for (int i = 0; i < arrSearchTxt.length; ++i) {
                    QFilter nameFilter = new QFilter(FNAME, "like", (Object)("%" + arrSearchTxt[i] + "%"));
                    QFilter tagFilter = new QFilter("ftag", "like", (Object)("%" + arrSearchTxt[i] + "%"));
                    searchFilters.add(nameFilter);
                    searchFilters.add(tagFilter);
                }
                QFilter f1 = (QFilter)searchFilters.get(0);
                for (int i = 1; i < searchFilters.size(); ++i) {
                    f1 = f1.or((QFilter)searchFilters.get(i));
                }
                filters.add(f1);
            } else {
                QFilter f1 = new QFilter(FNAME, "like", (Object)("%" + searchtxt + "%"));
                QFilter f2 = new QFilter("ftag", "like", (Object)("%" + searchtxt + "%"));
                filters.add(f1.or(f2));
            }
        }
        String orderBy = "fname desc";
        Map pics = BusinessDataServiceHelper.loadFromCache((String)"ide_pictureresediter", (String)"id, fname, furl0", (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)orderBy);
        if (pics.size() > 0) {
            int i = 0;
            String rootUrl = UrlService.getDomainContextUrl();
            if (rootUrl.endsWith("/")) {
                rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
            }
            model.beginInit();
            model.batchCreateNewEntryRow(SHOW_ENTRYKEY, pics.size());
            for (DynamicObject obj : pics.values()) {
                model.setValue("id", obj.get("id"), i);
                Object fname = obj.get(FNAME);
                String name = "";
                if (fname != null && StringUtils.isEmpty((CharSequence)(name = ((OrmLocaleValue)fname).getLocaleValue()))) {
                    name = ((OrmLocaleValue)fname).getLocaleValue_zh_CN();
                }
                model.setValue(NAME, (Object)name, i);
                Object url0 = obj.get("furl0");
                if (StringUtils.isNotBlank((Object)url0)) {
                    if (url0.toString().startsWith("/")) {
                        model.setValue("url0", (Object)(rootUrl + url0), i);
                    } else {
                        model.setValue("url0", (Object)(rootUrl + "/" + url0), i);
                    }
                }
                ++i;
            }
            model.endInit();
        }
        this.getView().updateView(SHOW_ENTRYKEY);
    }

    private List<ListboxItem> getCategoryNodes(String type) {
        ListboxItem node;
        ArrayList<ListboxItem> nodes = new ArrayList<ListboxItem>();
        String longNumber = PictureResourceKit.getLongNumber(this.getView(), type);
        QFilter f1 = new QFilter("longnumber", "like", (Object)(longNumber + ".%"));
        QFilter[] filters = new QFilter[]{f1};
        String orderby = "name desc";
        Map categorys = BusinessDataServiceHelper.loadFromCache((String)"bos_resourcecategory", (String)"*", (QFilter[])filters, (String)orderby);
        for (DynamicObject row : categorys.values()) {
            Object id = row.get("id");
            Object number = row.get("number");
            String name = row.getString(NAME);
            if (!StringUtils.isNotBlank((Object)number) || !StringUtils.isNotBlank((Object)name)) continue;
            node = new ListboxItem();
            node.setId(id.toString());
            node.setContent(row.getString(NAME));
            nodes.add(node);
        }
        String currentIsv = ISVService.getISVInfo().getId();
        String isvLongNumber = "";
        isvLongNumber = IMAGE.equals(type) ? "images." + currentIsv : "icons." + currentIsv;
        QFilter f2 = new QFilter("longnumber", "=", (Object)isvLongNumber);
        DynamicObject isvCategory = QueryServiceHelper.queryOne((String)"bos_resourcecategory", (String)"id, name, number", (QFilter[])new QFilter[]{f2});
        if (isvCategory != null) {
            node = new ListboxItem();
            node.setId(isvCategory.getString("id"));
            node.setContent(isvCategory.getString(NAME));
            nodes.add(node);
        }
        return nodes;
    }

    public void search(SearchEnterEvent evt) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_EDIT});
        String type = "icon";
        Tab c = (Tab)this.getControl(TAB_KEY);
        String currentTab = c.getCurrentTab();
        String itemId = null;
        if (currentTab == null) {
            c.activeTab(PIC_TAB_PAGE);
        }
        if (PIC_TAB_PAGE.equals(currentTab)) {
            type = IMAGE;
            itemId = this.getPageCache().get(ITEM_ID);
            if (itemId == null) {
                itemId = this.getPageCache().get(PIC_ITEM_ID_CACHE);
            }
        }
        if ("icontabpage".equals(currentTab)) {
            type = "icon";
            itemId = this.getPageCache().get(ITEM_ID);
            if (itemId == null) {
                itemId = this.getPageCache().get(ICON_ITEM_ID_CACHE);
            }
        }
        String path = this.getPageCache().get("nodeid");
        Search search = (Search)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCH, (CharSequence)search.getKey())) {
            String searchText = evt.getText();
            if (StringUtils.isBlank((CharSequence)searchText)) {
                this.showPictureGrid(itemId, type, "");
            } else {
                this.showPictureGrid(path, type, searchText);
            }
        }
    }
}

