/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.picture;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ThumbnailsParameter;
import kd.bos.form.control.Button;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ThumbnailsParamPlugin
extends AbstractFormPlugin {
    private static final String KEY_BUTTON_CANCEL = "btncancel";
    private static final String KEY_THUMBNAILSPARAM_ENTRY = "thumbnailsparam";
    private static final String KEY_SCALE = "scale";
    private static final String KEY_THUMBNAILSTAG = "thumbnailstag";
    private static final String KEY_BUTTON_CONFIRM = "btnconfirm";
    private static final String KEY_BUTTON_ADDROW = "advconbaritemap";
    private static final String KEY_BUTTON_DELETEROW = "advconbaritemap1";

    public void afterCreateNewData(EventObject e) {
        List context = (List)this.getView().getFormShowParameter().getCustomParam("context");
        if (context != null && !context.isEmpty() && context.get(0) != null && !((List)context.get(0)).isEmpty()) {
            List params = (List)((Map)((List)context.get(0)).get(0)).get("ThumbnailsParam");
            if (params != null && !params.isEmpty()) {
                this.getModel().batchCreateNewEntryRow(KEY_THUMBNAILSPARAM_ENTRY, params.size());
                for (int i = 0; i < params.size(); ++i) {
                    Map param = (Map)params.get(i);
                    this.getModel().setValue(KEY_SCALE, param.get(KEY_SCALE), i);
                    this.getModel().setValue(KEY_THUMBNAILSTAG, param.get("thumbnailsTag"), i);
                }
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BUTTON_CONFIRM, KEY_BUTTON_ADDROW, KEY_BUTTON_DELETEROW});
            FieldEdit scaleFieldEdit = (FieldEdit)this.getControl(KEY_SCALE);
            FieldEdit tagFieldEdit = (FieldEdit)this.getControl(KEY_THUMBNAILSTAG);
            scaleFieldEdit.setEnable("", false, -1);
            tagFieldEdit.setEnable("", false, -1);
        }
    }

    public void initialize() {
        this.addClickListeners(new String[]{KEY_BUTTON_CANCEL, KEY_BUTTON_CONFIRM});
    }

    public void click(EventObject evt) {
        Button button = (Button)evt.getSource();
        String key = button.getKey();
        if (KEY_BUTTON_CONFIRM.equals(key)) {
            if (this.inputValidate()) {
                this.returnDataToDesigner();
                this.getView().close();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7f29\u653e\u6bd4\u4f8b\u201d\u503c\u65e0\u6548,\u201c\u7f29\u7565\u56fe\u6807\u8bc6\u201d\u4e0d\u80fd\u91cd\u590d\uff0c\u4e14\u53ea\u80fd\u4e3a\u5b57\u6bcd\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u3002", (String)"ThumbnailsParamPlugin_0", (String)"bos-picture", (Object[])new Object[0]));
            }
        } else if (KEY_BUTTON_CANCEL.equals(key)) {
            this.getView().close();
        }
    }

    private boolean inputValidate() {
        HashSet<String> tagRecord = new HashSet<String>(16);
        for (int i = 0; i < this.getModel().getEntryRowCount(KEY_THUMBNAILSPARAM_ENTRY); ++i) {
            BigDecimal scale = (BigDecimal)this.getModel().getValue(KEY_SCALE, i);
            String thumbnailsTag = (String)this.getModel().getValue(KEY_THUMBNAILSTAG, i);
            if (scale.compareTo(BigDecimal.ONE) > 0 || scale.compareTo(BigDecimal.ZERO) <= 0 || StringUtils.isBlank((CharSequence)thumbnailsTag) || !thumbnailsTag.matches("[A-z_0-9]*")) {
                return false;
            }
            tagRecord.add(thumbnailsTag);
        }
        return tagRecord.size() == this.getModel().getEntryRowCount(KEY_THUMBNAILSPARAM_ENTRY);
    }

    private void returnDataToDesigner() {
        ArrayList<ThumbnailsParameter> thumbnailsParams = new ArrayList<ThumbnailsParameter>(10);
        HashMap param = new HashMap(16);
        for (int i = 0; i < this.getModel().getEntryRowCount(KEY_THUMBNAILSPARAM_ENTRY); ++i) {
            ThumbnailsParameter thumbnailsParameter = new ThumbnailsParameter();
            thumbnailsParameter.setThumbnailsTag(this.getModel().getValue(KEY_THUMBNAILSTAG, i).toString());
            thumbnailsParameter.setScale(this.getModel().getValue(KEY_SCALE, i).toString());
            thumbnailsParams.add(thumbnailsParameter);
        }
        param.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        param.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        param.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        param.put("value", thumbnailsParams);
        this.getView().returnDataToParent(param);
    }
}

