/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import javax.imageio.ImageIO;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class UserPicListPlugin
extends AbstractListPlugin {
    public static final String BOS_PICTURE = "bos-picture";
    private static Log log = LogFactory.getLog(UserPicListPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("encryptall".equals(itemKey)) {
            DynamicObject[] userCol;
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (CollectionUtils.isNotEmpty((Collection)selectedRows)) {
                Object[] pkIds = selectedRows.getPrimaryKeyValues();
                MainEntityType userEntityType = EntityMetadataCache.getDataEntityType((String)"bos_user");
                userCol = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)userEntityType);
            } else {
                userCol = BusinessDataServiceHelper.load((String)"bos_user", (String)"picturefield", null);
            }
            if (userCol.length == 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u52a0\u5bc6\u7684\u4eba\u5458\u5934\u50cf\u3002", (String)"UserPicListPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
                return;
            }
            FileService imageService = FileServiceFactory.getImageFileService();
            ArrayList<FileItem> fileItemList = new ArrayList<FileItem>(10);
            ArrayList<DynamicObject> updateUserList = new ArrayList<DynamicObject>(10);
            ArrayList<String> deletePicList = new ArrayList<String>(10);
            for (DynamicObject userObj : userCol) {
                String picturefield = userObj.getString("picturefield");
                if (picturefield.contains("kdimg")) {
                    System.out.println();
                }
                if (!StringUtils.isNotBlank((CharSequence)picturefield) || picturefield.startsWith("http")) continue;
                picturefield = "/" + picturefield.replaceAll("\\?v=1.0", "").replaceAll("&v=1.0", "");
                while (picturefield.startsWith("//")) {
                    picturefield = picturefield.replace("//", "/");
                }
                if (!imageService.exists(picturefield) || !this.checkImage(picturefield)) continue;
                deletePicList.add(picturefield);
                String fileName = picturefield.substring(picturefield.lastIndexOf("/") + 1);
                String pathPreffix = picturefield.substring(0, StringUtils.lastIndexOf((CharSequence)picturefield, (CharSequence)"/"));
                String pathTwo = picturefield.substring(StringUtils.lastIndexOf((CharSequence)picturefield, (CharSequence)"/") + 1);
                String ext = pathTwo.substring(StringUtils.lastIndexOf((CharSequence)pathTwo, (CharSequence)"."));
                pathTwo = Uuid8.generateShortUuid() + ext;
                String kdImgPath = pathPreffix + "/kdimg" + pathTwo;
                String pictureFullUrl = this.getFileServerUrl(picturefield);
                URL url = null;
                InputStream in = null;
                try {
                    url = new URL(pictureFullUrl);
                    in = url.openConnection().getInputStream();
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u6587\u4ef6\u6d41\u9519\u8bef \uff1a " + e);
                    in = imageService.getInputStream(picturefield);
                }
                FileItem item = new FileItem(fileName, kdImgPath, in);
                fileItemList.add(item);
                userObj.set("picturefield", (Object)kdImgPath);
                updateUserList.add(userObj);
                log.error("\u627e\u5230\u9700\u8981\u52a0\u5bc6\u7684\u56fe\u7247url \uff1a " + pictureFullUrl);
                this.closeStream(in);
            }
            if (fileItemList.isEmpty()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u52a0\u5bc6\u7684\u4eba\u5458\u5934\u50cf\u3002", (String)"UserPicListPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
                return;
            }
            FileItem[] fileItems = fileItemList.toArray(new FileItem[fileItemList.size()]);
            imageService.upload(fileItems);
            SaveServiceHelper.update((DynamicObject[])updateUserList.toArray(new DynamicObject[updateUserList.size()]));
            for (String deletePicPath : deletePicList) {
                imageService.delete(deletePicPath);
            }
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u6210\u529f\uff0c\u52a0\u5bc6\u6761\u6570\uff1a%s", (String)"UserPicListPlugin_1", (String)BOS_PICTURE, (Object[])new Object[0]), new Object[0]), Integer.valueOf(fileItemList.size()));
            this.getView().updateView();
        } else if ("reuploadall".equals(itemKey)) {
            DynamicObject[] userCol;
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (CollectionUtils.isNotEmpty((Collection)selectedRows)) {
                Object[] pkIds = selectedRows.getPrimaryKeyValues();
                MainEntityType userEntityType = EntityMetadataCache.getDataEntityType((String)"bos_user");
                userCol = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)userEntityType);
            } else {
                userCol = BusinessDataServiceHelper.load((String)"bos_user", (String)"picturefield", null);
            }
            if (userCol.length == 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u91cd\u65b0\u4e0a\u4f20\u7684\u4eba\u5458\u52a0\u5bc6\u5934\u50cf\u3002", (String)"UserPicListPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
                return;
            }
            FileService imageService = FileServiceFactory.getImageFileService();
            ArrayList<FileItem> fileItemList = new ArrayList<FileItem>(10);
            ArrayList<DynamicObject> updateUserList = new ArrayList<DynamicObject>(10);
            ArrayList<String> deletePicList = new ArrayList<String>(10);
            for (DynamicObject userObj : userCol) {
                String picturefield = userObj.getString("picturefield");
                if (!StringUtils.isNotBlank((CharSequence)picturefield) || picturefield.startsWith("http")) continue;
                picturefield = "/" + picturefield.replaceAll("\\?v=1.0", "").replaceAll("&v=1.0", "");
                while (picturefield.startsWith("//")) {
                    picturefield = picturefield.replace("//", "/");
                }
                if (!imageService.exists(picturefield) || this.checkImage(picturefield)) continue;
                deletePicList.add(picturefield);
                String fileName = picturefield.substring(picturefield.lastIndexOf("/") + 1);
                String pathPreffix = picturefield.substring(0, StringUtils.lastIndexOf((CharSequence)picturefield, (CharSequence)"/"));
                String pathTwo = picturefield.substring(StringUtils.lastIndexOf((CharSequence)picturefield, (CharSequence)"/") + 1);
                String ext = pathTwo.substring(StringUtils.lastIndexOf((CharSequence)pathTwo, (CharSequence)"."));
                pathTwo = "/" + Uuid8.generateShortUuid() + ext;
                String kdImgPath = pathPreffix + pathTwo;
                FileItem item = new FileItem(fileName, kdImgPath, imageService.getInputStream(picturefield));
                fileItemList.add(item);
                userObj.set("picturefield", (Object)kdImgPath);
                updateUserList.add(userObj);
                log.error("\u627e\u5230\u9700\u8981\u91cd\u65b0\u4e0a\u4f20\u7684\u56fe\u7247url \uff1a " + this.getFileServerUrl(picturefield));
            }
            if (fileItemList.isEmpty()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u91cd\u65b0\u4e0a\u4f20\u7684\u4eba\u5458\u52a0\u5bc6\u5934\u50cf\u3002", (String)"UserPicListPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] fileItems = fileItemList.toArray(new FileItem[fileItemList.size()]);
            imageService.upload((FileItem[])fileItems);
            SaveServiceHelper.update((DynamicObject[])updateUserList.toArray(new DynamicObject[updateUserList.size()]));
            for (String deletePicPath : deletePicList) {
                imageService.delete(deletePicPath);
            }
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u91cd\u65b0\u4e0a\u4f20\u6210\u529f\uff0c\u6210\u529f\u6761\u6570\uff1a%s", (String)"UserPicListPlugin_2", (String)BOS_PICTURE, (Object[])new Object[0]), new Object[0]), Integer.valueOf(fileItemList.size()));
            this.getView().updateView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkImage(String pictrueUrl) {
        InputStream imageInputStream = null;
        try {
            String pictrueFullUrl = this.getFileServerUrl(pictrueUrl);
            URL url = new URL(pictrueFullUrl);
            imageInputStream = url.openConnection().getInputStream();
            BufferedImage image = ImageIO.read(imageInputStream);
            boolean bl = image != null;
            this.closeStream(imageInputStream);
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeStream(imageInputStream);
        }
    }

    private void closeStream(InputStream imageInputStream) {
        try {
            if (imageInputStream != null) {
                imageInputStream.close();
            }
        }
        catch (IOException e) {
            log.warn((Throwable)e);
        }
    }

    private String getFileServerUrl(String path) {
        String imageServerUrl = System.getProperty("image.fileserver");
        if (null == imageServerUrl) {
            imageServerUrl = System.getProperty("fileserver");
        }
        if (!imageServerUrl.endsWith("/")) {
            imageServerUrl = imageServerUrl + "/";
        }
        if (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        return imageServerUrl + path;
    }
}

