/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.file.security;

import kd.bos.dataentity.resource.ResManager;

public class FileCheckResult {
    private boolean checkReuslt;
    private String errorMsg;
    private String realFileName;

    public FileCheckResult(boolean checkReuslt, String errorMsg) {
        this.checkReuslt = checkReuslt;
        this.errorMsg = errorMsg;
    }

    public FileCheckResult(boolean checkReuslt, String errorMsg, String realFileName) {
        this.checkReuslt = checkReuslt;
        this.errorMsg = errorMsg;
        this.realFileName = realFileName;
    }

    public static FileCheckResult pass() {
        return new FileCheckResult(true, "", "");
    }

    public static FileCheckResult refuse(String errMsg) {
        return new FileCheckResult(false, errMsg, "");
    }

    public static FileCheckResult forbidTypeRefuse(String realFileName) {
        return new FileCheckResult(false, "", realFileName);
    }

    public static FileCheckResult commonRefuse() {
        String errMsg = ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u6587\u4ef6\u4e2d\u5b58\u5728\u6076\u610f\u4fe1\u606f\uff0c\u5b89\u5168\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"FileChecker_0", (String)"bos-attachment", (Object[])new Object[0]);
        return new FileCheckResult(false, errMsg);
    }

    public static FileCheckResult zipEmptyFileRefuse(String zipSubFileName) {
        String errMsg = ResManager.loadKDString((String)"%s\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u4e0a\u4f20\u3002", (String)"FileChecker_5", (String)"bos-attachment", (Object[])new Object[0]);
        errMsg = String.format(errMsg, zipSubFileName);
        return new FileCheckResult(false, errMsg);
    }

    public static FileCheckResult zipSubFileRefuse(String zipFileName, String forbidFileName) {
        String errMsg = ResManager.loadKDString((String)"%1$s\u538b\u7f29\u5305\u5185\u7684%2$s\u6587\u4ef6\u5728\u7cfb\u7edf\u914d\u7f6e\u7684\u9ed1\u540d\u5355\u8303\u56f4\u5185\uff0c\u4e0d\u652f\u6301\u4e0a\u4f20\u3002", (String)"FileChecker_3", (String)"bos-attachment", (Object[])new Object[0]);
        errMsg = String.format(errMsg, zipFileName, forbidFileName);
        return new FileCheckResult(false, errMsg);
    }

    public static FileCheckResult boomZipFileRefuse() {
        String errMsg = ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u538b\u7f29\u5305\u7684\u538b\u7f29\u6bd4\u4f8b\u4e0d\u80fd\u8d85\u8fc7100%\u3002", (String)"FileChecker_1", (String)"bos-attachment", (Object[])new Object[0]);
        return new FileCheckResult(false, errMsg);
    }

    public boolean isCheckReuslt() {
        return this.checkReuslt;
    }

    public void setCheckReuslt(boolean checkReuslt) {
        this.checkReuslt = checkReuslt;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getRealFileName() {
        return this.realFileName;
    }

    public void setRealFileName(String realFileName) {
        this.realFileName = realFileName;
    }
}

